;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;	@(#)chario.s	1.6	07/11/22
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	.module	chario

	.globl console, cctl, ci, co, crxstat, ctxstat
	.globl MODEM_ON
	.globl BS, LF, CR, XON, XOFF, SPACE, DEL

	.area CODE


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	Initialize the console.
;
;	Parameters:
;		None
;
;	Returns:
;		Clobbers B & C
;
;	T States: 54
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
con_init::
	ld b,#MODEM_ON	; get the modem control bit values		7
	ld c,#console	; get console address				7
	jp cctl		; set the modem control lines and leave		40


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	Get the console receive status
;
;	Parameters:
;		None
;
;	Returns:
;		A = 0 for no data, 0xFF for data available
;
;	T States: 104
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
con_rxstat::
	push bc		; save these					11
	ld c,#console	; get console address				7
	call crxstat	; set the receiver status			55
	pop bc		; restore these					10
	jr nz,1$	; data available?				7,12
	xor a,a		; no, return false				4
	ret		; done						10
1$:	ld a,#0xff	; yes, return true				7
	ret		; done						10


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	Get the console transimit status
;
;	Parameters:
;		None
;
;	Returns:
;		A = 0x00 for idle,  0xff for transmitting.
;		Clobbers C
;
;	T States: 104
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
con_txstat::
	push bc		; save these					11
	ld c,#console	; get console address				7
	call ctxstat	; set the transmitter status			55
	pop bc		; restore these					10
	jr nz,1$	; transmitter busy?				7,12
	xor a,a		; no, return false				4
	ret		; done						10
1$:	ld a,#0xff	; yes, return true				7
	ret		; done						10


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	Send a character to the console.
;
;	Parameters:
;		A = character
;
;	Returns:
;		Nothing	
;
;	T States: 112+
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
putchar::
	push bc		; save these					11
	ld c,#console	; get console address				7
	call co		; print on console				74+
	pop bc		; restore these					10
	ret		; done						10


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	Send a NULL-terminated string to
;	the console.
;
;	Parameters:
;		HL = string
;
;	Returns:
;		A = NULL
;		HL = points to the NULL
;
;	T States: 163+ per character, 22 for the NULL
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
put::
1$:	ld a,(hl)	; get the next character from the string	7
	or a,a		; end of string?				4
	ret z		; yes, leave					5,11
	call putchar	; no, send character to console			129+
	inc hl		; next position					6
	jr 1$		; print next character				12


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	Send a string to the console w/CRLF.
;
;	Parameters:
;		HL = string
;
;	Returns:
;		Clobbers A
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
puts::
	call put	; print the string
			; fall through to crlf

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	Send a CRLF to the console.
;
;	Parameters:
;		None
;
;	Returns:
;		Clobbers A
;
;	T States: 265+
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
crlf::
	ld a,#CR	; carriage return				7
	call putchar	; print return					129+
	ld a,#LF	; line feed					7
	jp putchar	; print line feed				122+


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	Get a character from the console.
;
;	Parameters:
;		None
;
;	Returns:
;		A = character
;
;	T States: 112+
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
getchar::
	push bc		; save these					11
	ld c,#console	; get console address				7
	call ci		; print on console				74+
	pop bc		; restore these					10
	ret		; done						10


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	Get a string from the console w/processing.
;
;	Parameters:
;		HL = buffer address
;
;	Returns:
;		A = first character in the buffer
;
;	T States: 191+ per character
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
gets::
	push hl		; save the original buffer address		11
1$:	call getchar	; wait for a character				129+
	and a,#0x7F	; strip the high bit				7
	call proc_char	; process it					32+
	or a,a		; store this character?				4
	jr z,1$		; no, get another				7,12
	call putchar	; echo the character back			129+
	cp #CR		; end of line?					7
	jr z,2$		; yes terminate the line			7,12
	ld (hl),a	; no, save the character in the buffer		7
	inc hl		; point to the next position in the buffer	6
	jr 1$		; get the next character			12
2$:	ld (hl),#0	; terminate the buffer				10
	ld a,#LF	; send a LF					7
	call putchar	;						129+
	pop hl		; restore the orignal buffer address		10
	ld a,(hl)	; load the first character in the buffer	7
	ret		; done						10


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	Process an input character
;
;	Parameters:
;		None
;
;	Returns:
;		Clobbers A
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;	Printable:	32
;	LF:		50
;	CR:		56
;	BS:		213+
;	DEL:		511+
;	Default:	102
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc_char:
	cp #SPACE	; control character?				7
	jr c,1$		; yes, handle it				7,12
	cp #DEL		; no, printable?				7
	ret c		; yes, return char for storage			5,11

	; process control characters and DEL
1$:	cp #LF		; newline?					7
	jr nz,2$	; no, check next character			7,12
	ld a,#CR	; yes, convert to CR				7
	ret		; leave						10

2$:	cp #CR		; return?					7
	ret z		; yes, done					5,11

	cp #BS		; backspace?					7
	jr nz,3$	; no, check for another match			7,12
	dec hl		; yes, skip back one space in the buffer	6
	call putchar	; output backspace				129+
	xor a		; don't store this character			4
	ret		; done						10

3$:	cp #DEL		; DEL?						7
	jr nz,4$	; no, check for another match			7,12
	dec hl		; yes, skip back one space in the buffer	6
	ld a,#BS	; backspace					7
	call putchar	;						129+
	ld a,#SPACE	; rub out this character			7
	call putchar	;						129+
	ld a,#BS	; backspace again				7
	call putchar	;						129+

4$:	xor a		; don't store this character			4
	ret		; done						10


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	Convert a byte in the accumulator to ASCII
;	hex and print it to the console.
;
;	Parameters:
;		A = byte
;
;	Returns:
;		Clobbers A
;
;	T States: 356
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
prhex::
	push af		; save an extra copy				11
	rrca		; shift the high nibble down to low position	4
	rrca		;						4
	rrca		;						4
	rrca		;						4
	and a,#0x0f	; strip off the high nibble			7
	add a,#0x90	; convert to ASCII				7
	daa		;						4
	adc a,#0x40	;						7
	daa		;						4
	call putchar	; output the character				129+
	pop af		; get the original number			10
	and a,#0x0f	; strip off the high nibble			7
	add a,#0x90	; convert to ASCII				7
	daa		;						4
	adc a,#0x40	;						7
	daa		;						4
	jp putchar	; output the character and leave		122+

