;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;	@(#)boot.s	1.10	07/12/20
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	.area BOOT (ABS)

	.include "memcfg.s"

bias	= (msize-20)*1024
ccp	= moff+bias		; base of ccp
bios	= ccp+0x1600		; base of bios
bioslen	= 0x400			; length of bios
nblocks	= ((msize*1024-ccp)/512)-1 
ccp	= ccp - 128		; offset one logical sector

start	= 0x0100

	.org start

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	Available ROM routines
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
cold_start		= rom+3*0
warm_start		= rom+3*1
con_rxstat		= rom+3*2
con_txstat		= rom+3*3
getchar			= rom+3*4
putchar			= rom+3*5
gets			= rom+3*6
put			= rom+3*7
puts			= rom+3*8
crlf			= rom+3*9
prhex			= rom+3*10
_spio13_rxstat		= rom+3*11
_spio13_txstat		= rom+3*12
_spio13_sctrl		= rom+3*13
_spio13_sread		= rom+3*14
_spio13_swrite		= rom+3*15
_ide_address		= rom+3*16
_ide_hard_reset		= rom+3*17
_ide_drive_id		= rom+3*18
_ide_read_a_sector	= rom+3*19
_ide_write_a_sector	= rom+3*20

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	General definitions.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
TYPE_EXT	= 0x05		; extended partition type
TYPE_CPM	= 0x52		; CP/M partition
LBA		= 0b01000000	; LBA flag for the drive/head byte

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	Start of code.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	jp getsys		; jump to the boot routine
	.asciz "CP/M 2.2"	; identify the OS we're written for
	.even

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	Look for a bootable partition.  Bit
;	7 of the drive byte will be set if the
;	partition set active.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
getsys:
	call findpart		; find a bootable partition
	ld hl,#msg2		; print loading message
	call put		;
	call getaddr		; get the LBA and load address

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	Load the operating system from disk.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
1$:	or a,#LBA		; set the LBA flag
	call _ide_read_a_sector	; load a sector
	push af			; save A
	ld a,(blocks)		; get the block count
	inc a			; increment the block count
	ld (blocks),a		; save the block count
	cp a,#nblocks		; done?
	jr nc,3$		; yes, continue
	ld a,#'.		; no, print progress dot
	call putchar		;
	pop af			; restore A
	inc b			; increment the LBA by one
	jr nz,2$		;
	inc e			;
	jr nz,2$		;
	inc d			;
	jr nz,2$		;
	inc a			;
2$:	and a,#0b00001111	; separate the head from the garbage
	jr 1$			; do it again

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	Cleanup and start the operating system.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
3$:	pop af			; clean off the stack.
	call crlf		; terminate the progress string
	jp bios			; perform a cold start


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	Find a bootable partition of the
;	right type.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
findpart:
	ld ix,#part1		; check partition 1
	bit 7,drive(ix)		; bootable?
	jr nz,1$		; yes, continue
	ld ix,#part2		; no, check partition 2
	bit 7,drive(ix)		; bootable?
	jr nz,1$		; yes, continue
	ld ix,#part3		; no, check partition 3
	bit 7,drive(ix)		; bootable?
	jr nz,1$		; yes, continue
	ld ix,#part3		; no, check partition 4
	bit 7,drive(ix)		; bootable?
	jr z,2$			; no, leave
1$:	ld a,#TYPE_CPM		; get the CP/M partition type
	cp type(ix)		; is this a CP/M partition?
	jr z,2$			; yes, leave
	ld hl,#msg1		; no, print error message
	call puts		;
	pop hl			; throw away the return address
2$:	ret			; give up and leave


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	Get the LBA address and the memory
;	address
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
getaddr:
	xor a,a			; clear the block count
	ld (blocks),a		; 
	call _ide_address	; get the controller address
	ld b,start_lba(ix)	; get the LBA
	ld e,start_lba+1(ix)	;
	ld d,start_lba+2(ix)	;
	ld a,start_lba+3(ix)	;
	ld hl,#ccp		; get the target address
	ret


	.org start + 0x100

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	Write the OS to the first track of the
;	partition.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
putsys:
	call findpart		; find the boot partition
	ld hl,#msg3		; print saving message
	call put		;
	call getaddr		; get the LBA and load address

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	Load the operating system from disk.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
1$:	or a,#LBA		; set the LBA flag
	call _ide_write_a_sector; load a sector
	push af			; save A
	ld a,(blocks)		; get the block count
	inc a			; increment the block count
	ld (blocks),a		; save the block count
	cp a,#nblocks		; done?
	jr nc,3$		; yes, continue
	ld a,#'.		; no, print progress dot
	call putchar		;
	pop af			; restore A
	inc b			; increment the LBA by one
	jr nz,2$		;
	inc e			;
	jr nz,2$		;
	inc d			;
	jr nz,2$		;
	inc a			;
2$:	and a,#0b00001111	; separate the head from the garbage
	jr 1$			; do it again

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	Cleanup and leave.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
3$:	pop af			; clean off the stack.
	call crlf		; terminate the progress string
	ret			; leave


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	Service messages.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
msg1:	.asciz "NO BOOT DISK FOUND"
msg2:	.asciz "LOADING."
msg3:	.asciz "SAVING."

blocks:	.db	0		; number of blocks loaded from disk


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	Partition table.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	.area DATA (ABS)
	.org start+446

drive		= 0		; bits 0-6 always 0, bit 7 set if bootable
head		= 1		; partition starting point (CHS)
sector		= 2		;
cylinder	= 3		;
type		= 4		; partition type
end_head	= 5		; partition ending point (CHS)
end_sector	= 6		;
end_cylinder	= 7		;
start_lba	= 8		; starting LBA of the partition
len_lba		= 12		; length of partition in blocks

part1:	.blkb	16		; partition 1
part2:	.blkb	16		; partition 2
part3:	.blkb	16		; partition 3
part4:	.blkb	16		; partition 4
	.db	0x55,0xaa	; end of boot sector
