;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;	@(#)spio13.s	1.3	07/11/08
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	.module	spio13

	.globl _spio13_paddr, _spio13_saddr

	.area CODE

crxstat		== _spio13_rxstat
ctxstat		== _spio13_txstat
cctl		== _spio13_sctrl
ci		== _spio13_sread
co		== _spio13_swrite

; PIO Register Offsets
_PA	= 0		; Port A
_PB	= 1		; Port B
_PC	= 2		; Port C
_CR	= 3		; Control Register (write only)

; PIO Control Register
_MODE_ACTIVE	= 0B10000000
_GA_MODE_2	= 0B01000000
_GA_MODE_1	= 0B00100000
_GA_PA_IN	= 0B00010000
_GA_PCH_IN	= 0B00001000
_GB_MODE_1	= 0B00000100
_GB_PB_IN	= 0B00000010
_GB_PCL_IN	= 0B00000001

; UART Register Offsets
_RR	= 0		; Receiver Register (read only)
_TBR	= 0		; Transmitter Buffer Register (write only)
_SR	= 1		; Status Register (read only)
_MCR	= 1		; Modem Control Register (write only)

; UART Modem Control Register
_RTS	= 0B00000010	; Request To Send
_DTR	= 0B00000001	; Data Terminal Ready

MODEM_ON	== _DTR+_RTS	; both lines

; UART Status Register
_TBRE	= 7		; Transmitter Buffer Register Empty
_DR	= 6		; Data Received
_OE	= 5		; Overrun Error
_FE	= 4		; Framing Error
_PE	= 3		; Parity Error
_TRE	= 2		; Transmitter Register Empty
_CTS	= 1		; Clear To Send
_DSR	= 0		; Data Set Ready

XOFF	= 19
XON	= 17

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	Get the UART receive status.
;
;	Parameters:
;		C = port
;
;	Returns:
;		A = UART status register
;		Z: 0=no data, 1=data available
;
;	T States: 38
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
_spio13_rxstat::
	inc c		; switch to the status register			4
	in a,(c)	; get the UART status				12
	dec c		; switch to the data register			4
	bit _DR,a	; data received?				8
	ret		; done						10


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	Get the UART transmit status.
;
;	Parameters:
;		C = port
;
;	Returns:
;		A = UART status register
;		Z: 0=no data, 1=data transmitting
;
;	T States: 38
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
_spio13_txstat::
	inc c		; switch to the status register			4
	in a,(c)	; get the UART status				12
	dec c		; switch to the data register			4
	bit _TBRE,a	; transmit register empty?			8
	ret		; done						10


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	Modify the modem control lines.
;
;	Parameters:
;		B = new line states
;		C = port
;
;	Returns:
;		Nothing
;
;	T States: 30
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
_spio13_sctrl::
	inc c		; switch to the modem control register		4
	out (c),b	; set the modem control lines			12
	dec c		; switch to the data register			4
	ret		; done						10


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	Wait until the receive register is full
;	then read a character from the UART.
;
;	Parameters:
;		C = port
;
;	Returns:
;		A = new character
;
;	T States: 57+
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
_spio13_sread::
	inc c		; switch to the status register			4
1$:	in a,(c)	; get the UART status				12
	bit _DR,a	; data received?				8
	jr z,1$		; no, check again				7,12
	dec c		; yes, switch to the data register		4
	in a,(c)	; get byte from the serial port			12
	ret		; done						10


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	Wait until the transmit register is empty
;	then write a character to the UART.
;
;	Parameters:
;		A = character
;		C = port
;
;	Returns:
;		Clobbers B
;
;	T States: 57+
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
_spio13_swrite::
	inc c		; switch to the status register			4
1$:	in b,(c)	; get the UART status				12
	bit _TBRE,b	; is the transmitter buffer empty?		8
	jr z,1$		; no, check again				7,12
	dec c		; switch to transmit register			4
	out (c),a	; write byte to serial port			12
	ret		; done						10

