/*
 *	@(#)signal.c	1.1	14/12/13
 *
 *	interrupt()
 *
 *	Signal handling routine.
 */

/*LINTLIBRARY*/
/*PROTOLIB1*/

#include <memory.h>
#include <signal.h>
#include <string.h>
#include <errno.h>
#include "tu58.h"

#define FALSE	0
#define TRUE	1
#define ERROR	( -1)

extern int debug;
extern int foreground;
extern void log_msg(int level, const char *fmt, ...);

int done, quit;
int int_ret;

void interrupt(int sig)
{
	struct sigaction act;

	memset(&act, 0, sizeof(act));

	switch (sig) {
		case 0:
			act.sa_handler = interrupt;
			if (sigaction(SIGHUP, &act, (struct sigaction *)0) == ERROR) {
				log_msg(0, "sigaction(SIGHUP): %s", strerror(errno));
				int_ret = ERROR;
				return;
			}
			act.sa_handler = interrupt;
			if (sigaction(SIGINT, &act, (struct sigaction *)0) == ERROR) {
				log_msg(0, "sigaction(SIGINT): %s", strerror(errno));
				int_ret = ERROR;
				return;
			}
			act.sa_handler = interrupt;
			if (sigaction(SIGQUIT, &act, (struct sigaction *)0) == ERROR) {
				log_msg(0, "sigaction(SIGQUIT): %s", strerror(errno));
				int_ret = ERROR;
				return;
			}
			act.sa_handler = interrupt;
			if (sigaction(SIGTERM, &act, (struct sigaction *)0) == ERROR) {
				log_msg(0, "sigaction(SIGTERM): %s", strerror(errno));
				int_ret = ERROR;
				return;
			}
			act.sa_handler = interrupt;
			if (sigaction(SIGALRM, &act, (struct sigaction *)0) == ERROR) {
				log_msg(0, "sigaction(SIGALRM): %s", strerror(errno));
				int_ret = ERROR;
				return;
			}
			act.sa_handler = interrupt;
			if (sigaction(SIGPIPE, &act, (struct sigaction *)0) == ERROR) {
				log_msg(0, "sigaction(SIGPIPE): %s", strerror(errno));
				int_ret = ERROR;
				return;
			}
			act.sa_handler = interrupt;
			if (sigaction(SIGUSR1, &act, (struct sigaction *)0) == ERROR) {
				log_msg(0, "sigaction(SIGUSR1): %s", strerror(errno));
				int_ret = ERROR;
				return;
			}
			act.sa_handler = interrupt;
			if (sigaction(SIGUSR2, &act, (struct sigaction *)0) == ERROR) {
				log_msg(0, "sigaction(SIGUSR2): %s", strerror(errno));
				int_ret = ERROR;
				return;
			}
			done = FALSE;
			quit = FALSE;
			break;
		case SIGHUP:
			log_msg(1, "SIGHUP caught");
			if (foreground)
				done = TRUE;
			break;
		case SIGINT:
			log_msg(1, "SIGINT caught");
			done = TRUE;
			break;
		case SIGQUIT:
			log_msg(1, "SIGQUIT caught");
			quit = TRUE;
			break;
		case SIGTERM:
			log_msg(1, "SIGTERM caught");
			done = TRUE;
			break;
		case SIGALRM:
			log_msg(1, "SIGALRM caught");
			break;
		case SIGPIPE:
			log_msg(1, "SIGPIPE caught");
			break;
		case SIGUSR1:
			debug++;
			log_msg(1, "Debug level=%d", debug);
			break;
		case SIGUSR2:
			debug = 0;
			log_msg(0, "Debug level=%d", debug);
			break;
		default:
			log_msg(1, "Unknown signal %d caught", sig);
			break;
	}

	return;
}
