;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;	@(#)string.s	1.4	07/12/01
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	.module	string

	.globl SPACE

	.area CODE

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	Convert a string to uppercase.
;
;	Parameters:
;		HL = string address
;
;	Returns:
;		Clobbers A
;
;	T States: 31 +
;		  78 per lower case character
;		  55 for non-lower case
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
upper::
	push hl		; save a copy of the buffer address		11
1$:	ld a,(hl)	; get a character				7
	or a,a		; end of string?				4
	jr z,3$		; yes, we're done				7,12
	cp a,#'a	; no, char < 'a'?				7
	jr c,2$		; yes, check next character			7,12
	cp a,#'z+1	; no, char > 'z'?				7
	jr nc,2$	; yes, check next character			7,12
	and a,#0xdf	; no, convert to uppercase			7
	ld (hl),a	; save character				7
2$:	inc hl		; next character				6
	jr 1$		; keep going					12
3$:	pop hl		; restore these registers			10
	ret		; done						10


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	Skip whitespace.
;
;	Parameters:
;		HL = string address
;
;	Returns:
;		A = next non-space character
;		HL = start of next parameter
;
;	T States: 39 per space, 40 for non-space
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
nextparm::
1$:	ld a,(hl)	; get the next character in the buffer		7
	cp #SPACE	; space?					7
	jr nz,2$	; no, leave					7,12
	inc hl		; yes, skip to the next buffer position		6
	jr 1$		; check the character				12
2$:	or a,a		; do the EOL check now				4
	ret		; done						10


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	Convert 4 ASCII hex digits to a 16-bit
;	word
;
;	Parameters:
;		HL = string address
;
;	Returns:
;		DE = converted word
;
;	T States: ~620 for 4 digits
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
scanhexw::
	push af		; save these					11
	push bc		;						11
	ld de,#0	; clear the result				10
	ld b,#4		; we're going for 4 nibbles			7
1$:	ld a,(hl)	; get the character				7
	sub a,#'0	; subtract ASCII offset				7
	cp a,#10	; are we <= 9?					7
	jr c,2$		; yes, leave					7,12
	sub a,#7	; no, subtract offset for letters		7
2$:	cp a,#16	; bad conversion?				7
	jr nc,3$	; yes, leave					7,12
	sla e		; no, shift high nibble to high byte		8
	rl d		;						8
	sla e		;						8
	rl d		;						8
	sla e		;						8
	rl d		;						8
	sla e		;						8
	rl d		;						8
	or a,e		; add new nibble to the low nibble		4
	ld e,a		; save as low byte				4
	inc hl		; point to the next character			6
	djnz 1$		; go back if more				13,8
3$:	pop bc		; restore these					10
	pop af		;						10
	ret		; done						10


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	Convert 2 ASCII characters to a binary
;	number
;
;	Parameters:
;		HL = string address
;
;	Returns:
;		A = binary number if 2 digits found
;		    clobbered otherwise
;		C = binary number
;		HL = string address following number
;
;	T States: ~158 for 2 digits
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
scanhexb::
	ld a,(hl)	; get next character				7
	sub a,#'0	; subtract ASCII offset				7
	cp a,#10	; are we <= 9?					7
	jr c,1$		; yes, continue					7,12
	sub a,#7	; no, subtract offset for letters		7
1$:	cp a,#16	; error?					7
	ret nc		; yes, leave					5,11
	ld c,a		; no, move it to C				4
	inc hl		; next character				6
	ld a,(hl)	; get character					7
	sub a,#'0	; subtract ASCII offset				7
	cp a,#10	; are we <= 9?					7
	jr c,2$		; yes, continue					7,12
	sub a,#7	; no, subtract offset for letters		7
2$:	cp a,#16	; error?					7
	ret nc		; yes, leave					5,11
	sla c		; no, make digit the high nibble		8
	sla c		;						8
	sla c		;						8
	sla c		;						8
	or a,c		; add to upper nibble				4
	ld c,a		; move back to C				4
	inc hl		; next character				6
	ret		; done						10

