;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;	@(#)startup.s	1.12	07/12/16
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	.module startup

	.title	Initialization Routine
	.sbttl Global references & code origin definitions

	.globl ram_amt, ram_addr, mon_pc
	.globl warm_start, con_init
	.globl con_rxstat, con_txstat, getchar, putchar
	.globl _spio13_rxstat, _spio13_txstat, _spio13_sctrl
	.globl _spio13_sread, _spio13_swrite
	.globl _ide_address, _ide_hard_reset, _ide_drive_id
	.globl _ide_read_a_sector, _ide_write_a_sector
	.globl gets, put, puts, prhex, crlf

	.area CODE (ABS)

	.include "memcfg.s"

mirror	== 1	; 1=mirrored ROM, 0=ROM starts at 0

	.if mirror
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	The ROM is mirrored at 0, but it's
;	really located here.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	.org rom
	.else
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	The ROM starts at location 0, so we'll
;	have to hard-code the various vectors.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	.org 	0x0		; RESET vector
	jp cold_start		; jump to the cold start routine on reset
	.org	0x08		; restart vectors
	reti			;
	.org	0x10		;
	reti			;
	.org	0x18		;
	reti			;
	.org	0x20		;
	reti			;
	.org	0x28		;
	reti			;
	.org	0x30		;
	reti			;
	.org	0x38		; make RST 0x38 do a warm start
	jp warm_start		;
	.org	0x66		; NMI vector
	retn			;
	.endif

	.page
	.sbttl Jump table definition
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	Jump table to commonly used routines.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
coldst:	jp cold_start		; cold start routine
warmst:	jp warm_start		; warm start routine
	jp con_rxstat		; console receiver status
	jp con_txstat		; console transmitter status
	jp getchar		; get a character from the console
	jp putchar		; send a character to the console
	jp gets			; get a string from the console
	jp put			; send a string to the console
	jp puts			; send a string to the console w/crlf
	jp crlf			; send a crlf to the console
	jp prhex		; convert a byte to ASCII & send to the console
	jp _spio13_rxstat	; serial port receiver status
	jp _spio13_txstat	; serial port transmitter status
	jp _spio13_sctrl	; serial port modem control lines
	jp _spio13_sread	; read a character from a serial port
	jp _spio13_swrite	; write a character to a serial port
	jp _ide_address		; get the I/O port of the ATA controller
	jp _ide_hard_reset	; reset the ATA bus
	jp _ide_drive_id	; request the ID from the drive
	jp _ide_read_a_sector	; read a sector from the drive
	jp _ide_write_a_sector	; write a sector to the drive


	.page
	.sbttl Cold start routine
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	Determine where the RAM is located
;	and how much is equipped.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
cold_start:
	.if mirror		; Un-mirror the ROM from low memory
	ld b,#100		; move the ROM up to the ORG
0$:	in a,(0)		; for some reason it takes several tries
	djnz 0$			;
	.endif

	;
	;  Configure interrupts
	;
	di			; disable interrupts
	im 1			; interrupt mode 1

	;
	;  Find the RAM starting point
	;
	ld hl,#0		; start at address 0x0
	ld bc,#1		; increment one location at a time
	ld a,#0b10101010	; use this pattern
1$:	ld (hl),a		; store pattern
	cp a,(hl)		; pattern still the same?
	jr nz,2$		; no, continue to the next location
	cpl			; yes, flip the pattern bits
	ld (hl),a		; store the new pattern	
	cp a,(hl)		; pattern still the same?
	jr z,3$			; yes! found the start of RAM
	cpl			; no, flip the pattern back
2$:	add hl,bc		; next location
	jr nc,1$		; if not done, store next location
	halt			; else, no RAM found -- panic!
3$:	ld d,h			; save the RAM starting address (high byte)
	ld e,l			; save the RAM starting address (low byte)

	; 
	;  Find the length of the RAM.
	; 
	ld bc,#0		; clear the byte counter
4$:	xor a,a			; store a 0 in the location
	ld (hl),a		;
	ld a,#0b10101010	; use this pattern again
	inc bc			; increment number of bytes found
	inc hl			; next address
	ld (hl),a		; store pattern
	cp a,(hl)		; pattern the same?
	jr nz,5$		; no, found end of RAM
	cpl			; flip the pattern bits
	ld (hl),a		; store the new pattern
	cp a,(hl)		; pattern the same?
	jr z,4$			; yes, keep going

	.page
	.sbttl Storage initialization
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	Initialize the stack and local variable
;	storage.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
5$:	ld sp,hl		; anchor the stack pointer here
	push bc			; save the amount of RAM
	push de			; save the RAM start address

	ld bc,#16		; allocate variable storage above the stack
	or a,a			; clear the carry
	sbc hl,bc		; calculate the new stack pointer
	ld sp,hl		; move the stack pointer down
	push hl			; store the variable storage location
	pop iy			; IY = local variable storage


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	Initialize page 0 (if it exists)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	xor a,a			; clear A
	cp ram_addr+1(iy)	; if the RAM starts at 0...
	jr nz,6$		;
	cp ram_addr(iy)		;
	jr nz,6$		;
	ld ram_addr(iy),#0x80	; reserve space for the vectors

	;
	; populate the various interrupt vectors
	;
	ld a,#0xC3		; jump instruction
	ld (0x00),a		;
	ld hl,#coldst		; jump to the startup routine
	ld (0x01),hl		;

	ld hl,#0x4DED		; RETI instruction
	ld (0x08),hl		; populate the restart vectors
	ld (0x10),hl		;
	ld (0x18),hl		;
	ld (0x20),hl		;
	ld (0x28),hl		;
	ld (0x30),hl		;

	ld (0x38),a		; jump instruction
	ld hl,#warmst		; jump to the monitor routine on RST 0x38
	ld (0x39),hl		;
	ld hl,#0x45ED		; RETN instruction
	ld (0x66),hl		; populate the NMI vector


	.page
	.sbttl Initialize I/O devices
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	Now that the stack is established,
;	initialize the console.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
6$:	call con_init		; initialize the console
	ld hl,#banner		; get banner address
	call puts		; write banner to console

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	Print the various service messages.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	ld hl,#ramfound 	; get RAM found string
	call put		; print it
	ld a,d			; print the RAM starting address
	call prhex		; 
	ld a,e			;
	call prhex		; 
	call crlf		; print CRLF

	ld hl,#ramsize		; get RAM size string
	call put		; print it
	ld a,ram_amt+1(iy)	; print the RAM starting address
	call prhex		; 
	ld a,ram_amt(iy)	;
	call prhex		; 
	call crlf		; 

	ld hl,#stackat		; get stack starts at string
	call put		; print it
	ld hl,#15		; calculate the top of stack
	add hl,sp		;
	ld a,h			; stack pointer
	call prhex		; 
	ld a,l			; 
	call prhex		; 
	call crlf		; 
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	Reset the ATA bus.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	call _ide_address	; get the controller address
	ld a,c			; see if it looks valid
	cp a,#0			; same as console?
	jr z,7$			; yes, skip this
	cp a,#0xff		; no, all ones?
	jr z,7$			; yes, skip this
	call _ide_hard_reset	; no, reset the bus
	ld hl,#ide1		; print ATA message
	call put		;
	ld a,c			; get controller address
	call prhex		; print it
	call crlf		; terminate line

	.page
	.sbttl Finish up
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	Go!
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
7$:	jp warm_start


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	Message strings.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
banner:
	.db 13,10
	.ascii "Monitor v1.3"
	.db 13,10,0

ramfound:
	.asciz "RAM starts at 0x"
ramsize:
	.asciz "RAM size is 0x"
stackat:
	.asciz "Stack starts at 0x"
ide1:
	.asciz "ATA found at 0x"
