/*
 *	@(#)tu58.h	1.1	14/12/13
 *
 *	TU58 protocol header file.
 */

#ifndef TU58_H
#define TU58_H

/*
 * States
 */
#define LINK_INIT	0
#define LINK_START	1
#define LINK_BOOT	2
#define LINK_IDLE	3

/*
 * Flags
 */
#define TU_F_BREAK	0x00	/* break received */
#define TU_F_DATA	0x01	/* data packet */
#define TU_F_CTRL	0x02	/* command packet */
#define TU_F_INIT	0x04	/* initialize */
#define TU_F_BOOT	0x08	/* boot from drive w/o packaging */
#define TU_F_CONT	0x10	/* continue */
#define TU_F_XOFF	0x13	/* x-off from host */

/*
 * Command Op Codes
 */
#define TU_OP_NOP	0		/* return an end packet */
#define TU_OP_INIT	1		/* reset to a ready state */
#define TU_OP_READ	2		/* read data from tape */
#define TU_OP_WRITE	3		/* write data to tape */
#define TU_OP_POS	5		/* position tape to the selected block */
#define TU_OP_DIAG	7		/* return self test result */
#define TU_OP_GSTAT	8		/* return an end packet */
#define TU_OP_SSTAT	9		/* return an end packet */
#define TU_OP_END	0x40	/* end packet */

#define	TU_CMD_SIZE	10

/*
 * End Codes
 */
#define TU_E_SUCCESS  0		/* normal success */
#define TU_E_RETRIES  1		/* success, but with retries */
#define TU_E_ETEST	 -1		/* failed self-test */
#define	TU_E_EPART	 -2		/* partial operation (end of medium) */
#define TU_E_EUNIT	 -8		/* bad unit number */
#define TU_E_ECART	 -9		/* no cartridge */
#define TU_E_EWP	-11		/* write protected */
#define	TU_E_EDATA	-17		/* data check error */
#define TU_E_ESEEK	-32		/* seek error (block not found) */
#define TU_E_ESTOP	-33		/* motor stopped */
#define	TU_E_EBADOP	-48		/* bad op code */
#define TU_E_EBLOCK	-55		/* bad block number (i.e. > 511) */

/*
 * Summary Status Codes
 */
#define TU_E_NOSUM	0x00	/* no error */
#define TU_E_LOGIC	0x10	/* logic error */
#define TU_E_MOTION	0x20	/* motion error */
#define TU_E_XFER	0x40	/* transfer error */
#define	TU_E_SPCL	0x80	/* special condition (errors) */


#define TU_BLK_SIZE	512		/* size of block */
#define TU_BUF_SIZE	128		/* size of tape buffer */


typedef struct ctrl_packet {
	unsigned char flag;
	unsigned char count;
	unsigned char op_code;
	unsigned char modifier;
	unsigned char unit;
	unsigned char switches;
	unsigned char seq_num_low;
	unsigned char seq_num_hi;
	unsigned char byte_count_low;
	unsigned char byte_count_hi;
	unsigned char block_num_low;
	unsigned char block_num_hi;
	unsigned char checksum_low;
	unsigned char checksum_hi;
} ctrl_packet;

#define SEQ(a) (((a).seq_num_hi << 8) | (a).seq_num_low)
#define BLOCK(a) (((a).block_num_hi << 8) | (a).block_num_low)
#define COUNT(a) (((a).byte_count_hi << 8) | (a).byte_count_low)
#define CHECKSUM(a) (((a).checksum_hi << 8) | (a).checksum_low)

typedef struct data_packet {
	unsigned char flag;
	unsigned char count;
	unsigned char data[128];
	unsigned char checksum_low;
	unsigned char checksum_hi;
} data_packet;

extern int tu_state;

#endif /* TU58_H */
