/*
 *	@(#)globals.h	1.1 14/12/13
 *
 *	Miscellaneous definitions.
 */

#ifndef GLOBALS_H
#define GLOBALS_H

#include <stdio.h>
#include <termios.h>
#include "log.h"

#define ERROR	( -1)
#define TRUE	1
#define FALSE	0
#define max(a, b)	(((a) >= (b)) ? (a) : (b))
#define min(a, b)	(((a) <= (b)) ? (a) : (b))

extern char *program;
extern int debug, foreground;
extern FILE *logfile;
extern int int_ret, done, quit;

extern int open_serial(char *devname, speed_t speed);
extern int close_serial(int fd);
extern int read_serial(int fd, unsigned char *buf, int count);
extern int write_serial(int fd, unsigned char *buf, int count);

#endif
