	.title Global Defines
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;	@(#)globals.s	1.6	14/02/18
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


ram_amt		== 14	; amount of RAM in the system
ram_addr	== 12	; starting point of usable RAM
mon_pc		== 10	; the monitor's memory pointer
head_no		== 9	; current disk head number
cylinder_msb	== 8	; current cylinder
cylinder_lsb	== 7	;
sector_no	== 6	; current sector
lba_no		== 6	; LBA block number
load_addr	== 4	; sector load/save address
part_num	== 3	; partition number
boot_parm	== 2	; boot parameter

; Starting I/O address of the SPIO-13 parallel port
_spio13_paddr	== 0x00

; Starting I/O address of the SPIO-13 serial port
_spio13_saddr	== 0x04

; First port on the IDE controller
_ide_port	== 0x70

; ASCII characters
BS		== 8
LF		== 10
CR		== 13
XON		== 17
XOFF		== 19
SPACE		== 32
DEL		== 127

console		== _spio13_saddr

; DOS partition table info
partlen		= 16		; Partition entry length
sig		= 0xAA55	; Master boot record signature

; Partition entry offsets
drive		= 0		; bits 0-6 always 0, bit 7 set if bootable
head		= 1		; partition starting point (CHS)
sector		= 2		;
cylinder	= 3		;
type		= 4		; partition type
end_head	= 5		; partition ending point (CHS)
end_sector	= 6		;
end_cylinder	= 7		;
start_lba	= 8		; starting LBA of the partition
len_lba		= 12		; length of partition in blocks


; Features
id_drive	== 0	; include _ide_drive_id routine
print_ptable	== 1	; include ptable routine
ide16		== 0	; 16-bit IDE controller installed
mirror		== 1	; 1=mirrored ROM, 0=ROM starts at 0
			;   Note: update the CODE variable in Makefile with
			;   the ROM origin.

free_space	== 12

