C
C------------------------------------------------------------------
C
C     RTNI SOLVES NONLINEAR  EQUATIONS OF THE FORM F(X)=0
C     FOR THEIR ROOTS BY NEWTONS METHOD
C
C     FCT IS THE EXTERNAL FUNCTION TO BE SOLVED
C
C     X=ROOT,                  F=FUNCTION VALUE AT X
C     DERF=VAL OF DERIVATIVE AT X
C     XST=INITIAL GUESS OF X   EPS=ERROR ALLOWED IN ROOT
C     IEND=MAX ITERATIONS ALLOWED
C     IER=ERROR PARAM, IER=0 THEN NO ERROR
C
C-----------------------------------------------------------------
C
      SUBROUTINE RTNI(X,F,DERF,FCT,XST,EPS,IEND,IER)
C
C  PREPARE ITERATION
C
      IER=0
      X=XST
      TOL=X
      CALL FCT(TOL,F,DERF)
      TOLF=100.*EPS
C
C  START ITERATION LOOP
C
      DO 6 I=1,IEND
      IF(F)1,7,1
C
C  EQUATION IS NOT SATISFIED BY X
C
    1 IF(DERF)2,8,2
C
C  ITERATION IS POSSIBLE
C
    2 DX=F/DERF
      X=X-DX
      TOL=X
      CALL FCT(TOL,F,DERF)
C
C  TEST ON SATISFACTORY ACCURACY
C
      TOL=EPS
      A=ABS(X)
      IF(A-1.)4,4,3
    3 TOL=TOL*A
    4 IF(ABS(DX)-TOL)5,5,6
    5 IF(ABS(F)-TOLF)7,7,6
    6 CONTINUE
C
C  END OF ITERATION LOOP
C  NO CONVERGENCE AFTER IEND ITERATION STEPS.  ERROR RETURN.
C
      IER=1
    7 RETURN
C
C  ERROR RETURN IN CASE OF ZERO DIVISOR
C
    8 IER=2
      RETURN
      END
