C
C-----------------------------------------------------------------
C
C  THIS SUBROUTINE COMPUTES THE ELECTRON EQUIVALENTS OF
C  LIGHT DEPOSITED IN THE SCINTILLATER, WHEN A PARTICLE
C  OF TYPE  "L"  (1=PROTON, 4=ALPHA) WITH ENERGY  E
C  SCATTERS FROM COORDINATES X(I) WITH DIRECTION COSINES C(I)
C  AND SCATTERING ANGLE  COSLP
C
C  THE SCINT RESPONSE FUNC IS  ELM(ENERGY,PAR1,PAR2,PAR3,PAR4)
C
C ------------------------------------------------------------------
C
      FUNCTION EEQUIV(E,X,C,COSLP,L)
C
      DIMENSION C(3),CN(3),X(3)
      COMMON /SCIN/ DHYD,DCARB,IGEO,X0,Y0,Z0
      COMMON /SCINP/ A,B,R,S,T,V
      COMMON /SCINA/ G,H,O,P,Q,W
C
      ELM(Y,A,B,R,S)=A*(1.-EXP(B*Y**R))+S*Y
      ELT=0
      IF (E .LT. .02) GOTO 300
      IF (E .LE. 0.2) GOTO 100
      U=6.2832*FNCRAN()
      D=1.0E+6
      DSM=1.0E+6
      CALL SCATTR(C,COSLP,U,CN)
      IF(CN(3) .GT. 0.0) DSM=(Z0-X(3))/CN(3)
      IF(CN(3) .LT. 0.0) DSM=-X(3)/CN(3)
      IF (IGEO-1) 10,20,20
   10 IF(CN(1) .NE. 0.0) D=ABS((X0-(ABS(CN(1))/CN(1))*X(1))/CN(1))
      IF(D .LT. DSM) DSM=D
      IF(CN(2) .NE. 0.0) D=ABS((Y0-(ABS(CN(2))/CN(2))*X(2))/CN(2))
      IF(D .LT. DSM) DSM=D
      GOTO 30
C
C  FOR CYLINDER WE FIND DISTANCE A HARDER WAY
C
   20 AQ=CN(1)*CN(1)+CN(2)*CN(2)
      BQ=2*(X(1)*CN(1)+X(2)*CN(2))
      CQ=X(1)*X(1)+X(2)*X(2)-X0*X0
      IF(AQ .NE. 0.0) D=(-BQ+SQRT(BQ*BQ-4.*AQ*CQ))/(2.*AQ)
   30 IF(D .LE. DSM) DSM=D
      D=E
      IF (L .EQ. 4) D=D*.25
      D=ALOG(D)
C
C  NEXT TWO LINES FIND RANGE OF PARTICLE IN SCINTILLATOR
C
      F=(((3.1471E-3-2.321E-4*D)*D-.020364)*D+.0819283)*D
      D=EXP((F+1.61711)*D-3.8103)/25.4
C
C  IF PARTICLE WONT ESCAPE SCINT  I.E. D.LE.DSM CALCULATION
C  IS SIMPLIFIED TO JUST PLUGING ENERGY INTO ELM(E, , , , , )
C
      IF(D .LE. DSM) GOTO 100
C
C  RANGE IS TO BIG SO WE MUST CALCULATE ENERGY LOST
C  IN TRAVELING A DISTANCE D-DSM OUTSIDE OF SCINT
C
      D=ALOG(25.4*(D-DSM))
      F=(((D*2.742E-5-1.8209E-4)*D-8.88849E-5)*D+1.00554E-3)*D
      EEXT=EXP((F+.561839)*D+2.1964)
C
C  EEXT=ENERGY FOR PRO OR ALPHA OUTSIDE SCIN
C
      IF (EEXT .LE. .02) GOTO 100
      IF (L .EQ. 4) GOTO 150
      ELT=ELM(EEXT,A,B,R,S)
  100 IF (L .EQ. 4) GOTO 400
      ELT=ELM(E,A,B,R,S)-ELT
      GOTO 300
  150 ELT=ELM(4.0*EEXT,G,H,O,P)
  400 ELT=ELM(E,G,H,O,P)-ELT
  300 IF(ELT .LE. 0.) ELT=0.
      EEQUIV=ELT
      RETURN
      END

