5
	!=======================================================!
	!							!
	!	COPYRIGHT	(C)	1978,1979		!
	!	AUTHOR		A E LAWRENCE			!
	!			PHYSICS SECTION			!
	!							!
	!	F L A S H	VERSION 1B-03   (10-79)		!
	!	*********	***********************		!
	!							!
	!	OP. SYSTEM	RSTS 6B	OR 6C:	BASIC+ RTS	!
	!	THIS SOFTWARE IS LIABLE TO CHANGE AND NO	!
	!	COMMITMENT IS IMPLIED BY IT.			!
	!							!
	!=======================================================!






10
	!=======================================================!
	!							!
	!	FLASH IS DESIGNED TO PROCESS DATA FROM A	!
	!	LUMMER-GEHRKE PLATE, AN ETALON OR A FABRY-	!
	!	PEROT INTERFEROMETER.				!
	!							!
	!	THE PROCEDURE IS SUITABLE FOR DETERMINING	!
	!	THE 'SPLITTING'  OF CLOSE SPECTRAL LINES,SUCH	!
	!	AS ARE OBTAINED IN THE ZEEMAN EFFECT.		!
	!							!
	!	++++++++++++++++++++++++++++++++++++++++++	!
	!							!
	!	THE PROGRAM CALLS GRAPH1 TO CARRY OUT THE	!
	!	PLOTTING  REQUIREMENTS AND LEAST SQUARES	!
	!	FITTING: GRAPH 1 SHOULD BE ACCESSIBLE ON	!
	!	ACCOUNT [1,2], PREFERABLY COMPILED.  IF IT	!
	!	IS ONLY AVAILABLE ON ANOTHER ACCOUNT OR		!
	!	DEVICE, MODIFY LINE 1000 APPROPRIATELY.		!
	!							!
	!	FLASH SHOULD ITSELF BE AVAILABLE, AGAIN		!
	!	COMPILED FOR PREFERENCE, ON THE CURRENT		!
	!	ACCOUNT OR ONE OF THOSE FLAGGED BY #,&,$ OR	!
	!	!. THESE REFERENCES ARE SET IN A$ IN LINE	!
	!	20100, AND MAY BE MODIFIED, IF REQUIRED.	!
	!							!
	!=======================================================!20
	!=======================================================!
	!							!
	!	FLASH ACCEPTS & STORES READINGS OF FRINGE	!
	!	POSITION X(I) AGAINST AN ARBITRARY COUNT I.	!
	!	THIS IS DONE FOR ONE OR MORE SETS OF FRINGES:	!
	!	WHEN THERE IS MORE THAN ONE SET, THEY ARE 	!
	!	IDENTIFIED BY A SINGLE CHARACTER SYMBOL.	!
	!							!
	!	THE PROGRAM CARRIES OUT UP TO 4 STAGES OF	!
	!	CALCULATION:					!
	!							!
	!	1)	FOR EACH SET OF LINES, THEORY PREDICTS	!
	!							!
	!	1/[X(I+1)-X(I)] = M*[X(I+1)+X(I)] + 2HM.	!
	!	THE SIGNIFICANCE OF THE CONSTANT M DEPENDS	!
	!	UPON WHETHER AN ETALON OR A LUMMER PLATE IS	!
	!	USED, BUT IN BOTH CASES H IS THE ZERO ERROR	!
	!	FOR X(I):					!
	!		R(I)=X(I)+H				!
	!	WHERE R IS THE 'RADIUS' OF THE FRINGE FROM	!
	!	THE OPTICAL AXIS. LEAST SQUARES FITTING YIELDS	!
	!	VALUES OF H AND OF M.				!
	!							!
	!	2)	HAVING OBTAINED VALUES OF H AND HENCE OF!
	!	R(I), IT IS POSSIBLE TO OBTAIN IMPROVED VALUES	!
	!	OF THE PARAMETER M. FOR BOTH INTERFEROMETERS	!
	!	WE FIND A RELATION OF THE FORM			!
	!		I  =  M*[R(I)]^2  +   K.		!
	!							!
	!	THUS A PLOT OF I AGAINST [R(I)]^2 YIELDS AN	!
	!	(IMPROVED) VALUE OF M.				!
	!							!
	!	3)	FOR VERY CLOSELY SPACED LINES, THEORY	!
	!	INDICATES THAT
	!	(R[I+J])^2 - (S[I])^2 = A*(R[I+J])^2		!
	!				 + B + J/M		!
	!	WHERE R[I] AND S[I] ARE THE ITH FRINGE RADII	!
	!	FOR THE TWO SPECTRAL LINES. A & B ARE CONSTANTS	!
	!	DEPENDING UPON WHICH  INTERFEROMETER IS USED:	!
	!	J IS A (SMALL) INTEGER. THE VALUE OF B YIELDS	!
	!	THE SPACING OF THE LINES. FLASH CARRIES OUT	!
	!	A 'SPLITTING PLOT' CALCULATION BASED UPON THIS.	!
	!	A IS NORMALLY TOO SMALL TO BE SIGNIFICANT.	!
	!							!
	!	4)	EXCESS FRACTIONS.			!
	!		THE PROGRAM INCLUDES AN OPTION TO	!
	!	DETERMINE THE ETALON SPACING OR LUMMER PLATE	!
	!	THICKNESS BY THE METHOD OF EXCESS FRACTIONS. AT	!
	!	LEAST 2 WAVELENGTHS SHOULD BE KNOWN.		!
	!	THE METHOD IS BELIEVED TO BE ORIGINAL.		!
	!							!
	!	FOR FURTHER DETAILS, SEE THE FLASH USER GUIDE.	!
	!							!
	!=======================================================!
50
	!	LINE NUMBER INDEX
	!	-----------------
	!
	!	200  -  900	:INITIALIZATION
	!	1000 -  1099	:DATA FILE LOOKUP
	!	1100 -  1999	:ERROR HANDLING
	!	2000 -  9999	:MAIN CODE
	!	10000-  20000	:FUNCTIONS
	!	20000-  30000	:SUBROUTINES


190
	!=======================================!
		INITIALIZATION
	!=======================================!

200
	NO EXTEND\
	DIM C%(200%),X(200%),S$(200%),A$(64%),N$(127%)\
	GOSUB 20000
	!	DO INITIALIZATION IN S/R SINCE MUST DO IT
	!	ON EVERY CHAIN ENTRY POINT
	!	RETURN WITH ERROR SET
	!	AND T$,C$, & J$ LOADED(CR/LF,CHAIN STRING,JOB-STRING)
999
	!==========================================!
		LOOK UP ON FILES
	!==========================================!


1000
	&"FLASH";T$\
	IFFNL%("$GRAPH1.BAC")THEN1020ELSE
	IFFNL%("$GRAPH1.BAS")=0%THEN&
	"GRAPH1 is not available.Cannot continue!"\GOTO32767
	!	PRINT HEADING
	!	LOOKUP ON GRAPH1.BAC
	!	IF IT'S THERE, BEAUTIFUL JUMP TO 1020
	!	ELSE  ... WHAT ABOUT .BAS ?
	!	IF THAT'S GONE, IT'S A SAD WORLD.

1010
	GOTO 32767 UNLESS FNI%(
"GRAPH1 is not compiled!Thus this will be a slow run."+T$+
	"Do you wish to continue")
	!	TELL 'EM BAD NEWS
	!	SO WHAT ABOUT IT, BABY??

1020
	N%=0%\
	GOTO2000UNLESSFNI%(
"If you have stored previous readings, and you want to utilize"+
	T$+"them on this run, answer YES")
	!	INIT. N% (NO. OF READINGS)
	!	JUMP TO 2000 IF NO PREVIOUS TO BE USED


1040
	INPUT"Name of file of previous readings";K$\
	OPENK$FORINPUTASFILE1%\
	GOSUB20400\
	CLOSE1%\
	GOTO1040IFFNI%("Any more files")\
	IFFNI%("Is there new data to be entered")THEN2000
	ELSE2040
	!	FILENAME?
	!	LOOK FOR IT & OPEN
	!	GET DATA INTO CORE & LOAD O$
	!	FINISHED!
	!	WHAT NEXT?

	!==========================================
	            END OF RAW DATA FILE RETRIEVAL
	 ==========================================


		ERROR ROUTINE
	==========================================1100
	IFERR=5%THENIFERL=10000%THENRESUME10010%
	ELSEIFERL=1040%THEN&K$;" not found:"\
	RESUME1040%
	!	IF FILE NOT FOUND BY FNL% RESUME AT 10010
	!	OTHERWISE IF DATA FILE NOT FOUND, TELL 'EM


1120
	IF ERR=52% AND ERL=2020% THEN RESUME 2040%

	!	ILLEGAL NUMBER ERROR TO SIGNAL END OF READINGS FROM 
	!	KB:

1130
	IF ERR<>16% AND ERL<>3250% THEN 1170 ELSE
	IF FNI%("Overwrite copy of "+F$) THEN KILL F$
		ELSE INPUT "New name";F$

1140
	RESUME

1170
	IFERL=3420%ANDERR=11%THENRESUME3440

1175
	IFERL=2120%THEN
		IFERR>47%ANDERR<53% THEN
			&"Impossible! Try again!";T$\RESUME







1180
	&"Run terminated!"IFERR=28%\
	E%=0%\
	IFLINE>3300%ORERL>3300%THENE%=3%ELSE
	IFLINE>2200%ORERL>2200%THENE%=1%


	!	Well it's one way out of this jungle.
	!	Try to leave it as we would wish to find it.





1200
	&RIGHT(SYS(CVT%$(1545%)+CHR$(ERR)),4%)UNLESSERR=28%\
	IFE%THENRESUME1980ELSERESUME32767
	!	REPORT ERROR   AND EXIT


1980
	F$="FLASH."+J$\
	GOSUB20800\
	IFE%AND2%THENF$="FLSH"+J$+".CMD"\
	GOSUB20800\
	FORJ%=0%TOA%\
	F$="FH"+NUM1$(J%)+"."+J$\
	GOSUB20800\
	NEXTJ%

	!	CLEAN UP DISC AND EXIT

1999
	GOTO 32767

	!================================================!
		KB: DATA INPUT SECTION
	!================================================!


2000
	S%=FNI%("Does the data refer to more than 1 spectral line")\
	&"OK, ready to accept your readings";T$;
"Please use return after each number, and type 'E' to signal";
	T$;"the end.";T$;
	"(RUB OUT works, but does not echo in the usual way.)"
\
&"Please identify readings relating to different lines by giving";
T$;"a single letter symbol for each line"IFS%\
&"Please giue your readings after the headings:-"

2010
	A$=SYS(CHR$(3%))\
	GOSUB 20200\
	OPEN"KB:"ASFILE12%\
	FIELD#12%,BUFSIZ(12%)ASE$
	!	ANY SYMBOLS?
	!	PROMPT
	!	DISABLE ECHO
	!	OPEN & FIELD UP ON CHANNEL 12



2020
	C%(N%+1%)=VAL(FNG$)\
	&TAB(15%);\
	X(N%+1%)=VAL(FNG$)\
	N%=N%+1%\
	IFS%THEN2030ELSE&\
	GOTO2020

2030
	&TAB(35%);\
	S$(N%)=LEFT(FNG$,1%)\
	&\ GOTO2020

	!	GET SYMBOL IF NECESSARY





2040
	A$=SYS(CHR$(2%))\
	GOTO2100UNLESSFNI%(
	T$+"Do you want to inspect the readings")\
	GOSUB 20200\
	FORI%=1%TON%\
	&C%(I%);TAB(15%);X(I%);\
	IFS%THEN&TAB(35%);S$(I%)ELSE&

2060
	NEXT I%\&
	!	LOOP ROUND
	!	FINISH WITH PRINT





2100
	GOTO2180UNLESSFNI%("Any deletions")\
	&"Please give the incorrect reading for deletion:-"
	!	STAY HERE IF THERE ARE DELETIONS
	!	PROMPT

2120
	INPUT	"FRINGE COUNT";F%,
		"POSITION (MM.)";X\
	INPUT"SYMBOL";S$IFS%\
	GOTO 2140 IF
	C%(I%)=F%ANDX(I%)==XAND(S%IMP(S$=S$(I%)))
		FORI%=1%TON%+1%\
	&"Reading not found!"\GOTO2160
	!	REQUEST DUD POINT
	!	SCAN FOR MATCH
	!	IF NOT FOUND, JUMP TO SEE IF ANY MORE (2180)


2140
	GOTO 2160 IFI%=N%+1%\
	FORJ%=I%TON%-1%\
	C%(J%)=C%(J%+1%)\
	X(J%)=X(J%+1%)\
	NEXT J%\
	S$(J%)=S$(J%+1%)FORJ%=I%TON%-1%IFS%\N%=N%-1%\
	&"Deleted!"
	!	IF MATCH AT N%+1%, NOT GENUINE (& FUNNY POINT!)
	!	WIPE IT OUT, & REPORT

2160
	GOTO2120IFFNI%("More deletions")
	!	ROUND IF ANY MORE

2180
	GOTO2190UNLESSFNI%("Any more readings")\
	&"OK, go ahead under the headings."\
	GOTO2010
	!	OFFER CHANCE TO PUT IN FURTHER READINGS
	!	PROMPT & GO AROUND TO 2020 AGAIN

	!	=========================================
2190
	C%=1%\
	GOSUB20600IFS%\
	O$=STRING$(Q%,0%)IFLEN(O$)<Q%\
	O2$=""\
	FORC1%=1%TOC%\
	S$=MID(W$,C1%,1%)\
	&T$;"Symbol:";S$IFS%\
	J%,K%=0%\
	FORI%=1%TOLEN(O$)/Q%\

	O1$=MID(O$,(I%-1%)*Q%+1%,Q%)\
	M%=ASCII(O1$)\
	M1%=((S%IMPS$=MID(O1$,2%,1%))ANDM%AND1%)
		<>0%\
	IFM1%ANDM%AND2%THENJ%=J%+1%\
	&"H value:";CVT$F(MID(O1$,3%,V%))
	!	SET C% TO 1 ANYWAY
	!	SET C% AND W$ IF S%
	!	Q% IS SIZE FOR 1 ENTRY OF FLAG, SYM, AND 2 CVTF$'S
	!	SET O$ TO DEFAULT IF NOT ALREADY
	!	INIT O2$ TO TAKE NEW O$
	!	LOOP ON SYMBOLS (IF ANY)
	!	SET SYMBOL WHETHER RELEVANT OR NOT
	!	TELL WHICH WE ARE INSPECTING
	!	LOOP ON ENTRIES IN O$
	!	CLEAR J% (FOR NO. OF H ENTRIES FLAGGED)
	!	LIKEWISE FOR K% AND M VALUES
	!	GET RELEVANT CHUNCK FROM O$  - SAVES CALLING MID
	!	REPEATEDLY
	!	SET FLAG BYTE INTO M%
	!	BOOLEAN ALGEBRA TO YOU
	!	IF WE GOT ONE AND H FLAG BIT SET THEN INCREMENT
	!	COUNT IN J% AND REPORT
2192
	IFM1%ANDM%AND4%THENK%=K%+1%\
	&"M Value:";CVT$F(MID(O1$,3%+V%,V%));T$;
	"Intercept K:";CVT$F(MID(O1$,3%+2%*V%,V%))
	!	M VALUE FLAG BIT ON??
	!	YEP! - REPORT & PUSH UP K%


2194
	NEXT I%\
	M%=0%\M%=M%OR2%IFJ%\M%=M%OR4%IFK%\M%=M%OR1%IFS%\
	GOTO2300UNLESSJ%+K%\
	M%=(M%ANDNOT2%)IFFNI%("Clear value(s) of H")IFJ%\
	M%=(M%ANDNOT4%)IFFNI%("Clear value(s) of M")IFK%
	!	CLOSE SCAN ON THIS SYMBOL (IF ANY)
	!	SET FLAG BITS CORRECTLY
	!	CLEAR FLAG BITS IF ASKED


2200
	J%=2%IFFNI%("Reset H")IFM%AND2%IFJ%=1%\
	K%=2%IFFNI%("Reset M")IFM%AND4%IFK%=1%\
	H=FNV(2%)IFJ%=1%IFM%AND2%\
	M=FNV(4%)IFK%=1%ANDM%AND4%\
	INPUT"Value of H to use";HIFM%AND2%IFJ%>1%\
	IFK%>1%THENIFM%AND4%THENINPUT"Value of M to use";M,
	"& of intercept K";W1
	!	GET ONLY VALUE OF H IF J%=1% IF FLAGGED
	!	LIKEWISE FOR M
	!	IF SEVERAL, ASK FOR VALUES2300
	O2$=O2$+CHR$(M%)+S$+CVTF$(H)+CVTF$(M)+CVTF$(W1)\
	NEXT C1%\
	O$=O2$\
	OPEN"FLASH."+J$FOROUTPUTASFILE1%\
	D%=3%+V%\
	E%=-INT(-(5.+C%*Q%)/D%)\
	GOSUB20300\L%=256%/D%\
	LSETB$=CHR$(C%)+CVT%$(N%)+CVT%$(E%)+O$\
	I%=E%\
	FORJ%=1%TON%\
	I%=I%+1%\
	LSETA$(I%)=CVT%$(C%(J%))+CVTF$(X(J%))+S$(J%)
	!	ADD IN APPROPRIATE ENTRY TO O2$
	!	CLOSE SYMBOL LOOP
	!	RESET O$
	!	OPEN RAW DATA FILE ON CHANNEL 1
	!	SET D% TO SPACE FOR 1 ENTRY
	!	SET E% TO POSITION BEFORE 1ST DATA SLOT
	!	(IE. 1ST E% SLOTS RESERVED)
	!	FIELD UP,  L% IS MAX SIZE FOR 1 BLOCK
	!	LOAD C%,N%,E% AND DATA ALREADY CALCULATED, IF ANY
	!	INIT I% FOR 1ST DATA ENTRY
	!	LOOP TO LOAD DATA

3100
	IFI%=L%THENPUT#1%\I%=0%
	!	PUT IF BUFFER FULL; RESET I% FOR NEXT BUFFER




3150
	NEXT J%\PUT#1% IFI%
	!	FINISH LOOP
	!	WRITE LAST PARTIALLY FILLED BLOCK OF BUFFER
	!======================================================
	END OF RAW DATA STORAGE
		NOTE:
		FLASH.J$ STILL OPEN ON #1, AND KB: ON #12

		NEXT NEED TO KNOW WHAT IS NEEDED...

	=======================================================
3200
	&"Readings entered!"\
	IFFNI%("Anything else required on this run")THEN3300
		ELSE INPUT
		"Name for data storage (??????.???)";F$\
	CLOSE1%,12%
	!	IT'S STORED
	!	IS THAT ALL?
	!	SO WHAT DO YOU WANT TO CALL IT?

3250
	NAME"FLASH."+J$ AS F$\
	GOTO 32767
	!	DO IT --  AND OUT


3300
	GOSUB 20700\
	GOSUB 20600\
	FORA%=1%TOC%\
	GOTO3320IF
	ASCII(MID(O$,(A%-1%)*Q%+1%,1%))AND2%\
	S$=MID(W$,A%,1%)\
	Y$=">"+T$+"X(I+1)+X(I)  METRES"\
	Y$=Y$+"  "+S$IFS%\
	Y$=Y$+T$+"Reciprocal of X(I+1)-X(I)  M^-1"+T$\
	F$=FNB$(A%,R%,Y$,1%)\R%=R%+3%*V%\
	GOTO3340IFR%>127%-3%*V%

	!	Set up for GRAPH1 first set of plots



3320 
	NEXT A%

	!	Patch to avoid GRAPH1 common core overflow



3340
	GOTO4000IFP$=""\
	F$="FLSH"+J$+".CMD"\
	P$=FNC$(F$,P$+"N"+T$+Q$+CHR$(26%))\
	P$=SYS(C$+"3400*"+F$)
	!	FLASH+J$.CMD will be command file
	!	Direct GRAPH1 to return to  line 3400


3350
	CLOSE1%\
	CHAIN"$GRAPH1"500
	!	CLOSE SYMBOL SCAN LOOP
	!	JUMP TO 4000 IF NOTHING FOUND TO DO
	!	F$ IS COMMAND FILE
	!	CREATE IT VIA FNC$
	!	WRITE COMMON CORE





3400
	GOSUB20000\
	K$=SYS(CHR$(7%))\
	OPEN"FLASH."+J$FORINPUTASFILE1%\
	GOSUB20400\
	B$="FLSH"+J$+".CMD"\
	OPEN B$FORINPUTASFILE2%\
	INPUT#2%,D$FORI%=1%UNTILD$="##"
	!	Return here
	!	Get data passed by GRAPH1 in common core
	!	Pick up raw data again
	!	LOOK FOR COMMAND FILE FLAG


3420
	INPUT#2%,D$,S$,J%\
	KILLD$\ONF%GOTO4420,6020IFF%\
	H=CVT$F(MID(K$,J%+V%,V%))/CVT$F(MID(K$,J%,V%))*500.\
	&S$;": ";IFS%\
	&"H value is";H;"(mm.)"\
	I%=2%\
	I%=I%+Q%	WHILE
	(ASCII(MID(O$,I%-1%,1%))AND2%
	OR
	S%ANDS$<>MID(O$,I%,1%))ANDLEN(O$)>I%\
	O$=LEFT(O$,I%-2%)+CHR$(2%ORASCII(MID(O$,I%-1%,1%)))+S$+
	CVTF$(H)+RIGHT(O$,I%+V%+1%)\
	GOTO3420
	!	READ COMMAND FILE RECOVERY ENTRY
	!	-- AND ACT ON IT!

3440	CLOSE2%\
	KILLB$\GOTO6040IFF%=2%\
	FIELD#1%,512%ASE$\
	GET#1%,RECORD1%\
	LSETE$=LEFT(E$,5%)+O$+RIGHT(E$,LEN(O$)+6%)\
	PUT#1%,RECORD1%\
	GOTO3200

	!	To standard request @ 3200
	!	(modification from version 1B-02)






4000
	GOSUB20600\GOSUB20700\
	FORA%=1%TOC%\
	O1$=MID(O$,(A%-1%)*Q%+1%,Q%)\
	GOTO4020IFASCII(O1$)AND4%\
	S$=MID(O1$,2%,1%)\
	H=CVT$F(MID(O1$,3%,V%))\
	Y$=">"+T$+"  [X(C)+H]^2  (metres^2)"\
	Y$=Y$+"  "+S$IFS%\
	F$=FNB$(A%,R%,
	Y$+T$+"FRINGE COUNT"+T$,2%)\
	R%=R%+3%*V%\
	GOTO 4040	IFR%>127%-3%*V%


	!	Here we go again...
	!	Set everything up once more:we lost all on chaining
	!	Scurry around ready for GRAPH1 to do next set of plots.


4020
	NEXT A%

	!	Close loop (patch)



4040
	GOTO5000IFP$=""\
	F$="FLSH"+J$+".CMD"\
	P$=FNC$(F$,P$+"N"+T$+Q$+CHR$(26%))\
	P$=SYS(C$+"4400*"+F$)\
	GOTO3350

4400
	F%=1%\GOTO3400
	!	SECOND CHAIN RE-ENTRY POINT

4420
	M=CVT$F(MID(K$,J%,V%))\
	&S$;":";IFS%\
	&"M VALUE IS";M;"M^-2"\
	I%=2%\
	I%=I%+Q%WHILE
	(ASCII(MID(O$,I%-1%,1%))AND4%
	OR
	S%ANDS$<>MID(O$,I%,1%))ANDLEN(O$)>I%\
	O$=LEFT(O$,I%-2%)+CHR$(4%OR
	ASCII(MID(O$,I%-1%,1%)))+S$+MID(O$,I%+1%,V%)+MID(K$,J%,V%+V%)
		+RIGHT(O$,I%+Q%-1%)\
	GOTO3420
	!	Recover values returned by GRAPH1
	!	Wash & brush-up at 3420 again



5000
	IFC%<2%THEN&
"Only 1 line present, so no splitting or excesses can be calculated."\
	GOTO7050
	!	Nothing more to do if only 1 line entered


5100
	GOTO5200UNLESSFNI%("Splitting calculation required")\
	&"'Splitting' plot:"\
INPUT"Please give the symbols for the lines, separated by a ','";S1$,S2$


5120
	S$=S1$\H1=FNV(2%)\
	S$=S2$\H2=FNV(2%)\
	H1,H2=(H1+H2)/2.IF
		FNI%("Use average value of H")\
	GOSUB20700\A$=""\
	FORA%=0%TO2%\A$="+"+NUM1$(A%)IFA%\
	R$="r["+S2$+",I"+A$+"]^2"\
	Y$=R$+"-r["+S1$+",I]^2"\
	F$=FNB$(A%,R%,
	"/25/>"+T$+R$+T$+Y$+T$,3%)\
	R%=R%+3%*V%\&\
	NEXT A%\
	F$="FLSH"+J$+".CMD"\
	K$=FNC$(F$,P$+"N"+T$+Q$+CHR$(26%))\
	K$=SYS(C$+"6000*"+F$)\
	GOTO3350
	!	As usual, set everything up for GRAPH1


5200
	&"EXCESS FRACTIONS";T$;
	"====== =========";T$\GOSUB20600\
	INPUT"How many lines are to be processed";N1%\
	IFN1%<2%THEN&"At least 2 lines required!"\
	GOTO6040

	!	PRINT NOTICE
	!	ASK HOW MANY LINES
	!	EXIT IF <2 SPEC.

5220
	FORJ%=1%TON1%\
		INPUT"Symbol";S$\
		IFLEN(S$)<>1%ORINSTR(1%,W$,S$)=0%THEN
		&S$;" Invalid!"\GOTO6040

	!	LOOP FOR POINTS


5240
		A=FNV(4%)\
		K(J%)=W1+INT(-W1)\
		INPUT"Wavelength (Angstrom)";L(J%)\
	NEXT J%\

	J%=1%\
	J%=I%IFL(I%)<L(J%)FORI%=2%TON1%\
	X=L(1%)\L(1%)=L(J%)\L(J%)=X\
	X=K(1%)\K(1%)=K(J%)\K(J%)=X\
	&T$;"Wavelengths:-"\
	FORI%=1%TON1%\
		&L(I%),\
		H(I%)=1./L(I%)\
	NEXTI%\

		&\INPUT"Separation/thickness d(mm)";D,
	"Estimated % error on d";Y\

	GOTO5300UNLESS
		FNI%("Are the results from a Lummer plate")\

	FOR I%=1%TON1%\
	H(I%)=H(I%)*SQR((FNN(L(I%))-1)*(1+FNN(L(I%))))\
	K(I%)=-K(I%)\
	NEXT I%


	!	FNN IS THE DISPERSION CURVE FOR LUMMER PLATE
	!	IT SHOULD BE RESET ACCORDING TO THE PLATE
	!	IN USE.(line 10900.)
	!	We have taken the absolute refractive index of air
	!	above as 1 : feel free to change it ---


5300
	X=TIME(1%)	\
	H=0.		\
	H=H+H(I%)*H(I%)FORI%=1%TON1%	\
	H=SQR(H)	\
	H1=.5		\
	H2=2E7*D	\
	&T$;"Initial lattice point"\
	FORI%=1%TON1%	\
		O(I%)=INT(H1+K(I%)+H2*H(I%))	\
		D(I%)=H2*H(I%)-O(I%)+K(I%)	\
		GOSUB20960IFV%=4%	\
		H(I%)=H(I%)/H	\
		&O(I%),		\
	NEXT I%			\

	S=H(1%)\A=D(1%)/S\D,J%=0.\
	FORI%=2%TON1%	\
		A(I%)=D(I%)-A*H(I%)\
		D=D+A(I%)*A(I%)	\
	NEXTI%\
	&T$;"Initial modulus limit=";SQR(D);T$\
	A=S*S\W1=1.1*D\
	GOTO6040IFY=0.\
	R%=(Y/100.*O(1%))+1%	\

	FORI1%=-R%TOR% STEP SGN(Y)	\
		M=FNS(I1%)	\
		GOTO5360IFM*A>=D	\
		GOSUB20900		\
		M=M-H2*H2		\
		IFM<DTHENJ%=I1%		\
		D=M	\	W1=1.1*D

	!	Set H to mod H()
	!	Load O() with q0 vector & report
	!	Reset H() to unit k() vector
	!	Calculate C init.  vector very carefully for good accuracy
	!	Load it into A()
	!	Initialize D to an initial modulus^2 limit
	!		[ m (init) ^2]
	!	Set A for fast check below (& W1 for 'tolerance' check).
	!	R% is range for scan
	!	The main loop on I1%
	!	Call FNS to load  current q vector into Z()
	!	Current m-vector into M()
	!	and m^2 n into M
	!	Fast check: if m^2 (k1 ^2)>D,  no hope!
	!	Otherwise calculate m().H() --> H2 @ 20900
	!	Set  M= !delta!^2
	!	If new minimum, reset minimum integer (J%)
	!	and modulus^2 limit (D)
	!	Reset "tolerance" limit W1


5320
		IFM<W1THEN&	\
		M(1%)=0.	\
		&"**New ";IFJ%=I1%	\
		&"Modulus=";SQR(M);"at"	\
		Z(1%)=I1%	\
		GOSUB20950	\
		&T$;"with delta="	\
		MAT&D(N1%),\&

	!	If outside tolerance, fall through.
	!	Patch zero element of M().
	!	Report everything, loading D() with corresponding delta
	!		in passing.
	!	D() is reset, even if not new minimum.


5360
	NEXTI1%	\
	X=(TIME(1%)-X)/10.	\
	A$=SYS(CHR$(0%))	\
	&T$;"Complete!";T$;"Minimum="SQR(D);T$;
	"At lattice point:"			\
	M=FNS(J%)	\
	Z(1%)=J%	\
	GOSUB20900	\
	GOSUB20950	\
	&T$;"corresponding to K intercepts:"	\
	MAT&K(N1%),	\
	&"with delta:"	\
	MAT&D(N1%),	\
	&T$;"Wavelengths:-"	\
	MAT&L(N1%),	\
	&"CPU time:";X;"seconds.";T$\	GOTO6040

	!	Close main scan loop
	!	Re-enable ^O
	!	And report results.
	!	(Assume M(1%)=0, still.)

6000
	F%=2%\&"Y intercepts were:"\
	GOTO3400


6020
	&CVT$F(MID(K$,J%+V%,V%));"metres^2"\
	GOTO3420


6040
	GOTO5100UNLESSFNI%("Finish")
7050
	GOTO7090UNLESSFNI%("Store data")

7080
	INPUT"Storage name";F$\GOTO3250
7090
	KILL"FLASH."+J$\GOTO32767
10000
	DEF FNL%(F$)\
	FNL%=-1%\
	K$=SYS(CVT%$(1553%)+CVT%$(-1%)+RIGHT(SYS(CVT%$(1782%)+F$),5%))\
	GOTO10020


	!FNL% LOOKS UP ON FILE F$
	!SETS FNL% TO -1% IF FOUND ,0% OTHERWISE


10010
	FNL%=0%
	!SIGNAL NOT FOUND

10020
	FNEND
	!

	=============================================



10100
	DEF FNI%(P$)\
	&P$;\
	INPUT P$\
	FNI%=((ASCII(P$)AND95%)=89%)\
	FNEND
	!
	!GENERAL INPUT FUNCTION FOR YES/NO QUESTIONS
	!P$ IS THE PROMPT STRING (OVERWRITTEN)
	!RETURNS -1% FOR YES,0% FOR NO.

	============================================
10200
	DEFFNO$(F$,S$,B%)\
	OPENF$FOROUTPUTASFILE11%\
	GOSUB20500\
	L%=255%/V%\
	K%=0%\
	&"LINE ";S$IFS%UNLESSB%=3%\
	IFB%=1%THEN&"COUNT I";TAB(9%);"[X(I+1)-X(I)]^-1",
	"X(I+1)+X(I)";T$,"(METRE)^-1","METRES"
	ELSEIFB%=2%THEN&"COUNT I","[X(I)+H]^2";T$,"METRES^2"
	ELSE&"COUNT I",R$,Y$;T$,"M^2","M^2"\GOTO10212


10210
	FORI%=1%TON%\
	GOTO10240UNLESSS$=S$(I%)IFS%\
	GOTO10220IFB%=2%\
	J%=1%\
	J%=J%+1%UNTIL
	(C%(J%)=C%(I%)+1%AND(S%IMPS$=S$(J%)))ORJ%=N%+1%\
	GOTO10240IFJ%=N%+1%ORX(J%)=X(I%)\
	X=(X(J%)+X(I%))/1E3\
	Y=1E3/(X(J%)-X(I%))\
	&C%(I%),Y,X\
	GOTO10230


10212
	J%=1%\N1%,S=0%
10214
	J%=J%+1%UNTIL
	S$(J%)=S1$ORJ%=N%+1%\
	GOTO10250IFJ%=N%+1%\
	G%=1%\
	G%=G%+1%UNTIL
	S$(G%)=S2$ANDC%(G%)=C%(J%)+A%ORG%=N%+1%\
	GOTO10235IFG%=N%+1%\
	X=(X(G%)+H2)^2/1E6\
	Y=(X(G%)+X(J%)+H1+H2)*(X(G%)-X(J%)+H2-H1)/1E6\
	&C%(J%),X,Y\S=S+Y\N1%=N1%+1%\
	GOTO10230

10220
	X=(X(I%)+H)*(X(I%)+H)*1E-6\
	Y=C%(I%)\
	&Y,X


10230
	K%=K%+1%\
	A$=FNW$(X,Y,K%)
	!	Insert in graph data file with FNW$

10235
	IFB%=3%THENJ%=J%+1%\GOTO10214
10240	NEXT I%
10250
	&"Average Y=";S/N1%IFB%=3%\

	A=(K%+1.)/L%			\
	IF A>INT(A) THEN PUT#11%		\
	GET#11%,RECORD 1%
	!LOOP
	!FIND A TO SEE IF WE ARE STILL ON 1ST BLOCK
	!NO, GONE PAST, SO WRITE CURRENT RECORD, &
	! GET BLOCK 1 BACK


10260	LSET N$(1%)=CVT%$(K%)\LSETN$(2%)="N"\
	PUT#11%,RECORD 1%\
	CLOSE 11%	\
	FNEND
	!WRITE NO OF POINTS IN FILE
	!SIGNAL NO SYMBOLS : WE ARE ONLY USING GRAPH 1
	!& WE SHALL OVERWRITE DATA ON RETURN, HENCE
	!NO POINT IN SYMBOLS, BECAUSE WE CAN'T PASS
	!TO GRAPH 2 ANYWAY.
	!WRITE BLOCK 1 BACK
	!CLOSE & FINISH

	===========================================


10300	DEF FNW$(X,Y,K%)\
	A=1.*K%/L%\
	K1%=A\
	PUT#11% IF K1%=A\
	K1%=1%+(K%-K1%*L%)*2%\
	LSET N$(K1%)=CVTF$(X)\
	LSET N$(K1%+1%)=CVTF$(Y)\
	FNEND
	!FNW$ WRITES THE (X,Y) POINT INTO THE K%TH
	!DATA SPACE IN A GRAPH RECORD I/O FILE.
	!IT ONLY WRITES THE BUFFER TO DISC WHEN IT REQUIRES
	!NEXT. THUS IT ALWAYS LEAVES THE CURRENT BUFFER IN
	!CORE, SO THAT THE SYMBOL STRING, IF ANY ,CAN BE EASILY
	!WRITTEN.
	!FNW$ REQUIRES THAT L% HAS BEEN SET TO NUMBER
	!OF DATA SLOTS - PROBABLY BY FNO$, ETC.
	!ALSO ASSUMES THAT FIELDING HAS BEEN DONE BY
	!SUBROUTINE AT 20500
	!*ASSUMES THAT K% IS INCREASED ON SUBSEQUENT CALLS*

	============================================


10400
	DEFFNP(A)\
	A$=CVTF$(A)\
	FNP=CVT$F(CVT%$(CVT$%(A$)AND-4096%)+RIGHT(A$,3%))\
	FNEND

	!	FNP RETURNS FLOAT VARIABLE WITH ONLY 12 BIT
	!	MANTISSA :DESIGNED FOR 2-WORD MATH PACK.
	!	FOR FULL PRECISION MULTIPLY

	!===========================================================10500
	DEF FNC$(F$,P$)\
	OPEN F$ FOR OUTPUT AS FILE 10%\
	&#10%,P$\
	CLOSE10%\
	FNEND

	!	FNC$ WRITES AN ASCII FILE F$
	!	CONTAINING SIMPLY P$ 
	!	FOR WRITING COMMAND FILE

	============================================
10600
	DEF FNG$	\
	K$=""
	!	ODT TERMINATOR ECHO-SUPPRESSED INPUT FUNCTION

10620
	L%=0%\
	A$=SYS(CVT%$(1036%))\
	GET#12%\
	A$=LEFT(E$,RECOUNT)\
	&CVT$$(A$,4%);\
	K$=K$+A$\
	L%=INSTR(1%,A$,CHR$((K%*(11%*K%-39%)+54%)/2%))
		FORK%=0%UNTILL%<>0%ORK%=2%\
	GOTO10620UNLESSL%
	!	ODT MODE ENABLED ON CHANNEL 12
	!	GET ANYTHING GOING
	!	LOAD INTO A$
	!	ECHO CHARACTER(S)
	!	PUT IN LARDER K$
	!	LOOK FOR TERMS. IN ORDER ESC, CR,LF
	!	Well it's different,  & can't use CMP
	!	GO ROUND FOR MORE IF NO TERMS.
	!	OTHERWISE FALL THROUGH


10630
	I%=INSTR(2%,K$,CHR$(127%))\
	IFI%THEN&"^";\
	K$=LEFT(K$,I%-2%)+RIGHT(K$,I%+1%)\
	GOTO10630

	!	SEE IF ANY RUBOUTS SEEN
	!	IF SO SIGNAL SEEN WITH "^"
	!	AND DELETE PRECEEDING BYTE & R/O ITSELF


10640
	FNG$=CVT$$(K$,4%)\
	FNEND
	!	LOAD EVERYTHING UPTO & EXCLUDING TERMINATORS
	!	COULD BE A PROBLEM IF TIME FOR >1 CHARACTER

	===================================================
10700
	DEFFNV(B%)\
	FORI%=1%TOLEN(O$)/Q%\
	O1$=MID(O$,(I%-1%)*Q%+1%,Q%)\
	G%=ASCII(O1$)\
	W1%=(G%ANDB%)*(S%IMPS$=MID(O1$,2%,1%)ANDS%ANDG%AND1%)\
	FNV=CVT$F(MID(O1$,3%+(B%-2%)/2%*V%,V%))IFW1%\
	W1=CVT$F(MID(O1$,3%+V%+V%,V%))IFW1%IFB%AND4%\NEXTI%\
	FNEND
	!	Isn't Boolean fun?
	!	Picking up data - depends on bit in B% - see calls




10800
	DEFFNB$(A%,R%,L$,F%)\
	F$="FH"+NUM1$(A%)+"."+J$\
	P$=P$+"M"+T$+"Y"+T$UNLESSR%=1%\
	P$=P$+"N/"+F$+T$+"E"+T$+"N"+T$+"P<^"+NUM1$(R%)+"^"+L$\
	FNB$=FNO$(F$,S$,F%)\
	Q$=Q$+F$+","+S$+","+NUM1$(R%)+T$\
	FNEND
	!	Writing GRAPH1 command file

	!===================================================!



10850
	DEFFNS(J%)\
		M=0.\
		FORI%=2%TON1%	\
			H=A(I%)+J%/S*H(I%)	\
			Z(I%)=INT(H+H1)	\
			M(I%)=H-Z(I%)		\
			M=M+M(I%)*M(I%)		\
		NEXTI%		\
	FNS=M	\
	FNEND

	!	EXCESS FRACTION FUNCTION
	!	J% IS DISPLACEMENT X-INTEGER
	!	Z() is set to lattice point
	!	M() is the corresponding m vector
	!	FNS and M return with m^2

	!======================================================10900
	DEFFNN(L)=1.5258-390.247/(L-1306.97)^1.2

	!	HARTMAN FIT FOR DISPERSION OF GLASS
	!	RESET THIS FOR PARTICULAR LUMMER PLATE IN USE
	!	L SHOULD BE IN ANGSTROM UNITS


20000
	T$=SYS(CVT%$(1785%))\
	T$=CVT%$(3338%)\
	V%=LEN(CVTF$(0.))\
	Q%=3%*V%+2%\
	ONERRORGOTO 1100

	!	T$ IS LF,CR
	!	V% SHOWS 2 OR 4 WORD MATH PACK.
	!	INITIALIZE ERRORS


20100
	J$=NUM1$(ASCII(SYS(CVT%$(1545%)))/2%)\
	A$=" #&$!"\
	GOTO20120IFFNL%(MID(A$,I%,1%)+"FLASH.BAC")
		FOR I%=1%TO5%\
	GOTO20120 IF FNL%(MID(A$,I%,1%)+"FLASH.BAS")
			FOR I%=1%TO5%\
	&'Please type "COMPILE" and then RUN again.";T$;
	"However, if there is no room, then instead type 'SAVE'";T$;
	"and RUN again."\	GOTO32767

	!	SET JOB NUMBER STRING INTO J$
	!	LOOKUP FOR A COMPILED FILE SOMEWHERE
	!	LOOK UP FOR A SOURCE FILE
	!	NONE FOUND - THEY'LL HAVE TO CREATE ONE
	!	NOTE THAT OUR SYSTEM HAS BEEN PATCHED SO THAT '&'_
	!	SPECIFIES AN ACCOUNT:YOU MAY NEED TO DELETE IT FROM A$
	!	AND CONTRACT THE LOOPS TO 4%




20120
	C$=CHR$(8%)+"*"+MID(A$,I%,1%)+"FLASH"+"+"\
	RETURN

	!	LOAD "CHAIN - FILE"  INTO C$
	!	WE DON'T NEED TO KNOW EXTENSION FOR CHAINING
	!	SYSTEM LOOKS FOR US  (THANKS, RSTS!!)
	!	If odd RTS such as 4-word math BASIC+ co-resident
	!	with 2-word BASIC+ RTS, extension may have to be
	!	explicit.








20200
	&T$;"FRINGE COUNT";TAB(15%);"POSITION (MM.)";\
	IFS%THEN&TAB(35%);
	"SYMBOL   <--IDENTIFIES SPECTRAL LINE" ELSE &

	!	PRINT HEADINGS
	!	SYMBOL PROMPT IF C% SET





20220
	&"------ -----";TAB(15%);"-------- -----";\
	IFS%THEN&TAB(35%);
	"------" ELSE &

	!	ISN'T THAT BEAUTIFUL?

20240
	& \ RETURN

	!	THAT'S YOUR LOT

20300
	FIELD#1%,D%*I%ASB$,D%ASA$(I%+1%)FORI%=0%TO256%/V%-1%\
	FIELD#1%,E%*D%ASB$\
	RETURN
	!	D% IS ROOM FOR 2 BYTE INTEGER + V% BYTE FLOAT &
	!		1 BYTE CHARACTER
	!	FIELD UP ON CHANNEL 1
	!	B$ IS USED IN ACCESSING RESERVED SLOTS
	!	1ST DATA POINT IN A$(E%+1%) SLOT.


20400
	D%=3%+V%\FIELD#1%,1%ASA$,2%ASN$,2%ASE$\
	L%=256%/D%\GET#1%,RECORD1%\
	C%=ASCII(A$)\
	M%=CVT$%(N$)\
	E%=CVT$%(E$)\
	GOSUB20300\
	O$=O$+MID(B$,6%,C%*Q%)\
	I%=E%+1%\S%=-1%IF
	(C%>1%)OR(C%=1%AND(ASCII(MID(B$,6%,1%))AND1%))
	!	FIELD UP
	!	L% IS MAX ADDRESS IN BUFFER
	!	GET 1ST BLOCK
	!	SET SYMBOL FLAG IF MORE THAN 1 LINE FROM DATA FILE:
	!	 READ C%,M%,E%, ETC, AND LOAD O$
	!	I% SET TO INITIAL DATA ADDRESS IN 1ST BLOCK
	!	SET SYMBOL FLAG IF MORE THAN 1 LINE FROM DATA FILE


20420
	FOR J%=I% UNTIL J%=L%+1% OR M%=0%\
	N%=N%+1%\	M%=M%-1%	\
	C%(N%)=CVT$%(A$(J%))\
	X(N%)=CVT$F(MID(A$(J%),3%,V%))\
	S$(N%)=MID(A$(J%),D%,1%) IF S%\
	NEXT J%\
	GOTO 20460 UNLESSM%\
	I%=1%\
	GET#1%\
	GOTO 20420
	!	LOOP ON J% FROM INITIAL 'TILL END OF BLOCK
	!			OR ALL DATA READ.
	!	INCREMENT N% - INTERNAL NO. OF POINTS IN CORE
	!	UPDATE M% - NUMBER YET TO COME FROM FILE
	!	READ IN POINT  /  LOOP
	!	JUMP OUT WHEN ALL POINTS READ
	!	RESET INITIAL POINTER IN BUFFER
	!	UPDATE BUFFER WINDOW
	!	GO ROUND FOR NEXT SET OF POINTS.


20460
	RETURN
	!	FINISHED READ OPERATION

20500
	FIELD#11%,V%*(J%-1%)ASZ$,V%ASN$(J%)
		FORJ%=1%TO510%/V%\
	RETURN
	!	FIELD UP FOR GRAPH DATA FILES

20600
	W$=S$(1%)\
	C%=1%\
	FORI%=2%TON%\
	IFINSTR(1%,W$,S$(I%))=0%THENW$=W$+S$(I%)\
	C%=C%+1%
	!	SUBROUTINE TO SET C% TO NUMBER OF SYMBOLS
	!	*****************************************
	!
	!	C% --> NO. OF SYMBOLS IN CORE, W$--> LIST OF THEM
	!	INIT. W$ AND C%
	!	DO SCAN
	!	IF CURRENT SYMBOL NOT IN LIST, THEN ADD IT
	!	& INCREMENT C%


20620
	NEXTI%\FORI%=1%TOC%\
	S$=MID(W$,I%,1%)\
	GOTO20640IFS$=MID(O$,2%+J%*Q%,1%)FORJ%=0%TOLEN(O$)/Q%-1%\
	O$=O$+CHR$(1%)+S$+STRING$(2%*V%,0%)

20640
	NEXT I%\	RETURN
	!	CLOSE 2ND SCAN TO UPDATE O$

	!======================================================


20700
	Q$="##"+T$\
	P$=""\
	R%=1%\
	RETURN

	!	SUBROUTINE TO INITIALIZE THESE PARAMETERS
	!	FOR FILE BUILDING


20800
	KILLF$IFFNL%(F$)\RETURN
	!	SUBROUTINE FOR CLEANING UP DISC
	!	AFTER ERRORS


20900
	H2=0.	\
	H2=H2+H(I%)*M(I%)FORI%=2%TON1%	\
	RETURN

	!	Excess Fractions subroutine
	!	Load H2 with H().M() scalar product

	!=======================================================


20950
	FORI%=1%TON1%	\
		&Z(I%)+O(I%),	\
		D(I%)=M(I%)-H2*H(I%)	\
	NEXTI%		\
	RETURN


	!	Excess fractions subroutine
	!	Print lattice point
	!	Load D() with delta vector

	!=======================================================


20960
	A1=FNP(H2)	\
	A2=H2-A1	\
	B1=FNP(H(I%))	\
	B2=H(I%)-B1	\

	D(I%)=((A1*B1-O(I%))+A1*B2+A2*B1)+(K(I%)+A2*B2)	\
	RETURN


32767
	END
