1000	!		***** Cycles *****		!
1010	! Originally written by Susan Lewis, Signal Processing Systems,
	! Waltham, MA. Modified and improved by Jim Morton, System
	! Programmer, Albany BOCES, Albany NY.  27-Jul-79
1020	!
1030  OPEN "KB:" AS FILE 1%
1040  INPUT"Birthdate for biorhythm chart (M,D,Y) ";B2%,B1%,B3%
1050  INPUT"Chart for which month (M,Y) ";C2%,C3%
1060  INPUT"Person's name for chart is ";N$
1070  IF C3%>99THENC3%=C3%-1900
1080  IFB3%>99THENB3%=B3%-1900
1090  DIM M9%(12),L(3),V(4),P$(31,21),C$(4),M$(12)
1100	!
1110	!	Julian day from date
1120	!
1130  IFC2%=2ANDFIX((C3%+318)/4)+.5=FIX(C3%+318)/4THENZ=29ELSEIFC2%=2THENZ=28
1140  IFC2%=9ORC2%=4ORC2%=6ORC2%=11THENZ=30
1150  IF Z=0 THEN Z=31
1160  DEF FNJ%(D0%,M0%,Y0%)
1170  J0%=M9%(M0%)+D0%
1180  IF 4%*(Y0%/4%)=Y0% AND M0%>2 THEN J0%=J0%+1
1190  FNJ%=J0%
1200  FNEND
1210	!
1220	!	Days between two Julian dates
1230	!
1240  DEF FND% (J1%,Y1%,J2%,Y2%)
1250  Q0%=4%-(Y1%-4%*(Y1%/4%))
1260  Q0%=(Y2%-Y1%-Q0%)/4%
1270  FND%=Q0%+(Y2%-Y1%)*365%+J2%-J1%
1280  FNEND
1290	!
1300	!	Initialize
1310	!
1320  READ D$
1330  MAT READ L,C$,M9%,M$
1340  DATA "-"
1350  DATA 23,28,33
1360  DATA "P","E","I","*"
1370  DATA 0,31,59,90,120,151,181,212,243,273,304,334
1380  DATA "January","February","March","April","May","June","July"
1390  DATA "August","September","October","November","December"
1400	!
1410	!	Reset P$
1420	!
1430  FOR J%=1 TO 21
1440  P$(I%,J%)=SPACE$(1%) FOR I%=1 TO Z
1450	!
1460	!	Spaces
1470	!
1480  NEXT J%
1490  FOR I%=1 TO Z
1500  RESTORE
1510  READ P$(I%,11%)
1520	!
1530	!	Zero axis
1540	!
1550  NEXT I%
1560  &:&:&:&
1570  T0%=FND%(FNJ%(B1%,B2%,B3%),B3%,FNJ%(1%,C2%,C3%),C3%)
1580  T=T0%
1590	!
1600	!	Compute cycles, set P$
1610	!
1620  FOR I%=1 TO Z
1630  V(K%) = 10*SIN(T/L(K%)*2*PI) FOR K%=1 TO 3
1640  V(4%) = (V(1%) + V(2%) + V(3%)) / 3
1650  FOR K%=1 TO 4
1660  K0%=INT(ABS(V(K%)+.5)*SGN(V(K%)))+11%
1670  P$(I%,K0%) = C$(K%)
1680  NEXT K%
1690  T=T+1
1700  NEXT I%
1710	!
1720	!	Print P$
1730	!
1740  &"Align paper and return <CR>";:INPUT#1%,K$
1750  &:&:&:&:&:&:&:&:&
1760  &,"Biorhythm chart for ";N$
1770  &,"    Born on";B2%;"-";B1%;"-";B3%+1900
1780  &:&,"For the month of ";M$(C2%);C3%+1900:&
1790  &"Charting the Physical     - P (23 day cycle)"
1800  &"             Emotional    - E (28 day cycle)"
1810  &"             Intellectual - I (33 day cycle)"
1820  &"         and Overall      - * (average)"
1830  &:&
1840  &"     These cycles are believed to occur in everyone,"
1850  &"           beginning on the day of their birth."
1860  &:&
1870  &"Number of cycles since birth - ";
1880  &C$(I%);T/L(I%);"   "; FOR I%=1 TO 3
1890  &:&:&:&:&
1900  FOR J%=21 TO 1 STEP -1
1910  &"   | ";				! "|" IS CHR$(124)
1920  &P$(I%,J%);" "; FOR I%=1 TO Z
1930  &
1940  NEXT J%
1950  &"   |-+-------+---------+---------+---------+---------+-----";
1960  ON Z-27 GOTO  1970,1980,1990,2000
1970  &"+":GOTO 2010
1980  &"--+":GOTO 2010
1990  &"----+":GOTO 2010
2000  &"----+--"
2010  &"     1       5        10        15        20        25    ";
2020  ON Z-27 GOTO 2030,2040,2050,2050
2030  &"28":  GOTO 2070
2040  &"  29":GOTO 2070
2050  &"    30"
2060  &:&,,M$(C2%);C3%+1900
2070  &:&:&:&:&:&:&:&:&:&
2080  &CHR$(7)FORX=1TO5:Z$=SYS(CHR$(5)):END
