10!	CURSOR

	THIS FILE LISTS SOME OF THE CURSOR FUNCTIONS/GOSUBS WHICH
WORK WITH THE ADDS-580 AND ADDS 520 24-LINE CATHODE RAY TUBES. 
THEY WERE FORMULATED BY PHILLIP ALBERS AND RICHARD O'NEILL OF
XAVIER UNIVERSITY, CINCINNATI OH 45207

20!	THE FUNCTIONS ARE OF THE FORM:
		FNZ(C,R,S$)
WHERE:  C  = HORIZONTAL (X) COORDINATE - COLUMNS 0-79
        R  = VERTICAL   (Y) COORDINATE - ROWS    0-23
        S$ = STRING PRINTED WITH FIRST CHARACTER AT C,R    .
THE UPPER LEFT HAND CORNER IS THE 0,0 POSITION. OTHER POSITIONS
ARE LOCATED BY THEIR  COLUMN,ROW  COORDINATES.

30!	A STRING FUNCTION IS RECOMMENDED IF THE SYSTEM ALLOWS IT.
A ONE-LINE FUNCTION IS AVAILABLE IF MORE THAN 80 CHARACTERS ARE
PERMITTED ON A LINE; OTHERWISE A MULTIPLE LINE FUNCTION IS NEEDED.
A NUMERIC FUNCTION IS ALSO POSSIBLE, BUT IT MUST BE OF THE 
MULTIPLE LINE VARIETY.  IF NEITHER STRING FUNCTIONS OR MULTIPLE
LINE FUNCTIONS ARE ALLOWED, A GOSUB MAY BE USED.

40!	FOR STRING FUNCTIONS, USE:	PRINT FNZ(C,R,S$)
	FOR NUMERIC FUNCTIONS, USE:	I=FNZ(C,R,S$)
	FOR GOSUBS, DEFINE C,R,S$ BEFORE THE GOSUB STATEMENT.

50!	FUNCTIONS/GOSUBS MAY BE MADE MORE EFFICIENT BY USING
INTEGER VARIABLES/CONSTANTS (% SIGNS IN EXAMPLES BELOW) AND/OR
MULTIPLE STATEMENT LINES (EASILY CONSTRUCTED FROM EXAMPLES) AS
THE SYSTEM PERMITS.

1000!


FNZ1$	STRING FUNCTION; FLOATING POINT NUMBERS; ONE LINE

1010 DEF FNZ1$(C,R,S$)=CHR$(144)+CHR$(16*INT(C/10)+C-10*INT(C/10)+128)
	+CHR$(139) + CHR$(R+64) + S$
1100!


FNZ2$	STRING FUNCTION; FLOATING POINT NUMBERS; MULTIPLE LINES

1110	DEF FNZ2$(C,R,S$)
1120	Z$=CHR$(16+128) + CHR$(16*INT(C/10)+C-10*INT(C/10)+128)
1130	FNZ2$=Z$+CHR$(11+128)+CHR$(R+64)+S$
1140 	FNEND
1200!


FNZ3$	STRING FUNCTION; INTEGER NUMBERS; ONE LINE

1210	DEF FNZ3$(C%,R%,S$) = CHR$(144%)
		+ CHR$( C%/10%*16% + C% -C%/10%*10% + 128%)
		+ CHR$(139%) + CHR$(R%+64%) + S$
1300!


FNZ4$	STRING FUNCTION; INTEGER NUMBERS; MULTIPLE LINES

1310	DEF FNZ4$(C%,R%,S$)
1320	Z$=CHR$(16%+128%) + CHR$(C%/10%*16%+C%-C%/10%*10% + 128%)
1330	FNZ4$=Z$+CHR$(11%+128%)+CHR$(R%+64%) + S$
1340	FNEND
1400!


FNZ5	NUMERIC FUNCTION; FLOATING POINT NUMBERS; MULTIPLE LINES

1410	DEF FNZ5(C,R,S$)
1420	Z$=CHR$(16+128)+CHR$(10*INT(C/10)+C-10*INT(C/10) +128)
1430	Z$=Z$ + CHR$(11+128)+CHR$(R+64)+S$
1440	PRINT Z$
1450	FNZ5 = 0
1460	FNEND
1500!


FNZ6%	NUMERIC FUNCTION; INTEGER NUMBERS; MULTIPLE LINES
1510	DEF FNZ6%(C%,R%,S$)
1520	Z$=CHR$(16%+128%)+CHR$(C%/10%*16% + C% -C%/10%*10% + 128%)
1530	Z$=Z$ + CHR$(11%+128%) + CHR$(R%+64%) + S$
1540	PRINT Z$
1550	FNZ6%=0%
1560	FNEND
1997!

1998 	GOTO 4000
1999!


GOSUB WITH FLOATING POINT NUMBERS

2000	Z$=CHR$(16+128)+CHR$(16*INT(C/10) + C -10*INT(C/10) + 128)
2010	Z$=Z$+CHR$(11+128)+CHR$(R+64)+S$
2020	PRINT Z$
2030	RETURN
2499!

GOSUB WITH INTEGER NUMBERS

2500	Z$=CHR$(16%+128%)+CHR$(C%/10%*16% + C% -C%/10%*10% + 128%)
2510	Z$=Z$+CHR$(11%+128%)+CHR$(R%+64%) + S$
2520	PRINT Z$
2530	RETURN
3999!


TEST OF FUNCTIONS AND GOSUBS

4000	PRINT CHR$(140%)
4010	PRINT FNZ1$(0,0,"FNZ1$ AT 0,0")
4020	PRINT FNZ1$(0,1,"FNZ1$ AT 0,1")
4030	PRINT FNZ2$(1,2,"FNZ2$ AT 1,2")
4040	PRINT FNZ3$(2%,3%,"FNZ3$ AT 2,3")
4050	PRINT FNZ4$(3%,4%,"FNZ4$ AT 3,4")
4060	I=FNZ5(4,5,"FNZ5 AT 4,5")
4070	I%=FNZ6%(5%,6%,"FNZ6% AT 5,6")
5000	C=6
5010	R=7
5020	S$="GOSUB (FLOATING POINT) AT 6,7"
5030	GOSUB 2000
5100	C%=7%
5110	R%=8%
5120	S$="GOSUB (INTEGER) AT 7,8"
5130	GOSUB 2500
9999 	END
