1!	PROGRAM FRQCDI - RECEIVES INPUT FROM CARDS AND PACKS INTO A FREQUENCY
			   FILE
			- FORMAT INFORMATION IS INPUT FROM THE TERMINAL
			- FILES MAY BE CREATED OR UPDATED

2!
	FREQUENCY ANALYSIS PACKAGE

	DEVELOPED AT:	CENTRAL STATE UNIVERSITY
			COMPUTER CENTER
			EDMOND, OKLAHOMA 73034

	BY:  CAROL T. SUMNER

	DATE:  AUGUST, 1979

5	CHAIN "LIB:FREQ"
10	EXTEND
20	P$="FRQCDI"
	\ P%=0%		! PRINT CHANNEL NUMBER; 0 IS KEYBOARD
30	ON ERROR GO TO 9000
	\ GO SUB 10000
40!	DEFINE STRING CONSTANTS&
	FF$=CHR$(12%)		! FORM FEED&
	\ CR$=CHR$(13%)		! CARRIAGE RETURN&
	\ FIL$=".FIL"
	\ LST$=".LST"
	\ FRQ$=".FRQ"		! STANDARD FREQUENCY EXTENSION&
	\ LF$=CHR$(10%)		! LINE FEED&
	\ LIB$="LIB:"		! SYSTEM LIBRARY LOGICAL&
	\ E$="INVALID - RE-ENTER"
80!	CHECK RESPONSE (INVALID/YES/NO)&
	DEF FNA%(A$)
	\ A%=INSTR(1%," YN",LEFT(A$,1%))
	\ A%=1% IF A%=0%
	\ PRINT "PLEASE ANSWER YES OR NO" IF A%=1%
	\ FNA%=A%
	\ FNEND
  !	CALLING ARGUMENT - A$ - STRING TO CHECK
	RETURNED ARGUMENT - FNA%
			    1  - INVALID
			    2   - YES
			    3   - NO
	USAGE - ON FNA%(A$) GOTO ERROR,YES,NO
		WHERE ERROR,YES AND NO REPRESENT STATEMENT NUMBERS
90	DEF FNMOD%(M%,N%)=M%-M%/N%*N%		! MOD FUNCTION
100	DIM FORMAT%(100%,2%)			! FORMAT INFORMATION&
	\ DIM MM%(100%,2%)			! MAX/MIN ARRAY&
	\ GMAX%=-1%				! INITIAL VALUE, GLOBAL MAXIMUM&
	\ MAXRESPONSE%=100%			! MAXIMUM ALLOWABLE RESPONSE&
	\ GMIN%=MAXRESPONSE%+1%			! INITIAL VALUE, GLOBAL MINIMUM&
	\ MAXITEM%=100%				! MAXIMUM ALLOWABLE ITEMS&
	\ REJ%=255%				! VALUE TO REJECT&
	\ FRQRET%=250%				! NORMAL RETURN&
	\ ERRRET%=30%				! ERROR RETURN
105	PRECSIZE%=512%			! PHYSICAL RECORD SIZE
110	PRINT "INPUT FILE";		! INPUT FILENAME&
	\ INPUT LINE INFIL$
	\ INFIL$=CVT$$(INFIL$,4%)
	\ OPEN INFIL$ FOR INPUT AS FILE 2%,MODE 8192%	! OPEN, READ ONLY
120	INPUT "INITIAL ENTRY OR UPDATE(I,U)";A$
	\ ON INSTR(1%," IU",LEFT(A$,1%))+1% GO TO 120,120,200,400
			! GO TO ERROR,ERROR,INITIAL ENTRY,UPDATE

200!

			INITIAL ENTRY


210	GO SUB 2300			! GET FILENAME&
	\ PRINT OUTFIL$;" WILL BE CREATED"	! INFORM USER OF FILENAME AND EXTENSION&
	\ OPEN OUTFIL$ FOR INPUT AS FILE 1%	! CHECK FOR EXISTENCE OF FILE&
	\ CLOSE 1%
	\ PRINT " THIS FILE ALREADY EXISTS."
220	INPUT "DO YOU WANT TO DESTROY IT";A$
	\ ON FNA%(A$) GO TO 220,250,230
230!			DO NOT DESTROY CURRENT FILE&
	PRINT "EITHER INPUT A DIFFERENT FILENAME OR UPDATE CURRENT FILE"
	\ GO TO 120
250!
			OPEN FILE FOR OUTPUT
		THIS SECTION REACHED BY ANSWERING 'YES' AT LINE 220
		OR GENERATING AN ERROR 5 AT LINE 210


260	OPEN OUTFIL$ FOR OUTPUT AS FILE 1%	! READY TO CREATE NEW FILE
270	PRINT "IDENTIFICATION"
	\ INPUT "STARTING COLUMN - 1";IDSC%
	\ IDSC%=1% UNLESS IDSC%
275	INPUT "ID LENGTH";IDLEN%
	\ IF IDLEN% > 9% OR IDLEN% < 1%
	  THEN PRINT E$
	\	GO TO 275
280	FORMAT%(0%,1%)=IDSC%
	\ FORMAT%(0%,2%)=IDLEN%
	\ GO SUB 2500			! GET MIN/MAX & FORMAT INFORMATION&
	\ GO SUB 2400			! PRINT CONTROL INFORMATION
290	INPUT "DO YOU WISH TO EDIT CONTROL INFORMATION";A$
	\ ON FNA%(A$) GO TO 290,300,370
			! REPEAT QUESTION, EDIT, READ DATA
299!

			EDIT CONTROL INFORMATION


300	INPUT "ADD,CHANGE,PRINT,<CR> TO EXIT EDIT MODE";A$
	\ ON INSTR(1%," ACP",LEFT(A$,1%))+1% GO TO 300,370,310,330,360
			! REPEAT QUESTION,READ DATA,ADD,CHANGE,PRINT

310!			ADD AN ITEM&
	IEXIT%=0%
	\ ITEM%=NITEM%
	\ GO SUB 2500			! ADD UNTIL <CR>&
	\ GO TO 300			! CHECK FOR MORE EDIT
330!			CHANGE AN ITEM&
	ITEM%=NITEM%
	\ WHILE ITEM%
		\ INPUT "ITEM TO BE CHANGED";ITEM%
		\ IF ITEM%
		  THEN IF ITEM% <= NITEM%
			THEN GO SUB 5000
			ELSE PRINT E$
340	NEXT
	\ GO TO 300			! CHANGE UNTIL <CR>
360!			PRINT&
	GO SUB 2400			! PRINT CONTROL INFORMATION&
	\ GO TO 300			! CHECK FOR MORE EDIT
370!		CONTROL INFORMATION INPUT AND EDITED - FIND RECORD LENGTH&
	READ LRECL% UNTIL LRECL% >= IDLEN% + NITEM%
	\ DATA 8,16,32,64,128
380!			STORE CONTROL INFORMATION&
	GO SUB 2000			! ZERO BUFFER&
	\ GO SUB 1000			! FIELD PARAMETER RECORD&
	\ LSET GMAX$=CHR$(GMAX%)	! GLOBAL MAXIMUM&
	\ LSET GMIN$=CHR$(GMIN%)	! GLOBAL MINIMUM&
	\ LSET IDSC$=CHR$(IDSC%)	! ID START COLUMN&
	\ LSET IDLEN$=CHR$(IDLEN%)	! ID LENGTH&
	\ LSET NITEM$=CHR$(NITEM%)	! NO. OF ITEMS&
	\ LSET N$=CVT%$(0%)		! NO. OF RESPONDENTS&
	\ LSET LRECL$=CHR$(LRECL%)	! LOGICAL RECORD LENGTH&
	\ FOR ITEM%=1% TO NITEM%
	\	FIELD #1%,12% AS D$,(ITEM%-1%)*4% AS D$,1% AS IMAX$,1% AS IMIN$,
			  1% AS ISTART$,1% AS ILENGTH$
	\	LSET IMAX$=CHR$(MM%(ITEM%,1%))		! ITEM MAXIMUM&
	\	LSET IMIN$=CHR$(MM%(ITEM%,2%))		! ITEM MINIMUM&
	\	LSET ISTART$=CHR$(FORMAT%(ITEM%,1%))	! ITEM START COLUMN&
	\	LSET ILENGTH$=CHR$(FORMAT%(ITEM%,2%))	! ITEM LENGTH&
	\ NEXT ITEM%
	\ NREC%=PRECSIZE%/LRECL%	! NO. RECORDS PER BLOCK&
	\ PUT #1%, RECORD 1%		! STORE PARAMETER RECORD&
	\ FILE.OPEN%=-1%
	\ NBLK%=2%			! START BLOCK FOR DATA&
	\ NRLB%=0%			! NO. RECORDS LAST BLOCK&
	\ GO TO 750			! CONTINUE AS FOR UPDATE


400!


			UPDATE MODE


410	GO SUB 2300			! GET FILENAME&
	\ OPEN OUTFIL$ FOR INPUT AS FILE 1%	! CHECK FOR FILE'S EXISTENCE&
	\ FILE.OPEN%=-1%
	\ PRINT OUTFIL$;" WILL BE UPDATED"
	\ GET #1%, RECORD 1%		! GET PARAMETER RECORD&
	\ GO SUB 1000			! FIELD PARAMETER RECORD&
	\ IF IDSC$=" "
	  THEN PRINT "THIS FILE CREATED WITH TERMINAL INPUT."
	\	PRINT "IT CANNOT BE UPDATED WITH CARDS."
	\	CLOSE 1%,2%
	\	FRQRET%=ERRRET%
	\	GO TO 32700
420	NITEM%=ASCII(NITEM$)		! NO. ITEMS TO BE READ&
	\ N%=CVT$%(N$)			! NO. OF RESPONDENTS IN FILE&
	\ LRECL%=ASCII(LRECL$)		! LOGICAL RECORD LENGTH&
	\ NREC%=PRECSIZE%/LRECL%	! NO. RECORDS PER BLOCK&
	\ IDSC%=ASCII(IDSC$)		! ID START&
	\ IDLEN%=ASCII(IDLEN$)		! ID LENGTH&
	\ FORMAT%(0%,1%)=IDSC%
	\ FORMAT%(0%,2%)=IDLEN%
430!		GET FORMAT AND CONTROL INFORMATION&
	FOR ITEM%=1% TO NITEM%
	\	FIELD #1%, 12% AS D$,(ITEM%-1%)*4% AS D$,1% AS IMAX$,1% AS IMIN$,
			1% AS ISTART$,1% AS ILENGTH$
	\	MM%(ITEM%,1%)=ASCII(IMAX$)	! ITEM MAXIMUM&
	\	MM%(ITEM%,2%)=ASCII(IMIN$)	! ITEM MINIMUM&
	\	FORMAT%(ITEM%,1%)=ASCII(ISTART$) ! ITEM START COLUMN&
	\	FORMAT%(ITEM%,2%)=ASCII(ILENGTH$) ! ITEM LENGTH&
	\ NEXT ITEM%
440!			CALCULATE NEXT BLOCK AND RECORD TO BE WRITTEN&
	NBLK%=N%/NREC% + 2%		! NO. BLOCKS IN FILE&
	\ NRLB%=FNMOD%(N%,NREC%)	! NO. RECORDS LAST BLOCK&
	\ GO SUB 2000			! ZERO BUFFER&
	\ GET #1%, RECORD NBLK% IF NRLB%	! GET LAST PARTIAL RECORD

750!			COMMON PORTION - ADD TO FILE&
	UNTIL IEND%
	\	GO SUB 4000 FOR NRLB%=NRLB% UNTIL (NRLB%=NREC%) OR IEND%
	\	PUT #1%, RECORD NBLK%
	\	NBLK%=NBLK%+1%
	\	NRLB%=0%
	\ NEXT
800!			FINISHED&
	IF FILE.OPEN%
	THEN GET #1%, RECORD 1%		! PARAMETER RECORD&
	\    GO SUB 1000		! FIELD PARAMETER RECORD&
	\    LSET N$=CVT%$(N%)		! NO. OF RESPONDENTS&
	\    PUT #1%, RECORD 1%		! STORE NEW VALUE&
	\    CLOSE 1%,2%
	\    PRINT OUTFIL$;" CREATED WITH ";N%;"RECORDS
	\    FILE.OPEN%=0%
850	 GO TO 32700
1000!
		SUBROUTINE TO FIELD PARAMETER RECORD


1010	FIELD #1%,1% AS GMAX$,1% AS GMIN$,1% AS IDSC$,1% AS IDLEN$,
		 1% AS NITEM$,2% AS N$,1% AS LRECL$
	\ RETURN
2000!
			ZERO BUFFER

2010	FIELD #1%,512% AS D$
	\ LSET D$=STRING$(512%,0%)
	\ RETURN
2300!
			GET FILENAME

2310	PRINT "OUTPUT FILE TO BE PROCESSED";
	\ INPUT LINE OUTFIL$
	\ OUTFIL$=CVT$$(OUTFIL$,4%)		! STRIP OFF <CR><LF>&
	\ F%=INSTR(1%,OUTFIL$,".")		! LOOK FOR EXTENSION&
	\ OUTFIL$=LEFT(OUTFIL$,F%-1%) IF F% ! ELIMINATE INPUT EXTENSION&
	\ OUTFIL$=OUTFIL$+FRQ$		! APPEND STANDARD EXTENSION&
	\ RETURN
2400!
			PRINT CONTROL INFORMATION

2410	PRINT "ITEM","MIN","MAX","START","LENGTH"
	\ PRINT "IDENTIFICATION",,IDSC%,IDLEN%
	\ PRINT ITEM%,MM%(ITEM%,2%),MM%(ITEM%,1%),FORMAT%(ITEM%,1%),FORMAT%(ITEM%,2%)
			FOR ITEM%=1% TO NITEM%
	\ RETURN
2500!
			SOLICIT CONTROL INFORMATION

2510	IEXIT%=0%
	\ UNTIL IEXIT%
	\ 	IF ITEM% >  MAXITEM%
		THEN PRINT "NO MORE ITEMS CAN BE ADDED"
	\		GO TO 2550
2520		ITEM%=ITEM%+1%
	\	GO SUB 5000
	\ NEXT
2550	NITEM%=ITEM%-1%
	\ RETURN
4000!
			ADD RESPONSES TO FILE

4005	IERR%=0%
4010	INPUT LINE #2%, INREC$
	\ INREC$=CVT$$(INREC$,4%)
	\ FOR ITEM%=1% TO NITEM%
	\	IF FORMAT%(ITEM%-1%,1%) > FORMAT%(ITEM%,1%)
		THEN INPUT LINE #2%, INREC$		! READ NEXT CARD OF DATA SET&
	\		INREC$=CVT$$(INREC$,4%)
4020		FIELD #1%,NRLB%*LRECL% AS D$,IDLEN% AS ID$,ITEM%-1% AS D$,1% AS DAT$
	\	RSET ID$=MID(INREC$,IDSC%,IDLEN%) IF ITEM%=1%
	\	INDAT$=MID(INREC$,FORMAT%(ITEM%,1%),FORMAT%(ITEM%,2%))
4030		IF INDAT$=" "
		THEN INDAT%=REJ%
		ELSE INDAT%=VAL(INDAT$)
4040		IF INDAT%>=MM%(ITEM%,2%) AND INDAT%<=MM%(ITEM%,1%)
		THEN RSET DAT$=CHR$(INDAT%)
		ELSE IF INDAT%=0% OR INDAT%=REJ%
		     THEN RSET DAT$=CHR$(REJ%)
		     ELSE GO SUB 6000
4050	NEXT ITEM%
	\ N%=N%+1% UNLESS IERR%
4090	 RETURN
5000!
			SINGLE ITEM CONTROL INFORMATION

5010	PRINT "ITEM";ITEM%
	\ INPUT "MAXIMUM VALUE, <CR> TO EXIT INPUT MODE";MAX$
	\ IF LEN(MAX$)=0%
	  THEN IEXIT%=-1%
	\	GO TO 5100
5020	MAX%=VAL(MAX$)
	\ IF MAX% > MAXRESPONSE% OR MAX% < 1%
	  THEN PRINT E$
	\	GO TO 5010
5030	MM%(ITEM%,1%)=MAX%
	\ GMAX%=MAX% IF GMAX% < MAX%
5040	INPUT "MINIMUM VALUE ";MIN%
	\ IF MIN% < 0% OR MIN% > MAX%
	  THEN PRINT E$
	\	GO TO 5010
5050	MM%(ITEM%,2%)=MIN%
	\ GMIN%=MIN% IF GMIN% > MIN%
5055	DATASTRT%=FORMAT%(ITEM%-1%,1%) + FORMAT%(ITEM%-1%,2%)
	\ DATASTRT%=1% IF DATASTRT% > 80%
5060	PRINT "STARTING COLUMN ";DATASTRT%;
	\ INPUT FORMAT%(ITEM%,1%)
	\ FORMAT%(ITEM%,1%)=DATASTRT% UNLESS FORMAT%(ITEM%,1%)
5065	INPUT "FIELD LENGTH - 1";FORMAT%(ITEM%,2%)
	\ FORMAT%(ITEM%,2%)=1% UNLESS FORMAT%(ITEM%,2%)
	\ IF FORMAT%(ITEM%,1%)+FORMAT%(ITEM%,2%) > 81%
		OR FORMAT%(ITEM%,1%) > 80%
		OR FORMAT%(ITEM%,1%) < 1%
		OR FORMAT%(ITEM%,2%) < 1%
	  THEN PRINT E$
	\	GO TO 5055
5100	RETURN
6000	 PRINT "INVALID DATA: ID ";ID$,"ITEM ";ITEM%,"VALUE ";INDAT%
	\		 INPUT LINE #2%,INREC$ IF FORMAT%(ITEM%-1%,1%) > FORMAT%(ITEM%,1%)
					FOR ITEM%=ITEM%+1% TO NITEM%
	\		NRLB%=NRLB%-1%
	\		IERR%=-1%	
	\ RETURN
9000!
	ERROR ROUTINE

9010!			CONTROL C&
	IF ERR=28%
	THEN GO SUB 10000
	\	PRINT "DATA INTEGRITY NOT GUARANTEED"
	\	PUT #1%, RECORD NBLK% IF NRLB%		! STORE LAST PARTIAL BLOCK&
	\	FRQRET%=ERRRET%				! SET ERRPR RETURN&
	\	RESUME 800				! FINIAH NORMALLY
9020!			END OF FILE&
	GO TO 9045 IF ERR <> 11%
	\ IF ERL=4010
	  THEN IEND%=-1%
	\	RESUME 4090				! INPUT FILE EXHAUSTED
9030	IF ERL=440
	THEN FRQRET%=ERRRET%
	\	PRINT "DATA INTEGRITY NOT GUARANTEED"	! END OF FILE ON OUTPUT&
	\	RESUME 32700
9040	PRINT "DATA INTEGRITY NOT GUARANTEED"		! CTRL Z AT TERMINAL&
	\ PUT #1%, RECORD NBLK% IF NRLB%		! STORE LAST PARTIAL BLOCK&
	\ FRQRET%=ERRRET%
	\ RESUME 800
9045	IF ERR=5 AND ERL=210
	THEN RESUME 250			! OKAY TO CREATE NEW FILE
9050!			INVALID FILENAME&
	IF ERR=2 OR ERR=5 OR ERR=10
	THEN PRINT "INVALID FILENAME"
	\	TRY%=TRY%+1%
	\	IF TRY% < 6%
		THEN RESUME
		ELSE FRQRET%=ERRRET%
	\		RESUME 32700
9060!			ILLEGAL NUMBER&
	IF ERR > 49 AND ERR < 52
	THEN PRINT "INVALID NUMBER"
	\	IF ERL <> 4030
		THEN RESUME
		ELSE GO SUB 6000
	\		RESUME 4050
9070!			DISK BLOCK INTERLOCK&
	IF ERR=19
	THEN PRINT "FILE IN USE. TRY AGAIN LATER"
	\	FRQRET%=ERRRET%
	\	RESUME 32700
9080	PRINT "UNEXPECTED ERROR ";ERR;"IN 'FRQCDI' AT LINE ";ERL
	\ PRINT "PLEASE RETAIN THIS INFORMATION AND NOTIFY COMPUTER CENTER PERSONEL"
	\ PUT #1%, RECORD NBLK% IF NRLB%
	\ FRQRET%=ERRRET%
	\ RESUME 800
9990	ON ERROR GOTO 0
10000!	
	CTRL/C TRAP

10010	V$=SYS(CHR$(6%)+CHR$(-7%))
	\  V$=""
	\  RETURN
32700	S$=SYS(CHR$(8%)+OUTFIL$)		! PUT CORE COMMON&
	\ CHAIN LIB$+"FREQ" FRQRET%
32750	PRINT "*** ";P$;"   END ";TIME$(0%)
	\ NO EXTEND
32767	END
