1	!


	!		C L E A N



2!		Program:	CLEAN
3!		Version:	V06A
4!		Edit:		02
6!		Edit Date:	25-Sep-79
8!		Author:		Brant Cheikes
10!		System:		PDP-11  RSTS/E V06C-03 or later
12!		Affiliation:	Nassau Community College

20	!
			Program Description

	  CLEAN is a utility program for use with the MAIL package of
	  programs.  It is designed to either CLEAN the MAIL data files
	  or DELETE registered users at the discretion of the system 
	  manager. This program is for privileged users only.

	  Suggested protection code for CLEAN.BAC:  <124>

	  	The [C]lean Command

	  The CLEAN command (the default) reorders and restructures the
	  MAIL data files, eliminating any corruptions of the MAIL index
	  or name index values.  CLEAN also weeds out and removes from
	  registration all users whose accounts no longer exist.  In this
	  way, certain accounts can be removed from MAIL service without
	  re-initializing the data files.

	  Though most errors can be eliminated using CLEAN, there are some
	  cases when the data files are so corrupt that they must simply
	  be re-initialized through MAILUP.  If any such error occurs,
	  CLEAN will notify the user.

	  During [C]leaning, certain purely informational messages may be
	  printed depending on the status of the cleaning.

		The [D]elete Command

	  The [D]elete command allows the privileged user to delete either
	  single accounts or entire project groups from the MAIL registered
	  user ledger.  It is suggested that after each set of deletions
	  are made, the files be [C]leaned, so that the associated names
	  are removed from NAMES.MAI, thereby reducing its necessary
	  storage space requirement.

	  Complete documentation of the algorithm with which CLEAN
	  works can be found within the source of MAIL.

	!
900	!

			Modification History

	  Version/Edit		Date		Reason

910!	   V06A-01		09-Aug-79	New release
   !	   V06A-02		25-Sep-79	General repairs

1000	!

		M A I N   P R O G R A M   C O D I N G

	!
1010	V$ = "V06A-02"
	!  Set up version/edit level

1020	PRINT
	\  PRINT "CLEAN   "+V$+"   "+
	   CVT$$(RIGHT(SYS(CHR$(6%)+CHR$(9%)),3%),4%)
	\  PRINT "MAIL Data File Cleaner"
	\  PRINT
	!  Output system header

1030	ON ERROR GOTO 30000
	\  OPEN 'KB:' AS FILE 1%
	\  X$ = SYS(CHR$(6%)+CHR$(-7%))
	\  DIM #2%,A%(254%,254%)
	\  DIM #4%,B%(254%,254%)
	!  Set error trap; open keyboard; set CTRL/C trapping
	!  Dimension both virtual array files

1040	INPUT #1% "Data file account: ";P1%,P2%
	\  A1$ = '['+NUM1$(P1%)+','+NUM1$(P2%)+']'
	!  Get target account and set up UFD as a string

1050	OPEN A1$ + 'ACCT.MAI' FOR INPUT AS FILE 2%
	\  OPEN A1$ + 'NAMES.MAI' FOR INPUT AS FILE 3%,MODE 1%
	\  PRINT
	\  PRINT "The MAIL system is now temporarily shut down"
	\  PRINT
	\  S9% = -1%
	!  Open input files and make sure that they exist
	!  Open NAMES.MAI in update mode to disable the MAIL system
	!  If it succeeds, print an informative message and continue
	!  Set a flag to indicate that the MAIL system was shut down

1055	INPUT #1% "[C]lean or [D]elete?  <C>  ? ";A$
	\  A$ = LEFT(A$,1%)
	\  IF A$ = '' OR A$ = 'C' THEN 1060 ELSE
	   IF A$ = 'D' THEN 4000 ELSE PRINT
	   "?Commands are 'C' or 'D'"
	\  PRINT
	\  GOTO 1055
	!  Get command

1060	OPEN A1$ + 'ACCT.TMP' FOR OUTPUT AS FILE 4%
	\  OPEN A1$ + 'NAMES.TMP' FOR OUTPUT AS FILE 5%
	!  Create temporary cleaning output files

1075	PRINT
	\  PRINT "Cleaning..."
	\  PRINT
	!  Notify user

1080	!

		C O R R U P T I O N   C H E C K

	!
1090	GET #3%,RECORD 1%
	\  FIELD #3%,2% AS R$,2% AS P$
	\  R% = CVT$%(R$)
	\  P% = CVT$%(P$)
	!  Get 'MAIL index'

1100	IF R% > 120% OR P% > 480% OR R% < 1% OR P% < 0% THEN PRINT
	"Data file structure is corrupt - attempting to rectify"
	\  C% = -1%
	\  PRINT
	!  Check that index values aren't absurd indicating corruption

1110	R% = 1%
	\  P% = 32%
	!  Set counters for CLEAN output to NAMES.MAI

2000	!

		C L E A N I N G   S E C T I O N

	!
2010	FOR X% = 0% TO 254%
	\  FOR Y% = 0% TO 254%
	!  Set up cleaning loop

2020	S% = SGN(A%(X%,Y%))
	\  B%(X%,Y%) = 0% UNLESS S%
	\  GOTO 2090 UNLESS S%
	!  If zero, write and get next account to check

2030	GOSUB 10000
	!  Go check to see if account exists on disk

2040	S% = 0% IF S% = 1%
	\  I% = ABS(A%(X%,Y%))
	\  R2% = SWAP%(I%) AND 255%
	\  P2% = I% AND 255%
	\  P2% = P2% + P2%
	!  Set suspended flag if suspended; get NAMES.MAI index

2050	GET #3%,RECORD R2%
	\  FIELD #3%,P2% AS G$,32% AS N$
	\  H$ = N$
	!  Get name and transfer to another variable

2055	GET #5%, RECORD R%

2060	FIELD #5%,P% AS G$,32% AS N$
	\  LSET N$ = H$
	\  PUT #5%,RECORD R%
	!  Transfer name to clean output file

2070	B%(X%,Y%) = SWAP%(R%) OR (P%/2%)
	\  B%(X%,Y%) = -B%(X%,Y%) IF S%
	!  Set index in ACCT.MAI; if user was suspended, then retain suspension

2080	P% = P% + 32%
	\  IF P% > 480% THEN P% = 0%
	\  R% = R% + 1%
	!  Set offsets to point to next available name slot

2090	NEXT Y%
	\  NEXT X%
	!  End loop

2100	!
		Now we write the final revised 'MAIL index'
	!
2110	GET #5%,RECORD 1%
	\  FIELD #5%,2% AS R$,2% AS P$
	\  LSET R$ = CVT%$(R%)
	\  LSET P$ = CVT%$(P%)
	\  PUT #5%,RECORD 1%
	!  Write the index

3000	!

		C L E A N U P   F I L E S   L E F T

	!
3010	CLOSE #1%,2%,3%,4%,5%
	\  KILL A1$ + 'NAMES.MAI'
	\  KILL A1$ + 'ACCT.MAI'
	!  Close all files and kill CLEANed files

3020	NAME A1$ + 'NAMES.TMP' AS A1$ + 'NAMES.MAI<60>'
	\  NAME A1$ + 'ACCT.TMP' AS  A1$ + 'ACCT.MAI<60>'
	!  Rename all files 

3100	PRINT "Data files cleaned and restructured";
	\  PRINT " - corruption rectified" IF C%
	\  PRINT UNLESS C%
	\  GOTO 32000
	!  Notify user CLEAN is finished

4000	!


	!	D E L E T E   A   R E G I S T E R E D   U S E R



4010	PRINT
	\  INPUT #1% "Delete by [A]ccount or by [P]roject: ";A$
	\  A$ = LEFT(A$,1%)
	\  IF A$ = 'A' THEN 4020 ELSE IF A$ = 'P' THEN 4500 ELSE PRINT
	   "?Commands are 'A' or 'P'"
	\  GOTO 4010
	!  Get sub-command

4020	!


	!	D E L E T E   B Y   S P E C I F I C   A C C O U N T



4030	PRINT
	\  INPUT #1% "Account: ";P1%,P2%
	\  P1% = ABS(P1%)
	\  P2% = ABS(P2%)
	!  Get account whose registration is to be terminated

4040	S%=SGN(A%(P1%,P2%))
	\  IF S%<>0% THEN 4100
	!  Make sure account is really registered

4050	PRINT "["+NUM1$(P1%)+","+NUM1$(P2%)+"] is not registered at this time"
	\  GOTO 4030

4100	A%(P1%,P2%) = 0%
	\  PRINT "["+NUM1$(P1%)+","+NUM1$(P2%)+"] taken off ledger"
	\  GOTO 4030
	!  Do the deletion

4500	!


	!	D E L E T E   E N T I R E   P R O J   G R O U P S



4510	PRINT
	\  INPUT #1% "Project group: ";P%
	\  P% = ABS(P%)
	!  Get project group to terminate

4520	A%(P%,P1%) = 0% FOR P1% = 0% TO 254%
	\  PRINT "["+NUM1$(P%)+",*] taken off ledger"
	!  Do the mass termination

4530	GOTO 4510
	!  Go get another proj

10000	!

		S U B R O U T I N E S

	!
10010	!  Lines 10010-10030 make sure that the account being checked
	!  really exists

10020	X$ = SYS(CHR$(6%)+CHR$(14%)+STRING$(4%,0%)+CHR$(Y%)+CHR$(X%))
	!  Do the accounting lookup on [X%,Y%]; ERR = 5 if the account
	!  doesn't exist

10030	RETURN

30000	!

		E R R O R   H A N D L I N G

	!
30010	IF ERR = 28% THEN RESUME 32000

30020	IF ERL = 1050% AND ERR = 5% THEN PRINT
	"?Data files don't exist in "+A1$
	\  PRINT
	\  RESUME 1040

30021	IF ERL = 1050% AND ERR = 10% THEN PRINT
	\  PRINT "The MAIL system is in use - try again later"
	\  RESUME 32000
	!  If either MAIL or PSTOFC are running, then abort CLEAN with
	!  an error message

30022	IF ERL = 1050% THEN PRINT
	\  PRINT "?Invalid account format - please re-enter (type '?' for help)"
	\  PRINT
	\  RESUME 1040

30025	IF ERL=2050% OR ERL=2020% THEN PRINT
	 "Account ["+NUM1$(X%)+","+NUM1$(Y%)+
	"] index invalid - registering as NAME UNKNOWN"
	\  H$ = "NAME UNKNOWN"
	\  RESUME 2055
	!  If invalid name index for any reason, register with a dummy name

30030	IF ERL = 2055% AND ERR = 11% THEN RESUME 2060

30035	IF ERL = 4040% OR ERL = 4520% THEN PRINT
	\  PRINT "?Invalid account format - please re-enter (type '?' for help)"
	\  RESUME 4030 IF ERL = 4040%
	\  RESUME 4510

30040	IF ERL = 10020% AND ERR = 5% THEN B%(X%,Y%) = 0%
	\  PRINT "["+NUM1$(X%)+","+NUM1$(Y%)+"] does not exist on disk - ";
	\  PRINT "deleted from ledger"
	\  RESUME 2090

30050	IF ERR = 10% THEN PRINT
	"?Protection error at line";ERL;"- aborting CLEAN run"
	\  RESUME 32000

30055	IF ERR=59% OR ERR=50% THEN PRINT
	"That account format is invalid. Please re-enter it without brackets,"
	\  PRINT "parentheses, or wildcards, separating the PPN with a comma."
	\  PRINT
	\  RESUME
	!  Take care of erroneously entered PPNs

30060	IF ERR = 11% THEN
	IF ERL = 1055% THEN RESUME 32000 ELSE
	IF ERL= 4010% THEN RESUME 1055% ELSE
	IF ERL = 4030% THEN RESUME 4010% ELSE
	IF ERL = 4510% THEN RESUME 4010% ELSE
	RESUME 32000
	!  Wow!!

30900	PRINT "Data file structure corrupt beyond recovery";
	\  PRINT " - unable to rectify" IF C%
	\  PRINT UNLESS C%
	\  PRINT "Please re-initialize through MAILUP"
	\  PRINT
	\  PRINT "Aborting CLEAN run"
	\  PRINT "Error: ";CVT$$(RIGHT(SYS(CHR$(6%)+CHR$(9%)+CHR$(ERR)),3%),4%)
	\  PRINT "Line: ";ERL
	\  CLOSE #4%,5%
	\  KILL A1$ + 'NAMES.TMP'
	\  KILL A1$ + 'ACCT.TMP'
	\  S9% = 0%
	\  RESUME 32000

32000	!

		E X I T

	!
32005	GOTO 32010 UNLESS S9%
	\  PRINT
	\  PRINT "The MAIL system is now re-enabled"
	!  Tell user that the MAIL system is once more operative

32010	CLOSE #1%,2%,3%,4%,5%
	\  X$ = SYS(CHR$(9%))

32767	END
