1 !
	500.20 - STAT11 - T0TEST

		T - TEST MODULE

	RELEASED FOR SUBMISSION TO THE DECUS LIBRARY BY THE DEC
	ENGINEERING SYSTEMS GROUP AND THE EDUCATION PRODUCTS GROUP
		SEPTEMBER, 1977


2 !	COPYRIGHT (C) 1973, DIGITAL EQUIPMENT CORPORATION,

			MAYNARD, MASSACHUSETTS

3 !	THIS SOFTWARE IS FURNISHED TO PURCHASER UNDER A LICENSE FOR USE
	ON A SINGLE COMPUTER SYSTEM AND CAN BE COPIED (WITH INCLUSION OF
	DEC'S COPYRIGHT NOTICE) ONLY FOR USE IN SUCH SYSTEM, EXCEPT AS
	MAY OTHERWISE BE PROVIDED IN WRITING BY DEC.

4 !	THE INFORMATION IN THIS DOCUMENT IS SUBJECT TO CHANGE WITHOUT
	NOTICE AND SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL
	EQUIPMENT CORPORATION.

5 !	DEC ASSUMES NO RESPONSIBILITY FOR USE OR RELIABILITY OF ITS
	SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DEC.



6 !	THIS MODULE COMPUTES THE T STATISTIC FOR TWO VARIABLES UNDER ANY
	OF FOUR DIFFERENT HYPOTHESES.



7 ! 	AUTHOR:		MICHAEL D. KNAUER

	VERSION NUMBER:	001

	DATE:		OCTOBER, 1973



8  !	MODIFICATIONS:  MAY, 1975
	
	MODIFIED TO ACCEPT MISSING DATA POINTS

		BY ARDOTH HASSLER WILSON
		   CENTRAL STATE UNIVERSITY
		   EDMOND, OKLAHOMA


00009!	MODIFICATIONS:  JUNE, 1976

	CTRL/C TRAP ADDED

10 !
	CALLING ARGUMENTS

11 !		1) VARIABLE NAME:	F3$
		   RANGE OF VALUES:	S00000.RWM - S99999.RWM
		   USE:			NAME OF THE 250 ROW BY 15 COLUMN
					VIRTUAL DATA MATRIX.

13 !		2) VARIABLE NAME:	F4$
		   RANGE OF VALUES:	S00000.ESF - S99999.ESF
		   USE:			NAME OF ELEMENTARY STATISTICS FILE

15 !		3) VARIABLE NAME:	R%
		   RANGE OF VALUES:	1 - 250
		   USE:			NUMBER OF ROWS IN DATA MATRIX.

17 !		4) VARIABLE NAME:	C%
		   RANGE OF VALUES:	1 - 15
		   USE:			NUMBER OF COLUMNS IN DATA MATRIX.

20 !

	RETURNING ARGUMENTS

		NONE -- THIS MODULE DOES NOT CHANGE OR ADD TO ANY OF THE
			FILES OR VARIABLES PASSED TO IT.


30 !
	DESCRIPTION OF FUNCTION

31 !		THIS MODULE COMPUTES THE T STATISTIC FOR TWO VARIABLES UNDER
		ANY OF FOUR DIFFERENT HYPOTHESES.

32 !		THE MODULE ASKS THE USER WHICH OPTION (HYPOTHESIS) HE WANTS
		TO USE, AND THEN ASKS HIM TO ENTER VARIABLE NUMBER(S)
		AND/OR A GIVEN VALUE.

33 !		AFTER COMPUTING THE APPROPRIATE T VALUE AND DEGREES OF
		FREEDOM, IT ASKS THE USER IF HE WANTS TO COMPUTE ANY
		MORE T VALUES.

34 !		IF NOT, THEN CONTROL IS RETURNED TO STATCM.

40 !






















99 !


	THIS CODE RETRIEVES CALLING ARGUMENTS FROM COMMON AND OPENS
	THE ELEMENTARY STATISTICS FILE.



100	ON ERROR GOTO 3000: GOSUB 10000: F$=SYS(CHR$(7%))
105	A9$=MID(F$,62%,9%): A9$=LEFT(A9$,INSTR(5%,A9$,"]")):
	H9=.9E-38
110  R%=VAL(MID(F$,46%,5%))
120  C%=VAL(MID(F$,51%,5%))
130  F3$=MID(F$,31%,15%)
140  F4$=LEFT(F3$,6%)+".ESF"
144  R=R%
146  C=C%
150  OPEN F4$ FOR INPUT AS FILE 4
160  DIM #4,S(10%,15%)
164 !


	HERE THE USER IS ASKED TO ENTER THE OPTION NUMBER. IF HE TYPES
	HELP, A DESCRIPTION OF THE OPTIONS WILL BE PRINTED OUT. CONTROL
	IS TRANSFERRED FROM HERE TO THE APPROPRIATE OPTION ROUTINE.



165  PRINT "TYPE HELP FOR A LIST OF THE T-TEST OPTIONS": PRINT
170  INPUT "ENTER YOUR OPTION NUMBER"; P$:PRINT
180  IF P$="HELP" GOTO 2000
190  IF P$="1" OR P$="2" OR P$="3" OR P$="4" GOTO 230
200  PRINT "YOU MUST TYPE EITHER 1, 2, 3, OR 4 AS YOUR OPTION NUMBER"
210  PRINT "PLEASE TRY AGAIN"
220  GOTO 170
230  P%=VAL(P$)
240  ON P% GOTO 250,350,500,600
248 !


	THIS OPTION COMPUTES THE T VALUE FOR THE MEAN OF A VARIABLE AND
	A USER-INPUT VALUE.
249 !	IT IS SIMPLY THE SQUARE ROOT OF THE NUMBER OF ROWS TIMES THE
	DIFFERENCE OF THE MEAN OF THE VARIABLE AND THE USER-INPUT VALUE,
	ALL TIMES THE STANDARD DEVIATION OF THE VARIABLE.



250	!
255  INPUT "ENTER VARIABLE A"; A% :PRINT
260  IF A%>=1% AND A%<=C% GOTO 280
265  PRINT "VARIABLE NUMBER A MUST BE BETWEEN 1 AND"; C%
270  PRINT "PLEASE TYPE IT IN AGAIN"
275  GOTO 255
280	!
284  PRINT "ENTER THE VALUE YOU WISH TO COMPARE"
285  PRINT "AGAINST THE MEAN OF VARIABLE";A%;
290  INPUT V: PRINT
310	T=((S(4%,A%)-V)/S(5%,A%))*SQR(S(0%,A%))
320	D%=S(0%,A%)-1%
330  GOTO 1000
349 !


	THIS IS THE ROUTINE FOR OPTION 2, COMPUTING THE T VALUE ASSUMING
	THE TWO VARIANCES ARE EQUAL.



350  GOSUB 900
360	S1=(S(0%,A%)-1)*S(5%,A%)^2+(S(0%,B%)-1)*S(5%,B%)^2
370	S1=S1/(S(0%,A%)+S(0%,B%)-2)*(1/S(0%,A%)+1/S(0%,B%))
380  S1=SQR(S1)
390	T=(S(4%,A%)-S(4%,B%))/S1
410	D%=S(0%,A%)+S(0%,B%)-2%
420  GOTO 1000
499 !


	THIS IS THE ROUTINE FOR OPTION 3, COMPUTING THE T VALUE ASSUMING
	THE TWO VARIANCES ARE NOT EQUAL.



500  GOSUB 900
510	T=(S(4%,A%)-S(4%,B%))
520	T=T/SQR(S(5%,A%)^2/S(0%,A%)+S(5%,B%)^2/S(0%,B%))
530	D=(S(5%,A%)^2/S(0%,A%)+S(5%,B%)^2/S(0%,B%))^2
540	D1=(S(5%,A%)^2/S(0%,A%))^2/(S(0%,A%)+1)
550	D2=(S(5%,B%)^2/S(0%,B%))^2/(S(0%,B%)+1)
560  D%=D/(D1+D2)-2+.5
570  GOTO 1000
598 !


	THIS IS THE ROUTINE FOR OPTION 4, COMPUTING THE T VALUE ASSUMING
	THE TWO VARIABLES ARE RELATED.
599 !	NOTE THAT THIS IS THE ONLY OPTION THAT USES THE DATA MATRIX.
	HENCE, THIS IS THE ONLY PLACE WHERE THE MATRIX IS OPENED AND
	CLOSED.



600  GOSUB 900
610	N=0: D=0: D1=0
620	OPEN F3$ FOR INPUT AS FILE 3
630  DIM #3,E(250%,15%)
635	FOR I%=1% TO R%: IF E(I%,A%)=H9 OR E(I%,B%)=H9 GOTO 670
640	D2=E(I%,A%)-E(I%,B%)
650	D=D+D2: D1=D1+D2*D2
660	N=N+1
670	NEXT I%
675  CLOSE 3
680	IF N<=1 GOTO 760
682	S1=SQR((D1-D*D/N)/(N*(N-1)))
685	T=(D/N)/S1
690	D%=N-1
700  GOTO 1000
708 !


	THE T VALUE IS NOT MEANINGFUL WHEN TWO VARIABLES ARE EXACTLY EQUAL
	AT EACH POINT EXCEPT FOR A MULTIPLICATIVE FACTOR. WHEN SUCH IS
	THE CASE, THIS MESSAGE IS PRINTED OUT INSTEAD OF THE T STATISTIC.



710  PRINT
720  PRINT "***VARIABLE";B%+1%;" EXCEEDS VARIABLE";A%+1%;" AT EACH"
730  PRINT "***OBSERVATION POINT BY THE ADDITIVE CONSTANT";D
740  PRINT
750  GOTO 1030
760	PRINT "NOT ENOUGH PAIRS OF DATA EXIST TO COMPUTE A T STATISTIC"
765	PRINT "BETWEEN VARIABLE ";A%;" AND VARIABLE ";B%
770	GOTO 1030
899 !


	THIS IS THE VARIABLE NUMBERS INPUT ROUTINE, USED BY MEANS OF A GOSUB
	INSTRUCTION BY OPTIONS 2, 3, AND 4.



900  X=X             !INPUT VAR A & B SUBROUTINE
905	!
910  INPUT "ENTER THE NUMBERS OF TWO VARIABLES FOR THE T-TEST";A%,B%
911  PRINT
915	IF A%>=1% AND B%>=1% AND A%<=C% AND B%<=C% GOTO 950
920  PRINT "YOUR VARIABLE NUMBERS MUST BE BETWEEN 1 AND"; C%
925  PRINT "PLEASE TRY AGAIN"
930  GOTO 910
950  RETURN
999 !


	THIS ROUTINE PRINTS THE COMPUTED T AND DEGREES OF FREEDOM.



1000 PRINT "COMPUTED T VALUE....";
1005 PRINT USING " #######.#####",T
1010 PRINT "DEGREES OF FREEDOM..";
1015 PRINT USING "        ######",D%
1020 PRINT
1029 !


	HERE THE MORE T VALUES QUESTION IS ASKED. IF NO, THEN CONTROL IS
	RETURNED TO STATCM.



1030 INPUT "DO YOU WISH TO COMPUTE MORE T VALUES ";N$
1035 PRINT
1040 IF LEFT(N$,1%)="Y" GOTO 170
1045 IF LEFT(N$,1%) = "N" OR N$="" GOTO 1060
1050 PRINT "PLEASE ANSWER EITHER YES OR NO"
1055 GOTO 1030
1060 R$=SYS(CHR$(8)+F$)
1070 CHAIN "STATCM"+A9$
1999 !


	THIS IS THE HELP MESSAGE ROUTINE, LISTING THE FOUR T TEST OPTIONS.



2000 PRINT "THE FOLLOWING FOUR HYPOTHESES ARE OPTIONAL FOR CALCULATION"
2010 PRINT " OF T-STATISTIC ON THE MEANS OF SAMPLE VARIABLES A AND B:"
2020 PRINT "  1 - MEAN OF A = GIVEN VALUE"
2030 PRINT "  2 - MEAN OF A = MEAN OF B, ASSUMING TWO VARIANCES ";
2035 PRINT "ARE EQUAL"
2040 PRINT "  3 - MEAN OF A = MEAN OF B, ASSUMING TWO VARIANCES ";
2045 PRINT "ARE NOT EQUAL"
2050 PRINT "  4 - MEAN OF A = MEAN OF B, WHERE A AND B ARE RELATED"
2060 PRINT
2070 GOTO 170
2999 !


	THESE ARE ERROR ROUTINES FOR WHEN THE USER TYPES IN NON-NUMERICS.



3000	IF ERR=28% THEN GOSUB 10000: RESUME 1030
3001 PRINT "INSTEAD OF A VARIABLE NUMBER"
3005	IF ERL<280 GOTO 3010 ELSE IF ERL<330 GOTO 4000 ELSE
	IF ERL>900 AND ERL<950 GOTO 5000 ELSE ON ERROR GOTO 0
3010	PRINT "YOU TYPED NON-NUMERIC CHARACTER(S)"
	: PRINT "INSTEAD OF A VARIABLE NUMBER"
	: PRINT "PLEASE TYPE ONLY NUMBERS WHEN NUMBERS ARE REQUESTED"
3020 RESUME 265
4000 PRINT"YOU TYPED NON-NUMERIC CHARACTER(S)"
4001 PRINT "INSTEAD OF A NUMERIC VALUE"
4010 PRINT "PLEASE TYPE ONLY NUMBERS WHEN NUMBERS ARE REQUESTED"
4020 RESUME 284
5000 PRINT "YOU TYPED NON-NUMERIC CHARACTER(S)"
5001 PRINT "FOR ONE OR BOTH VARIABLE NUMBERS"
5010 PRINT "PLEASE TYPE ONLY NUMBERS, SEPARATING THEM WITH A COMMA"
5020 RESUME 920
10000	V0$=SYS(CHR$(6%)+CHR$(-7%)): RETURN	! CTRL/C TRAP
32767 END
