10!  GAMES	VER 6B	EDIT 00 	01-MAR-77	J.CONDICT


	WRITTEN BY JIM CONDICT '78, MIDDLEBURY COLLEGE, VERMONT.

20!	THIS PROGRAM IS A GAME MANAGER.  IT ALLOWS RUN ACCESS TO COMPILED
	GAMES STORED ON THE GAME ACCOUNT (DEFINED IN LINE 1000) THAT ARE
	NORMALLY RUN-PROTECTED BY DOING A PRIVILEGED CHAIN TO THEM.  IT
	WILL ALLOW OR DENY ACCESS TO THE GAMES BASED ON A TABLE OF
	AVAILABILITY REQUIREMENTS STORED IN "GAMES.TBL" ON THE GAME ACCOUNT.
	THIS TABLE TAKES INTO ACCOUNT THE DAY OF THE WEEK, THE TIME OF DAY
	AND HOW MANY USERS ARE LOGGED ON THE SYSTAM WITHIN A GIVEN RANGE
	OF KEYBOARD NUMBERS.  BY RUNNING THIS PROGRAM, A PRIVELEGED USER MAY
	REDEFINE THE AVAILABILITY REQUIREMENTS.

	THIS PROGRAM SHOULD BE STORED ON THE LIBRARY ACCOUNT
	WITH A PROTECTION CODE OF <232>.

	THE ACCOUNT ON WHICH THE GAMES ARE STORED MUST BE DEFINED IN LINE 1000.
	ANY .BAC OR .SAV FILE IN THIS ACCOUNT WILL BE CONSIDERED A GAME AND
	WILL BE RUNABLE THROUGH THIS PROGRAM WHETHER PROTECTED OR NOT.
	THIS PROGRAM INCLUDES A DIRECTORY OPTION WHICH SEARCHES THROUGH THE
	UFD OF THE GAME ACCOUNT AND LISTS THE NAMES OF ALL THE .BAC AND .SAV
	FILES IN THAT ACCOUNT.  THERE SHOULD NOT EXIST ON THE GAME ACCOUNT TWO
	FILES WITH THE SAME NAME THAT HAVE .BAC AND .SAV EXTENSIONS.

	THE ARGUMENTS TO FNB% IN LINE 1030 SHOULD BE INCLUSIVE OF ALL KEYBOARD
	NUMBERS ON THE SYSTEM, BUT MUST NOT INCLUDE ANY PSEUDO-KEYBOARD
	TERMINAL NUMBERS, AS THEY WILL ALWAYS TEST "IN USE" BY THE PEEK
	LOOKUP USED TO DETURMINE BUSY TERMINALS.

	THIS PROGRAM DUMPS THE ACCUMULATED ACCOUNTING DATA TO THE ACCOUNT
	FROM WHICH IT IS BEING RUN.  IF IT IS DESIRED TO KEEP TRACK OF GAME
	USAGE, THE GAME THAT IS RUN MAY, AT THE AND OF ITS RUN, DUMP THE
	ACCOUNTING DATA ACCUMULATED SINCE THE GAME MANAGER'S DUMP TO THE
	GAME ACCOUNT.  AN EXAMPLE OF THIS MAY BE FOUND IN THE GAME "PICTUR".
	
250!  PROGRAM REVISIONS
	DATE		MODIFICATION

999!


	!	S T A R T    O F    P R O G R A M


1000 DIM#1%, S1%(4%),I1%(20%,7%)
	\ DIM#2%, U%(3583%,7%)
	\ DIM D%(7%), S%(2%), N%(4%)
	\ G$="[8,9]"
	! DIMENSION GAME ACCESS FILE, UFD FOR GAME ACCOUNT.
	! DEFINE GAME ACCOUNT.

1010 ON ERROR GOTO 19000
	\ D%=PEEK(512%) \ T%=PEEK(514%)
	\ W%=D%/1000% \ W%=D%+W%+(W%+3%)/4%+2% \ W%=W%-7%*(W%/7%)+1%
	\ READ D$ FOR J%=1% TO W%
	! GET DATE, TIME, AND DAY OF WEEK.  (ALLOW FOR LEAP YEARS.)

1020 DATA "Mon","Tue","Wed","Thu","Fri","Sat","Sun"

1030 PRINT "GAMES - ";CVT$$(RIGHT(SYS(CHR$(6%)+CHR$(9%)),3%),4%);
		" on ";D$;" ";DATE$(D%);" at ";TIME$(T%);
		" with";FNB%(0%,0%)+FNB%(5%,8%)+FNB%(10%,20%);"Users."
		\ PRINT
	! PRINT HEADER.
	! THE NUMBERS IN THE FNB% CALLS SHOULD INCLUDE ALL THE TERMINALS
	! IN THE SYSTEM.  THEY MAY NOT, HOWEVER, INCLUDE THE PSEUDO KB'S.

1040 OPEN G$+"GAMES.TBL" FOR INPUT AS FILE 1%
	\ B%=FNB%(S1%(0%),S1%(1%))
	! OPEN DATA FILE AND FIND OUT
	! HOW MANY USERS ON TERMINALS TO BE CHECKED.

1050 OPEN G$ FOR INPUT AS FILE 2%
	\ F%=U%(31%,0%)
	\ C1%=3243%
	\ C2%=30462%
	! OPEN UFD FOR GAME ACCOUNT AND GET CLUSTER SIZE.
	! DEFINE RADIX-50 REPRESENTATION FOR "BAC" AND "SAV".

1060 S$=SYS(CHR$(6%)+CHR$(-15%))
	\ IF (PEEK(PEEK(PEEK(520%)+8%)+24%)AND-256%)=256% THEN 2020
	! DUMP ACCOUNTING DATA TO CURRENT ACCOUNT.
	! IF PRIVILEGED, BRANCH TO PRIVILEGED USER ROUTINE.



		**** See if games are allowed now ****

1070 S%=0% \ GOSUB 10010
	\ IF S% AND NOT P% THEN 32767
	! CHECK TO SEE IF GAMES ARE CURRENTLY SUSPENDED.

1080 T1%=1% \ T1%=T1%+1% UNTIL I1%(T1%,0%)<=T%
	\ I%=I1%(T1%,W%)
	\ CLOSE 1%
	! FIND TIME PERIOD OF DAY.
	! FIND INDEX OF AVAILABILITY OF GAMES FOR THIS TIME AND DAY.

1090 IF I%<0% THEN
	PRINT "GAMES NOT AVAILABLE AT THIS TIME TODAY."
	\ GOTO 32767 UNLESS P%
	! GAMES UNCONDITIONALLY UNAVAILABLE NOW.

1100 IF I%<B% THEN
	PRINT "TOO MANY USERS ON LINE NOW FOR GAMES."
	\ GOTO 32767 UNLESS P%
	! SYSTEM TOO BUSY NOW.



		**** Get game to play and chain to it ****

1105 PRINT 'ENTER "DIR" FOR DIRECTORY OF GAMES.'
	! INFORM USER OF DIRECTORY OPTION.

1110 PRINT \ INPUT "GAME TO PLAY"; C$ \ PRINT
	\ C$=CVT$$(C$,255%)
	\ IF C$="DIR" THEN
		PRINT "GAMES AVAILABLE:" \ PRINT
		\ U%=0% \ GOTO 10050
	! GET GAME TO PLAY.
	! IF "DIR" THEN GO TO DIRECTORY ROUTINE.

1120 CHANGE MID(SYS(CHR$(6%)+CHR$(-10%)+C$),7%,4%) TO N%
	\ N1%=N%(1%)+SWAP%(N%(2%))
	\ N2%=N%(3%)+SWAP%(N%(4%))
	\ U%=0%
	! PACK GAME NAME INTO RADIX-50 FORMAT.
	! INITIALIZE UFD POINTER.

1130 GOSUB 10030
	\ IF U%<>0% AND (U%(U%,1%)<>N1% OR U%(U%,2%)<>N2%) THEN 1130
	ELSE IF U%=0% THEN
		PRINT "GAME ";C$;" NOT FOUND."
		\ GOTO 1110
	! LOOK UP GAME NAME IN UFD.
	!WANT TO MAKE SURE IT IS A .BAC OR .SAV FILE,
	! NOT A .BAS PROGRAM.
	! PRINT ERROR MESSAGE IF NOT FOUND.

1140 IF I%=C1% THEN CHAIN G$+RAD$(N1%)+RAD$(N2%)+".BAC"
	       ELSE CHAIN G$+RAD$(N1%)+RAD$(N2%)+".SAV"
	! DO CHAIN TO APPROPRIATE .BAC OR .SAV FILE.

2020!


	!	P R I V I L E G E D    U S E R    R O U T I N E


2030 PRINT 'Type "?" for help.'
	\ RESTORE \ READ D$(I%) FOR I%=1% TO 7%
	\ L$=CHR$(13%)+CHR$(10%)
	\ P%=-1%
	! READ IN DAYS OF WEEK.
	! DEFINE LINE TERMINATING STRING
	! SET PRIVELAGE FLAG.

2040 PRINT
	\ INPUT "COMMAND"; C$
	\ C$=LEFT(CVT$$(C$,255%),1%)
	! GET COMMAND.

2050	IF C$="I" THEN 2080 ELSE
	IF C$="C" THEN 2130 ELSE
	IF C$="S" THEN 2180 ELSE
	IF C$="T" THEN 2210 ELSE
	IF C$="P" THEN 1070 ELSE
	IF C$="?" THEN 2060 ELSE 2030
	! BRANCH ON COMMAND.



		**** Print available commands ****

2060 PRINT L$;	"AVAILABLE COMMANDS ARE:";L$;L$;
		" I -- Inspect current availability requirements.";L$;
		" C -- Change availability requirements.";L$;
		" S -- Suspend games temporarily.";L$;
		" T -- Modify time interval(s)."
2070 PRINT	" P -- Play a game (restrictions will be listed).";L$;
		"^Z -- Exit from program.";L$;
		" ? -- Print this message.";L$;L$;
		'A ^Z typed in response to any question but "COMMAND?"';L$;
		'will return the program to the "COMMAND" level.'
	\ GOTO 2040
	! PRINT LIST OF AVAILABLE COMMANDS.



		**** Inspect ****

2080 PRINT \ PRINT "Table shows maximum number of terminals from KB"
		NUM1$(S1%(0%));": to KB";NUM1$(S1%(1%));":";L$;
		"that can be in use and still allow games to be played.";L$;
		"-1 means no games in that time period unconditionally.";L$
2090	T$=CHR$(9%) \ PRINT "Time interval";
	\ PRINT T$;J%;D$(J%); FOR J%=1% TO 7%
	\ PRINT L$;"ending at"
	! PRINT HEADING FOR AVAILABILITY TABLE.

2100 FOR I%=1% TO S1%(4%)
	\ PRINT NUM1$(I%);") ";TIME$(I1%(I%,0%));
	\ PRINT T$;"  ";I1%(I%,J%); FOR J%=1% TO 7%
	\ PRINT
2110 NEXT I%
	\ GOSUB 10010
	! PRINT OUT AVAILABILITY TABLE.
	! CHECK TO SEE IF GAMES ARE SUSPENDED.

2120 GOTO 2040
	! AVAILABILITY INFORMATION PRINTED OUT.
	! RETURN FOR NEXT COMMAND.



		**** Change availability requiremants ****

2130 MAT S%=ZER
	\ PRINT "NEW TERMINAL NUMBERS TO SCAN (<CR> = NO CHANGE)";
	\ MAT INPUT S%
	\ PRINT
	\ IF NUM>1% THEN
		S1%(J%)=S%(J%+1%) FOR J%=0% TO 1%
		\B%=FNB%(S%(1%),S%(2%))
	! CHANGE TERMINALS TO SCAN, IF DESIRED.

2140 INPUT "DAY TO CHANGE(1-7, 8=ALL, 9=M-F)"; D0%
	\ IF D0%<1% OR D0%>9% THEN 2140
	! INPUT DAY TO CHANGE.

2150 PRINT "TIME INTERVAL(1-";NUM1$(S1%(4%));")";
	\ INPUT T0%
	\ IF T0%<1% OR T0%>S1%(4%) THEN 2150
	! INPUT TIME INTERVAL TO CHANGE.

2160 PRINT "For ";
	\ PRINT D$(D0%); IF D0%<8%
	\ PRINT "EVERY DAY"; IF D0%=8%
	\ PRINT "Mon to Fri"; IF D0%=9%
	\ PRINT " ";TIME$(I1%(T0%-1%,0%)-1%);" To ";TIME$(I1%(T0%,0%));
	\ INPUT I1%
	! GET NEW AVAILABILITY CRITERION.

2170 I1%=-1% IF I1%<0%
	\ I1%(T0%,D0%)=I1% IF D0%<8%
	\ I1%(T0%,J%)=I1% FOR J%=1% TO 7% IF D0%=8%
	\ I1%(T0%,J%)=I1% FOR J%=1% TO 5% IF D0%=9%
	\ PRINT \ GOTO 2140
	! UPDATE FILE.



		**** Suspend ****

2180 INPUT "HOW LONG TO SUSPEND GAMES FOR (DD/HH)"; T0$
	\ I%=INSTR(1%,T0$,"/")
	\ D0%=VAL(LEFT(T0$,I%-1%))+D%
	\ T%=PEEK(514%)
	\ T0%=T%-VAL(RIGHT(T0$,I%+1%))*60%
	! GET TIME AND DATE WHEN TO END SUSPENSION.

2190	IF T0%<=0% THEN
		T0%=T0%+1440%
		\ D0%=D0%+1%
		\ GOTO 2190
		! IF NUMBER OF HOURS RUNS OVER INTO NEXT DAY,
		! FIND CORRECT DAY AND TIME.

2200 S1%(2%)=D0% \ S1%(3%)=T0%
	\ GOSUB 10010
	\ GOTO 2040
	! SUSPEND PLAYING OF GAMES AND NOTIFY USER.



		**** Time interval modification ****

2210 INPUT "NEW NUMBER OF INTERVALS (<CR> = NO CHANGE)"; T0%
	\ PRINT
	\ IF T0%>0% THEN S1%(4%)=T0%
	! CHANGE NUMBER OF INTERVALS, IF DESIRED.

2220 PRINT
	\ INPUT "TIME INTERVAL (NUMBER)"; T0%
	\ PRINT "NEW ENDING TIME"; \ INPUT LINE T0$
	\ T0$=CVT$$(T0$,253%)
	\ GOTO 2230 IF TIME$(I%)=T0$ FOR I%=1% TO 1440%
	\ PRINT "TIME ENTRY NOT RECOGNISED."
	\ PRINT "PLEASE ENTER EXACTLY AS SYSTEM WOULD PRINT TIME."
	\ GOTO 2220
	! ENTER NEW INTERVAL END TIME.

2230 I1%(T0%,0%)=I%
	\ GOTO 2220
	! CHANGE INTERVAL ENDING TIME IN FILE.

9000!


	!	P R O G R A M M E R    D E F I N E D    F U N C T I O N S


10010 IF S1%(2%)>=D% THEN
		IF S1%(2%)>D% OR S1%(3%)<T% THEN
	PRINT "GAMES SUSPENDED UNTIL ";DATE$(S1%(2%));" at ";TIME$(S1%(3%));"."
	\ S%=-1%
10020 RETURN
	! IF GAMES ARE CURRENTLY SUSPENDED, NOTIFY USER AND SET FLAG S%.


10030 I%=U%(U%,0%)
	\ U%=(((I% AND 3584%)/512%)*F%+(SWAP%(I% AND -4096%)/16%))*32%+
		((I% AND 496%)/16%)
	\ I%=U%(U%,3%) \ IF I%<>C1% AND I%<>C2% AND U%<>0% THEN 10030
10040 RETURN
	! SCAN THROUGH UFD UNTIL A .BAC OR A .SAV FILE IS FOUND,
	! OR UNTIL END OF UFD.


10050 GOSUB 10030
	\ PRINT IF POS(0%)>70% OR U%=0%
	\ IF U%=0% THEN 1110
		ELSE PRINT USING "\ \\      \",RAD$(U%(U%,1%)),RAD$(U%(U%,2%));
		\ GO TO 10050
	! PRINT DIRECTORY OF GAMES.

19000!


	!	E R R O R    H A N D L I N G    R O U T I N E


19010 IF ERR=11% THEN
	IF ERL>=2130% AND ERL<=2220% THEN RESUME 2040
	ELSE IF ERL=1110% OR ERL=2040% THEN CLOSE 1% \ RESUME 32767
	! USER TYPING CTRL/Z.

19050 IF ERL=1110% OR ERL=1140% THEN
	PRINT CVT$$(RIGHT(SYS(CHR$(6%)+CHR$(9%)+CHR$(ERR)),3%),4%)
	\ RESUME 1110
	! ERROR IN CHAINING TO GAME PROGRAM.

19060 IF ERR=5% AND ERL=1010% THEN PRINT
	\ IF (PEEK(PEEK(PEEK(520%)+8%)+24%)AND-256%)=256% THEN RESUME 19110
	ELSE PRINT "GAME MANAGING FILE NOT FOUND -- GAMES NOT AVAILABLE."
		\ RESUME 32767
	! "GAMES.TBL" NOT FOUND.

19100 CLOSE 1%,2% \ ON ERROR GOTO 0
	! UNEXPECTED ERROR.

19110 OPEN G$+"GAMES.TBL<62>" FOR OUTPUT AS FILE 1%
	\ PRINT '"';G$;'GAMES.TBL" BEING CREATED.'
	\ PRINT "IT CURRENTLY CONTAINS NO MEANINGFUL DATA."
	\ PRINT "THIS MUST BE SUPPLIED."
	\S1%(4%)=4%
	\ GOTO 1050
	! CREATE "GAMES.TBL".

19999!


	!	S T A N D A R D    F U N C T I O N S


20000 DEF FNB%(I%,J%)
	\ O3%=0%
	\ O1%=SWAP%(CVT$%(RIGHT(SYS(CHR$(6%)+CHR$(-3%)),7%)))
	\ O1%=PEEK(O1%+ASCII(RIGHT(SYS(CHR$(6%)+CHR$(-12%)),9%)))
	! GET (DEVPTR)
	! GET (TTYDEV)
	! (TTYDEV MAY CHANGE IF DEVICES ARE ADDED TO SYSTEM)

20010 O3%=O3%+1% IF 255% AND PEEK(PEEK(O1%+O9%*2%)+2%) FOR O9%=I% TO J%
	\ FNB%=O3%
	! RUN THROUGH KEYBOARDS WITHIN LIMITS AND COUNT ONES
	! THAT ARE ATTACHED TO A JOB

20020 FNEND
	! FNB%(I%,J%)- RETURNS THE NUMBER OF KEYBOARDS THAT ARE
	! IN USE AND NUMBERS LIE BETWEEN THE LIMITS I% AND J%



32767 END
