10 REM			MNEPCH
20 REM	CALCULATES ORBITAL ELEMENTS AND MEAN EPOCHS
30 REM		AND LOADS 'SAM.DAT'
35 REM  PART OF A PACKAGE INCLUDING NORTON.BAS AND EPHEM1.BAS
40 GOTO 60
50 R0%=1%:PRINT:PRINT "Calculating New Epoch"		!SNEAK IN
60 OPEN "SAM.DAT" AS FILE 2
70 DIM #2,D$(1)=128,E(15,6),D(13),M$(12)=3,Y%(13),P%(15),
	P$(15)=7,F%(15),N$(9)=15,C0$(20)=25,C(20,8)
80 C$=N$(9%):D=D(1%):T=D(10%)

100 !*********** USER OPTIONS AND SPECIFICS ***********
110 L1=45.5083:L0=123.716		!LATITUDE,LONGITUDE OF PORTLAND
120 G=8%				!GMT-PST
130 D(0%)=1%				!HOME PLANET IS EARTH
140 PRINT "PLEASE ADD YOUR LOCALIZED DATA TO MNEPCH."
141 PRINT "UNTIL YOU DO, YOU WILL RECEIVE INFORMATION ABOUT THE"
142 PRINT "SKIES IN PORTLAND, OREGON."
155 ! INSERT RSTS ACCOUNT NUMBER IN NORTON, LINE 50
	OR PROGRAMS WON'T WORK!
160 !**************************************************

170 L1=L1*PI/180:L0=L0*PI/180	!CONVERT TO RADIANS
172 DEF FNM(N)=((N/360-INT(N/360))*360)*PI/180
			!MOD 360, CONVERTED TO RADIANS
180 RESTORE:ON ERROR GOTO 2000:RANDOMIZE
190 DEF FNJ(M,D,Y)=D-.5+Y%(M)+(Y-1900)*365+FIX((Y-1900)/4)-(M<3)*(Y/4=INT(Y/4))
		! JULIAN DATE EPOCH 0 JAN 1900
200 MAT READ M$:D(12%)=13%		!MONTH MATRIX
210 DATA "JAN","FEB","MAR","APR","MAY","JUN"
220 DATA "JUL","AUG","SEP","OCT","NOV","DEC"
230 MAT READ Y%: Y%(0%)=0%: D(8%)=G	!DATE MATRIX
240 DATA 0,31,59,90,120,151,181,212,243,273,304,334,365
280 READ N$(J%)  FOR J%=1% TO 6%
290 DATA "Mean Distance","Eccentricity","Inclination","Ascending Node"
300 DATA "Arg.Perihelion","Mean Anomaly"
310 IF R0%=1% THEN 360		!SKIP ON REMOTE ENTRY
320 PRINT "Month,Day & Year (Input as numbers separated by commas)";
330 INPUT M%,D,Y%:IF Y%<1900% THEN Y%=Y%+1900%
340 D=FNJ(M%,D,Y%)
360 T=D/36525
	:E(0%,2%)=L1: E(0%,3%)=L0
	:D(2%)=D		!STORE LONGIT & LATIT, SET NEW EPOCH

370 FOR P%=1% TO 4%			!ORBITAL ELEMENTS OF INNER PLANETS
375 READ P$(P%)	!NAME
380 READ E(P%,1%),A,B,C			!FROM SIMON NEWCOMB
390 E(P%,2%)=A+(B+C*T)*T	!ECCENTRICITY
410 READ A,B,C,D,E
430 E(P%,3%)=FNM(A+B/60%+(C+(D+E*T)*T)/3600%)	!INCLINATION OF ORBIT
440 FOR J%=4% TO 6%	!ASC NODE, ARG PERIH, MEAN ANOM
450 READ A,B,C,D,E,F,G
460 E(P%,J%)=FNM(A+B/60%+C/3600%+D*360%*T+(E+(F+G*T)*T)*T/3600%)
470 IF J%=5% THEN E(P%,5%)=E(P%,5%)-E(P%,4%)	!ARG OF PERIHELION
500 NEXT J%
510 NEXT P%

520 READ A,B,C,D,E,F
540 E(0%,1%)=FNM(A+B/60%+C/3600%+(D+(E+F*T)*T)*T/3600%)	!OBLIQUITY OF ECLIPTIC
550 E(P%,0%)=D(2%) FOR P%=0% TO 4%

560 DATA 'Earth'
570 DATA 1.00000023,.01675104,-.418E-4,-.126E-6
575 DATA 0,0,0,0,0
577 DATA 0,0,0,0,0,0,0
580 DATA 101,13,15,0,6189.03,1.63,.012
590 DATA 358,28,33.04,0,129596579.1,-.54,-.12
610 DATA 'Mercury'
620 DATA .3870986,.20561421,.2046E-4,-.3E-7
630 DATA 7,0,10.37,6.699,-.066
640 DATA 47,8,45.4,0,4266.75,.626,0
650 DATA 75,53,58.91,0,5599.76,1.061,0
660 DATA 102,16,45.77,415,261055.04,.024,0
680 DATA 'Venus'
690 DATA .7233316,.682069E-2,-.4774E-4,.91E-7
700 DATA 3,23,37.07,3.621,-.0035
710 DATA 75,46,46.73,0,3239.46,1.476,0
720 DATA 130,9,49.8,0,5068.93,-3.515,0
730 DATA 212,36,11.59,162,712093.95,4.6298,0
750 DATA 'Mars'
760 DATA 1.5236915,.0933129,.92064E-4,-.77E-7
770 DATA 1,51,1.2,-2.43,.0454
780 DATA 48,47,11.19,0,2775.57,-.005,-.0192
790 DATA 334,13,5.53,0,6626.73,.4675,-.0043
800 DATA 319,31,45.93,53,215490.6,.6509,.0043
820 DATA 23,27,8.26,-46.845,-.0059,.00181

830 FOR P%=5% TO 13%			!OUTER PLANET AND ASTEROID DATA
835 READ P$(P%),M,D,Y		!NAME, EPOCH DATE OF ELEMENTS
838 E(P%,0%)=FNJ(M,D,Y)	!STORE EPOCH IN ARRAY AS JULIAN FROM 1900
840 READ E(P%,J%) FOR J%=1% TO 2%	!S.M.AXIS, ECCENTRICITY
845 FOR J%=3% TO 6%: READ X: E(P%,J%)=X*PI/180: NEXT J%
850 NEXT P%
880 DATA 'Jupiter', 1,28,1975
890 DATA 5.202483, .0480239, 1.30564 , 100.1892, 273.7611, 343.6683
895 DATA 'Saturn', 1,28,1975
900 DATA 9.542341, .0552447, 2.4888  , 113.4641, 338.3666, 12.9678
905 DATA 'Uranus', 1,28,1975
910 DATA 19.14116, .0450722, .77288  , 73.8967 , 95.5203 , 36.7340
915 DATA 'Neptune', 1,28,1975
920 DATA 30.04112, .0102417, 1.77082 , 131.5914, 266.2912, 212.4085
925 DATA 'Pluto', 12,19,1974
930 DATA 39.30096, .2461528, 17.14464, 109.998 , 114.2665, 338.024
935 DATA 'Vesta', 6,11,1957
940 DATA 2.3617  , .08888  , 7.132   , 104.102 , 49.124  , 79.667
945 DATA 'Juno', 6,11,1957
950 DATA 2.6683  , .25848  , 12.993  , 170.438 , 246.133 , 329.336
955 DATA 'Ceres', 6,11,1957
960 DATA 2.7675  , .0759   , 10.607  , 80.514  , 71.853  , 279.88
965 DATA 'Pallas', 6,11,1957
970 DATA 2.7718  , .23402  , 34.798  , 172.975 , 295.759 , 271.815
975 !     A           E         I           U        W       M

1010 P$(0%)='Sun': E(0%,5%)=E(D(0%),5%)+PI	!SUN'S ANGLES ARE ALWAYS
1020 E(0%,6%)=E(D(0%),6%)+PI			! 180 FROM EARTH'S
1030 E(0%,4%)=0%	!ASC NODE

1050 !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
	The Main activity of this program is to load matrix E(15,8)
	 with the orbital elements of elliptical motion:
	E(P%,J%)  P% is planet number, J% is orbital element pointer
1060!	 J%
	 0=Epoch date, Julian from 0-Jan-00
	 1=Mean Distance
	 2=Eccentricity
	 3=Inclination to Ecliptic
	 4=Ascending Node
	 5=Arg. Perihelion
	 6=Mean Anomaly at Epoch

1080 !C0$ HAS COMET NAMES
     !C(A,B) HAS 5 PARABOLIC ELEMENTS AND 3 MAGNITUDE COEFFICIENTS,
     !STORED BY COMET NUMBER B
1090 J%=0%	!THIS LOOP STOPS WHEN AN OUT-OF-DATA ERROR OCCURS
1100 J%=J%+1%
1110 READ C0$(J%)	!NAME
1120 C(0%,0%)=J%	!STORE NUMBER OF COMETS
1130 READ C(J%,1%)	!Q
1135 FOR J1%=2% TO 4%
	:READ X: C(J%,J1%)=X*PI/180
	:NEXT J1%		!READ I,U,W, CONVERT TO RADIANS
1140 READ C(J%,5%)	!ECCENTRICITY, 0-.9 FOR ELLIPSE, 1 FOR PARABOLA
1145 READ M,D,Y: C(J%,0%)=FNJ(M,D,Y)	!PERIHELION DATE
1150 READ C(J%,J1%)  FOR J1%=6% TO 8%	!MAGNITUDE COEFFICIENTS, IF ANY
1160 GOTO 1100	!END OF LOOP

1170 DATA 'WEST'
1180 !IAU CIRCULAR #2931
1190 DATA .196630, 43.0710, 118.2332, 358.4186, 1, 2,25.2212,1976, 7,5,10
1200 DATA 'KOBAYASHI-BERGER-MILON'
1210 !IAU CIRCULAR #2813  8-AUG-1975
1220 DATA .425533, 80.7741, 295.6519, 116.9808, 1, 9,5.3367,1975, 0,0,0
1230 DATA 'KOHOUTEK'
1240 !IAU CIRCULAR #2577  28-SEP-1973
1250 DATA .142425, 14.2969, 257.7153, 37.8738, 1, 12,28.46437,1973, 0,0,0
1260 DATA 'HARLAN'
1270 !IAU CIRCULAR #2960
1280 DATA 1.568651, 38.8026, 80.725, 193.2473, 1,  11,3.0848,1976, 12,5,10
1290 DATA 'HALLEY'
1300 !COMET ORBIT CATALOG (1975)
1310 DATA .587211, 162.2160, 57.8464, 111.7186, .967298, 4,20.1788,1910,0,0,0
1320 DATA '1975J'
1325 !IAU CIRCULAR #2955
1330 DATA 1.603893, 91.6057, 277.9789, 246.2503, .997269, 12,25.8829,1975,10,5,10
1800 !       Q      I        U         W        E  (M, D, Y OF EPOCH)(MAGNITUDE)

1900 CLOSE 2
1910 IF R0% THEN CHAIN C$ 50	!EXIT IF CHAINED IN
1920 GOTO 32767

2000 !***ERROR HANDLER***
2010 IF ERR=57% AND ERL=1110% THEN RESUME 1900
2020 PRINT 'MNEPCH - ';
2030 IF ERR=5% THEN PRINT C$+".BAS is missing":
	PRINT "TRY AGAIN":CHAIN B$+"NORTON"
2090 ON ERROR GOTO

32767 END
