1	!


	!		P A S S W D 



2!		Program:	PASSWD
3!		Version:	V01A
4!		Edit:		01
7!		Edit Date:	23-Jun-80
9!		Author:		Brant Cheikes


15	EXTEND
	!  Set up BASIC-PLUS EXTEND mode processing

20	! &
	&
	&
	!	M o d i f i c a t i o n   H i s t o r y &
	&
	&
	!	Version/Edit	Edit Date	Reason &

21!		V01A-01		23-Jun-80	New release &

50	! &
	&
	&
	!	P r o g r a m   D e s c r i p t i o n &
	&
	&

60	! &
	!  PASSWD is designed to allow any user to change his own password. &
	!  In order to do so, however, he must know the current password. &
	!  This restriction prevents users who have gained unauthorized access &
	!  to another user's account (say an account that was left logged in &
	!  accidentally) from changing the password.  PASSWD allows the user &
	!  to additionally print the new password out on the terminal (it is &
	!  overwritten several times after 2 seconds).  When entered by CCL &
	!  command at line 30000, PASSWD simply skips the printing of the &
	!  system header and jumps right into the main code.  When entered &
	!  by "RUN", PASSWD executes as a standard system program. &
	! &
	!  Users are not allowed to change their password to anything other &
	!  than a valid six-character filename. &
	! &

900	! &
	&
	&
	!	D i m e n s i o n   S t a t e m e n t s &
	&
	&

910	DIM M%(30%) &
	!  Dimension matrix for SYS call returns &

1000	! &
	&
	&
	!	M a i n   P r o g r a m   C o d i n g &
	&
	&

1010	V$ = "V01A-01" &
	!  Set up version/edit level &

1020	ON ERROR GOTO 19000 &
	\  S$ = SYS(CHR$(6%)+CHR$(-7%)) &
	\  PRINT &
	\  PRINT "PASSWD   "+V$+"   "+ &
	   CVT$$(RIGHT(SYS(CHR$(6%)+CHR$(9%)),3%),4%) &
	\  PRINT "Password Changing Program" &
	\  PRINT &
	\  OPEN 'KB:PASSWD.CMD' FOR INPUT AS FILE 1% &
	!  Set (non)standard error handling routine; enable CTRL/C trapping; &
	!  output system header; open keyboard for input &

1030	S$ = SYS(CHR$(3%)) &
	\  PRINT "Enter old password: "; &
	\  INPUT #1% OLDPAS$ &
	!  Disable echoing on terminal; get old password &

1040	PRINT IF POS(0%) &
	\  PRINT "Enter new password: "; &
	\  INPUT #1% NEWPAS$ &
	\  GOTO 10100 IF LEN(NEWPAS$) > 6% &
	\  PRINT IF POS(0%) &
	\  S$ = SYS(CHR$(2%)) &
	!  Get desired password and make sure it is not too long &

1050	CHANGE SYS(CHR$(6%)+CHR$(14%)) TO M% &
	\  P$ = RAD$(M%(9%)+SWAP%(M%(10%)))+RAD$(M%(11%)+SWAP%(M%(12%))) &
	\  IF P$ <> OLDPAS$ THEN PRINT "?Invalid old password" &
	\  GOTO 32000 &
	!  Get current password; if old password entered incorrect, say "hey &
	!  idiot, wrong one!" and exit &

1060	CHANGE SYS(CHR$(6%)+CHR$(-10%)+NEWPAS$) TO M% &
	\  S0% = M%(27%)+SWAP%(M%(28%)) &
	\  GOTO 10000 IF S0% < 0% &
	\  M%(I%+2%) = M%(I%) FOR I% = 10% TO 7% STEP -1% &
	\  M%(0%) = 30% &
	\  M%(1%) = 6% &
	\  M%(2%) = 8% &
	\  M%(7%) = 0% &
	\  M%(8%) = 0% &
	\  M%(21%) = 0% &
	\  M%(28%) = 0% &
	\  CHANGE M% TO M$ &
	\  CHANGE SYS(M$) TO M% &
	!  Push new password thru a filename scan and make sure it is legal; &
	!  set up for CHANGE PASSWORD SYS call and execute it &

1070	INPUT #1% "Display new password?  (Yes/No)  <N>  ";D$ &
	\  D$ = LEFT(D$,1%) &
	\  IF D$ = "Y" THEN 1080 ELSE IF D$ = '' OR D$ = "N" THEN 32000 ELSE &
	   PRINT "Please type YES or NO" &
	\  PRINT &
	\  GOTO 1070 &
	!  Ask if user wants new password displayed &

1080	PRINT "New password is:   ";NEWPAS$;"      "; &
	\  SLEEP 2% &
	\  PRINT STRING$(LEN(NEWPAS$)+6%,8%); &
	\  BCK$ = STRING$(6%,8%) &
	\  PRINT "******";BCK$;"OOOOOO";BCK$;"######";BCK$;"XXXXXX";BCK$; &
	\  PRINT "%%%%%%";BCK$;"      ";BCK$;" Gone!" &
	\  GOTO 32000 &
	!  Display current password and exit &

10000	! &
	&
	&
	!	S u b r o u t i n e s &
	&
	&

10010	PRINT "?Invalid new password" &
	\  PRINT &
	\  GOTO 32000 &
	!  Handle bad new passwords &

10100	PRINT IF POS(0%) &
	\  PRINT "?New password is too long - must be less than 7 characters" &
	\  PRINT &
	\  GOTO 1040 &
	!  Tell user he entered a password that was too long for comfort &

19000	! &
	&
	&
	!	E r r o r   H a n d l i n g &
	&
	&

19010	IF ERR=28% THEN S$ = SYS(CHR$(2%)) &
	\  RESUME 32000 &
	!  Handle CTRL/Cs by enabling echo and exiting &

19020	IF ERL=1060% AND ERR=2% THEN PRINT "?Invalid new password" &
	\  RESUME 32000 &
	!  Handle illegal passwords by clearing out &

19800	IF ERR=11% THEN RESUME 32000 &
	!  Exit on CTRL/Z &

30000	! &
	&
	&
	!	C C L   E n t r y &
	&
	&

30005	ON ERROR GOTO 19000 &
	!  Set nonstandard error handling routine &

30010	OPEN 'KB:PASSWD.CMD' FOR INPUT AS FILE 1% &
	\  GOTO 1030 &
	!  Handle CCL entries by opening the keyboard (very bad, sorry) and &
	!  jumping back into the main code, omitting the header &

32000	! &
	&
	&
	!	E x i t &
	&
	&

32500	S$ = SYS(CHR$(2%)) &
	!  Turn echo back on &

32550	PRINT IF ERR=11% &
	!  Skip a line if we are exiting because of a lousy CTRL/Z &

32600	NO EXTEND
	!  Disable EXTEND mode processing

32700	S$ = SYS(CHR$(9%))
	!  Clear core and exit fast

32767	END
