10	!---------------------------------------------------------------------!
	!								      !
	!	MANAGE  V03.01						      !
	!	ACCOUNT MANAGEMENT PROGRAM				      !
	!	BY RUSS SCHWARTZ					      !
	!	NATIONWIDE MUTUAL INSURANCE COMPANY			      !
	!	NOVEMBER, 1979						      !
	!								      !
	!---------------------------------------------------------------------!

13	!*********************************************************************!
	!								      !
	!			D I S C L A I M E R			      !
	!								      !
	!*********************************************************************!
	!								      !
	!	THIS SOFTWARE IS PROPERTY OF NATIONWIDE MUTUAL INSURANCE      !
	!	COMPANY.  NO WARRANTY, EXPRESS OR IMPLIED, IS MADE CON-       !
	!	CERNING THE ACCURACY OR RELIABILITY OF THIS SOFTWARE.	      !
	!	THUS THE OWNER ASSUMES NO RESPONSIBILITY FOR THE SUPPORT      !
	!	OR MAINTENANCE OF THIS SOFTWARE ON ANY SYSTEM.		      !
	!								      !
	!*********************************************************************!

15	!---------------------------------------------------------------------!
	!								      !
	!	"MANAGE" IS THE ACCOUNT MANAGEMENT PROGRAM.  THROUGH A        !
	!	DIALOGUE WITH THE REQUESTOR, "MANAGE" ASSEMBLES REQUESTS      !
	!	TO: CREATE AND DELETE ACCOUNTS; CHANGE ACCOUNT PASSWORDS,     !
	!	QUOTAS AND NAMES; VERIFY ACCOUNTING DATA; AND UPDATE	      !
	!	"$ACCT.SYS".  THE DIALOGUE ENSURES THAT ONLY CORRECT          !
	!	PARAMETERS ARE INCLUDED IN THE REQUEST.  THEN THE REQUEST     !
	!	IS SENT TO "ACMAN.BAC", THE ACCOUNT MANAGER FOR PROCESSING.  !
	!								      !
	!---------------------------------------------------------------------!

20	!	EDIT	DATE		MODIFICATION
	!	----	----		------------
	!	01	12-NOV-79	UPGRADE TO VERSION 3.
30	!	VARIABLE NAME	DESCRIPTION
	!	-------------	-----------
	!	A$		SYS() CALL PARAMETER STRING.
	!	A%		ASCII() OF RESPONSE STRING.
	!	BACKUP%		BACK-UP-ONE-QUESTION FLAG.
	!	BAD%		BAD RESPONSE FLAG.
	!	BUF.LEN%	LENGTH OF PARAMETER BUFFER FOR SENDING.
	!	CLUSTR$		CLUSTER SIZE PARAMETER IN SYS() FORMAT.
	!	CMD$		REQUEST COMMAND; ASCII(CMD$) = REQUEST NUMBER.
	!	CMD%()		COMMAND NUMBER INDICATORS.
	!	CODE%		COMMAND PROCESSING CODE.
	!	CODE%()		COMMAND PROCESSING CODE INDICATORS.
	!	DESC$		ACCOUNT NAME PARAMETER.
	!	DEV$		DEVICE PARAMETER IN SYS() FORMAT.
	!	DEV.MAX%	MAX. NO. OF DEVICES WHICH ACMAN SERVICES.
	!	DISK$()		LIST OF DISKS WHICH ACMAN SERVICES.
	!	ERR1$		ERROR TEXT AS GENERATED BY FIP #9.
	!	HELP$		HELP TEXT.
	!	INDEX%		GENERAL-USE INDEX.
	!	J%		GENERAL-USE INDEX.
	!	KB$		KEYBOARD PARAM. FOR BROADCASTING TO REQUESTOR.
	!				ASCII(KB$) = UNIT NUMBER.
	!	LIBPAS$		SYSTEM LIBRARY ACCOUNT PASSWORD.
	!	LIBR$		ACCOUNT WHERE "ACMAN" FILES RESIDE.
	!	OPLIST$		LIST OF OPTION NAMES.
	!	OPTION$		NAME OF USER-SELECTED OPTION.
	!	OPTION%		NUMBER OF OPTION CORRESPONDING TO NAME.
	!	PARM$		PARAMETER STRING FOR SENDING REQUESTS.
	!	PARM%(85%)
	!	PASWRD$		PASSWORD PARAMETER IN RADIX-50.
	!	PPN$		ACCOUNT NUMBER PARAMETER.
	!	PROG%		PROGRAMMER NUMBER.
	!	PROG%		PROJECT NUMBER.
	!	QUOTA$		QUOTA PARAMETER IN SYS() FORMAT.
	!	R		RESPONSE VARIABLE -- FLOATING-POINT.
	!	R%		RESPONSE VARIABLE -- INTEGER.
	!	R$		RESPONSE VARIABLE -- STRING.
	!	R%()		MATRIX FOR CHECKING RESPONSE STRING.
	!	RES$		RESERVED SPACE IN PARAMETER STRING.
	!	S$		STRING FOR LINES OF HELP TEXT.
	!	TEXT$		RESPONSE PROMPT.
	!	VERSION$	CURRENT VERSION NUMBER.
50	!---------------------------------------------------------------------!
	!								      !
	!	I N I T I A L I Z A T I O N   S E C T I O N		      !
	!								      !
	!---------------------------------------------------------------------!

60	EXTEND
	\ DIM		R%(256%),
			CMD%(15%),
			CODE%(15%),
			DISK$(4%)
		! PROGRAM WRITTEN IN EXTEND MODE.
		! DIMENSION STATEMENTS.

70	VERSION$ = "V03.01"
	\ LIBR$ = "[1,2]"
	\ DEV.MAX% = 0%
	\ BUF.LEN% = 84%
	\ OPLIST$ = "OFFCREENTDELQUOCHAPASNAMSAVVERSTAREBCONOPEDUM"
		! VARIES ACCORDING TO INSTALLATION.

80	READ CMD%(INDEX%) FOR INDEX% = 1% TO 15%
	\ READ CODE%(INDEX%) FOR INDEX% = 1% TO 15%
	\ READ DISK$(INDEX%) FOR INDEX% = 0% TO DEV.MAX%
		! READ IN PARAMETERS.

90	DATA 0,  1,  1, 2,  3, 4, 4,  5, 6, 7, 8, 8,  9,  9, 10

92	DATA 0, 63, 63, 5, 13, 7, 7, 33, 0, 5, 4, 4, 64, 64, 2

94	DATA SY:

99	!
990	!---------------------------------------------------------------------!
	!								      !
	!	E X E C U T I V E   S E C T I O N			      !
	!								      !
	!---------------------------------------------------------------------!

1000	ON ERROR GO TO 9000
	\ A$ = SYS(CHR$(6%) + CHR$(-7%))
	\ PRINT CHR$(12%) + 'MANAGE  ' + VERSION$ + CHR$(9%)
	  + RIGHT(SYS(CHR$(6%) + CHR$(9%)), 3%)
	\ PRINT
	\ PRINT 'Account Management Request Program'
	\ PRINT
	! SET UP ERROR TRAP.
	! CTRL/C TRAP ENABLE.
	! PRINT HEADER & SYSTEM I.D.

1001	LIBPAS$ = SYS(CHR$(6%) + CHR$(14%) + STRING$(4%, 0%)
		+ CHR$(2%) + CHR$(1%) + STRING$(32%, 0%))
	\ A$ = SYS(CHR$(3%))
	\ INPUT 'Enter SYSLIB password'; R$
	\ PRINT STRING$(2%, 10%)
	\ A$ = SYS(CHR$(2%))
	\ IF CVT$$(R$, -1%) <> CVT$$(RAD$(SWAP%(CVT$%(MID(LIBPAS$, 9%, 2%))))
		+ RAD$(SWAP%(CVT$%(MID(LIBPAS$, 11%, 2%)))), -1%) THEN
	  A$ = SYS(CHR$(9%))
	! SEE IF THEY SHOULD BE IN HERE.
	! IF NOT, THEN GET OUT.

1005	PRINT TAB(5%); 'Type "?" for help.'
	\ PRINT TAB(5%); 'Hit "ESCAPE" or "ALT MODE" to back-up one question.'
	\ PRINT TAB(5%); 'Hit "LINE FEED" to take the default.'
	\ PRINT TAB(5%); 'Exit with CTRL/C or CTRL/Z.'
	\ PRINT
	! GIVE THEM GENERAL INSTRUCTIONS.

1010	OPEN "NL:MANAGE.WRK" AS FILE 12%, RECORDSIZE BUF.LEN%
	\ FIELD #12%,	BUF.LEN% AS PARM$
	\ FIELD #12%,	1% AS KB$,
			1% AS CMD$,
			2% AS PPN$,
			4% AS PASWRD$,
			2% AS QUOTA$,
			2% AS CLUSTR$,
			4% AS DEV$,
			4% AS RES$,
			64% AS DESC$
	\ LSET PARM$ = STRING$(BUF.LEN%, 0%)
	! SET UP PARAMETER BUFFER.

1020	PRINT
	\ R$ = ""
	\ WHILE R$ = ""
		\ PRINT "Select an option";
		\ INPUT LINE R$
		\ A% = ASCII(R$)
		\ PRINT TAB(5%); 'Type "?" for help.'
			IF A% = 13% OR A% = 10% OR A% = 12% OR A% = 27%
		\ R$ = CVT$$(R$, -1%)
	\ NEXT
	\ IF R$ = "?"
		THEN GOSUB 7500
		\ GO TO 1020

1030	OPTION$ = R$
	\ LSET PARM$ = STRING$(BUF.LEN%, 0%)
	\ OPTION% = INSTR(0%, OPLIST$, LEFT(OPTION$, 3%))
	\ IF OPTION% = 0% THEN
	  PRINT TAB(5%); OPTION$ + ' -- Illegal option'
	\ GO TO 1020
	! SEE IF OPTION IS LEGAL.

1040	OPTION% = INT(OPTION% / 3%) + 1%
	\ LSET CMD$ = CHR$(CMD%(OPTION%))
	\ CODE% = CODE%(OPTION%)
	\ LSET KB$ = CHR$(ASCII(MID(SYS(CHR$(6%) + CHR$(9%)), 2%, 1%)) / 2%)
	\ INDEX% = 0%
	! SAVE ACMAN COMMAND.
	! SET UP PROCESSING CODE.
	! SAVE KEYBOARD NUMBER OF ACMAN MESSAGES.

1060	IF CODE% AND [2% ^ INDEX%] THEN
	  ON INDEX% + 1% GOSUB 1100, 1200, 1300, 1400, 1500, 1600, 1700
	! GET RELEVANT DATA FOR THIS REQUEST:
	!	LINE	DATA
	!	----	----
	!	1100	PPN
	!	1200	PASSWORD
	!	1300	DISK
	!	1400	QUOTA
	!	1500	CLUSTER
	!	1600	NAME
	!	1700	KEYBOARD

1065	IF BACKUP% THEN
	  INDEX% = INDEX% - 1%
	\ IF INDEX% < 0% THEN 1020 ELSE 1060
	! BACK UP PROPERLY.

1070	INDEX% = INDEX% + 1%
	\ GO TO 1060 UNLESS INDEX% >= 7%
	! BRANCH BACK UNTIL PROCESSING COMPLETE.

1073	DIM PARM%(85%)
1080	A$ = CHR$(6%) + CHR$(22%) + CHR$(-1%) + CHR$(0%)
	  + 'ACMAN ' + CHR$(12%) + CHR$(0%)
	  + CHR$(BUF.LEN%) + CHR$(SWAP%(BUF.LEN%))
	  + STRING$(2%, 0%) + CHR$(0%) + STRING$(4%, 0%)
	  + STRING$(20%, 0%)
	\ A$ = SYS(A$)
	! SEND BY LOGNAME.
	! LOGNAME = ACMAN
	! CHANNEL = 12
	! LENGTH = BUF.LEN% = 84%
	! OFFSET = 0
	! SEND THE MESSAGE.

1090	GO TO 1020
	! BRANCH BACK
1092	!---------------------------------------------------------------------!
	!								      !
	!	D A T A   E N T R Y   R O U T I N E S			      !
	!								      !
	!---------------------------------------------------------------------!

1095	!	G E T    P P N
	!	--------------

1100	TEXT$ = 'Enter project-programmer number as: PROJ,PROG'
	\ HELP$ = 'Project number can be: 1 - 254; '
	  + 'Programmer number can be: 0 - 254.'
	\ GOSUB 8000
	\ GO TO 1130 IF BACKUP%
	\ GO TO 1100 IF R$ = ''
	\ A% = INSTR(0%, R$, ",")
	\ IF A% = 0% THEN
	  PRINT TAB(5%); R$ + ' -- Invalid project-programmer number'
	\ GO TO 1100
	! GET A PPN; SEE IF IT IS LEGAL.

1110	PROJ% = ABS(VAL(LEFT(R$, A% - 1%)))
	\ PROG% = ABS(VAL(RIGHT(R$, A% + 1%)))
	\ IF (PROJ% > 254% OR PROJ% < 1% OR PROG% > 254%) THEN
	  PRINT TAB(5%); R$ + ' -- Invalid project-programmer number'
	\ GO TO 1100
	! MAKE SURE IT IS LEGAL.

1120	LSET PPN$ = CHR$(PROG%) + CHR$(PROJ%)
	! SAVE THE PPN.

1130	RETURN





1190	!	G E T    P A S S W O R D
	!	------------------------

1200	TEXT$ = 'Enter password <NONAME>'
	\ HELP$ = 'Password can be 1 - 6 alphanumeric characters.'
	\ GOSUB 8000
	\ GO TO 1220 IF BACKUP%
	\ R$ = 'NONAME' IF R$ = ''
	\ BAD% = 0%
	\ CHANGE R$ TO R%
	\ BAD% = -1% UNLESS (R%(J%) >= 48% AND R%(J%) <= 57%) OR
			    (R%(J%) >= 65% AND R%(J%) <= 90%)
		FOR J% = 1% TO R%(0%)
	\ IF BAD% THEN
	  PRINT TAB(5%); R$ + ' -- Invalid password'
	\ GO TO 1200
	! GET PASSWORD.
	! MAKE SURE IT IS LEGAL.

1210	LSET PASWRD$ = MID(SYS(CHR$(6%) + CHR$(-10%) + LEFT(R$, 6%)), 7%, 4%)
	! SAVE THE PASSWORD.

1220	RETURN





1290	!	G E T    D I S K    D E S I G N A T I O N
	!	-----------------------------------------

1300	TEXT$ = 'Enter disk designation <SY:>'
	\ HELP$ = 'Disks are: '
	\ HELP$ = HELP$ + DISK$(J%) + CHR$(32%) FOR J% = 0% TO DEV.MAX%
	\ GOSUB 8000
	\ GO TO 1320 IF BACKUP%
	\ R$ = 'SY:' IF R$ = ''
	\ BAD% = -1%
	\ BAD% = 0% IF R$ = DISK$(J%) FOR J% = 0% TO DEV.MAX%
	\ IF BAD% THEN
	  PRINT TAB(5%); R$ + ' -- Invalid disk designation'
	\ GO TO 1300
	! GET DISK DESIGNATION.
	! MAKE SURE IT IS IN LIST OF VALID DISKS.

1310	LSET DEV$ = MID(SYS(CHR$(6%) + CHR$(-10%) + R$), 23%, 4%)
	! SAVE DISK DESIGNATION.

1320	RETURN





1390	!	G E T    Q U O T A
	!	------------------

1400	TEXT$ = 'Enter quota <0>'
	\ HELP$ = 'Quota can be 0 - 65535 (0 is unlimited quota)'
	\ GOSUB 8200
	\ GO TO 1420 IF BACKUP%
	\ IF R > 65535. THEN
	  PRINT TAB(5%); R; '-- Illegal quota'
	\ GO TO 1400
	! GET QUOTA.
	! MAKE SURE IT IS LEGAL.

1410	R% = R - 32768.
	\ R% = R% EQV 32767%
	\ LSET QUOTA$ = CHR$(R% AND 255%) + CHR$(SWAP%(R%) AND 255%)
	! SAVE THE QUOTA.

1420	RETURN





1490	!	G E T    C L U S T E R
	!	----------------------

1500	TEXT$ = 'Enter cluster size <0>'
	\ HELP$ = 'Clusters can be: 0, 1, 2, 4, 8, 16 (0 uses disk default)'
	\ GOSUB 8100
	\ GO TO 1520 IF BACKUP%
	\ BAD% = -1%
	\ BAD% = 0% IF R% = [2% ^ J%] FOR J% = 0% TO 4%
	\ BAD% = 0% IF R% = 0%
	\ IF BAD% THEN
	  PRINT TAB(5%); R%; '-- Illegal cluster size'
	\ GO TO 1500
	! GET CLUSTER SIZE.
	! MAKE SURE IT IS LEGAL.

1510	LSET CLUSTR$ = CVT%$(SWAP%(R%))
	! SAVE THE CLUSTER SIZE.

1520	RETURN





1590	!	G E T    A C C O U N T    N A M E
	!	---------------------------------

1600	TEXT$ = 'Enter account name'
	\ HELP$ = 'Name must be <= 32 characters.'
	\ GOSUB 8000
	\ GO TO 1610 IF BACKUP%
	\ LSET DESC$ = CVT$$(R$, 4%)
	\ LSET DEV$ = MID(SYS(CHR$(6%) + CHR$(-10%) + "SY:"), 23%, 4%)
		IF CMD%(OPTION%) = 5%
	! GET ACCOUNT NAME.
	! SAVE IT.
	! ONLY HAS MEANING FOR SYSTEM DISK ACCOUNTS.

1610	RETURN





1690	!	G E T    K E Y B O A R D    N U M B E R
	!	---------------------------------------

1700	TEXT$ = "Enter new console number"
	\ HELP$ = "Enter the number of the keyboard to be the new console."
	\ GOSUB 8100
	\ GO TO 1710 IF BACKUP%
	\ R% = ABS(R%)
	\ LSET RES$ = CHR$(R%)
	\ BAD% = 0%
	\ BAD% = -1% IF R% > [ASCII(MID(SYS(CHR$(6%) + CHR$(-3%)), 3%, 1%)) -1%]
	\ IF BAD% THEN PRINT TAB(5%); R$ + " -- Invalid keyboard number"
	\ GO TO 1700
		! GET KEYBOARD NUMBER.
		! MAKE SURE IT'S NOT HIGHER THAN THERE ARE KEYBOARDS.

1710	RETURN
6990	!---------------------------------------------------------------------!
	!								      !
	!	S U B R O U T I N E S					      !
	!								      !
	!---------------------------------------------------------------------!

7490	!	" H E L P "    S U B R O U T I N E
	!	----------------------------------

7500	OPEN LIBR$ + 'MANAGE.HLP' FOR INPUT AS FILE 4%

7510	INPUT LINE #4% S$
	\ PRINT S$;
	\ GO TO 7510
	! PRINT HELP DOCUMENTATION.

7520	CLOSE 4%
	\ RETURN





7990	!	G E T    R E S P O N S E    S T R I N G
	!	---------------------------------------

8000	PRINT TEXT$;
	\ INPUT LINE R$
	\ A% = ASCII(R$)
	\ R$ = CVT$$(R$, 45%)
	\ BACKUP% = (A% = 27%)
	\ IF (A% = 12% OR A% = 13%) THEN
	  PRINT TAB(5%); 'Type "?" for help.'
	\ GO TO 8000
	! PRINT A PROMPT.
	! GET A RESPONSE.
	! IF NO RESPONSE, TELL THEM HOW TO GET HELP.

8020	PRINT IF BACKUP%
	\ IF A% = 63% THEN
	  PRINT TAB(5%); HELP$
	\ GO TO 8000
	! GIVE THEM HELP IF THEY WANT IT.

8030	RETURN





8090	!	G E T    I N T E G E R    R E S P O N S E
	!	-----------------------------------------

8100	GOSUB 8000
	\ R% = ABS(VAL(R$))
	! GET A RESPONSE & CONVERT TO INTEGER.

8110	RETURN





8190	!	G E T    F L O A T I N G    R E S P O N S E
	!	-------------------------------------------

8200	GOSUB 8000
	\ R = ABS(VAL(R$))
	! GET A RESPONSE & CONVERT TO FLOATING-POINT.

8210	RETURN
8990	!---------------------------------------------------------------------!
	!								      !
	!	E R R O R   H A N D L I N G				      !
	!								      !
	!---------------------------------------------------------------------!

9000	ERR1$ = RIGHT(SYS(CHR$(6%) + CHR$(9%) + CHR$(ERR)), 3%)
	! SET UP ERROR TEXT.

9010	IF ERR = 28% THEN
	  RESUME 32766
	! IF THEY CTRL/C'D THEN GET OUT FAST.

9020	IF ERR = 11% AND (ERL = 8000% OR ERL = 1020%) THEN
	  RESUME 32766
	! THEY CTRL/Z'D ON A RESPONSE, SO THEY WANT OUT.

9030	IF ERR = 11% AND ERL = 7510 THEN
	  RESUME 7520
	! HAVE READ IN ALL OF HELP FILE.

9040	IF ERL = 1080% AND (ERR = 4% OR ERR = 32%) THEN
	  RESUME 1080
	! CAN'T SEND A MESSAGE RIGHT NOW, SO TRY AGAIN.

9050	IF ERL = 1080% AND ERR = 5% THEN
	  PRINT TAB(5%); '?ACMAN not running'
	\ RESUME 32766
	! CAN'T SEND A MESSAGE BECAUSE NOT A RECEIVER.

9060	IF ERL = 8100% THEN
	  PRINT TAB(5%); R$ + ' -- ' + ERR1$ + ' -- Please re-enter...'
	\ RESUME 8100
	! ILLEGAL NUMBER ERRORS.

9070	IF ERL = 8200% THEN
	  PRINT TAB(5%); R$ + ' -- ' + ERR1$ + ' -- Please re-enter...'
	\ RESUME 8100
	! MORE ILLEGAL NUMBER ERRORS.

9080	IF ERL = 7500 THEN
	  PRINT TAB(5%); ERR1$ + ' -- Sorry, no help available.'
	\ RESUME 7520
	! CAN'T ACCESS THE HELP FILE.

9090	IF ERL = 1110% THEN
	  PRINT TAB(5%); R$ + ' -- Invalid project-programmer number'
	\ RESUME 1100
	! RESPONSE WAS NOT A NUMBER.

9100	IF ERL = 1001% THEN
	  A$ = SYS(CHR$(9%))
	! IF ANY ERRORS OCCURRED HERE, THEN THEY SHOULDN'T BE IN HERE.

9900	PRINT TAB(5%); ERR1$ + " at line"; ERL
	\ PRINT TAB(5%); "?Program malfunction at line"; ERL
	\ PRINT
	\ RESUME 32766
		! UNEXPECTED ERRORS.

32766	CLOSE INDEX% FOR INDEX% = 1% TO 12%
	\ A$ = SYS(CHR$(9%))

32767	END
