100!
	P R O G R A M   C O M M E N T S

110!				 FORMAT
			Version 02  -  10-Mar-78

		Author: David Spencer - SBVC

	  Program Description:
	  This program is designed to take a source Basic program and
	return it in a more stylized and beautified format. This is
	accomplished through a two pass process. The first pass creates
	a unique, job-oriented temporary file; and writes to it the input
	file in a crushed format. After the completion of pass one, pass
	two reopens the temporary file and writes to the output file the
	formatted statements.
	  The returned format changes all ":" characters outside of quotes
	and not in remark strings to "\". Multi-statement lines are broken
	down to single logical statement lines. All Multi-statement line
	Programmer Defined Functions, For - Next loops, and Until and
	While loops are indented two spaces. (Nested loops are recognized.)
	All If - Then statements as well as the possible Else statement
	are indented three spaces. All remarks are left unaltered.

	  Limitations:
	  The author recomends that this program not be used on any non-Basic
	program or file; and suggests nonuse if the object program has one
	or more of the following characteristics which could produce
	unsatisfactory results:

	    The object program contains many single line statements;
	    A special coding format is already in use;
	    Extensive remarks are part of the program formatting;
	    The object program is still being coded and/or tested.

	  Also; FORMAT may produce unpredictable results on an
	EXTENDed mode program.


	  Version 1A provides control by the user over the formatting
	of his program. Futhur corrections include proper handling of
	DATA statements. Version 02 provides the option of converting
	Basic Plus keywords to lower case.

	(Look Ma, I'm Structured!)
200!
	I N I T I A L I Z E

210	On Error Goto 30000\
	Dim C$(128%)\
	B%, C%, C1%, D%, E%, F%, G%, I%, N%, P%, Q%, R%, S%, T%, Z%=0%\
	B$=Chr$(9%)\
	C$=Chr$(13%)+Chr$(10%)\
	D$="DATA"\
	F$=Chr$(10%)+Chr$(13%)+Chr$(0%)\
	R$="REM"\
	R1$="\"\
	R2$=":"\
	Print "FORMAT V02 - "+FNE$(0%)+"  "+Date$(0%)+"  "+Time$(0%)+C$\
	Print "File to be formatted <??????.BAS> ";\
	Input line I$\
	I$=Cvt$$(I$,-1%)\
	I$="KB:OUTPUT.OUT" If Len(I$)=0%\
	I$=I$+".BAS" If Instr(1%,I$,".")=0%\
	Print "Output file <";I$;"> ";\
	Input line O$\
	O$=Cvt$$(O$,-1%)\
	O$=I$ If Len(O$)=0%\
	O$=O$+".BAS" If Instr(1%,O$,".")=0%\
	Input 'Change : to \, or \ to : <":" = : to \> ';G$\
	Input "Add blank line on end of every statement <Yes> ";L$\
	Q4%=-1%\
	Q4%=0% If Left(Cvt$$(L$,-1%),1%)="N"\
	! Get I/O files, default delimiters.

220	Input "Indent how much on loops <2> ";Q5%\
	Q5%=2% If Q5%<=0%\
	Input "Change keywords to lower case <No> ";L$\
	C1%=-1% If Left(Cvt$$(L$,-1%),1%)="Y"\
	J%=Ascii(Sys(Chr$(6%)+Chr$(9%)))/2%\
	T=Time(1%)\
	If Left(Cvt$$(G$,-1%),1%)="\" Then 
	   R1$=R2$\
	   R2$="\"
400!
	M A I N   P R O G R A M

500  !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
     !					!
     !  Pass 1, Convert all ":" to "\",	!
     !  Make single statement lines.	!
     !					!
     !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

510	P%=P%+1%\
	Open I$ for input as file P%\
	P$="FRMT"+Num1$(J%)+".WRK"\
	Open P$ For output as file P%+6%\
	Print "Pass"+Num$(P%)
	! Opening files complete, pass 1.

520	Until 1%<>1%\
	  G$, L$=""\
	  While B%<>10% and B%<>12%\
	    Input line #P%,G$\
	    B%=Ascii(Right(G$,Len(G$)))\
	    D%=FNN%(G$)\
	    I$=Right(G$,D%+1%)\
	    F%=FNF%(1%,"!",R$,Cvt$$(I$,32%))\
	    Z$=T$\
	    F%=FNF%(1%,D$,Z$,Cvt$$(I$,32%))\
	    Z$=T$\
	    I%=-1% If F%=1%\
	    G$=Cvt$$(Left(G$,D%),2%)+Cvt$$(Left(I$,F%),16%+256%)
	    +Right(I$,F%+1%) If I%=0%\
	    I%=-1% If FNG%(1%,Z$,Cvt$$(G$,32%))\
	    L$=L$+G$\
	  Next\
	  L$=Left(L$,Len(L$)-2%)+F$+C$ If Len(Cvt$$(G$,-1%)) and Q4%\
	  F%=FNF%(1%,"!",R$,Cvt$$(L$,32%))\
	  Z$=T$\
	  F%=FNF%(1%,D$,Z$,Cvt$$(L$,32%))\
	  Z$=T$\
	  B%=0%
	! Get the entire line, and append LF-CR if needed.

530	  I%=1%\
	  L$=Cvt$$(L$,8%)\
	  While I%\
	    C%=FNI%(1%,Z$,Cvt$$(L$,32%))\
	    I%=FNG%(I%,R2$,L$)\
	    I%=0% If I%>C%\
	    L$=Cvt$$(Left(L$,I%-1%),128%)+R1$+Cvt$$(Right(L$,I%+1%),8%) If I%\
	  Next
	! Change all the valid ":"'s to "\".
 
540	  I%=1%\
	  While I%\
	    C%=FNI%(1%,Z$,Cvt$$(L$,32%))\
	    I%=FNG%(I%,R1$,L$)\
	    I%=0% If I%>C%\
	    If I% Then 
	       L$=Left(L$,FNB%(I%,L$))+R1$+F$+Right(L$,FNP%(I%+1%,L$)+1%)\
	       I%=R%+2%

550	Next\
	I%=FNG%(1%,Z$,Cvt$$(L$,32%))\
	L$=Left(L$,FNB%(I%,L$))+"Data"+F$+Right(L$,FNP%(I%+4%,L$)+1%)
	If I% and Mid(Cvt$$(L$,32%),I%,4%)=D$
	! Add a LF-CR after each valid "\",
	! Add a LF-CR after a valid DATA statement.

560	  I%=1%\
	  While I%\
	    G$=Cvt$$(L$,32%)\
	    C%=FNI%(1%,Z$,G$)\
	    I%=FNG%(I%,"THEN",G$)\
	    I%=0% If I%>C%\
	    T$=Right(L$,FNP%(I%+4%,L$)+1%)\
	    T$=F$+T$ Unless Q3%>47% and Q3%<58%\
	    L$=Left(L$,I%+3%)+" "+T$ Unless I%=0%\
	    I%=I%+1% If I%\
	  Next
	! Bring down the remainder of the valid If - Then statement.

570	  I%=1%\
	  While I%\
	    G$=Cvt$$(L$,32%)\
	    C%=FNI%(1%,Z$,G$)\
	    I%=FNG%(I%,"ELSE",G$)\
	    I%=0% If I%>C%\
	    T$=" "+Right(L$,FNP%(I%+4%,L$)+1%)\
	    T$=F$+Right(T$,2%) Unless Q3%>47% and Q3%<58%\
	    L$=Left(L$,FNB%(I%,L$))+F$+Mid(L$,I%,4%)+T$ Unless I%=0%\
	    I%=I%+1% If I%\
	  Next
	! Bring down the valid Else statement.

590	  Print #P%+6%,L$;\
	  I%=0%\
	Next
	! Print line, clear strings, get another.
600  !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
     !					!
     !  Pass 2, Get pass 1 lines and	!
     !  Indent them properly.		!
     !					!
     !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

610	Close P%, P%+6%\
	P%=P%+1%\
	Open P$ for input as file P%\
	Open O$ for output as file P%+6%\
	Print "Pass"+Num$(P%)
	! Opening files complete, pass 2.

620	Until 1%<>1%\
	  B%, C%, F%, G%, J%, N%, Q%, Q1%, S%, X%=0%\
	  While F%<>10% and F%<>12%\
	    Input line #P%,L$\
	    F%=Ascii(Right(L$,Len(L$)))\
	    G$=Cvt$$(L$,32%)\
	    E%=FNN%(L$)+1%\
	    S%=FNF%(1%,"!",R$,G$)\
	    C%=FNG%(1%,T$,G$)\
	    Q%=-1% If C%=E%\
	    E%=1% If J%
	! Get single line at a time and set up check pointers.

630	    Q1%=Q1%+Q5% If (Mid(G$,E%,3%)="FOR" or Mid(G$,E%,3%)="DEF" and
	    FNG%(E%,"=",G$)=0% or Mid(G$,E%,5%)="UNTIL" or
	    Mid(G$,E%,5%)="WHILE") and Q%=0% and X%=0%\
	    I%=FNG%(E%,"END",G$)\
	    Z%=Z%-Q5% If (I% and I%<S% and Mid(G$,I%-3%,6%)<>"EXTEND"
	    or Mid(G$,E%,4%)="NEXT") and Q%=0% and X%=0%\
	    I%=FNG%(E%,"THEN",G$)\
	    If I% and I%<S% and Q%=0% and X%=0% Then 
	       N%=-1%\
	       G%=G%+3%
	! Indent two on For, Def, Until and While; three on If - Then.

640	    I%=FNG%(E%,"ELSE",G$)\
	    If I% and I%<S% and Q%=0% and X%=0% Then 
	       G%=G%+3%\
	       B%=B%-3% If N%\
	       N%=0%
	! Indent three on the Else.

650	    If X% Then 
	       E%=1%\
	       L$=Cvt$$(L$,8%)
	! If DATA statement was encountered, remove the leading spaces.

660	    I%=FNG%(E%,"DATA",G$)\
	    If I% and I%<S% and Q%=0% and X%=0% Then 
	       X%=-1%\
	       G%=G%+4%
	! Indent four on the DATA statement.

670	    T$=""\
	    T$=B$+Space$(B%+Z%) If Len(Cvt$$(G$,-1%)) and Q%=0%\
	    Print #P%+6%,Left(L$,E%-1%)+T$+Right(L$,E%);\
	    B%=B%+G%\
	    Z%=Z%+Q1%\
	    G%, Q1%=0%\
	    B%, Q%=0% If F%=10% or F%=12%\
	    Q%=-1% If C%\
	    J%=-1%\
	  Next\
	Next
	! Print out the line in new format.
700  !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
     !					!
     !  Do the optional changing to	!
     !  lower case.			!
     !					!
     !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

710	If C1% Then 
	   If Instr(1%,O$,":") Then 
	      Print "?Output was to a device, Pass 3 cannot be performed."
	   Else
	      Close P%, P%+6%\
	      P%=P%+1%\
	      Kill P$\
	      Name O$ as P$\
	      Open P$ for Input as file P%\
	      Open O$ for Output as file P%+6%\
	      Print "Pass"+Num$(P%)\
	      Read J%\
	      Read C$(X%) For X%=0% to J%\
	      Until 1%<>1%\
	        C%, D%, E%, F%, I%, Q%, X%=0%\
	        While F%<>10% and F%<>12%\
	          Input Line #P%, L$\
	          F%=Ascii(Right(L$,Len(L$)))\
	          G$=Cvt$$(L$,32%)\
		  D%=FNN%(L$)+1%\
	          C%=FNF%(1%,"!",R$,G$)\
	          Z$=T$\
	          C%=FNF%(1%,D$,Z$,G$)\
	          Z$=T$\
		  X%=FNG%(1%,Z$,G$)\
	          Q%=-1% If X%=D%\
	          For I%=0% Until I%>J% or Q%\
	            E%=FNG%(1%,Cvt$$(C$(I%),32%),G$)\
	            While E%\
	              L$=Left(L$,E%-1%)+C$(I%)+Right(L$,E%+Len(C$(I%)))
	              Unless C$(I%)=Mid(L$,E%,Len(C$(I%))) or E%>C%\
	              E%=E%+1% If E%\
	              E%=FNG%(E%,Cvt$$(C$(I%),32%),G$)\
	            Next\
	          Next I%\
	          Print #P%+6%, L$;\
		Q%=-1% If X%\
	        Next\
	      Next
	   ! Convert the upper case keywords to lower case.

1000 !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
     !					!
     !  Formatting complete, its	!
     !  quittin' time!			!
     !					!
     !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

1010	Kill P$\
	Print "Formatting complete."\
	T=(Time(1%)-T)/10.\
	If T>=3600. Then 
	   Z%=Int(T/3600.)\
	   T=T-Z%*3600%\
	   Print Num1$(Z%);" Hour";\
	   Print "s"; If Z%<>1%\
	   Print ", ";
	! Calculate hours used.

1020	If T>=60. Then 
	   Z%=Int(T/60.)\
	   T=T-Z%*60%\
	   Print Num1$(Z%);" Minute";\
	   Print "s"; If Z%<>1%\
	   Print ", ";
	! Calculate minutes used.

1030	Print Num1$(T);" Second";\
	Print "s"; If T<>1.\
	Print " of CPU time used."\
	&"Output file was "+O$\
	Goto 32000
	! Print seconds used and,
	! Ride off into the sunset.
10000!
	P R O G R A M M E R   D E F I N E D   F U N C T I O N S

10100	Def FNE$(X%)=Cvt$$(Right(Sys(Chr$(6%)+Chr$(9%)+Chr$(X%)),3%),4%)

10200	Def FNS%(L%,S1$,S2$,T1$)\
	  Z1%=Instr(L%,T1$,S1$)\
	  Z1%=Len(T1$) If Z1%=0%\
	  Z2%=Instr(L%,T1$,S2$)\
	  Z2%=Len(T1$) If Z2%=0%\
	  If Z1%<Z2% and Z1% Then 
	     Z2%=Z1%\
	     S2$=S1$

10210	  FNS%=Z2%\
	  T$=S2$\
	FNend
	! Find the lower position in the target string of the two sub-strings.

10300	Def FNF%(R%,S1$,S2$,L$)\
	  Q2%=FNS%(R%,"'",'"',L$)\
	  Q3%=Instr(Q2%+1%,L$+T$,T$)\
	  R%=FNS%(R%,S1$,S2$,L$)\
	  While Q2%<R% and R%<Q3% or R%>Q2%\
	    R%=Q3% If Q2%<R% and R%<Q3%\
	    Q2%=FNS%(Q3%+1%,"'",'"',L$)\
	    Q3%=Instr(Q2%+1%,L$+T$,T$)\
	    R%=FNS%(R%,S1$,S2$,L$)\
	  Next\
	  FNF%=R%\
	FNend
	! Find the position of a valid string, max if not found.

10400	Def FNG%(R%,S1$,L$)\
	  Q2%=FNS%(R%,"'",'"',L$)\
	  Q3%=Instr(Q2%+1%,L$+T$,T$)\
	  R%=Instr(R%,L$,S1$)\
	  While (Q2%<R% and R%<Q3% or R%>Q2%) and R%\
	    R%=Q3% If Q2%<R% and R%<Q3%\
	    Q2%=FNS%(Q3%+1%,"'",'"',L$)\
	    Q3%=Instr(Q2%+1%,L$+T$,T$)\
	    R%=Instr(R%,L$,S1$)\
	  Next\
	  FNG%=R%\
	FNend
	! Find the position of a valid string, zero if not found

10500	Def FNN%(L$)\
	  Q3%, R%=0%\
	  While Q3%>47% and Q3%<58% or Q3%=32% or Q3%=9% or Q3%=0%\
	    R%=R%+1%\
	    Q3%=Ascii(Right(L$,R%))\
	  Next\
	  FNN%=R%-1%\
	FNend
	! Isolate the line number from rest of statement.

10600	Def FNP%(R1%,L$)\
	  T%=R1%\
	  T%=T%-1%\
	  Q3%=0%\
	  While Q3%=0% or Q3%=9% or Q3%=10% or Q3%=13% or Q3%=32%\
	    T%=T%+1%\
	    Q3%=Ascii(Right(L$,T%))\
	    Q3%=127% If T%>Len(L$)\
	  Next\
	  FNP%=T%-1%\
	FNend
	! Pass over transparent characters.

10700	Def FNB%(R1%,L$)\
	  R%=R1%\
	  Q3%=0%\
	  While Q3%=0% or Q3%=9% or Q3%=10% or Q3%=13% or Q3%=32%\
	    R%=R%-1%\
	    Q3%=Ascii(Right(L$,R%))\
	  Next\
	  FNB%=R%\
	FNend
	! Look back over transparent characters.

10800	Def FNI%(R%,S1$,L$)\
	  Q2%=FNS%(R%,"'",'"',L$)\
	  Q3%=Instr(Q2%+1%,L$+T$,T$)\
	  R%=Instr(R%,L$+S1$,S1$)\
	  While Q2%<R% and R%<Q3% or R%>Q3%\
	    R%=Q3% If Q2%<R% and R%<Q3%\
	    Q2%=FNS%(Q3%+1%,"'",'"',L$)\
	    Q3%=Instr(Q2%+1%,L$+T$,T$)\
	    R%=Instr(R%,L$+S1$,S1$)\
	  Next\
	  FNI%=R%\
	FNend
	! Find the position of a valid string, max if not found.
20000!
	S U B R O U T I N E S

29000!
	D A T A

29100	Data
	    107,
	    "as", "Go", "If", "On", "or", "to", "Un", "Abs", 
	    "and", "Atn", "Chr", "Con", "Cos", "Cvt", "Def", 
	    "Det", "Dif", "Dim", "End", "eqv", "Exp", "Fix",
	    "For", "Get", "Idn", "imp", "Int", "Inv", "Len",
	    "Let", "Log", "Mat", "Mid", "Not", "Num", "Pos",
	    "Put", "Quo", "Rad", "Rnd", "set", "Sgn", "Sin",
	    "Sqr", "sub", "Sum", "Sys", "Tab", "Tan", "til", 
	    "Trn", "Val", "xor", "Zer", "Comp", "Date", 
	    "Else", "File", "Kill", "Left", "less", "Line", 
	    "lock", "Mode", "Name", "Next", "Open", "Peek", 
	    "Prod", "Read", "size", "Step", "Stop", "Swap", 
	    "Then", "Time", "Wait", "Ascii", "Chain", "Close", 
	    "Count", "Error", "Field", "Input", "Instr", "Place", 
	    "Print", "Right", "Scale", "Sleep", "Space", "Using",
	    "While", "Xlate", "Bufsiz", "Change", "Extend", "Output", 
	    "Record", "Resume", "Return", "Status", "String", 
	    "Cluster", "Magtape", "Recount", "Restore", "Randomize" 

30000!
	E R R O R   H A N D L E R

30100	If ERR=2 Then 
	   Print "?Bad output file - "+O$
	! Illegal file name.

30200	If ERR=5 Then 
	   L$=""\
	   L$="?Input file missing"+C$ If ERL=510\
	   L$="?Somebody killed my temporary file - "+P$+C$
	   If ERL=610 or ERL=710 or ERL=1010\
	   Print L$;\
	   P$="KB:"\
	   Resume 1010 If ERL=1010
	! Can't find file or account.

30300	If ERR=8 or ERR=10 Then 
	   Print "?Can't open "+O$
	! Device not available or Protection violation.

30400	If ERR=11 Then 
	   If ERL=210 Then 
	      Resume 32000
	   Else
	      If ERL=520 Then 
	         Resume 600
	      Else
	         If ERL=620 Then 
	            Resume 710
	         Else
	            If ERL=710 Then 
	               Resume 1000
	            Else
	               Print "?Unexpected End-Of-File Error!"
	! If we can't pin down the EOF, die screaming.

30500	If ERR=39 Then 
	   Print "?Please mount magtape"
	! Magtape select error.

30600	If ERR=50 Then
	   Print \
	   Print "%Please enter a number"\
	   Print \
	   Resume
	! Trap data format error.

31990	&FNE$(ERR)+" at line"+Num$(ERL)+"- Fatal."+C$
	! Issue fatal error message.

32000!
	P R O G R A M   E X I T

32010	Close I% For I%=1% to 12%
	! Close everything, regardless of status.

32767	
	E N D !

