5 !	MICROCOMPUTER SIMULATION	VERSION 1.0
10 !
11 !	PROGRAMMED BY C. P. LOCKE
12 !	OGDEN COLLEGE COMPUTER LAB
13 !	WESTERN KENTUCKY UNIVERSITY
14 !	BOWLING GREEN, KY
15 !			42101
16 !
17 !
19 PRINT
20 PRINT TAB(10); "M I C R O C O M P U T E R   S I M U L A T I 0 N"
25 A$=SYS(CHR$(6%)+CHR$(-21%))  ! DROP TEMPORARY PRIVILEGES
30 !
   !	INITIALIZE REGISTER SETUP
   !
31 !	R$ HOLDS REGISTER NAMES...R% THEIR VALUES
32 DIM R$(10%),R%(10%)
33 !	GET REGISTER NAMES
34 READ R$(I%) FOR I%=0% TO 10%
36 DATA "B","C","D","E","H","L","M","A","PC","SP","SR"
37 !	SET UP SYMBOLIC SUBSCRIPTS
38 B%=0% : C%=1% : D%=2% : E%=3% : H%=4% : L%=5% :
   M%=6% : A%=7% : P%=8% : S%=9% : S1%=10%
39 R%(S1%)=2%	!INIT STATUS REGISTER
44 !	OPEN UP MEMORY (32K)
45 OPEN "MEMORY.SIM" AS FILE 2
50 DIM #2,M%(32767)
66 !
70 !	read error messages
72 DIM E$(3%)
74 READ E$(I%) FOR I%=0% TO 3%
76 DATA "*** INVALID HEX CONSTANT ***",
	"*** ILLEGAL HEX ADDRESS ***",
	"*** ILLEGAL FILE NAME ***",
	"*** PROTECTION VIOLATION ***"
80 !	SET UP INSTR INDX TBL AND STAT BIT TBL
85 GOSUB 300
90 !	OPEN UP KB:
95 OPEN "KB:" AS FILE 1
97 !	SET ERROR TRAP AND ^C TRAP
110 ON ERROR GOTO 30000
112 A$=SYS(CHR$(6%)+CHR$(-7%))
114 !	PROMPT USER FOR COMMAND
115 PRINT
120 PRINT "READY" : PRINT
125 !	GET COMMAND STRING
127 WAIT 0
130 INPUT LINE #1,C$
135 !	ELIMINATE LEADING/TRAILING/MULTIPLE BLANKS,TABS,ETC
140 C$=CVT$$(C$,156%)
145 C$=C$+" "
147 !	GET COMMAND
150 C1$=LEFT(C$,INSTR(1%,C$," ")-1) : C$=RIGHT(C$,INSTR(1%,C$," ")+1)
160 !	GET FIELD 1
170 F1$=LEFT(C$,INSTR(1%,C$," ")-1)
175 !	GET FIELD 2
180 F2$=RIGHT(C$,INSTR(1%,C$," ")+1)
181 F2$=CVT$$(F2$,128%)
184	IF C1$="DS"	THEN GOSUB 450	: GOTO 110  !DISPLAY SWS
185	IF C1$="SS"	THEN GOSUB 400  : GOTO 110  !SET SWITCHES
186	IF C1$=""	THEN 130		    !OOPS! SOMEONE HIT <CR>
187	IF C1$="HE"	THEN GOSUB 500  : GOTO 110  !PRINT HELP
188	IF C1$="AC"	THEN GOSUB 700  : GOTO 110  !ALTER COUNTER
190	IF C1$="RE"	THEN GOSUB 1000	: GOTO 110  !RESET
200	IF C1$="DT"	THEN GOSUB 2000	: GOTO 110  !DISABLE TRACE
210	IF C1$="ET"	THEN GOSUB 3000	: GOTO 110  !ENABLE TRACE
220	IF C1$="SP"	THEN GOSUB 4000 : GOTO 110  !SAVE MAIN MEM
230	IF C1$="LP"	THEN GOSUB 5000	: GOTO 110  !LOAD MAIN MEM
240	IF C1$="AR"	THEN GOSUB 6000 : GOTO 110  !ALTER REGISTER
250	IF C1$="AM"	THEN GOSUB 7000	: GOTO 110  !ALTER MAIN MEM
260	IF C1$="DR"	THEN GOSUB 8000	: GOTO 110  !DUMP REGISTERS
270	IF C1$="DM"	THEN GOSUB 9000	: GOTO 110  !DUMP MAIN MEM
280	IF C1$="RU"	THEN GOSUB 10000: GOTO 110  !RUN
285	IF C1$="EX"	THEN 32760		    !EXIT TO RSTS
290	PRINT : PRINT "INVALID COMMAND" : GOTO 110
300 !
    !	THE FOLLOWING SUBROUTINE INITIALIZES THE INSTRUCTION INDEX TABLE
    !	AND THE STATUS BIT TABLE USED BY THE CONDITIONAL RETURNS,JUMPS,
    !	AND CALLS.
301 !
310 DIM T1%(255%),P%(4%)
315 !***PLACE PROPER PPN IN THE FOLLOWING OPEN STMT***!
320 OPEN "MICRO.NDX" AS FILE 5
330 INPUT #5 T1%(I%) FOR I%=0% TO 255%
340 CLOSE 5
350 !
    !	SET UP STATUS BIT TABLE
360 MAT READ P%
370 DATA 6,0,2,7
375 !
    !	SET UP HEX DIGIT TABLE
380	DIM D$(15%)
385	READ D$(I%) FOR I%=0% TO 15%
390	DATA 0,1,2,3,4,5,6,7,8,9,A,B,C,D,E,F
399 RETURN
400 !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
410 !	SET SWITCHES
    !
420	A1%=FNC%(F1$)
425	IF A1%<0% OR A1%>255% THEN PRINT :
			PRINT E$(0%) :
			GOTO 499
430	S9%=A1%
450 !
    !	DISPLAY SWITCHES
    !
455	PRINT : PRINT "        SWITCHES"
460	PRINT : PRINT " 7  6  5  4  3  2  1  0"
465	PRINT (S9%/2**I%) AND 1%; FOR I%=7% TO 0% STEP -1%
470 	PRINT
499 RETURN
500 !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
505 !
510 !	THE FOLLOWING SUBROUTINE WILL PRINT THE ALLOWED COMMANDS
520 !	FOLLOWED BY A SHORT DESCRIPTION OF THEIR FUNCTIONS.
530 !
532 ON ERROR GOTO 600
535 PRINT
538 PRINT TAB(20%);"SIMULATOR COMMANDS"
540 PRINT
550 OPEN "MICRO.HLP" AS FILE 3
560 INPUT #3,B$
565 PRINT #1,B$
570 GOTO 560
600 IF ERR<>11 THEN ON ERROR GOTO 0
610 CLOSE 3
699 RETURN
700 !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
705 !
710 !	THE FOLLOWING SUBROUTINE WILL SET THE CYCLE
720 !	COUNTER TO THE DECIMAL VALUE IN F1$.
730 !
740 ON ERROR GOTO 780
750 A1%=VAL(F1$)
755 PRINT : PRINT "OLD CYCLES: ";T0%
758 !	SET TIMER
760 T0%=A1%
765 PRINT "NEW CYCLES: ";T0%
770 GOTO 799
772 !
774 !	ERROR SECTION
776 !
780 IF ERR=52 THEN PRINT : PRINT "*** INVALID DECIMAL CONSTANT ***" :
	RESUME 799
785 IF ERR=28 THEN RESUME 799
790 ON ERROR GOTO 0
799 RETURN
1000 !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
1005 !
1010 !	THE FOLLOWING SUBROUTINE WILL RESET THE SYSTEM
1020 !	BY PERFORMING THE FOLLOWING ASSIGNMENTS:
1030 !
1040 R%(P%)=0%		!RESET THE PC
1070 T0%=0%		!RESET THE CYCLE COUNTER
1080 PRINT : PRINT "   SYSTEM HAS BEEN RESET"
1999 RETURN
2000 !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
2005 !
2010 !	THE FOLLOWING SUBROUTINE WILL DISABLE THE REGISTER
2020 !	TRACE FEATURE.
2025 !
2030	T%=0%		! RESET THE TRACE SWITCH
2035	PRINT
2040	PRINT "REGISTER TRACE DISABLED."
2060 RETURN
3000 !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
3005 !
3010 !	THE FOLLOWING SUBROUTINE WILL ENABLE THE REGISTER
3020 !	TRACE FEATURE.
3030 !
3040	T%=-1%		! SET THE TRACE SWITCH
3045	PRINT
3050 	PRINT "REGISTER TRACE ENABLED."
3060 RETURN
4000 !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
4005 !
4010 !	THE FOLLOWING SUBROUTINE WILL OUTPUT A SECTION OF MEMORY
4015 !	IN THE INTEL STANDARD PAPER TAPE FORMAT.
4020 !
4030	ON ERROR GOTO 4800
4035	IF F1$="" OR F2$="" THEN PRINT : PRINT E$(1%) : GOTO 4999
4040	F1%=FNC%(F1$) : F2%=FNC%(F2$)
4050	IF F1%<0% OR F2%<0% OR F1%>F2% THEN PRINT :
		PRINT E$(1%) :
		GOTO 4999
4060 !
4070	PRINT : PRINT "ENTER FILE NAME:"; : INPUT LINE #1,N9$ :
		N9$=CVT$$(N9$,6%)
4080	OPEN N9$ AS FILE 3
4090	PRINT : PRINT "SAVING ";N9$;"..."
4100 !	SAVE IT!
4102	B9%=28% : B9$=FNC$(B9%,2%)	!# OF BYTES/LINE OUTPUT
4105	T9%=F2%-F1%+1%	!GET BYTE COUNT
4110	FOR I%=F1% TO F2% STEP B9%
4115		C9%=(I% AND 255%) + (SWAP%(I%) AND 255%)
4120		S$=FNC$(I%,4%)+"00"
4130		FOR J%=0% TO B9%-1%
4140			IF I%+J%>F2% THEN 4185
4145			C9%=C9%+(M%(I%+J%) AND 255%)
4150			S$=S$+FNC$(M%(I%+J%),2%)
4160		NEXT J%
4165		C9%=(256%-(C9%+B9%)) AND 255%
4170		PRINT #3,":"+B9$+S$+FNC$(C9%,2%)
4180	NEXT I%
4181	GOTO 4195
4185	C9%=(256%-(C9%+J%)) AND 255%
4190	PRINT #3,":"+FNC$(J%,2%)+S$+FNC$(C9%,2%)
4195	PRINT #3,":0000000000"
4197	PRINT : PRINT T9%;"BYTES SAVED IN ";N9$
4200 GOTO 4990
4800 IF ERR<>28 THEN 4850
4810	PRINT : PRINT "*** SAVE ABORTED ***"
4820	RESUME 4990
4850 IF ERR=2 OR ERR=6 THEN PRINT : PRINT E$(2%) :
		RESUME 4990
4860 IF ERR=10 THEN PRINT : PRINT E$(3%) :
		RESUME 4999
4990 CLOSE 3
4999 RETURN
5000 !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
5005 !
5010 !  THE FOLLOWING SUBROUTINE WILL LOAD MAIN MEMORY FROM
5020 !  A DISK FILE SPECIFIED BY THE USER.
5022 !
5024 ON ERROR GOTO 5800
5025 I8%=1%
5026 !	CHECK FOR FILE NAME IN COMMAND STRING
5030 IF F1$<>"" THEN N$=F1$ : GOTO 5090
5035 !	DIDN'T FIND IT, SO ASK FOR IT
5040 PRINT : PRINT "ENTER FILE NAME: ";
5050 INPUT LINE #1,N$ : N$=CVT$$(N$,-1)
5085 !	OPEN UP FILE TO BE LOADED
5090 OPEN N$ FOR INPUT AS FILE #3
5102 !	TELL USER WHAT WE'RE DOING
5105 PRINT : PRINT"LOADING ";N$;"..."
5107 !	LOAD IT!
5108	T9%=0%		!ZERO BYTE COUNT
5110	C$=FNB$
5111	ON I8% GO TO 5112,5700,5160
5112	IF C$<>":" THEN 5110
5114	!
5116	L%=FNH%*16%+FNH%
5118 IF L%=0% OR I8%=3% THEN 5160
5119	T9%=T9%+L%	!INCREASE BYTE COUNT
5120	A7%=SWAP%(FNH%*16%+FNH%) + FNH%*16% + FNH%
5122 I%=FNH% : I%=FNH%
5124	FOR I%=A7% TO A7%+L%-1%
5126	M%(I%)=FNH%*16%+FNH%
5128	NEXT I%
5129	ON I8% GO TO 5130,5700,5160
5130	GOTO 5110
5132 !
5133 ! FUNCTION TO INPUT A LINE FROM HEX FILE AND RETURN A CHAR.
5134 DEF FNB$
5136	IF LEN(B$)=0% THEN INPUT LINE #3,B$
5138	FNB$=LEFT(B$,1%)
5140	B$=RIGHT(B$,2%)
5142 FNEND
5143 ! FUNCTION TO CONVERT AN ASCII HEX CHAR TO IT'S REAL VAL.
5144 DEF FNH%
5145	IF I8%=3% THEN GOTO 5154
5146	C$=FNB$
5148	L1%=(ASCII(C$) AND 127%)-48%
5150	IF L1%>10% THEN L1%=L1%-7%
5152	FNH%=L1%
5154 FNEND
5160 !	PRINT LOAD COMPLETE MESSAGE
5170	PRINT : PRINT T9%;"BYTES LOADED FROM ";N$
5180 GO TO 5999
5190 !
5200 !	ERROR SECTION
5210 !
5700 PRINT : PRINT "*** LOAD ABORTED ***" : GOTO 5999
5790 !	USER HIT ^C, SO ABORT OPERATION
5800 IF ERR=28 THEN I8%=2% : A$=SYS(CHR$(6%)+CHR$(-7%)) : RESUME
5805 IF ERR=11 AND ERL=5050 THEN RESUME 5999
5807 IF ERR=11 THEN I8%=3% : RESUME 5142
5810 IF ERR=5 THEN PRINT : PRINT "*** CAN'T FIND FILE '";N$;"' ***" 
		: RESUME 5999
5820 IF ERR=2 OR ERR=6 THEN PRINT : PRINT E$(2%) 
		: RESUME 5999
5830 ON ERROR GOTO 0
5840 !
5999 CLOSE 3 : RETURN
6000 !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
6005 !
6010 !  THE FOLLOWINT SUBROUTINE WILL PLACE THE SYMBOLIC
6020 !  HEX VALUE IN F2$ INTO THE REGISTER WHOSE NAME
6030 !	IS IN F1$
6040 !
6050 ON ERROR GOTO 6710
6090 !	GET HEX NUMBER FROM FIELD 2 AND CHECK FOR
6095 !	VALIDITY WHILE CONVERTING TO DECIMAL
6100 A2%=FNC%(F2$)
6110 IF A2%<0% THEN 6800
6115 !	SEARCH FOR REGISTER SPECIFIED IN FIELD 1
6120 FOR I%=0% TO 10%
6130    IF R$(I%)=F1$ THEN 6170
6140 NEXT I%
6145 !	WE DIDN'T FIND IT, SO GO TO TELL USER
6150 GOTO 6820
6160 !
6165 !	CHECK TO BE SURE THAT THE HEX NUMBER
6166 !	WILL FIT INTO THE SPECIFIED REGISTER
6170 IF I%<>P% AND I%<>S% AND A2%>255% THEN 6800
6180 IF I%=S1% AND A2%>255% THEN 6800
6182 !	SET L1% TO # OF HEX DIGITS IN REGISTER
6185 IF I%=P% OR I%=S% THEN L1%=4%
	ELSE L1%=2%
6190 PRINT : PRINT "OLD ";R$(I%);": ";FNC$(R%(I%),L1%)
6195 !	ALTER SPECIFIED REGISTER
6197 IF I%=S1% THEN A2%=(A2% AND 213%) OR 2%
6200 R%(I%)=A2%
6205 PRINT "NEW ";R$(I%);": ";FNC$(R%(I%),L1%)
6210 GOTO 6999
6220 !
6680 !	ERROR SECTION
6690 !
6700 !	CHECK FOR ^C FROM USER
6710 IF ERR=28 THEN RESUME 6999
6720 ON ERROR GOTO 0
6730 !
6800 PRINT : PRINT E$(0%)
6810 GOTO 6999
6820 PRINT : PRINT "*** INVALID REGISTER SPECIFICATION ***"
6999 RETURN
7000 !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
7005 !
7010 !	THE FOLLOWING SUBROUTINE WILL STORE THE SYMBOLIC
7020 !	HEX VALUE IN F2$ IN THE MEMORY LOCATION ADDRESSED 
7030 !	BY THE SYMBOLIC HEX VALUE IN F1$.
7040 !
7045 !	CONVERT FIELDS TO DECIMAL
7050 A1%=FNC%(F1$)
7060 A2%=FNC%(F2$)
7065 !	MAKE SURE NUMBERS WERE LEGAL
7070 IF A1%<0 THEN 7800
7080 IF A2%>255 OR A2%<0 THEN 7810
7085 PRINT
7090 PRINT "OLD ";FNC$(A1%,4%);": ";FNC$(M%(A1%),2%)
7092 !	CHANGE MEMORY
7095 M%(A1%)=A2%
7100 PRINT "NEW ";FNC$(A1%,4%);": ";FNC$(M%(A1%),2%)
7110 GOTO 7999
7700 !
7710 !	ERROR SECTION
7730 !
7800 PRINT : PRINT E$(1%)
7805 GO TO 7999
7810 PRINT : PRINT E$(0%)
7999 RETURN
8000 !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
8005 !
8010 !	THE FOLLOWING SUBROUTINE WILL DUMP THE CONTENTS
8020 !	OF THE B,C,D,E,H,L AND A REGISTERS, THE PC AND SP,
8030 !	AND THE STATUS FLAGS (C,Z,S AND P).
8035 !
8040 PRINT
8045 PRINT TAB(12%);"REGISTER DUMP"
8046 !	PRINT  ELAPSED MACHINE CYCLES
8047 PRINT : PRINT TAB(12%);"CYCLES:";T0%
8050 PRINT
8055 !	PRINT REGISTER NAMES FOR FIRST ROW
8060 PRINT TAB(I%*6%+3%);R$(I%);FOR I%=0% TO5%
8070 PRINT 
8075 !	PRINT CONTENTS OF 'FIRST ROW REGS' (B,C,D,E,H,L)
8080 PRINT TAB(I%*6%+2%);FNC$(R%(I%),2%); FOR I%=0% TO 5%
8090 PRINT
8100 PRINT
8105 !	PRINT REGISTER AND FLAG NAMES FOR SECOND ROW
8110 PRINT "   A   PC     SP    AC  P  S  C  Z"
8115 !	PRINT CONTENTS OF A,PC,SP
8120 PRINT TAB(2%);FNC$(R%(A%),2%);
8130 PRINT TAB(6%);FNC$(R%(P%),4%);
8140 PRINT TAB(13%);FNC$(R%(S%),4%);
8145 !	PRINT STATUS FLAGS
8147 I%=R%(S1%)
8150 PRINT TAB(21%);CVT$$(NUM$(I%/16% AND 1%),136%);
8160 PRINT TAB(24%);CVT$$(NUM$(I%/4% AND 1%),136%);
8170 PRINT TAB(27%);CVT$$(NUM$(I%/128% AND 1%),136%);
8180 PRINT TAB(30%);CVT$$(NUM$(I% AND 1%),136%);
8190 PRINT TAB(33%);CVT$$(NUM$(I%/64% AND 1%),136%);
8980 PRINT
8999 RETURN
9000 !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
9005 !
9010 !	THE FOLLOWING SUBROUTINE PERFORMS A MAIN MEMORY DUMP
9020 !	FROM THE SYMBOLIC HEX ADDRESS IN F1$ TO THE SYMBOLIC
9030 !	HEX ADDRESS IN F2$
9040 !
9058 !	CONVERT FIELDS TO DECIMAL
9060 A1%=FNC%(F1$) : A2%=FNC%(F2$)
9065 !	CHECK FOR PROPER RANGE
9070 IF A1% < 0% OR A2% < A1% THEN 9800
9073 !	PRINT HEADER
9075 PRINT : PRINT TAB(23%);"MEMORY DUMP"
9076 !	PRINT TOP ROW OF DUMP (COLUMN HEADERS)
9077 PRINT : PRINT " ADDR"; : PRINT TAB(I%*3%+8%);D$(I%); FOR I%=0% TO 15% 
9079 !	ROUND START ADDR DOWN TO NEAREST MULT OF 16
	ROUND END ADDR UP
9080 A1%=INT(A1%/16%)*16% : A2%=INT(A2%/16%)*16%
9085 !	PRINT THE CONTENTS OF MEMORY WITHIN THE
9086 !	SPECIFIED BOUNDS
9090 FOR I%=A1% TO A2% STEP 16%
9100	PRINT : PRINT " "; FNC$(I%,4%);"   ";
9110	FOR J%=I% TO I%+15% STEP 1%
9120		PRINT FNC$(M%(J%),2%);" ";
9125		IF J%=32767% THEN GO TO 9150
9130	NEXT J%
9140 NEXT I%
9150 PRINT
9180 RETURN
9700 !
9710 !	ERROR SECTION
9720 !
9800 PRINT : PRINT E$(1%)
9999 RETURN
10000 !
      !	 THE FOLLOWING SUBROUTINE BEGINS EXECUTING 8080 INSTRUCTIONS
      !	 AT THE LOCATION IN THE PROGRAM COUNTER OR AT THE LOCATION
10002 !	 SPECIFIED IN THE RUN COMMAND.  IT WILL RUN UNTIL 1) AN INVALID
      !	 OPCODE IS ENCOUNTERED, 2) A HLT INSTRUCTION IS ENCOUNTERED, OR
      !	 3) THE USER TYPES A ^C.
10004 !
10005 !
10010 ON ERROR GOTO 19000
10015	OPEN "KB:" AS FILE 5
10017	FIELD #5,80% AS N$
10020	IF F1$="" THEN 10100
10030	A1%=FNC%(F1$)
10035 !
10040 IF A1%<0% THEN PRINT : PRINT E$(1%) :
	GOTO 19999
10050 R%(P%)=A1% 
10060 !	SET NO ECHO ON CHAN 5
10065	A$=SYS(CHR$(3%)+CHR$(5%))
10090 !
      !
10100 !	IF TRACE SWITCH IS ON THEN DUMP REGISTERS
10102	IF T% THEN GOSUB 8047
10106 !	FETCH INSTRUCTION
10110	I1%=M%(R%(P%)) : R%(P%)=R%(P%)+1%
10120 !	GET INSTRUCTION INDEX
10130	I%=T1%(I1%)
10140 !	GET LOW ORDER GROUP NUMBER
10142	G1%=(I% AND 7%)+1%
10144	ON (I% AND 120%)/8%+1% GOTO 10150,10155,10160,10165,10170,10175,
					10180,10185,10190,10195
10148 !
10150 ON G1% GOTO 10200,10300,10400,10500,10600,10700,10800,10900
10155 ON G1% GOTO 11000,11100,11200,11300,11400,11500,11600,11700
10160 ON G1% GOTO 11800,11900,12000,12100,12200,12300,12400,12500
10165 ON G1% GOTO 12600,12700,12800,12900,13000,13100,13200,13300
10170 ON G1% GOTO 13400,13500,13600,13700,13800,13900,14000,14100
10175 ON G1% GOTO 14200,13500,14400,13700,13900,14700,14800,13500
10180 ON G1% GOTO 13700,15100,13900,15300,13500,13700,15600,13900
10185 ON G1% GOTO 15800,13500,13700,16100,13900,16300,13500,16500
10190 ON G1% GOTO 13700,16700,13900,16900,13500,13700,17200,13900
10195 ON G1% GOTO 17400,13500,17600,13700,17800,13900,18000
10198 !
10200 !		INVALID OP-CODE
10210 PRINT : PRINT "*** INVALID OPCODE  ***"
10220 PRINT : PRINT "PC:";FNC$(R%(P%)-1%,4%);"  OPCD:";FNC$(I1%,2%)
10299 GOTO 19999
10300 !	NOP
10302	T0%=T0%+4%
10399 GOTO 10100
10400 !	LXI
10402	T0%=T0%+10%
10404	P1%=M%(R%(P%)) : R%(P%)=R%(P%)+1%
10406	P2%=M%(R%(P%)) : R%(P%)=R%(P%)+1%
10408	F1%=(I1% AND 48%)/8%
10410	IF F1%=M% THEN R%(S%)=SWAP%(P2%)+P1% : GOTO 10100
10412	R%(F1%)=P2% : R%(F1%+1%)=P1%
10499 GOTO 10100
10500 !	STAX
10502	T0%=T0%+7%
10510	F1%=(I1% AND 16%)/8%
10512	M%(SWAP%(R%(F1%))+R%(F1%+1%))=R%(A%)
10599 GOTO 10100
10600 !	INX
10602	T0%=T0%+5%
10610	F1%=(I1% AND 48%)/16%*2%
10612	IF F1%=M% THEN R%(S%)=R%(S%)+1% : GOTO 10100
10614	F2%=F1%+1%
10616	R%(F2%)=R%(F2%)+1%
10618	IF R%(F2%)<=255% THEN 10100
10620	R%(F2%)=R%(F2%) AND 255%
10622	R%(F1%)=R%(F1%)+1% AND 255%
10699 GOTO 10100
10700 !	INR
10702	T0%=T0%+5%
10710	F1%=(I1% AND 56%)/8%
10712	IF F1%=M% THEN R%(M%)=M%(SWAP%(R%(H%)) OR
					R%(L%)) :
					T0%=T0%+5%
10714	C1%=((R%(F1%) AND 15%)+1%)/16%
10716	R%(F1%)=R%(F1%)+1% AND 255%
10718	R%(S1%)=(R%(S1%) AND 1%) OR FNR%(F1%,C1%)
10720	IF F1%=M% THEN M%(SWAP%(R%(H%)) OR
				R%(L%))=R%(M%)
10799 GOTO 10100
10800 !	DCR
10802	T0%=T0%+5%
10810	F1%=(I1% AND 56%)/8%
10812	IF F1%=M% THEN R%(M%)=M%(SWAP%(R%(H%)) OR
					R%(L%)) :
					T0%=T0%+5%
10814	C1%=(((R%(F1%) AND 15%)-1%) AND 16%)/16%
10816	R%(F1%)=R%(F1%)-1% AND 255%
10818	R%(S1%)=(R%(S1%) AND 1%) OR FNR%(F1%,C1%)
10820	IF F1%=M% THEN M%(SWAP%(R%(H%)) OR
			R%(L%)) = R%(M%)
10899 GOTO 10100
10900 !	MVI
10902	T0%=T0%+7%
10910	F1%=(I1% AND 56%)/8%
10912	R%(F1%)=M%(R%(P%)) : R%(P%)=R%(P%)+1%
10914	IF F1%=M% THEN M%(SWAP%(R%(H%)) OR R%(L%))=
			R%(F1%) : T0%=T0%+3%
10999 GOTO 10100
11000 !	RLC
11002	T0%=T0%+4%
11010	C1%=(R%(A%) AND 128%)/128%
11012	R%(A%)=(R%(A%)*2% OR C1%) AND 255%
11014	R%(S1%)=FNS%(0%,C1%)
11099 GOTO 10100
11100 !	DAD
11102	T0%=T0%+10%
11108	C0%=0%
11110	F1%=(I1% AND 48%)/16%
11112	F2%=F1%+1%
11114	R%(L%)=R%(L%)+R%(F2%)
11116	IF R%(L%)>255% THEN R%(L%)=R%(L%) AND 255% : C0%=1%
11118	R%(H%)=R%(H%)+R%(F1%)+C0%
11120	C0%=(R%(H%) AND 256%)/256%
11122	IF R%(H%)>255% THEN R%(H%)=R%(H%) AND 255%
11124	R%(S1%)=FNS%(0%,C0%)
11199 GOTO 10100
11200 !	LDAX
11202	T0%=T0%+7%
11210	F1%=(I1% AND 16%)/8%
11212	R%(L%)=M%(A0%)
11299 GOTO 10100
11300 !	DCX
11302	T0%=T0%+5%
11310	F1%=(I1% AND 48%)/8%
11312	F2%=F1%+1%
11314	IF F1%=M% THEN R%(S%)=R%(S%)-1% : GOTO 10100
11316	R%(F2%)=R%(F2%)-1%
11318	IF R%(F2%)>=0% THEN GOTO 10100
11320	R%(F2%)=R%(F2%) AND 255%
11322	R%(F1%)=R%(F1%)-1% AND 255%
11399 GOTO 10100
11400 !	RRC
11402	T0%=T0%+4%
11410	C1%=R%(A%) AND 1%
11412	R%(A%)=R%(A%)/2% OR C1%*128%
11414	R%(S1%)=FNS%(0%,C1%)
11499 GOTO 10100
11500 !	RAL
11502	T0%=T0%+4%
11510	C1%=(R%(A%) AND 128%)/128%
11512	R%(A%)=(R%(A%)*2% OR FNP%(0%)) AND 255%
11514	R%(S1%)=FNS%(0%,C1%)
11599 GOTO 10100
11600 !	RAR
11602	T0%=T0%+4%
11610	C1%=R%(A%) AND 1%
11612	R%(A%)=R%(A%)/2% OR FNP%(0%)*128%
11614	R%(S1%)=FNS%(0%,C1%)
11699 GOTO 10100
11700 !	SHLD
11702	T0%=T0%+16%
11710	A0%=SWAP%(M%(R%(P%)+1%))+M%(R%(P%)) : R%(P%)=R%(P%)+2%
11712	M%(A0%)=R%(L%)
11714	M%(A0%+1%)=R%(H%)
11799 GOTO 10100
11800 !	DAA
11802	T0%=T0%+4%
11810	IF(R%(A%) AND 15%)>9% OR FNP%(4%) THEN
		C1%=((R%(A%) AND 15%)+6% AND 16%)/16% :
		R%(A%)=R%(A%)+6% : R%(S1%)=FNR%(A%,C1%)
11812	IF (R%(A%) AND 240%)/16%>9% OR FNP%(0%) THEN
		R%(A%)=R%(A%)+96% : R%(S1%)=FNR%(A%,-1%)
11899 GOTO 10100
11900 !	LHLD
11902	T0%=T0%+16%
11910	A0%=SWAP%(M%(R%(P%)+1%))+M%(R%(P%)) : R%(P%)=R%(P%)+2%
11912	R%(L%)=M%(A0%)
11914	R%(H%)=M%(A0%+1%)
11999 GOTO 10100
12000 !	CMA
12002	T0%=T0%+4%
12010	R%(A%)=NOT R%(A%) AND 255%
12099 GOTO 10100
12100 !	STA
12102	T0%=T0%+13%
12110	A0%=SWAP%(M%(R%(P%)+1%))+M%(R%(P%)) : R%(P%)=R%(P%)+2%
12112	M%(A0%)=R%(A%)
12199 GOTO 10100
12200 !	STC
12202	T0%=T0%+4%
12210	R%(S1%)=(R%(S1%) AND 254%) OR 1%
12299 GOTO 10100
12300 !	LDA
12302	T0%=T0%+13%
12310	A0%=SWAP%(M%(R%(P%)+1%))+M%(R%(P%)) : R%(P%)=R%(P%)+2%
12312	R%(A%)=M%(A0%)
12399 GOTO 10100
12400 !	CMC
12402	T0%=T0%+4%
12410	R%(S1%)=R%(S1%) XOR 1%
12499 GOTO 10100
12500 !	MOV
12502	T0%=T0%+5%
12510	F1%=(I1% AND 56%)/8%
12512	F2%=I1% AND 7%
12514	IF F2%=M% THEN R%(M%)=M%(SWAP%(R%(H%))+R%(L%)) : 
			T0%=T0%+2%
12516	R%(F1%)=R%(F2%)
12518	IF F1%=M% THEN M%(SWAP%(R%(H%))+R%(L%))=R%(M%) :
			T0%=T0%+2%
12599 GOTO 10100
12600 !	HLT
12602	T0%=T0%+7%
12610	PRINT : PRINT "HALT AT ";FNC$(R%(P%)-1%,4%);"."
12699 GOTO 19999
12700 !	ADD
12702 T0%=T0%+4%
12708	C0%=0%
12710	F1%=I1% AND 7%
12712	IF F1%=M% THEN R%(M%)=M%(SWAP%(R%(H%)) OR
			R%(L%)) : T0%=T0%+3%
12714	C1%=(((R%(A%) AND 15%) + (R%(F1%) AND 15%) + C0%) AND 16%)/16%
12716	R%(A%)=R%(A%)+R%(F1%)+C0%
12718	R%(S1%)=FNR%(A%,C1%)
12799 GOTO 10100
12800 !	ADC
12802	T0%=T0%+4%
12810	C0%=FNP%(0%)
12899 GOTO 12710
12900 !	SUB
12902	T0%=T0%+4%
12908	B0%=0%
12910	F1%=I1% AND 7%
12912	IF F1%=M% THEN R%(M%)=M%((SWAP%(R%(H%)) AND 255%) OR 
			(R%(L%) AND 255%)) : T0%=T0%+3%
12914	C1%=(((R%(A%) AND 15%) - (R%(F1%) AND 15%) -B0%) AND 16%)/16%
12916	R%(A%)=R%(A%)-R%(F1%)-B0%
12918	R%(S1%)=FNR%(A%,C1%)
12999 GOTO 10100
13000 !	SBB
13002	T0%=T0%+4%
13010	B0%=FNP%(0%)
13099 GOTO 12910
13100 !	ANA
13102	T0%=T0%+4%
13110	F1%=I1% AND 7%
13112	IF F1%=M% THEN R%(M%)=M%(SWAP%(R%(H%)) OR
			R%(L%)) : T0%=T0%+3%
13114	R%(A%)=R%(A%) AND R%(F1%)
13116	R%(S1%)=FNR%(A%,-1%)
13199 GOTO 10100
13200 !	XRA
13202	T0%=T0%+4%
13210	F1%=I1% AND 7%
13212	IF F1%=M% THEN R%(M%)=M%(SWAP%(R%(H%) AND 255%) OR
			R%(L%) AND 255%) : T0%=T0%+3%
13214	R%(A%)=R%(A%) XOR R%(F1%)
13216	R%(S1%)=FNR%(A%,-1%)
13299 GOTO 10100
13300 !	ORA
13302	T0%=T0%+5%
13310	F1%=I1% AND 7%
13312	IF F1%=M% THEN R%(M%)=M%(SWAP%(R%(H%) AND 255%) OR
			R%(L%) AND 255%) : T0%=T0%+3%
13314	R%(A%)=(R%(A%) OR R%(F1%)) AND 255%
13316	R%(S1%)=FNR%(A%,0%)
13399 GOTO 10100
13400 !	CMP
13402	T0%=T0%+4%
13410	F1%=I1% AND 7%
13412	IF F1%=M% THEN R%(M%)=M%(SWAP%(R%(H%) AND 255%) OR
			R%(L%) AND 255%) : T0%=T0%+3%
13414	IF R%(A%)=R%(F1%) THEN R%(S1%)=FNS%(6%,1%) :
				R%(S1%)=FNS%(0%,0%) :
				GOTO 13420
13416	IF R%(A%)<R%(F1%) THEN R%(S1%)=FNS%(6%,0%) :
				R%(S1%)=FNS%(0%,1%) :
				GOTO 13420
13418	R%(S1%)=FNS%(6%,0%) : R%(S1%)=FNS%(0%,0%)
13420	!
13499 GOTO 10100
13500 !	RNZ,RZ,RNC,RC,RPO,RPE,RP,RM
13510	F1%=(I1% AND 48%)/16%+1%
13512	F2%=(I1% AND 8%)/8%
13514	IF F2%=FNP%(P%(F1%)) THEN T0%=T0%+1% : GOTO 14400
13516	T0%=T0%+5%
13599 GOTO 10100
13600 !	POP
13602	T0%=T0%+10%
13610	F1%=(I1% AND 48%)/8%
13612	IF F1%=M% THEN 13622
13614	R%(F1%+1%)=M%(R%(S%)) : R%(S%)=R%(S%)+1%
13616	R%(F1%)=M%(R%(S%)) : R%(S%)=R%(S%)+1%
13618	GOTO 10100
13620	!
13622	R%(S1%)=M%(R%(S%)) : R%(S%)=R%(S%)+1%
13624	R%(A%)=M%(R%(S%)) : R%(S%)=R%(S%)+1%
13699 GOTO 10100
13700 !	JNZ,JZ,JNC,JC,JPO,JPE,JP,JM
13710	F1%=(I1% AND 48%)/16%+1%
13712	F2%=(I1% AND 8%)/8%
13714	IF F2%=FNP%(P%(F1%)) THEN GOTO 13800
13716	T0%=T0%+10%
13718	R%(P%)=R%(P%)+2%
13799 GOTO 10100
13800 !	JMP
13802	T0%=T0%+10%
13810	R%(P%)=SWAP%(M%(R%(P%)+1%))+M%(R%(P%))
13899 GOTO 10100
13900 !	CNZ,CZ,CNC,CC,CPO,CPE,CP,CM
13910	F1%=(I1% AND 48%)/16%+1%
13912	F2%=(I1% AND 8%)/8%
13914	IF F2%=FNP%(P%(F1%)) THEN GOTO 14700
13916	R%(P%)=R%(P%)+2%
13918	T0%=T0%+11%
13999 GOTO 10100
14000 !	PUSH
14002	T0%=T0%+11%
14010	F1%=(I1% AND 48%)/8%
14012	IF F1%=M% THEN 14022
14014	R%(S%)=R%(S%)-1% : M%(R%(S%))=R%(F1%)
14016	R%(S%)=R%(S%)-1% : M%(R%(S%))=R%(F1%+1%)
14018	GOTO 10100
14020	!
14022	R%(S%)=R%(S%)-1% : M%(R%(S%))=R%(A%)
14024	R%(S%)=R%(S%)-1% : M%(R%(S%))=R%(S1%)
14099 GOTO 10100
14100 !	ADI
14102	T0%=T0%+7%
14110	C0%=0%
14112	F1%=6%
14114	R%(M%)=M%(R%(P%)) : R%(P%)=R%(P%)+1%
14199 GOTO 12714
14200 !	RST
14202	T0%=T0%+11%
14210	R%(S%)=R%(S%)-1% : M%(R%(S%))=SWAP%(R%(P%)) AND 255%
14212	R%(S%)=R%(S%)-1% : M%(R%(S%))=R%(P%) AND 255%
14218	R%(P%)=I1% AND 56%
14299 GOTO 10100
14400 !	RET
14402	T0%=T0%+10%
14410	R%(P%)=SWAP%(M%(R%(S%)+1%))+M%(R%(S%))
14412	R%(S%)=R%(S%)+2%
14499 GOTO 10100
14700 ! CALL
14702	T0%=T0%+17%
14710	M%(R%(S%)-1%)=SWAP%(R%(P%)+2%) AND 255%
14712	M%(R%(S%)-2%)=R%(P%)+2% AND 255%
14714	R%(S%)=R%(S%)-2%
14716	R%(P%)=SWAP%(M%(R%(P%)+1%))+M%(R%(P%))
14799 GOTO 10100
14800 !	ACI
14802	T0%=T0%+7%
14810	C0%=FNP%(0%)
14899 GOTO 14112
15100 !	OUT
15102	T0%=T0%+10%
15110	P1%=M%(R%(P%)) : R%(P%)=R%(P%)+1%
15112	IF P1%=1% THEN PRINT CHR$(R%(A%)); :
		GOTO 10100
15114	PRINT FNC$(R%(A%),2%);" OUT ON PORT ";FNC$(P1% AND 255%,2%)
15199 GOTO 10100
15300 ! SUI
15302	T0%=T0%+7%
15310	B0%=0%
15312	F1%=M%
15314	R%(M%)=M%(R%(P%)) : R%(P%)=R%(P%)+1%
15399 GOTO 12914
15600 !	IN
15602	T0%=T0%+10%
15610	P1%=M%(R%(P%)) : R%(P%)=R%(P%)+1%
15612	IF P1%<>0% THEN 15636
15614	ON ERROR GOTO 15626
15616	A$=SYS(CHR$(4%)+CHR$(5%))
15618	GET #5%, RECORD 8192% : Q$=Q$+LEFT(N$,RECOUNT)
15619	ON ERROR GOTO 19000
15620	R%(A%)=64%
15622	GOTO 10100
15624 !
15626	IF ERR<>13% THEN GOTO 19000
15628	RESUME 15629
15629	ON ERROR GOTO 19000
15630	IF LEN(Q$)>0% THEN R%(A%)=192%
			ELSE R%(A%)=128%
15632	GOTO 10100
15634 !
15636	IF P1%<>1% THEN 15660
15638	R%(A%)=ASCII(Q$)
15640	Q$=RIGHT(Q$,2%)
15642	GOTO 10100
15644 !
15646	PRINT : PRINT "INPUT INTO PORT ";FNC$(P1%,2%); : INPUT F1$
15648	A1%=FNC%(F1$)
15650	IF A1%<0% OR A1%>255% THEN PRINT : PRINT E$(0%) :
		GOTO 15646
15652	R%(A%)=A1%
15654	GOTO 10100
15656 !
15660	IF P1%<>255% THEN 15646
15662	R%(A%)=S9%
15699 GOTO 10100
15800 !	SBI
15802	T0%=T0%+7%
15810	B0%=FNP%(0%)
15899 GOTO 15312
16100 !	XTHL
16102	T0%=T0%+18%
16110	T1%=M%(R%(S%)+1%)
16112	M%(R%(S%)+1%)=R%(H%) AND 255%
16114	R%(H%)=T1%
16116	T1%=M%(R%(S%))
16118	M%(R%(S%))=R%(L%) AND 255%
16120	R%(L%)=T1%
16199 GOTO 10100
16300 !	ANI
16302	T0%=T0%+7%
16310	R%(A%)=R%(A%) AND M%(R%(P%))
16312	R%(P%)=R%(P%)+1%
16314	R%(S1%)=FNR%(A%,-1%)
16399 GOTO 10100
16500 !	PCHL
16502	T0%=T0%+4%
16510	R%(P%)=SWAP%(R%(H%)) OR R%(L%)
16599 GOTO 10100
16700 !	XCHG
16702	T0%=T0%+4%
16710	T1%=R%(L%) : R%(L%)=R%(E%) : R%(E%)=T1%
16712	T1%=R%(H%) : R%(H%)=R%(D%) : R%(D%)=T1%
16799 GOTO 10100
16900 !	XRI
16902	T0%=T0%+7%
16910	R%(A%)=R%(A%) XOR M%(R%(P%))
16912	R%(P%)=R%(P%)+1%
16914	R%(S1%)=FNR%(A%,0%) AND 254%
16999 GOTO 10100
17200 !	DI
17202	T0%=T0%+4%
17210	I0%=0%
17299 GOTO 10100
17400 !	ORI
17402	T0%=T0%+7%
17410	R%(A%)=R%(A%) OR M%(R%(P%))
17412	R%(P%)=R%(P%)+1%
17414	R%(S1%)=FNR%(A%,0%) AND 254%
17499 GOTO 10100
17600 !	SPHL
17602	T0%=T0%+5%
17610	R%(S%)=SWAP%(R%(H%)) OR R%(L%)
17699 GOTO 10100
17800 !	EI
17802	T0%=T0%+4%
17810	I0%=-1%
17899 GOTO 10100
18000 !	CPI
18002	T0%=T0%+7%
18010	F1%=6%
18012	R%(M%)=M%(R%(P%))
18014	R%(P%)=R%(P%)+1%
18016	GOTO 13414
18099 GOTO 10100
19000 !
      !		ERROR SECTION FOR RUN SEGMENT
      !
19006	A$=SYS(CHR$(2%))
19007 !	IF ^C OCCURS WHILE IN REGISTER DUMP, THEN ABORT DUMP BUT
      !	CONTINUE RUN.
19008 IF ERR=28 AND T% THEN T%=0% : 
		A$=SYS(CHR$(6%)+CHR$(-7%)) : RESUME
19009	IF ERR=28 THEN A$=SYS(CHR$(6%)+CHR$(-7%)) : RESUME19999
19010	IF ERR=11 THEN RESUME 19999
19020	IF ERR=55% THEN PRINT : PRINT TAB(4%);"*** INVALID MEMORY ADDRESS ***" :
			GOSUB 8000 :
			RESUME 19999
19090	ON ERROR GOTO 0
19999 A$=SYS(CHR$(2%)+CHR$(5%)) : CLOSE 5 : RETURN
20000 !
20010 !	   F U N C T I O N   D E F I N I T I O N S
20020 !
20030 !
20040 !	THE FOLLOWING FUNCTION WILL CONVERT A STRING
	OF HEX DIGITS IN N$ TO IT'S CORRESPONDING
	DECIMAL NUMBER.  A -1 IS RETURNED IF N$
20050 !	CONTAINS ANY CHARACTERS EXCEPT 0,1,...,9,A,...,F
20060 !
20100 DEF FNC%(N$)
20108	S2%=0%
20110	K%=LEN(N$)
20112	FOR I%=0% TO K%-1%
20114		D$=MID(N$,K%-I%,1%)
20116		FOR R%=0% TO 15%
20118			IF D$=D$(R%) THEN 20124
20120		NEXT R%
20122		FNC%=-1% : GOTO 20130
20124		S2%=S2%+R%*16%**I%
20126	NEXT I%
20128	FNC%=S2%
20130 FNEND
20179 !
	THE FOLLOWING FUNCTION WILL CONVERT A DECIMAL NUMBER
	IN I% TO IT'S CORRESPONDING HEX VALUE.  THE STRING
	RETURNED WILL BE N% HEX CHARACTERS IN LENGTH.
20190 !	TRUNCATION WILL OCCUR IF THE HEX NUMBER IS TOO
	LARGE TO FIT INTO THE SPECIFIED FIELD.

20200 DEF FNC$(I%,N%)
20210	N$=""
20212	S9%=0%
20214	IF I%<0% THEN I%=I% AND 32767% : S9%=-1%
20216	I9%=I%/16%**3% AND 15%
20218	IF S9% THEN N$=D$(I9% + 8%)
		ELSE N$=D$(I9%)
20220	FOR Q%=2% TO 0% STEP -1%
20222		N$=N$+D$(I%/16%**Q% AND 15%)
20224	NEXT Q%
20226	FNC$=RIGHT(N$,5%-N%)
20228 FNEND
20300	!
     	!	THE FOLLOWING FUNCTION WILL CHANGE THE STATUS OF
	!	BIT B1% AS FOLLOWS:
20302	!
	!		C%=0%		RESET (0)
	!		C%=1%		SET (1)
	!		C%=2%		COMPLEMENT
20310	DEF FNS%(B1%,C%)
20320	ON C%+1% GOTO 20330,20340,20350
20330	FNS%=R%(S1%) AND NOT (2%**B1%) : GOTO 20360
20340	FNS%=R%(S1%) OR      (2%**B1%) : GOTO 20360
20350	FNS%=R%(S1%) XOR     (2%**B1%)
20360 FNEND
20399	!
20400	!	THE FOLLOWING FUNCTION WILL RETURN THE STATUS
	!	OF BIT B1% OF THE STATUS WORD
20402	!
20410	DEF FNP%(B1%)
20420	FNP%=R%(S1%)/2%**B1% AND 1%
20430 FNEND
20500 !
      !	THE FOLLOWING FUNCTION WILL TEST THE A REGISTER AND
      ! WILL SET STATUS BITS S,Z,P, AND C.  AUX CARRY BIT IS
      !	IGNORED IF K%=-1; SET IF K%=1%; AND RESET IF K%=0.
      !
20510 DEF FNR%(X%,K%)
20511	E%=0%
20512	S2%=2%
20514	S2%=S2% OR (R%(X%) AND 128%) OR (R%(X%) AND 256%)/256%
20516	FOR I%=0% TO 7%
20518		E%=E% XOR (R%(X%)/2%**I% AND 1%)
20520	NEXT I%
20522	S2%=S2% OR E%*4%
20524	IF R%(X%)=0% THEN S2%=S2% OR 64%
20526	ON K%+2% GOTO 20528,20532,20530
20528	S2%=S2% OR (R%(S1%) AND 16%) : GOTO 20532
20530	S2%=S2% OR 16%
20532	FNR%=S2%
20534	R%(X%)=R%(X%) AND 255%
20536 FNEND
30000 !
      !	 MAIN ERROR SECTION
       !
30010 IF ERR=28 THEN RESUME 110
30020 IF ERR=11 THEN RESUME 110
30030 ON ERROR GOTO 0
32758 !
32760 CLOSE I% FOR I%=1% TO 12%
32761 PRINT : PRINT TAB(10); " * * * E N D   O F   S I M U L A T I O N * * *"
32762 KILL "MEMORY.SIM"
32767 END
