1	!	TECO6A  -  AUTOLOADER FOR TECO-11 RUN-TIME SYSTEM

2!			  Lawrence University
			    Computer Center
		       Appleton, Wisconsin 54911
		       (414) 739-3681,  ext. 564

3!	Copyright (C) 1976 by Lawrence University of Wisconsin.  General
	permission to copy or modify, but not for profit, all or part of
	this document  or  the  software  described   herein  is  hereby
4!	granted, provided that Lawrence's copyright notice is given, and
	reference is made to the fact that reproduction privileges  were
	granted by permission of Lawrence University of Wisconsin.

5!	Although  every  effort has been made to insure the accuracy and
	usefulness of this document and the software  described  herein,
	neither  the  author(s),  Lawrence  University,  nor its funding
6!	sources make any warranty, expressed or implied, with respect to
	the  performance or features of same on equipment which Lawrence
	neither owns nor controls.

7!	This program asks RSTS/E to load an  alternate  run-time  system
	and  then  deliver the user's job to the run-time system through
	its 'RUN' entry vector.  Thereafter, RSTS/E maintains a count of
8!	active  users  of this run-time system and automatically unloads
	it when the last user exits.  WARNING:  Loading will fail unless
	enough  memory  would  be left to accommodate the installation's
	declared SWPMAX.

100	N%=0%
:	DIM C%(30%)
200
	!	Autoloader for TECO alternate run-time system; also
		passes file name from CCL commands (TECO or MAKE)
		through core common to TECO.RTS

210	GOTO 270 UNLESS N% AND (LEN(C$)>4%)
:	C$=C$+'.BAS' UNLESS INSTR(1%,C$,'.')
		! Skip if no CCL or no file specification
		! Set '.BAS' if no extension given
220	C%=INSTR(1%,C$,'\')
:	C$=LEFT(C$,C%-1%)+RIGHT(C$,C%+1%)
:	GOTO 270 IF C%
		! Backslash overrides BASIC-PLUS option
230	C%=C% OR INSTR(1%,C$,'.BAS')
		! BASIC-PLUS option for '.BAS' files
240	C%=C% OR INSTR(1%,C$,'.BEX')
		! BASIC-PLUS option for '.BEX' files
250	C%=C% OR INSTR(1%,C$,'.MAS')
		! BASIC-PLUS option for '.MAS' files
260	C$=C$+'/' IF C%
		! Set BASIC-PLUS option
270	C$=SYS(CHR$(8%)+C$)
		! Put core common string
280	R$='TECO'
:	W%=0% : R%=0%
		! Read-only system, temporary residency
300
	!	Find a load address for run-time system
		under RSTS/E, V06A-02

310	L%=0%
:	CHANGE SYS(CHR$(6%)+CHR$(-3%)) TO C%
:	P%=C%(9%)+SWAP%(C%(10%))
		! P%= Address of CORTBL, monitor's memory table
320	L%=L%+1% UNTIL PEEK(P%+2%*L%)<>(32767%+1%)
		! L% is K#  of first available (unlocked) memory
330	ON ERROR GOTO 9000
		! Trap 'No room' errors
340	CHANGE SYS(CHR$(6%)+CHR$(-10%)+R$) TO C%
:	C%(0%)=30%
:	C%(1%)=6%
:	C%(2%)=-18%
:	C%(3%)=2%
:	C%(P%)=0% FOR P%=4% TO 6%
350	C%(11%)=L%
:	C%(12%)=SWAP%(L%)
:	C%(13%)=R%
:	C%(14%)=W%
:	C%(P%)=0% FOR P%=15% TO 30%
		! Load address is K# L% in memory
360	CHANGE C% TO C$
:	C$=SYS(C$)
		! Run-time system is now loaded
370	CHAIN R$+'.LDA$' N%
		! Deliver the user to new run-time system
9000
	!	Error handler

9010	IF ERR<>4% THEN ON ERROR GOTO
:	RESUME 32767
9200	GOTO 9210 IF F%
:	PRINT R$" not available now"
:	PRINT "Other run-time system(s) being used"
:	INPUT "How many seconds to wait"; S%
:	F%=1%
9210	IF S%<=0% THEN 9220
	ELSE S%=S%-2%
:	SLEEP 2%
:	RESUME 300
		! Retry once every 2 seconds
9220	RESUME 32767

30000	N%=30000%
:	C$=CVT$$(SYS(CHR$(7%)),-1%)
:	GOTO 200
		! CCL entry point - get core common string
32767	END
