1!		Lawrence University
		Department of Chemistry
		Appleton, Wisconsin 54911
		(414) 739-3681, Ext. 456

2!  Program name, version, date, authorship:
	HYBRID, Version 1A, 14-Dec-74 (Slave program for SPPLT)
	Written by Stephen L. Holmgren, class of 1973, and maintained
	by Dr. James S. Evans, Department of Chemistry, Lawrence
	University.

3!  Purpose of program:
	SPPLT prepares contour plots of hybrid atomic orbitals with
	specified contour levels, effective nuclear charge, amounts of
	2s and 2p character, and geometric operations (scaling,
	translation, rotation).

4!	Included are subroutines for several plotting devices:
	Tektronix 4010 graphics terminal; TSP-212 plotter system;
	Hewlett-Packard 7200A/7202A graphic plotter.

5!  Language and operating system:
	SPPLT, written in BASIC-PLUS, uses virtual core files and
	several non-privileged SYS functions, and runs in 8K under
	RSTS Versions 05-21 and 05B-24 (PDP-11/45).

6!  Availability:
	SPPLT is a non-proprietary program product of Lawrence
	University.  It is distributed at cost for educational use,
	on the condition that it not be sold, rented, or leased
	for profit.

7!  Limitations:
	Variables in NMRSIM are dimensioned to handle up to 6 spin-1/2
	nuclei, or fewer with larger spins.  Larger systems might be
	feasible on an 11/45 configured for 16K of user core.

8!  Further documentation:
	User's guide:  3 pages of run instructions and operational
	  features for students who will use SPPLT for class assignments.
9!	Programmer's guide:  discussion of algorithms and instructions
	  for system implementation.
	Literature reference:  S. L. Holmgren and J. S. Evans,
	  Journal of Chemical Education, vol. 51, pp. 189-191 (1974).

10! Disclaimer:
	Neither the author of this program nor Lawrence University
	assumes any liability, expressed or implied, with respect to
	the correctness or performance of this program.

40 PRINT "CAN'T RUN HYBRID" : GOTO 32000
50 GOSUB 5600 : M$=CHR$(K0%)
60 D=0.05 : A0=0.52915 : S=1.E-20 : A1(K1%)=F0 : C,S2=F1
65 INPUT "EFFECTIVE NUCLEAR CHARGE"; Z0 : M6%=K0% :
	GOTO 6040 UNLESS Z0>=F1
75 INPUT "AMOUNT OF P CHARACTER";A  ! ALPHA IS ENTERED
77 IF A>=20 THEN S2=F0    !  DEFAULT TO PURE "P" IF A > 20 
79 A=SQR(A)
86 INPUT "# OF CONTOURS";I5% : IF I5%>K3% THEN I5%=K3%
90 DIM P(3%),A1(38%),R1(37%,3%),R2(37%,3%),R3(37%,3%),R4(37%,3%)
100 DIM#1,Z1(37%,3%),Z2(37%,3%),Z3(37%,3%),Z4(37%,3%) : Z4(37%,K3%)=K0%
     !  OPEN AND EXTEND VIRT. CORE FILE
110 DEF FNF(S)=C1*E*(S2*(F2-S)+S1*A*C*S) ! PSI
120 DEF FNF1(S)=C2*E*(S2*(-F2+S)+S1*A*C*(F1-S)) ! D/DR(PSI)
140 Z1=Z0/A0 : Z9=F1/SQR(Z0) : C0=0.25/SQR(F2*PI) :
	C1=(C0*Z1^1.5)/SQR(S2+A*A) : C2=C1*Z1 ! NORMALIZATION CONST.
150 !                      **********BEGINNING OF FIRST LOOP******
160 FOR J%=K1% TO N% : J1%,J2%=K1% 
	! J1%,J2%=2 WHEN RESPECTIVE ROOTS FOUND
180 GOTO 400 UNLESS J%=K1% OR J%>11% ! MAX & MIN CHANGE LITTLE AT FIRST
205 IF A<=F1 THEN J1%=K2%  :  M1=F0 ! MAX PSI AT R=0 IF 0<=A<=1
209 R0=F0  !                         ***********FIND MAX & MIN*******
210 FOR I%=K1% UNTIL J1%+J2%=K4% OR I%=100%
220 E=EXP(-Z1*R0/F2)
230 ON J1% GOTO 240,280  !  HAS MAX BEEN FOUND
240 S1=F1
250 IF FNF1(Z1*R0/F2)>=F0 GOTO 280
260 M1=(R0-0.025) : J1%=K2%  ! ROOT SET HALFWAY BETWEEN PRESENT&PAST R0
280 ON J2% GOTO 290,320   !  HAS OTHER MAX BEEN FOUND
290 S1=-F1    !   NEGATIVE LOBE
300 IF FNF1(Z1*R0/F2)<=F0 GOTO 320
310 M2=(R0-.025) : J2%=K2%
320 R0=R0+.05    ! RADIUS INCREMENTED BY .05 ANGSTROMS
330 NEXT I% !				******END OF MAX-MIN PART***
334 GOTO 400 UNLESS J%=K1%
335 S1=F1 : E=EXP(-Z1*M1/F2) :
	PRINT "APPROX PSI MAX ="; FNF(Z1*M1) : PRINT "  AT R="; M1 :
	INPUT "CHOOSE CONTOURS"; C$
340 IF ASCII(C$)=89% THEN 350 ! TEST FOR Y[ES]
345 P(K1%)=0.03 : P(K2%)=0.06 : P(K3%)=0.12 ! DEFAULT VALUES OF CONTOURS
346 GOTO 354
350 PRINT "ENTER SMALLEST FIRST" : INPUT P(I%) FOR I%=K1% TO I5%
354 PRINT "CONTOURS USED:"
355 G$="##.###    ##.###    ##.###"
360 PRINT USING G$,P(I%); FOR I%=K1% TO I5% : PRINT
400 C=COS(A1(J%))            !   CALCULATE COSINE AT THIS ANGLE
410! 
    PSIMAX,MIN,AND NODE POSITION ARE CALCULATED FOR EACH ANGLE
  
420 S1=+F1 : E=EXP(-Z1*M1/F2) : P2=FNF(Z1*M1) ! MAX OF POS. LOBE
430 S1=-F1 : E=EXP(-Z1*M2/F2) : P1=FNF(Z1*M2) ! MIN OF NEG. LOBE
440 M5,P4=F0  : M6=M2  : C$=" NODE " : R8=0.2
445 IF S2=F0 THEN R9=F0 ELSE GOSUB 5001 ! SOLVE FOR NODE IF NOT PURE 'P'
447 N0=R9      !    NODE IS ALWAYS 0 FOR PURE "P" ORBITAL
455 !.....INITIAL GUESSES FOR ROOTS ARE MADE
460 R1(K0%,K1%)=(M1+6.0*Z9)/F2 : R1(K0%,K2%),R1(K0%,K3%)=M1+.75
461 FOR I2%=K1% TO K3%
462 R2(K0%,I2%)=M1/F2 + S ! ADDED TO PREVENT DIV BY ZERO
463 R3(K0%,I2%)=(M2+N0)/F2 : R4(K0%,I2%)=(M2+6.0*Z9)/F2
464 NEXT I2%
470
     FOR I%=K1% TO I5%  !     *************BEGINNING OF SECOND LOOP****
480 P4=-ABS(P(I%))   !            SELECT CONTOUR LEVEL
490 IF P4<P1 THEN 590       ! MAKE SURE P4 IS NOT < MIN VALUE
500 !     ...ROOT 3.....
501 S1=-F1 : M5=N0 : M6=M2 : C$=" ROOT 3 "
505 R8=R3(J%-K1%,I%) : IF R8<=-F3 THEN 590  !  IF ROOT AT LAST ANGLE
         WAS NOT POSSIBLE, DON'T BOTHER LOOKING FOR THIS ONE
510 GOSUB 5001  :  R3(J%,I%)=R9
519 !     ...ROOT 4.....
520 S1=-F1 : M5=M2 : M6=7.0*Z9 : C$=" ROOT 4"
525 R8=R4(J%-K1%,I%) : IF R8<=-F3 THEN 590
530 GOSUB 5001  : R4(J%,I%)=R9
570 GOTO 601
590 R3(J%,I%),R4(J%,I%)=-F3  ! SET ROOTS =-3 IF NO SOLUTION POSSIBLE
601 IF J%>19% GOTO 750 !  ROOTS 1&2 ARE REDUNDANT FOR THETA > 90
605 P4=ABS(P(I%))
610 IF P4>=P2 THEN 750 ! CHECK TO SEE IF ROOTS 1&2 ARE POSSIBLE
620 !			WHAT SIDE OF ORIGIN IS ROOT 2 ON??
625 E=F1
630 Q=P4-FNF(F0)  ! COMPARE CONTOUR LEVEL TO FUNCTION AT ZERO
640 IF Q>F0 THEN 649
           ELSE IF Q<F0 THEN 660
               			ELSE R2(J%,I%)=F0
645 GOTO 685
646 !     ...ROOT 2 .....
649 R8=ABS(R2(J%-K1%,I%))   !  USE PREVIOUS ROOT AS INITIAL GUESS
650 S1=+F1 : M5=F0: M6=M1 : C$=" ROOT 2+ "  ! ROOT ON RT. SIDE OF ORIGIN
655 GOSUB 5001 : R2(J%,I%)=R9  : GOTO 685
660 R8=ABS(R2(J%-K1%,I%))
665 S1=-F1 : M5=F0 : M6=N0 : C$=" ROOT 2- "  !  LEFT SIDE OF ORIGIN
670 GOSUB 5001 : R2(J%,I%)=-R9  ! NEG. SIGN IS FLAG FOR LEFT OF ORIGIN
685 !     ....ROOT 1.....
686 S1=+F1 : M5=M1 : M5=F0 IF M5<F0 : M6=6.0 : C$=" ROOT 1 "
	! ROOT 1 ALWAYS ON RIGHT SIDE OF ORIGIN
690 R8=R1(J%-K1%,I%)
700 GOSUB 5001  :  R1(J%,I%)=R9
720 GOTO 760
750 R2(J%,I%),R1(J%,I%)=-F3
760 
     NEXT I%   !        ********END OF SECOND LOOP*******

770 A1(J%+K1%)=A1(J%)+PI/36  ! INCREMENT ANGLE BY 5 DEGREES (IN RADIANS)
780
    NEXT J%    !         *********END OF FIRST LOOP********

900 R4(K0%,K0%)=I5% : R1(K0%,K0%)=F0 ! STORE # CONTOURS, SORT INDICATOR
          IN VIRT. CORE FOR USE BY PLOTTING SECTION
901 GOTO 6000
5000! ROOT FINDING SUBROUTINE USING VARIABLES T,R8,R9,M5,M6,C$
     R8= INITIAL GUESS     R9= FINAL ROOT
     M6= MAX. OF INTERVAL  M5= MIN. OF INTERVAL
     C$= VARIABLE NAME (USEFUL FOR DEBUGGING)
5001 T=-F1 : Q=F0  ! Q IS ON-OFF SWITCH FOR ENTRY INTO 2ND SUBROUTINE
5010 R9=R8
5015 D1=F2
5020 FOR K%=K1% UNTIL D1<D OR K%>=30%
5025 E=EXP(-R9*Z1/F2)
5030 R3=(FNF(Z1*R9)-P4)/(FNF1(Z1*R9/F2)+S)
5035 IF ABS(R3)>10 THEN 5055 ! CHECK FOR DIVERGENCE
5040 R8=R9-R3
5045 D1=ABS(R3/(R9+S)) ! CHECK CONVERGENCE CRITERION (0.05)
5050 R9=R8  :  GO TO 5070
5055 R9=-F1
5060 K%=30%
5070 NEXT K%
5080 IF R9<M6 AND R9>M5 THEN RETURN   ! IF ROOT IN PROPER RANGE,RETURN
5085 T=T+F2 !    ...T IS INCREMENTED AFTER EACH TRY FOR ROOT
5087 IF T>F3 THEN 5089 ELSE 5100
5089 !   ...TRY OTHER METHOD IF T>3
5090 IF Q=F0 THEN 5225 ELSE 5091
5091 R9=-F2 : RETURN
5100 R9=(M6-M5)*T/4+M5 ! TRY ANOTHER STARTING VALUE WITHIN THE INTERVAL
5150 GO TO 5015
5200! ADDITIONAL SUBROUTINE FOR STUBBORN ROOTS; USES THE SIMPLE
         INTERVAL-HALVING TECHNIQUE
5225 Q=F1
5230 R6=M6 : R5=M5 : R8=(R6+R5)/F2
5235 E=EXP(-R5*Z1/F2) : R3=FNF(Z1*R5)-P4
5240 E=EXP(-R8*Z1/F2) : IF R3*(FNF(Z1*R8)-P4)>F0 THEN 5270
5250 R9=(R8+R5)/F2 : R6=R8
5260 GOTO 5280
5270 R9=(R8+R6)/F2 : R5=R8
5280 D1=ABS((R9-R8)/R8)
5290 IF D1<.001 THEN 5300
5295 R8=R9 : GOTO 5235
5300 E=EXP(-R6*Z1/F2) : IF R3*(FNF(Z1*R6)-P4)<F0 THEN RETURN
5330 R9=-4 : RETURN      !  IF ROOT NOT FOUND SET R9 =-4
5400 GOSUB 5600 : M$=CHR$(K1%) ! OPTION "NAME"
5410 INPUT "FILENAME"; M$ : OPEN M$+".SPA" FOR OUTPUT AS FILE K2%
5420 DIM #2, Y1(37%,3%),Y2(37%,3%),Y3(37%,3%),Y4(37%,3%)
5430 Y1(J%,I%)=Z1(J%,I%) FOR I%=K0% TO K3% FOR J%=K0% TO N% :
	Y2(J%,I%)=Z2(J%,I%) FOR I%=K0% TO K3% FOR J%=K0% TO N% :
	Y3(J%,I%)=Z3(J%,I%) FOR I%=K0% TO K3% FOR J%=K0% TO N% :
	Y4(J%,I%)=Z4(J%,I%) FOR I%=K0% TO K3% FOR J%=K0% TO N%
5440 CLOSE K1%,K2% : CHAIN N1$+"SPPLT" 4350
5500 GOSUB 5600 : M$=CHR$(K0%) ! OPTION "USE"
5510 INPUT "FILENAME"; M$ : OPEN M$+".SPA" FOR INPUT AS FILE K2%
5530 Z1(J%,I%)=Y1(J%,I%) FOR I%=K0% TO K3% FOR J%=K0% TO N% :
	Z2(J%,I%)=Y2(J%,I%) FOR I%=K0% TO K3% FOR J%=K0% TO N% :
	Z3(J%,I%)=Y3(J%,I%) FOR I%=K0% TO K3% FOR J%=K0% TO N% :
	Z4(J%,I%)=Y4(J%,I%) FOR I%=K0% TO K3% FOR J%=K0% TO N%
5540 Z3(K0%,K0%)=R3(K0%,K0%) : CLOSE K2% : GOTO 6040
5600 N1$=CHR$(35%)
5610 N%=37% : F0=0 : F1=1 : F2=2 : F3=3 :
	M6%,K0%=0% : K1%=1% : K2%=2% : K3%=3% : K4%=4% :
	K5%=5% : K6%=6% : K7%=7% : K8%=8% : K9%=9% :
	ON ERROR GOTO 30000 : GOSUB 21400
5620 N$="SLHJSE.J" : I8%=K9% : GOSUB 20000 :
	N$=N$+RIGHT(NUM$(100%+ASCII(K0$)/K2%),K3%) :
	OPEN N$ FOR INPUT AS FILE K1%, CLUSTERSIZE K2% :
	R3(K0%,K0%)=Z3(K0%,K0%) : RETURN
6000!  LOAD ALL THE PERTINENT ROOTS INTO VIRT. CORE SO 
        CONTROL CAN BE TRANSFERRED TO THE PLOTTING ROUTINE
6010 Z1(J%,I%)=R1(J%,I%) FOR I%=K0% TO K3% FOR J%=K0% TO N% :
	Z2(J%,I%)=R2(J%,I%) FOR I%=K0% TO K3% FOR J%=K0% TO N% :
	Z3(J%,I%)=R3(J%,I%) FOR I%=K0% TO K3% FOR J%=K0% TO N% :
	Z4(J%,I%)=R4(J%,I%) FOR I%=K0% TO K3% FOR J%=K0% TO N%
6023 !   THIS SECTION TRANSFERS THE DATA BY ACCESSING VIRT. CORE
         MOST EFFICIENTLY
6040 CLOSE K1%
6050 ! CHAIN TO PLOTTER PROGRAM.......
6060 CHAIN N1$+"SPPLT" 2900
6070 KILL N$ : PRINT "Thank you for using SPPLT" :
	PRINT "Stephen L. Holmgren and James S. Evans" : GOTO 32000
20000 I8%,I9%=K0% UNLESS I7%=K6% :
	K0$=SYS(CHR$(I7%)+CHR$(I8%)+CHR$(I9%)) :
	RETURN					! SYS FUNCTION CALL
21200 I7%=K6% : I8%=K9% : GOSUB 20000 :
	PRINT MID(K0$,K3%,INSTR(K3%,K0$,CHR$(K0%))-K3%) :
	RETURN					! RSTS ERROR MESSAGE
21300 I7%=K0% : GOSUB 20000 : RETURN ! CANCEL ^O
21400 I7%=K6% : I8%=-K7% : I9%=K0% : GOSUB 20000 : RETURN
						! ENABLE ^C TRAP
30000 RESUME 31000 IF ERR=28% : I%=ERR : GOSUB 21200 :
	GOTO 30040 UNLESS ERR=K2% OR ERR=K5% :
	RESUME 5410 IF ERL=5410 : RESUME 5510 IF ERL=5510 :
	GOTO 31990 ! BAD FILENAME OR FILE CANNOT BE FOUND
30040 GOTO 31990 UNLESS ERR=50%
30050 RESUME 65 IF ERL=65 : RESUME 75 IF ERL=75 :
	RESUME 86 IF ERL=86 : RESUME 350 IF ERL=350 :
	GOTO 31990 ! ILLEGAL NUMBER TRAP ***CHANGE TO ERR=52%
	PRIOR TO RSTS VERSION 05B-24***
31000 GOSUB 21400 : GOSUB 21300 : RESUME 5440 IF M$=CHR$(K1%) :
	IF M6% THEN RESUME 6070 ELSE M6%=K1% : RESUME 65
31990 I9%=117% : GOSUB 21200 : I9%=114% : GOSUB 21200 :
	PRINT "IF POSSIBLE, CONTACT MR. EVANS BEFORE LOGGING OFF" :
	ON ERROR GOTO 0
32000 END
