9000 REM *****MARKOW*****BUSINESS PROGRAM
9002 REM MARKOW**********VERSION #1 (7/31/69)*****MARKOW CHAINS*****
9004 REM
9006 REM THIS PROGRAM COMPUTES THE EFFICIENT PORTFOLIOS ACCORDING TO THE
9008 REM FULL COVARIANCE MATRIX MARKOWITZ MODEL.
9010 REM
9012 REM    INPUT DATA IS NEEDED IN THE FOLLOWING ORDER:
9014 REM     1) THEN NUMBER OF SECURITIES
9016 REM     2) THE LENDING RATE
9018 REM     3) THE BORROWING RATE
9020 REM     4) THE EXPECTED RETURNS FOR EACH SECURITY, LISTED IN ORDER
9022 REM     5) THE FULL COVARIANCE MATRIX, LISTED ROW BY ROW
9024 REM
9026 REM      (THERE EXISTS A STORAGE PROBLEM, BUT MARKOW SHOULD HANDLE
9028 REM      UP TO 75 SECURITIES.)
9030 REM
9032 PRINT "*  SECURITIES PORTFOLIOS USING MARKOW CHAINS  *"
9034 PRINT
9036 READ N,I1,I2
9037 PRINT "AS INPUT WE HAVE:";N;"SECURITIES"
9038 PRINT "                 "I1*100;"PERCENT AS THE LENDING RATE"
9040 PRINT "                 "I2*100;"PERCENT AS THE BORROWING RATE"
9042 PRINT
9044 PRINT "***********************************************************************"
9046 Z9=1
9048 N9=1
9050 DIM E(20),A(15,15),B(15,15),R(15),H(15),G(80)
9051 G9=80
9052 E9=20
9054 A9,R9,H9=15
9055 MAT B=ZER(N+1,N+1)
9056 MAT G=ZER(G9)
9058 READ E(E9)
9060 Z=E(E9)
9062 K=0
9064 FOR I=1 TO N-1
9066 READ E(I)
9068 IF E(I)<Z THEN 9074
9070 K=I
9072 Z=E(I)
9074 NEXT I
9076 G(G9)=-1
9078 G(N+1)=1
9080 FOR I=1 TO N
9081 G(I)=-1
9082 G(I+N+1)=1
9083 NEXT I
9086 Z=K
9087 IF Z>0 THEN 9089
9088 Z=G9
9089 G(Z)=1
9090 G(K+N+2)=-1
9092 K2=1
9094 GOSUB 9272
9096 GOSUB 9319
9098 L3=-99999.
9100 IF H(1)<=0 THEN 9108
9102 IF L3>-R(R9)/H(1) THEN 9108
9104 L3=-R(R9)/H(1)
9106 L1=0
9108 FOR I=1 TO N
9110 IF H(I+1) <= 0 THEN 9118
9112 IF L3>-R(I)/H(I+1) THEN 9118
9114 L3=-R(I)/H(I+1)
9116 L1=I
9118 NEXT I
9120 IF L3 <> -99999. THEN 9126
9122 PRINT "THIS SOLUTION IS GOOD FOR ALL SMALLER SLOPES"
9123 PRINT
9124 PRINT"****************************************************************************"
9125 STOP
9126 L=L3
9128 GOSUB 9352
9130 ON Z9 GOTO 9132,9156,9242
9132 IF I3>I2 THEN 9242
9134 FOR L6=L TO L+20 STEP .001
9136 GOSUB 9182
9138 IF ABS(L6-(2*V1/(E1-I2)))<.005 THEN 9144
9140 NEXT L6
9141 PRINT
9142 PRINT "******************************************************************************"
9144 PRINT "BORROWING PORTFOLIO"
9146 I9=I2
9148 GOSUB 9214
9149 STOP
9150 GOSUB 9406
9152 GOSUB 9232
9154 Z9=2
9156 IF I3>I1 THEN 9242
9158 FOR L6=L TO  L+20 STEP .001
9160 GOSUB 9182
9162 IF ABS(L6-(2*V1/(E1-I1)))<.005 THEN 9168
9164 NEXT L6
9166 GOTO 9141
9168 I9=I1
9170 GOSUB 9214
9172 PRINT "LENDING PORTFOLIO"
9173 STOP
9174 GOSUB 9406
9176 GOSUB 9232
9178 Z9=3
9179 STOP
9180 GOTO 9242
9182 RESTORE
9184 FOR I=0 TO N+2
9186 READ X
9188 NEXT I
9190 E1,V1=0
9191 FOR I=0 TO N-1
9192 Z,W,U=I
9193 FOR J=0 TO N-1
9194 Y=J
9195 IF Z>0 THEN 9199
9196 Z=G9
9197 W=R9
9198 U=E9
9199 IF Y>0 THEN 9201
9200 Y=R9
9201 READ X
9202 IF G(Z)=-1 THEN 9205
9203 IF G(Y)=-1 THEN 9205
9204 V1=V1+(R(W)+L6*H(I+1))*(R(Y)+L6*H(J+1))*X
9205 NEXT J
9206 IF G(Z)=-1 THEN 9210
9208 E1=E1+(R(W)+L6*H(I+1))*E(U)
9210 NEXT I
9212 RETURN
9214 E2=E
9216 V2=V
9218 L5=L
9220 I4=I3
9222 L=L6
9224 E=E1
9226 V=V1
9228 I3=I9
9230 RETURN
9232 E=E2
9234 V=V2
9236 I3=I4
9238 L=L5
9240 RETURN
9241 STOP
9242 GOSUB 9406
9244 IF L>.001 THEN 9250
9245 PRINT
9246 PRINT "***************************************************************************"
9248 GOTO 9999
9250 G(L1)=G(L1)*(-1)
9252 IF L1=N THEN 9260
9254 IF L1=N+1 THEN 9264
9256 G(L1+N+2)=G(L1+N+2)*(-1)
9258 GOTO 9266
9260 K2=-1
9262 GOTO 9266
9264 K2=-1
9266 GOSUB 9272
9268 N9=N9+1
9270 GOTO 9096
9272 MAT A=ZER(N+1,N+1)
9274 RESTORE
9276 A(1,N+1)=K2
9277 IF G(G9)=-1 THEN 9279
9278 A(N+1,1)=1
9279 FOR I=1 TO N-1
9280 A(I+1,N+1)=K2
9281 IF G(I)=-1 THEN 9284
9282 A(N+1,I+1)=1
9284 NEXT I
9287 FOR I=0 TO N+2
9288 READ X
9290 NEXT I
9292 FOR I=0 TO N-1
9294 FOR J=0 TO N-1
9296 Z=J
9298 IF Z>0 THEN 9302
9300 Z=G9
9302 READ X
9304 IF G(Z)=-1 THEN 9310
9306 A(I+1,J+1)=2*X
9308 GOTO 9314
9310 IF I <> J THEN 9314
9312 A(I+1,J+1)=-1
9314 NEXT J
9315 NEXT I
9318 RETURN
9319 MAT B=INV(A)
9320 MAT A=B
9321 FOR I=0 TO N
9322 Z=I
9324 IF Z>0 THEN 9328
9326 Z=R9
9328 R(Z)=A(I+1,N+1)
9330 NEXT I
9332 MAT H=ZER(N+1)
9334 FOR I=1 TO N-1
9336 FOR J=0 TO N-1
9338 Z=J
9340 IF Z>0 THEN 9344
9342 Z=E9
9344 H(I+1)=H(I+1)+A(I+1,J+1)*E(Z)
9346 NEXT J
9348 NEXT I
9350 RETURN
9352 E=0
9354 V=0
9356 RESTORE
9358 FOR I=0 TO N+2
9360 READ X
9362 NEXT I
9364 FOR I=0 TO N-1
9366 Z,W,U=I
9368 FOR J=0 TO N-1
9370 Y=J
9372 IF Z>0 THEN 9380
9374 Z=G9
9376 W=R9
9378 U=E9
9380 IF Y>0 THEN 9384
9382 Y=R9
9384 READ X
9386 IF G(Z)=-1 THEN 9392
9388 IF G(Y)=-1 THEN 9392
9390V=V+(R(W)+L*H(I+1))*(R(Y)+L*H(J+1))*X
9392 NEXT J
9394 IF G(Z)=-1 THEN 9398
9396 E=E+(R(W)+L*H(I+1))*E(U)
9398 NEXT I
9400 I3=E-(2*V/L)
9401 IF V>0 THEN 9403
9402 V=-V
9403 L8=L/(2*SQR(V))
9404 RETURN
9406 PRINT
9407 PRINT "                       PORTFOLIO NUMBER";N9
9408 PRINT
9409 PRINT "EXP RETURN:";E;TAB(17);"STD DEV:";SQR(V);TAB(36);"ASS INT:";I3
9410 PRINT "          SLOP OF THE E-V CURVE IS:";L
9412 PRINT
9414 PRINT "STOCK NO","PERCENT","R","H"
9415 IF G(G9)=-1 THEN 9417
9416 PRINT 1,100*(R(R9)+L*H(1)),R(R9),H(1)
9417 FOR I=1 TO N-1
9418 IF G(I)=-1 THEN 9422
9420 PRINT I+1,100*(R(I)+L*H(I+1)),R(I),H(I+1)
9422 NEXT I
9424 PRINT
9426 PRINT
9428 PRINT "                            ---------"
9430 RETURN
9900 DATA 9
9901 DATA .045,.065
9910 DATA 2.84022E-02,.110011,4.77284E-03,6.33756E-02,6.14846E-02,3.05807E-02
9920 DATA -7.12097E-03,-5.32422E-03,.260657
9930 REM EXAMPLE COVARIANCE MATRIX FOLLOWS:
9950 DATA 2.88445E-02,9.04635E-03,1.31019E-02,1.70099E-02
9951 DATA 1.5701E-02 ,1.85585E-02,2.78296E-02,3.10865E-02
9952 DATA 1.1436E-02,9.04635E-03,6.75625E-03,4.64437E-04
9953 DATA 1.37025E-02,8.90057E-03,5.1941E-03,464437E-04
9954 DATA9.64282E-03,4.30107E-04,2.01453E-03,.010148
9955 DATA 1.55908E-02,9.31176E-03,4.03761E-03,1.70099E-02
9956 DATA 1.37025E-02,4.30107E-04,2.86772E-02,1.55314E-02
9957 DATA 1.14319E-02,1.28415E-02,2.95581E-02,-4.5765E-03
9958 DATA 1.57015E-02,8.90057E-03,2.05413E-03,1.55314E-02
9959 DATA 1.88851E-02,4.27909E-03,9.07786E-03,2.20021E-02
9960 DATA 1.85585E-02,.099266,5.19141E-03,.010148
9961 DATA 1.14319E-02,4.27909E-03,1.63099E-02,.021356
9962 DATA 1.93458E-02,-5.6284E-02,2.78296E-02,6.43849E-03
9963 DATA 1.55908E-02,1.28415E-02,9.07786E-03,.021356
9964 DATA 3.04166E-02,2.70716E-02,2.8313E-03,3.10865E-02
9965 DATA 1.49714E-02,9.31176E-03,2.95581E-02,2.20021E-02
9966 DATA .093458,2.70716E-02,4.04682E-02,8.28133E-03
9967 DATA 1.14316E-02,9.78117E-04,4.03761E-03,-4.5765E-03
9968 DATA 1.99266E-02,-5.68284E-03,2.8313E-03,8.28133E-03
9969 DATA 6.43849E-03,1.49714E-02,9.78117E-04,1.31019E-02
9970 DATA 4.86656E-02
9999 END
