9000 REM ***** LNTRND ***** BUSINESS PROGRAM
9010 REM LNTRND *********** VERSION #1 (7/31/69)*****LINEAR TRAND FORECASTING
9020 REM
9030 REM THIS PROGRAM COMPUTES A SIMPLE LINEAR TREND FORECAST WITH
9040 REM SEASONAL ADJUSTMENTS FOR MONTHLY DATA.  THIS WILL ONLY PROVIDE A
9050 REM GOOD FIT IF THE TREND IS LINEAR, I.E., OF THE FORM: Y = A + B*X
9060 REM
9070 REM UP TO NINE YEARS OF DATA CAN BE INPUT. DATA SHOULD BEGIN IN
9080 REM LINE 9900.  IT SHOULD BE OF THE FOLLOWING FORM:
9090 REM    N = THE NUMBER OF YEARS FOR WHICH THE USER WISHES TO ENTER
9100 REM        DATA
9110 REM    A(I,M)=THE MONTHLY DATA, SEQUENTIALLY. THERE SHOULD BE
9120 REM    (12*N) VALUES.
9130 REM
9140 REM  OUTPUT WILL BE OF THE FOLLOWING FORM:
9150 REM    FIRST THE A AND B VALUES OF THE EQUATION: Y=A+B*X, AND
9160 REM    THEN THE FORECASTS FOR THE NEXT 12 MONTHS AND THE SEASONAL
9170 REM    VALLES.
9180 REM
9190 PRINT "* LINEAR TREND FORECASTING *"
9200 PRINT
9210 PRINT
9220 PRINT "***********************************************************************"
9230 DIM A(9,12),B(9,12),D(9,12),E(12),F(12)
9240 READ N
9250 S1=0
9260 S2=0
9270 S3=0
9280 S4=0
9290 S5=0
9300 S6=0
9310 FOR I=1 TO N
9320 FOR M=1 TO 12
9330 READ A(I,M)
9340 S1=S1+A(I,M)
9350 S2=S2+(A(I,M)*A(I,M))
9360 S3=S3+(A(I,M))*(((I-1)*12)+M)
9370 S4=S4+(((I-1)*12)+M)*(((I-1)*12)+M)
9380 S5=S5+1
9390 S6=S6+(((I-1)*12)+M)
9400 NEXT M
9410 NEXT I
9420 B1=((S5*S3)-(S1*S6))/((S5*S4)-(S6*S6))
9430 A1=(S1-(B1*S6))/S5
9440 PRINT
9450 PRINT "LINEAR FORECASTING EQUATION IS: Y =";A1;"+";B1;"* X ."
9460 PRINT
9470 PRINT
9480 B2=0
9490 FOR I=1 TO N
9500 C(I)=0
9510 FOR M=1 TO 12
9520 B2=B2+B1
9530 B(I,M)=A(I,M)-B2
9540 C(I)=B(I,M)+C(I)
9550 NEXT M
9560 C(I)=C(I)/12
9570 NEXT I
9580 FOR I=1 TO N
9590 FOR M=1 TO 12
9600 D(I,M)=B(I,M)/C(I)
9610 NEXT M
9620 NEXT I
9630 FOR M=1 TO 12
9640 E(M)=0
9650 FOR I=1 TO N
9660 E(M)=E(M)+D(I,M)
9670 NEXT I
9680 E(M)=E(M)/N
9690 NEXT M
9700 PRINT "DATA FOR PERIODS 1 THRU";N*12;"WERE SUPPLIED AS INPUT."
9710 PRINT "THE NEXT 12 MONTHS ARE FORECAST HERE:"
9720 PRINT
9730 PRINT "PERIOD","FORECAST","SEASONAL FACTOR"
9740 FOR M=1 TO 12
9750 F(M)=(A1+(B1*((N*12)+M)))*E(M)
9760 PRINT (N*12)+M,F(M),E(M)
9770 NEXT M
9780 PRINT
9790 PRINT "************************************************************************"
9900 DATA 4,2,2.2,2.4,2.6,2.8,3,3.2,3.4,4,4.5,4.8,5
9901 DATA 5,5.2,5.4,5.6,5.3,5.4,5.6,5.7,5.8,6,6,6.1
9902 DATA 6,6.1,6.3,6.5,6.7,6.8,6.9,6.7,6.7,6.9,7,7
9903 DATA 7,7,7.1,7,7.2,7.3,6.9,7,7,7.4,7.5,7.5
9999 END
