1	!RESEQ.BAS
	!Version: 4A
	!Written by: Tony Nardo
	!Creation date: 10-Aug-79
	!Last modification: 07-Mar-80
	!Reason: to fix error in ON ... GOTO/GOSUB resequencing routine
	!
	!Functions:
	!	RESEQ.BAS can resequence a whole program or a specific
	!	range of line numbers. The maximum length of a program
	!	that can be resequenced is 3200 lines.
	!
	!	RESEQ allows resequencing under the following basic format:
	!	'A-B=C+D'. A,B,C, and D are numbers between 1 and 32767.
	!	Format variations and their results are as follows:
	!
	!		)RESEQ whole file, start new file at 10, inc. of 10
	!	A	)RESEQ whole file, start new file at A, inc. of 10
	!	A-B	)RESEQ from A to B, new value of A=10, inc. of 10
	!	A=C	)RESEQ from A to end, new value of A=C, inc. of 10
	!	A+D	)RESEQ whole file, start new file at A, inc. of D
	!	A-B=C	)RESEQ from A to B, new value of A=C, inc. of 10
	!	A-B+D	)*** Illegal RESEQ operation ***
	!	A=C+D	)RESEQ from A to end, new value of A=C, inc. of D
	!	A-B=C+D	)RESEQ from A to B, new value of A=C, inc. of D
	!
	!	RESEQ also features a format to multiply the old line
	!	numbers in all or part of a program by an integer.  The
	!	format for this operation is 'A-B*D', with the following
	!	variations:
	!
	!	*	)Multiply whole file by 10
	!	*D	)Multiply whole file by D
	!	A-B*	)Multiply line numbers from A thru B by ten
	!	A*D	)Multiply lines A to end by D
	!	A-B*D	)Multiply lines A thru B by D
	!
	!	See source listing for default values of A, B, C, and D.

2	!
	! M O D I F I C A T I O N   H I S T O R Y
	!
	!
	!	VERSION		DATE		REASON
	!
	!
	!	    4	      15-Jan-80		Set up HELP message
	!					Set up multiplying factor
	!
	!	   4A	      07-Mar-80		Fix error in ON ... GOTO/GOSUB
	!					Get rid of imbedded blanks in
	!					    target file line numbers
3	!
	! V A R I A B L E S
	!
	!	A% :UTILITY VARIABLE
	!	A$ :UTILITY VARIABLE
	!	B% :INITIAL LINE NUMBER TO RESEQUENCE
	!	B1%:POSITION OF OLD LINE NUMBER IN LIST B0%
	!	C% :CCL ENTRY DESIGNATOR
	!	C$ :COMPARISON STRING (USED WITH C1$)
	!	C1$:COMPARISON STRING
	!	D$ :DEVICE NAME OF FILE TO RESEQUENCE
	!	F% :FINAL LINE NUMBER TO RESEQUENCE
	!	F$ :FILE TO BE RESEQUENCED
	!	F1%:SORTING VARIABLE
	!	F1$:PASS #1 OUTPUT FILE NAME
	!	F2$:PASS #2 OUTPUT FILE NAME
	!	H% :UTILITY VARIABLE
	!	I% :UTILITY VARIABLE
	!	J$ :JOB NUMBER STRING
	!	J% :UTILITY VARIABLE
	!	K% :NUMBER OF LINES IN PROGRAM
	!	K0%:NUMBER OF LINES TO RESEQUENCE
	!	K1%:SORTING VARIABLE
	!	K2%:COUNTER USED IN FNL%
	!	L% :POSITION OF NEW LINE NUMBER IN LIST F0%(3200)
	!	L$ :DUMMY VARIABLE, STRING SEARCHED BY FNL%
	!	L1$:L$ WITHOUT SPACES, TABS, CR/LF, ETC.
	!	M% :SWITCH OPTION TO MULTIPLY OR ADD IN RESEQUENCE 
	!	N$ :STRING REPRESENTING NUMBER TO RESEQUENCE
	!	N1$:UTILITY VARIABLE
	!	P$ :NEW PROTECTION CODE FOR F$, IF DESIRED
	!	P% :LOCATION OF N$ IN L1$
	!	P0%:PASS COUNTER
	!	P1%:UTILITY VARIABLE
	!	Q% :STARTING POINT FOR FNL% SEARCH
	!	Q1%:LOCATION OF N$ IN S$
	!	R% :INCREMENT OF RESEQUENCING
	!	S$ :STRING TO ADJUST FOR RESEQUENCING
	!	S% :NEW STARTING LINE NUMBER
	!	T% :NUMBER TO BE CHECKED FOR RESEQUENCING
	!	T1%:NUMBER TO CHECK IF FILE F$ IS IN ORDER
	!	U$ :STRING REPLACING OLD VALUE OF T%
	!	Z% :LENGTH OF INITIAL LINE NUMBER

4	!
	! L I S T S
	!
	!	B0%(3200):OLD VALUES OF LINE NUMBERS
	!	F0%(3200):NEW VALUES OF LINE NUMBERS
	!	F%(7)    :VALUES OF TARGET LINES FOUND IN L1$
	!	T$(7)    :STRINGS USED IN FNL% SEARCH
	!	Y%(7)    :POSITIONS OF NUM1$(F%(7))
10	!*** LINES 10-70: FNL%(L$,Q%) -- GET TARGET LINE NUMBER ***

15	DEF FNL%(L$,Q%)
	\Z%=0%
	\K2%=1%
	\L1$=CVT$$(L$,1%+2%+4%+32%+256%)

20	FOR J%=1% TO 7%
	\P%=Q%
	!INITIALIZE POSITION FOR SEARCH START

25	P%=INSTR(P%,L1$,T$(J%))
	\GOTO 50 IF P%=0%
	\N$=""
	\I%=0%
	\P%=P%+LEN(T$(J%))

30	N1$=MID(L1$,P%+I%,1%)
	\GOTO 40 IF J%>5% AND N1$>="<" AND N1$<=">"
	\GOTO 45 IF N1$<"0" OR N1$>"9"
	\N$=N$+N1$

35	I%=I%+1%
	\GOTO 30
	!FIND NUMERICAL CHARACTERS FOR STRING N$

40	P%=P%+1%
	\GOTO 30
	!DISREGARD <, =, AND > FOR RESEQUENCING ERL AND LINE VALUES

45	IF N$<>"" GOTO 60 ELSE P%=P%+1%
		\GOTO 25
		!MAKE SURE N$ HAS A VALUE

50	NEXT J%
	\GOTO 65 IF Z%>0%

55	F%(K2%)=-1%
	\GOTO 70
	!INDICATOR THAT NO MORE LINE NUMBERS EXIST IN STRING L1$

60	Z%=Z%+1%
	\Y%(Z%)=P%
	\F%(Z%)=VAL(N$)
	\GOTO 50
	!STORE POSITION OF TARGET NUMBER IN LINE
	!STORE VALUE OF POSSIBLE NUMBER TO RESEQUENCE

65	A%,P%=Y%(1%)
	\GOTO 70 IF Z%=1%
	\FOR J%=2% TO Z%
	\P%=Y%(J%) IF Y%(J%)<P%
	\K2%=J% IF P%=Y%(J%)
	\NEXT J%
	\A%=P%
	!FIND POSITION OF TARGET NUMBER CLOSEST TO Q%
	!STORE COPY IN A% AND P%

70	FNL%=F%(K2%)
	\FNEND
1000	!*** LINES 1000-1550: GET FILE NAME DATA, SET UP RESEQ DELIMITERS ***

1050	PRINT "RESEQ VER 4A";CHR$(9%);CHR$(9%); IF NOT C%
	\PRINT RIGHT(SYS(CHR$(6%)+CHR$(9%)),3%) IF NOT C%
	\DIM B0%(3200%),F0%(3200%),Y%(7%),F%(7%),T$(7%)
	\OPEN "KB:" FOR INPUT AS FILE 3%
	\ON ERROR GOTO 5050
	\S$=SYS(CHR$(6%)+CHR$(-7%))
	\READ T$(J%) FOR J%=1% TO 7%
	\DATA THEN,ELSE,GOTO,OSUB,SUME,ERL,LINE,
	!GET SYSTEM NAME
	!PRINT PROGRAM HEADER
	!DIMENSION LISTS
	!SET UP ERROR HANDLING ROUTINE
	!SET UP SEARCH LIST FOR FNL%

1100	P0%=0%
	\PRINT CHR$(7%);"#"; IF NOT C%
	\INPUT LINE #3%,F$ IF NOT C%
	\F$=CVT$$(F$,-1%)
	\GOTO 8000 IF LEFT(F$,2%)="/H"
	\GOSUB 1400
	\GOSUB 1450
	\F$=F$+".BAS" IF INSTR(1%,F$,".")=0%
	\OPEN F$ FOR INPUT AS FILE 1%
	!SET PASS COUNTER TO ZERO
	!CHECK FOR CCL ENTRY
	!GET FILE NAME IF NOT IN CCL
	!GO TO "HELP" ROUTINE IF REQUESTED
	!TRY TO OPEN FILE

1150	PRINT CHR$(7%) IF C%
	\INPUT #3%,"*";S$
	\N1$=S$
	\GOTO 1500 IF INSTR(1%,S$,"*")
	\M%=0%
	\H%=INSTR(1%,S$,"-")
	\I%=INSTR(1%,S$,"=")
	\J%=INSTR(1%,S$,"+")
	\B%,F%,R%,S%=0%
	\GOTO 5300 IF (H%>I% OR H%>J%) AND I%*J%>0%
	\GOTO 5300 IF H%>0% AND I%=0% AND J%>0%
	\GOSUB 1250 IF J%>0%
	\GOTO 1200 IF H%=0% AND I%=0%
	\GOSUB 1300 IF I%>0%
	\GOSUB 1350 IF H%>0%
	\B%=VAL(S$)
	\GOTO 2100
	!INPUT COMMAND STRING
	!PUT COPY INTO N1$
	!GET DATA FOR RESEQ FROM STRING S$
	!CHECK FOR LEGALITY OF RESEQ FORMAT
	!SET RESEQ PARAMETERS TO ZERO
	!GO TO APPROPRIATE SUBROUTINES TO EXTRACT RESEQ DATA

1200	B%=1%
	\S%=VAL(S$)
	\GOTO 2100
	!START RESEQUENCE AT FIRST LINE

1250	R%=VAL(RIGHT(S$,J%+1%))
	\S$=LEFT(S$,J%-1%)
	\RETURN
	!GET RESEQUENCE INCREMENT

1300	S%=VAL(RIGHT(S$,I%+1%))
	\S$=LEFT(S$,I%-1%)
	\RETURN
	!GET NEW INITIAL LINE NUMBER

1350	F%=VAL(RIGHT(S$,H%+1%))
	\S$=LEFT(S$,H%-1%)
	\RETURN
	!GET LOWER BOUND OF RESEQ LIMITS

1400	P$=""
	\RETURN IF INSTR(1%,F$,"<")=0%
	\P$=RIGHT(F$,INSTR(1%,F$,"<"))
	\F$=LEFT(F$,INSTR(1%,F$,"<")-1%)
	\RETURN
	!GET NEW PROTECTION CODE, IF SPECIFIED

1450	D$=""
	\RETURN IF INSTR(1%,F$,":")=0%
	\D$=LEFT(F$,INSTR(1%,F$,":"))
	\RETURN
	!GET DEVICE NAME, IF SPECIFIED

1500	I%=INSTR(1%,S$,"*")
	\R%=VAL(RIGHT(S$,I%+1%))
	\S$=LEFT(S$,I%-1%)
	\M%=-1%
	\H%=INSTR(1%,S$,"-")
	\GOTO 1550 IF H%=0%
	\GOSUB 1350
	\B%=VAL(S$)
	\GOTO 2100
	!CHECK SWITCH OPTION
	!SEND ERROR MESSAGE IF WRONG SWITCH
	!STORE SWITCH MODE IN M%
	!	  0%--STANDARD RESEQUENCE
	!	 -1%--MULTIPLY LINE NUMBERS
	!GET SPECIAL RESEQ DELIMITERS IF M% NOT 0%
	!GO TO REGULAR ROUTINE AT LINE 2100

1550	B%=1%
	\F%=32767%
	!RESEQUENCE WHOLE PROGRAM

2000	!*** LINES 2000-2500: EXECUTE PASS #1 ***

2100	B%=1% IF B%=0%
	\S%=10% IF S%=0%
	\R%=10% IF R%=0%
	\F%=32767% IF F%=0%
	\H%=ASCII(SYS(CHR$(6%)+CHR$(9%)))
	\J$=RIGHT(NUM1$(100%+H%/2%),2%)
	\F1$=D$+"RSQ1"+J$+".TMP"
	\F2$=D$+"RSQ2"+J$+".TMP"
	!ASSIGN DEFAULT VALUES, IF NEEDED
	!GET JOB NUMBER FOR UNIQUE FILENAME
	!GIVE NAMES TO OUTPUT FILES

2200	OPEN F1$ FOR OUTPUT AS FILE 2%
	\P0%=1%
	\K%,K0%,B0%(0%),F0%(0%)=0%
	\T%,T1%=-1%
	\PRINT "PASS #1"
	!OPEN OUTPUT FILE FOR FIRST PASS
	!UPDATE PASS COUNTER
	!INITIALIZE RESEQ LISTS, COUNTER K%

2300	INPUT LINE #1%,S$
	\T1%=T% IF T%>0%
	\GOSUB 6100
	\GOTO 5200 IF T%<=T1% AND T%<>0%
	\K%=K%+1% IF T%<>0%
	\B0%(K%),F0%(K%)=T% IF T%<>0%
	\GOTO 2400 IF T%<B% OR T%>F%
	\K0%=K0%+1%
	\F0%(K%)=S%+R%*(K0%-1%)
	\GOSUB 2500 IF M%
	\GOTO 5350 IF F0%(K%)<0
	\S$=NUM1$(F0%(K%))+RIGHT(S$,Z%+1%)
	!SEND ERROR MESSAGE IF SECTION TO RESEQUENCE IS NOT IN ORDER
	!GO TO PROPER PRINT ROUTINE IF IT ISN'T

2400	PRINT #2%,S$;
	\GOTO 2300
	!GET LINE NUMBER
	!CHECK RESEQUENCE LIMITS
	!STORE OLD AND NEW VALUES
	!GO FOR MORE

2500	F0%(K%)=B0%(K%)*R%
	\RETURN
	!MULTIPLY OLD LINE NUMBER BY R%

3000	!*** LINES 3000-3800: MAIN ROUTINE FOR PASS #2 ***

3100	CLOSE 1%,2%
	\OPEN F1$ FOR INPUT AS FILE 1%
	\KILL F1$
	\PRINT "PASS #2"
	\OPEN F2$ FOR OUTPUT AS FILE 2%
	\P0%=2%
	!SET UP NEW FILES
	!UPDATE PASS COUNTER

3200	INPUT LINE #1%,S$
	\Q%=1%

3300	T%=FNL%(S$,Q%)

3400	C$=RIGHT(L1$,P%)
	\P1%=1%
	\GOTO 3700 IF T%<0%
	\GOSUB 7100
	\GOTO 5150 IF L%<0%
	\GOTO 3500 IF B0%(L%)<>F0%(L%)
	\Q%=A%
	\GOTO 4100
	!INPUT A LINE
	!CHECK STRING WITH FNL% FOR VALUES TO RESEQUENCE
	!GO PRINT IT IF NO VALUES EXIST
	!GO TO MULTIPLE BRANCH CHECK IF VALUE IS NOT RESEQUENCABLE

3500	U$=NUM1$(F0%(L%))
	!STRING FOR NEW VALUE OF TARGET NUMBER

3600	N$=NUM1$(T%)
	\Q1%=INSTR(P1%,S$,N$)
	\C1$=CVT$$(RIGHT(S$,Q1%),295%)
	\GOTO 3800 IF C$<>C1$
	\Q%=Q1%+LEN(N$)
	\S$=LEFT(S$,Q1%-1%)+U$+RIGHT(S$,Q%)
	\Q%=A%
	\GOTO 4100
	!VERIFY POSITION OF NUMBER TO RESEQUENCE IN S$
	!REPLACE N$ WITH U$ IN STRING S$
	!UPDATE POSITION COUNTER Q%
	!GO TO MULTIPLE-LINE GOTO/GOSUB CHECKING ROUTINE

3700	PRINT #2%,S$;
	\GOTO 3200

3800	GOTO 5500 IF Q1%=0%
	\P1%=Q1%+LEN(N$)
	\GOTO 3600
	!CHECK TO SEE IF NUM1$(FNL%) HAS IMBEDDED BLANKS
	!TELL THE PROGRAMMER IF THERE IS ONE, CONTINUE IF NOT
	!ADJUST VALUE OF P1% IF C$<>C1$
	!GO BACK TO SEARCH AGAIN

4000	!*** LINES 4000-4400: MULTIPLE LINE GOTO/GOSUB ROUTINE ***

4100	GOTO 3300 IF INSTR(1%,L1$,"ON")=0%
	\IF MID(C$,LEN(N$)+1%,1%)<>"," GOTO 3300
		ELSE P%=P%+LEN(N$)+1%
		\I%=0%
		\N1$=""
		!CHECK TO SEE IF THIS LINE HAS AN "ON ..." STATEMENT
		!CHECK TO SEE IF PROGRAM IS AT THAT STATEMENT

4200	N$=MID(L1$,P%+I%,1%)
	\GOTO 4400 IF N$<"0" OR N$>"9"
	\N1$=N1$+N$

4300	I%=I%+1%
	\GOTO 4200
	!FIND NUMERICAL VALUES IN L1$

4400	IF I%=0% GOTO 3300
		ELSE T%=VAL(N1$)
		\N$=N1$
		\GOTO 3400
		!MULTIPLE LINE GOTO/GOSUB ROUTINE. RETURNS POSITION P% IN
		!STRING L1$ OF THE NEXT NUMBER FOR A MULT. LINE BRANCHING
		!PROVIDED ONE EXISTS

5000	!*** LINES 5000-5600: ERROR HANDLING ROUTINE ***

5050	IF ERR<>11% GOTO 5100
		ELSE IF P0%=0% GOTO 32200
			ELSE IF P0%=1% THEN RESUME 3100
				ELSE CLOSE 1%,2%
				\RESUME 32100
				!END-OF-FILE ERROR ROUTINE

5100	IF ERL<>1100% OR ERR=28% GOTO 5250
		ELSE PRINT "?Error--";
		\PRINT RIGHT(SYS(CHR$(6%)+CHR$(9%)+CHR$(ERR)),4%)
		\C%=0%
		\RESUME 1100
		!MESSAGE FOR FILE OPENING ERROR

5150	PRINT "%Error--Can't find line #";T%
	\U$=NUM1$(T%)+"?"
	\GOTO 3600
	!ERROR MESSAGE WHEN WHOLE FILE RESEQUENCED. INFORMS PROGRAMMER THAT A
	!TARGET LINE WAS SPECIFIED BUT NOT FOUND

5200	PRINT "?Error--File not in order"
	\CLOSE 1%,2%
	\KILL F1$
	\GOTO 32200
	!FATAL ERROR. LINE NUMBERS WERE EDITED IN PROGRAM. TYPE 'OLD (F$)'
	!AND 'REPLACE' BEFORE RESEQUENCING F$.

5250	IF ERR<>52% GOTO 5400
		ELSE RESUME 5300
		!CLEAR ERROR FLAG

5300	PRINT "%Error--RESEQ format is 'A-B=C+D' or 'A-B*D', not ";N1$
	\P0%=0%
	\GOTO 1150
	!ERROR IN RESEQ INSTRUCTION FORMAT

5350	PRINT "%Error--New line number range <0 or >32767"
	\P0%=0%
	\GOTO 1150
	!ERROR IN MULTIPLICATION

5400	IF ERR<>28% GOTO 5550
		ELSE IF D$="" GOTO 5450
			ELSE IF P0%=1% THEN KILL F1$
			ELSE IF P0%=2% THEN KILL F2$
			!KILL TEMP FILES IF NOT ON PUBLIC DISK

5450	CLOSE 1%,2%
	\GOTO 32200
	!CLOSE FILES
	!GET OUT OF CTRL/C TRAP

5500	H%=0%
	\H%=H%+1% UNTIL C$=CVT$$(RIGHT(S$,H%),295%)
	\H%=H%+1%
	\S$=LEFT(S$,H%-1%)+CVT$$(MID(S$,H%,LEN(N$)),2%)+RIGHT(S$,H%+LEN(N$))
	\P1%=1%
	\GOTO 3600
	!SCAN FOR INTENDED LOCATION
	!TRIM EXCESS BLANKS FROM STRING
	!RESTORE TEMPORARY POINTER
	!CHECK AGAIN FOR TARGET LINE NUMBER

5550	IF ERL<>8100% THEN ON ERROR GOTO 0
	!CHECK FOR PROTECTION VIOLATION ON "HELP" FILE

5600	PRINT "?No HELP available"
	\RESUME 32200 IF C%
	\RESUME 1100
	!MAKE SURE ERROR IS AT LINE 8000, SEND ERROR MESSAGE IF NOT
	!TELL HIM THERE'S NO HELP AVAILABLE
	!GET OUT OF PROGRAM IF CCL
	!GET ANOTHER FILE NAME IF NOT CCL

6000	!*** LINES 6000-6300: INITIAL LINE NUMBER FINDING SUBROUTINE ***

6100	Z%=0%
	!INITIALIZE POSITION COUNTER

6200	Z%=Z%+1%
	\A%=ASCII(RIGHT(S$,Z%))
	\GOTO 6200 IF (Z%>1% AND (A%=9% OR A%=32%)) OR (A%>47% AND A%<58%)
	\Z%=Z%-1%
	!SEARCH INPUT STRING, CHECK FOR END OF STATEMENT NUMBER
	!IGNORE SPACES AND TABS

6300	A$=CVT$$(LEFT(S$,Z%),128%)
	\Z%=LEN(A$)
	\T%=VAL(A$)
	\RETURN
	!RETURN VALUE OF STATEMENT NUMBER
	!T%=0% IF PROGRAM IS IN EXTEND MODE

7000	!*** LINES 7000-7300: SEARCH SUBROUTINE ***

7100	F1%=0%
	\K1%=K%
	!SET UP DELIMITERS FOR SEARCH ROUTINE

7200	B1%=(F1%+K1%)/2%
	\GOTO 7300 IF B0%(B1%)=T%
	\F1%=B1%+1% IF B0%(B1%)<T%
	\K1%=B1%-1% IF B0%(B1%)>T%
	\IF F1%>K1% THEN B1%=-1% ELSE 7200
	!BINARY SEARCH
	!GET OUT OF ROUTINE IF OLD LINE NUMBER FOUND
	!SET B1% TO -1% IF OLD NUMBER NOT FOUND

7300	L%=B1%
	\RETURN
	!POINT TO THE OLD VALUE IN LIST B0%, IF IT EXISTS

8000	!*** LINES 8000-8300: PRINT "HELP" MESSAGE ***

8100	OPEN "$RESEQ.TXT" FOR INPUT AS FILE 1%
	!OPEN THE "HELP" FILE

8200	INPUT LINE #1%,R$
	\PRINT #3%,R$;
	\GOTO 8300 IF INSTR(1%,R$,"RESEQ.TXT")
	\GOTO 8200
	!INPUT A LINE
	!PRINT IT FOR USER
	!GET OUT OF LOOP IF LAST LINE IN "HELP" FILE
	!CONTINUE IF THERE IS MORE TO PRINT

8300	PRINT #3%
	\CLOSE 1%
	\GOTO 1100 IF NOT C%
	\GOTO 32200
	!CLOSE THE "HELP" FILE
	!GET ANOTHER FILE NAME TO RESEQUENCE IF NOT CCL MODE
	!EXIT PROGRAM IF IN CCL

30000	!*** LINES 30000-30300: CCL ENTRY ***

30100	C%=-1%
	\F$=SYS(CHR$(7%))
	!SET CCL FLAG
	!GET COMMON CORE STRING

30200	FOR I%=10% TO 1% STEP -1%
	\N1$=LEFT("RESEQUENCE",I%)
	\GOTO 30300 IF INSTR(1%,F$,N1$)
	\NEXT I%

30300	F$=CVT$$(RIGHT(F$,I%+1%),-1%)
	\C%=0% IF F$=""
	\GOTO 1050
	!EXTRACT FILE NAME
	!REPEAL CCL IF NO FILE DESIGNATED
	!GO TO MAIN ROUTINE

32000	!*** LINES 32000-32767: END-OF-PROGRAM ***

32100	KILL F$
	\NAME F2$ AS F$+P$
	\GOTO 1100 IF NOT C%
	!KILL ORIGINAL FILE
	!NAME TEMP FILE AS ORIGINAL FILE WITH PROT. CODE P$
	!SET UP FOR NEXT RUN IF NOT IN CCL

32200	CLOSE 3%
	\S$=SYS(CHR$(9%))
	!CLOSE KB INPUT FILE
	!GET PROGRAM OUT OF MEMORY

32767	END
