(********************************************************)
(* This is the main program which generates the fuseplot*)
(* and the jedec output for PAL 20RA10. It has been     *)
(* divided into four parts ---                          *)
(*    1) Reconstr_pin_list                              *)
(*        This part reconstructs the pin list from the  *)
(*        parser tree generated by PARSER.pas program.  *)
(*        The parse tree is resident in SPECSTRE.DAT    *)
(*    2) Reconstr_eqn                                   *)
(*        This parts reconstructs the equation tree     *)
(*        from the parse tree. Each id_node in the      *)
(*        eqntree points to the corresponding node in   *)
(*        the pin_list.                                 *)
(*     3) Xplot                                         *)
(*         Generates the xplot for the device.          *)
(*     4) Jedec                                         *)
(*         Generates the jedec formatted output         *)
(*                                                      *)
(*   Input files : user defined | default - specstre.dat*)
(*   output files :user defined | default - xplot.dat   *)
(*                 user defined | default - jedec.dat   *)
(********************************************************)

program ra2010 (input,output);

label 100;

(* $INCLUDE:'TYPE.IBM' *)

var      pinlist : chip_ptr;
         eqntree : tree_ptr;
         specstre,xplot,jedec1 :text;
         fusemap : fusearray;
         pol_map : polarray;
         errflag : boolean;
         filename: packed array [1..12] of char;
         i,j : integer;
         ch : char;

function int_to_string(value1:integer):chstring;external;

procedure write_eqn (eqnptr:tree_ptr);external;

procedure error (eqnptr:tree_ptr;
                 errsym : chstring;
                errnum : integer;
                var errflag :boolean);external;

procedure reconstr_pin_list (var pinlist:chip_ptr;
                             var f:text);external;

procedure reconstr_eqn (var eqntree:tree_ptr;
                        var pinlist:chip_ptr;
                        var errflag:boolean;
                        var f:text);external;

procedure fuseplot (var pinlist:chip_ptr;
                         eqnptr: tree_ptr;
                    var fusemap:fusearray;
                    var pol_map:polarray;
                    var errflag:boolean;
                    var f:text);external;

procedure jedec (var fusemap : fusearray;
                 var pol_map : polarray;
                 var pinlist : chip_ptr;
                 var f : text);external;
begin
 WRITELN ('PALASM V1.9A - (C) COPYRIGHT 1984, MONOLITHIC MEMORIES INC');
 WRITELN ('Backend for 20RA10 PAL');
 WRITELN;

 for i:= 1 to 12 do filename[i]:=' ';
 errflag:=false;
 assign (specstre,'specstre.dat');
 reset (specstre);
 i:=1;
 while (not eoln(specstre)) do
 begin
  read(specstre,ch);
  if ch<>' ' then
  begin
   filename[i]:=ch;
   i:=i+1;
  end;
 end;

 readln(specstre);
 filename[i]:='.';
 filename[i+1]:='x';
 filename[i+2]:='p';
 filename[i+3]:='t';
 assign (xplot, filename);
 filename[i]:='.';
 filename[i+1]:='j';
 filename[i+2]:='e';
 filename[i+3]:='d';

 assign (jedec1,filename);
 rewrite (xplot);
 rewrite(jedec1);
 reconstr_pin_list (pinlist,specstre);
 reset(specstre);
 readln(specstre);
 reconstr_eqn (eqntree,pinlist,errflag,specstre);
 if errflag then goto 100;
 fuseplot(pinlist,eqntree^.rsibling,fusemap,pol_map,errflag,xplot);
 if errflag then goto 100;
 jedec (fusemap,pol_map,pinlist,jedec1);

 write( 'The xplot is saved in file ==> ');
 for j:=1 to i-1 do write (filename[j]);
 write('.xpt');
 writeln;
 write( 'The jedec is saved in file ==> ');
 for j:=1 to i-1 do write(filename[j]);
 write('.jed');
 writeln;
100: end.

 write( 'The jedec is saved in file ==> ');
 for j:=1 to i-1 do