      HED SERIAL TELETYPE PACKAGE
*
*  MODIFY PBS FOR SERIAL TELETYPE
*
     ORG 15073B
*
SRIAL LDA SM11      SET
      LDB LST5A       TTY PUNCH
      JSB SETIA,I       ADDRESSES
      ISZ IOADA,I   INCREMENT SELECT CODE
      LDA SM5       SET
      LDB LST6A       TTY READER
      JSB SETIA,I       ADDRESSES
      LDA TT.IS     SET INTERRUPT
TI6   STA TTYI        CELL
*
      LDA TTYPI     SET OUTPUT
      STA COR1A,I
      STA COR3A,I     TELETYPE CALLS
      STA DMP1A,I
      STA GETAA,I       TO SERIAL
      STA GET2A,I
      STA CRL1A,I         DRIVER
*
      LDA STF0      SET INPUT
      STA COR2A,I
      STA GET1A,I     TELETYPE CALLS
      ISZ COR2A
      ISZ GET1A         TO SERIAL
      LDA TTYII
      STA COR2A,I         DRIVER
      STA GET1A,I
      ISZ COR2A
      ISZ GET1A
      LDA CLF0
      STA COR2A,I
      STA GET1A,I
*
      CLA           CLEAR
      STA TP9A,I
      ISZ TP9A        BUFFERED TELETYPE
      STA TP9A,I
      STA TP10A,I       INSTRUCTIONS
      STA DMP2A,I
      ISZ DMP2A
      STA DMP2A,I
*
      LDA STOUA     SET FOR POSSIBLE
      STA TOUTA,I     TTY PUNCHING
*
      LDA LST7A     USE READER AND PUNCH
      STA PHRLA,I     DRIVERS IN
      LDA LST8A         SERIAL TELETYPE
      STA PNCLA,I         PACKAGE
      SKP
      LDA ROFFA     PREPARE TO SET
      STA PHR1A,I     INTERRUPT-OFF INSTRUCTIONS
      LDA POFFA         IN SERIAL TELETYPE
      STA NOR1A,I         PACKAGE
*
      LDA SLWMT     SET SERIAL
      STA LWAM
      LDA SLWMR       TELETYPE VALUES
      STA LWMRA,I
      LDA SLWMP         IN LWAM CONSTANTS
      STA LWMPA,I
      LDA STTYP
      STA 102B
      LDA STTYI
      STA 104B
      LDA SIOFF
      STA IMOFF
      LDA SION
      STA IMON
*
*  OVERLAY PARALLEL DRIVERS WITH SERIAL DRIVERS
*
SRIA1 LDA MOVES,I   MOVE A
      STA DESTS,I     WORD
      ISZ MOVES     BUMP
      ISZ DESTS       POINTERS
      ISZ SMCNT     SERIAL DRIVERS MOVED?
      JMP SRIA1     NO
      JMP PHRDA,I   YES, RETURN TO MAIN SEQUENCE
      SPC 5
*
*  SUBROUTINE (STOUT) TO OUTPUT ONE CHARACTER TO THE
*  TELETYPE.  CHARACTER IS IN (A).  (B) IS NOT ALTERED.
*
STOUT NOP
      STA TCHAR
      LDA SM11      SET BIT
      STA BCNT        COUNTER
      LDA TCHAR
      ALS           ADD
      IOR B3000       CONTROL BITS
TP7   STC TTY       TURN ON TELETYPE
TP8   OTA TTY,C     OUTPUT BIT
      RAR           POSITION NEXT BIT
TP9   SFS TTY       WAIT FOR
      JMP *-1         COMPLETION FLAG
      ISZ BCNT      DONE?
      JMP TP8       NO
TP10  CLC TTY       YES, TURN OFF TELETYPE
      JMP STOUT,I
      SKP
*
*  MODIFICATION ADDRESSES
*
PHR1A DEF PHRD1
NOR1A DEF NORD1
COR1A DEF CORA1
COR2A DEF CORA2
COR3A DEF CORA3
DMP1A DEF DUMP1
DMP2A DEF DUMP2
GETAA DEF GETAD+1
GET1A DEF GETA1
GET2A DEF GETA2
CRL1A DEF CRLF1
TP9A  DEF TP.9-1
TP10A DEF TP.10
TOUTA DEF PNCHO
LWMRA DEF LWAMR
LWMPA DEF LWAMP
PHRLA DEF LST2A
PNCLA DEF LST3A
*
*  MODIFICATION INSTRUCTIONS
*
TTYPI JSB .TTYP
TTYII JSB .TTYI
STF0  STF 0
CLF0  CLF 0
STOUA DEF STOUT
ROFFA STA .ROFF
POFFA STA .POFF
SLWMT DEF .TTYI-1+2000B   LWAM OPTIONS
SLWMR DEF HSPR-1+2000B      FOR SERIAL
SLWMP DEF SPNCH-1+2000B       TELETYPE
STTYP DEF .TTYP+2000B
STTYI DEF .TTYI+2000B
SIOFF DEF .IOFF+2000B
SION  DEF .ION+2000B
*
*  COMMUNICATION LINKS
*
SETIA DEF SETI
IOADA DEF IOADR
PHRDA DEF PHRDR
*
*  LOCAL CONSTANTS AND ADDRESSES
*
SM5   DEC -5
TT.IS JSB TLINK,I   TTY INTERRUPT INSTRUCTION
MOVES DEF SPNCH
DESTS DEF SPNCH+2000B
SMCNT ABS SPNCH-SPROC
      SKP
*
*  TELETYPE OUTPUT INSTRUCTION LIST
*
LIST5 DEF TP2-1
      DEF TP2
      DEF TP2+2
      DEF TP3-1
      DEF TP3
      DEF TP5
      DEF TP6
      DEF TP7
      DEF TP8
      DEF TP9
      DEF TP10
*
LST5A DEF LIST5
*
*  TELETYPE INPUT INSTRUCTION LIST
*
LIST6 DEF TI2
      DEF TI3
      DEF TI4
      DEF TI5
      DEF TI6
*
LST6A DEF LIST6
*
*  PHOTOREADER INSTRUCTION LIST
*
LIST7 DEF PR.3+2000B
      DEF PR.5+2000B
      DEF PR.6+2000B
      DEF PR.7+2000B
      DEF RO
*
LST7A DEF LIST7
*
*  HIGH-SPEED PUNCH INSTRUCTION LIST
*
LIST8 DEF PN.2+2000B
      DEF PN.3+2000B
      DEF PN.4+2000B
      DEF PN.6+2000B
      DEF PO
*
LST8A DEF LIST8
      HED BASIC SYSTEM HIGH SPEED PUNCH DRIVER
*
************** BASIC SYSTEM HIGH SPEED PUNCH DRIVER ***************-
*
*  OUTPUTS ASCII THROUGH THE HIGH SPEED PUNCH
*
*  CALL:  JSB 103B,I
*
*        (A) = NUMBER OF CHARACTERS TO BE PUNCHED
*        (B) = STARTING ADDRESS OF BUFFER
*
*
*     IF (A) IS >= 0  THEN OUTPUT (A) CHARACTERS
*     FOLLOWED BY A CARRIAGE RETURN-LINE FEED.
*
*     IF (A) < 0 THEN PUNCH -(A) CHARACTERS ONLY.
*
*     BUFFER CONTAINS ASCII CHARACTERS PACKED TWO PER WORD.
*
*     IF (B) = 0 OK ENTRY (A) FEED FRAMES ARE PUNCHED.
*     IF (A) = 0 OK ENTRY ONLY A CR/LF IS PUNCHED.
*
*
SPNCH NOP
      JSB SINIT     INITIALIZE FOR PUNCHING
PN.1  JSB SGTCH     GET NEXT CHARACTER FROM BUFFER
      JMP PN.5      BUFFER EMPTY
PN.2  OTA PNCH      LOAD PUNCH BUFFER
PN.3  STC PNCH,C    GIVE PUNCH COMMAND
PN.4  SFS PNCH
      JMP *-1       WAIT FOR PUNCH READY
      JMP PN.1      GET NEXT CHARACTER
*
PN.5  LDA SIORI
      STA SFNSH+1   RESTORE IOR INSTRUCTION
PN.6  CLC PNCH      TURN OFF PUNCH
      SEZ,CLE,RSS   RECORD COMPLETE? CLEAR E
      JMP SPNCH,I   E=0, OUTPUT COMPLETE
      LDA SM2       E=1, APPEND CR AND LF
      LDB SCRLA     LOAD ADDRESS OF CR AND LF
      JMP SPNCH+1   DO CR/LF
      HED BASIC SYSTEM HIGH SPEED PHOTO READER DRIVER
*
*************** BASIC SYSTEM PHOTO READER DRIVER  ******************
*
*  INPUTS TAPE RECORDS THROUGH THE PHOTO READER
*
*  CALL:  JSB 101B,I
*
*        (A) =  MAXIMUM NUMBER CHARS IN RECORD
*        (B) =  BUFFER STARTING ADDRESS
*
*   ON RETURN  (A)= -1  TOO MANY CHARACTERS IN RECORD
*              (A)= -2  END OF TAPE DETECTED
*              (A)= -3  NO TAPE OR GATE DOWN
*              (A)= NUMBER OF CHARACTERS IN RECORD
*
*           INPUT IS PACKED TWO CHARACTERS PER WORD IN BUFFER.
*
*           ALL RECORDS MUST BE TERMINATED WITH A LINE FEED.
*           THE NULL AND CARRIAGE RETURN CHARACTERS ARE IGNORED.
*
*           THE LEFT ARROW(S) - DELETE THE PREVIOUS CHARACTER(S).
*
*           AN ALT MODE ANYWHERE BEFORE THE LINE FEED DELETES ALL
*           CHARACTERS IN THE RECORD. THE RECORD IS IGNORED.
*
*      IF 10 NULL CHARACTERS ARE DETECTED BEFORE ANY CHARACTER,
*      READING IS TERMINATED AND THE RETURN IS WITH A NULL RECORD.
*
*
HSPR  NOP
      STA SCONT     SAVE LENGTH
      STB SBFSA     SAVE BUFFER STARTING ADDRESS
PR.1  LDA SM11
      STA SEOTC     INITIALIZE EOT COUNTER
      LDB SBFSA
      STB SBDDR     INITIALIZE BUFFER POINTER
      CLB           INITIALIZE CHARACTER COUNT
PR.2  SZB,RSS       ANY NON-NULL CHARACTERS YET?
      SZA           NO, SKIP IF NULL
      JMP PR.3
      ISZ SEOTC     COUNT NULL
      JMP PR.3      NOT 10 NULLS
      LDA SM2       SET A TO INDICATE EOT (-2)
      JMP PR.7      10 NULLS, TURN OFF READER & EXIT
PR.3  STC RDR,C     REQUEST CHARACTER
      CLA           SET DELAY COUNT
PR.4  INA,SZA,RSS   DELAY = 6.4 * 65K = .41 SECONDS
      JMP PR.8      (A)=0, NO TAPE OR GATE DOWN
PR.5  SFS RDR
      JMP PR.4      NO FLAG, CHECK DELAY COUNT
PR.6  LIA RDR,C     LOAD CHARACTER
      JSB SPROC     PROCESS CHARACTER
      JMP PR.2      GET NEXT CHARACTER
      CPB SM2       RUBOUT IN THIS RECORD?
      JMP PR.1      YES, IGNORE RECORD
PR.7  CLC RDR       TURN OFF READER
      JMP HSPR,I
*
PR.8  LDA SM3       LOAD 'NO TAPE' STATUS
      JMP PR.7
      HED BASIC SYSTEM TELETYPE INPUT DRIVER
*
******************* BASIC SYSTEM TELETYPE INPUT DRIVER *************
*
*   INPUTS FROM AN ASR 33/35 THROUGH THE
*   TELETYPE CONTROL BOARD FROM TAPE OR KEYBOARD.
*
*    CALL:  JSB 104B,I
*
*        (A) =  MAXIMUM NUMBER CHARS IN RECORD
*        (B) =  BUFFER STARTING ADDRESS
*
*    RETURN:   (A)= -1  TOO MANY CHARACTERS IN RECORD
*              (A)= -2  RECORD DELETED
*              (A)= NUMBER OF CHARACTERS IN RECORD
*
*
*           THE CHARACTERS ARE PACKED TWO TO A WORD IN THE BUFFER.
*
*           ALL RECORDS MUST BE TERMINATED WITH A LINE FEED.
*           THE NULL AND CARRIAGE RETURN CHARACTERS ARE IGNORED.
*
*           THE LEFT ARROW(S) - DELETE THE PREVIOUS CHARACTER(S).
*
*           AN ALT MODE ANYWHERE BEFORE THE LINE FEED DELETES ALL
*           CHARACTERS IN THE RECORD. THE RECORD IS IGNORED.
*
*
.TTYI NOP
      STA SCONT     SAVE LENGTH
      STB SBDDR     SAVE BUFFER ADDRESS
      CLB           ZERO CHARACTER COUNT
      LDA TP5       SET
      STA OUTB        ECHO
TI1   JSB TTINT     INITIALIZE FOR INPUT CHARACTER
      LDA BITS      WAIT FOR
      SZA             CHARACTER
      JMP *-2           COMPLETE
      LDA TCHAR     PROCESS
      JSB SPROC       CHARACTER
      JMP TI1       GET NEXT CHARACTER
      CLB           CLEAR
      STB OUTB        ECHO
      JMP .TTYI,I
      SKP
*
*  THIS SECTION PROCESSES EACH BIT AS IT BECOMES AVAILABLE.
*  RETURN THROUGH 105B IF THE INTERRUPT MODE FLAG IS SET UPON
*  CHARACTER COMPLETION.
*
I.TTY NOP
      STA ATEMP     SAVE (A)
TI2   LIA TTYI,C    MERGE
      IOR TCHAR       NEW BIT
      RAR               INTO
      STA TCHAR           CHARACTER
      ALF,ALF       POSITION BIT
      RAL,RAL         FOR ECHO
OUTB  NOP           OUTPUT INSTRUCTION
      ISZ BITS      BIT 11?
      JMP EXIT      NO
TI3   CLC TTYI      YES
      LDA TCHAR     ALIGN
      ALF,RAR         COMPLETED
      STA TCHAR         CHARACTER
      LDA STOPI     STOP FLAG
      SZA,RSS         SET?
      JMP EXIT      NO
      LDA SIORI     YES, RESTORE
      STA SFNSH+1     IOR INSTRUCTION
      JSB I.STP,I   GO TO STOP
EXIT  LDA ATEMP     RESTORE (A)
      JMP I.TTY,I
*
ATEMP NOP
BITS  NOP
TCHAR NOP
*
TP5   OTA TTY       ECHO BIT INSTRUCTION
      SPC 5
*
*  THIS ROUTINE INITIALIZES THE SERIAL TELETYPE INPUT ROUTINE
*  AND SETS TELETYPE TO ACCEPT INPUT.
*
TTINT NOP
      LDA SM11      SET
      STA BITS        BIT COUNTER
TI4   STC TTYI,C    DEMAND INPUT
      CLA           ZERO OUT
      STA TCHAR       CHARACTER REPOSITORY
      JMP TTINT,I
      HED BASIC SYSTEM TELETYPE OUTPUT DRIVER
*
*************** BASIC SYSTEM TELETYPE OUTPUT DRIVER ***************-
*
*    OUTPUTS ASCII RECORDS THROUGH THE TELETYPE PRINTER,
*    PUNCH, OR BOTH.
*
*    CALL:  JSB 102B,I
*
*          (A) = NUMBER OF CHARACTERS TO BE OUTPUT
*          (B) = STARTING ADDRESS OF BUFFER
*
*
*     IF (A) IS >= 0  THEN OUTPUT (A) CHARACTERS
*     FOLLOWED BY A CARRIAGE RETURN-LINE FEED.
*
*     IF (A) < 0 THEN PUNCH -(A) CHARACTERS ONLY.
*
*     BUFFER CONTAINS ASCII CHARACTERS PACKED TWO PER WORD.
*
*     IF (B) = 0 OK ENTRY OUTPUT (A) FEED FRAMES.
*     IF (A) = 0 OK ENTRY ONLY A CR/LF IS OUTPUT.
*
*
.TTYP NOP
      JSB SINIT     INITIALIZE FOR OUTPUT
TP1   LDA SM11      SET BIT
      STA BCNT        COUNTER
      JSB SGTCH     FETCH NEXT CHARACTER FROM BUFFER
      JMP TP4       BUFFER EMPTY
      ALS           ADD BIT 7 AND
      IOR B3000       CONTROL BITS
      STC TTY       REQUEST PRINT
TP2   OTA TTY,C     OUTPUT BIT
      RAR           POSITION NEXT BIT
      SFS TTY       WAIT FOR
      JMP *-1         BIT OUT FLAG
      ISZ BCNT      CHARACTER OUT?
      JMP TP2       NO
      CLC TTY       YES, TURN OFF TTY
TP3   STF TTY       SET FLAG BUFFER (RESETS TIMER)
      JMP TP1
*
TP4   LDA SIORI     RESTORE IOR
      STA SFNSH+1     INSTRUCTION
      SEZ,CLE,RSS   DONE?
      JMP .TTYP,I   YES
      LDA SM2       NO
      LDB SCRLA     DO CR/LF
      JMP .TTYP+1
*
BCNT  NOP
B3000 OCT 3000
      SKP
*
*      THIS ROUTINE TURNS OFF THE TELETYPE INTERRUPT MODE
*
.IOFF NOP
TI5   CLC TTYI      TURN OFF KEYBOARD
TP6   CLC TTY       TURN OFF PRINTER
.ROFF NOP           SET TO CLC RDR IF READER EXISTS
.POFF NOP           SET TO CLC PNCH IF PUNCH EXISTS
      CLA           CLEAR
      STA STOPI       STOP FLAG
      JMP .IOFF,I
      SPC 5
*
*      THIS ROUTINE TURNS ON THE TELETYPE INTERRUPT MODE
*
.ION  NOP
      CCA           SET STOP FLAG
      STA STOPI       FOR INTERRUPTS
      JSB TTINT     ENABLE KEYBOARD
      JMP .ION,I
*
STOPI NOP           STOP FLAG (INITIALIZED OFF)
      HED CHARACTER PROCESSING SECTION FOR INPUT
*
*  CHARACTER PROCESSING SECTION FOR TTY AND PHOTOREADER
*
*      CALL:   JSB PROCS
*              (A) HOLDS CHARACTER
*
*      RETURN:    P+1 - GET NEXT CHARACTER
*                 P+2 - RECORD COMPLETE
*
SPROC NOP
      AND SB177     STRIP BIT 7
      SZA,RSS       NULL?
      JMP SPROC,I   YES, IGNORE
      CPA S.2       NO, CONTROL B?
      JMP SPROC,I   YES, IGNORE
      CPA S.3       NO, CONTROL C?
      JMP SPROC,I   YES, IGNORE
      CPA SLNFD     NO, LINE FEED?
      JMP SPROC,I   YES, IGNORE
      CPA SB177     NO, RUBOUT?
      JMP SPROC,I   YES, IGNORE
      CPA SAMDE     NO, ALT MODE?
      JMP SCMPL-1   YES, CANCEL RECORD
      CPA SOMDE     NO, OLD ALT MODE?
      JMP SCMPL-1   YES, CANCEL RECORD
      CPA SEMDE     NO, ESCAPE MODE?
      JMP SCMPL-1   YES, CANCEL RECORD
      CPA SCRTN     NO, CARRIAGE RETURN?
      JMP SCMPL     YES, COMPLETE RECORD
      CPB SCONT     NO, BUFFER OVERFLOW?
      CCB           YES, LOOK FOR CARRIAGE RETURN
      SSB           LOOKING FOR CARRIAGE RETURN?
      JMP SPROC,I   YES, RETURN
      CPA SLFTA     NO, LEFT ARROW?
      JMP SDLTE     YES, DELETE PREVIOUS CHARACTER
      SLB,INB       NO, CHECK ODD/EVEN FLAG
      JMP SPRO2     B0 = 0, EVEN CHARACTER
SPRO1 ALF,ALF       B0 = 1, ODD CHARACTER
      STA SBDDR,I   RECORD HIGH CHARACTER
      JMP SPROC,I
SPRO2 IOR SBDDR,I   PACK TWO CHARACTERS
      STA SBDDR,I   PUT IN BUFFER
      ISZ SBDDR     INDEX BUFFER ADDRESS POINTER
      JMP SPROC,I
      SKP
*
*  THIS SECTION DELETES PREVIOUS CHARACTER(S)
*
SDLTE SZB,RSS       IS BUFFER EMPTY?
      JMP SPROC,I   YES, RETURN
      CCA           NO
      ADB 0         DECREMENT CHARACTER COUNT
      SLB,RSS       LOW CHARACTER?
      JMP SPROC,I   YES
      ADA SBDDR     NO, DECREMENT
      STA SBDDR       ADDRESS POINTER
      LDA SBDDR,I   GET LAST TWO CHARACTERS
      ALF,ALF
      AND SB177     DELETE LAST CHARACTER
      JMP SPRO1     STORE NEXT-TO-LAST CHARACTER
*
*  THIS SECTION PUTS COUNT IN A AND RETURNS TO P+2
*
      LDB SM2       SET DELETE STATUS
SCMPL LDA 1         PUT CHARACTER COUNT INTO (A)
      ISZ SPROC
      JMP SPROC,I
      SPC 5
*
*  SUBROUTINE  GETCH
*
*    RETURN IO P+1 ON EMPTY BUFFER
*    IF THE BUFFER IS NOT EMPTY, ELSE
*    RETURN TO P+2 WITH CHARACTER IN (A).
*
SGTCH NOP
      CPB SCONT
      JMP SGTCH,I   BUFFER EMPTY, P+1 RETURN
      LDA SBDDR,I   GET TWO CHARACTERS
      SLB,RSS
      ALF,ALF       B EVEN, POSITION CHARACTER RIGHT
      SLB,INB       CHECK O/E, AND INDEX COUNT
      ISZ SBDDR     B ODD, INCREMENT ADDRESS POINTER
SFNSH AND SB177     STRIP LEFT CHARACTER
      IOR SB200     ADD BIT 7
      ISZ SGTCH
      JMP SGTCH,I   RETURN TO P+2
      HED 
*
*  INITIALIZES FOR OUTPUTTING A RECORD
*
SINIT NOP
      CCE,SSA       SET E=1, CHECK FOR (A) < 0
      CMA,CLE,INA   SET (E) = 0, (A) = -(A)
      STA SCONT     SAVE CHARACTER COUNT
      STB SBDDR     SAVE BUFFER STARTING ADDRESS
      SZA
      SZB           LEADER/TRAILER ONLY?
      JMP *+4       NO
      LDA SCLAI     YES, (B) = 0
      STA SFNSH+1   SET CLEAR INSTRUCTION
      CLE           SET NO CR/LF
      CLB           INITIALIZE OUTPUT COUNT
      JMP SINIT,I
      HED DATA, ADDRESSES, ETC.
*
*  COMMON DRIVER CONSTANTS AND ADDRESSES
*
SM11  DEC -11
SM3   DEC -3
SM2   DEC -2
S.2   DEC 2
S.3   DEC 3
SLNFD OCT 12        LINE FEED
SCRTN OCT 15        CARRIAGE RETURN
SEMDE OCT 33        ESCAPE
SLFTA OCT 137       LEFT ARROW
SOMDE OCT 175       OBSOLETE ALT MODE
SAMDE OCT 176       ALT MODE
SB177 OCT 177       RUBOUT
SB200 OCT 200
SCLAI CLA
SIORI IOR SB200     ADD IN BIT 7
*
SCRLA DEF SCRLF
SCRLF OCT 106612
*
SBFSA NOP           INITIAL BUFFER ADDRESS
SBDDR NOP           CURRENT BUFFER ADDRESS
SCONT NOP           HOLDS RECORD LENGTH
SEOTC NOP           END-OF-TAPE COUNTER
*
      END
