      HED EXECUTE THE PROGRAM
*
***                    ***
**  EVALUATE A FORMULA  **
***                    ***
*
FORMX NOP           FORMULA BEGINS IN (TEMPS)
      CLB           INITIALIZE OPERATOR
      JSB SLWST       STACK
FORM1 LDA TEMPS,I   FETCH OPERAND
      ISZ TEMPS     SET FOR NEXT WORD OF FORMULA
      AND OPDMK     EXTRACT OPERAND
      STA TEMPS+6     AND SAVE IT
      SZA,RSS       NULL OPERAND?
      JMP FORM2     YES
      JSB BHSTP     SET STACK FOR OPERAND ADDRESS
      SSA           FLAG BIT SET?
      JMP FORM4     YES
      JSB SSYMA,I   FETCH OPERAND ADDRESS
      INB,SZB,RSS   EXISTANT?
      JMP E8M1A,I   NO
      AND .15       YES
      CPA .15         FUNCTION?
      JMP FORM6     YES
      STB HSTPT,I   NO, STACK OPERAND ADDRESS
FORM2 LDA TEMPS,I   FETCH
      AND OPMSK       OPERATOR
      ALF,ALF       POSITION IT
      LDB 0         LOAD ADDRESS OF
      ADB FOPBS       OPERATOR'S INFORMATION WORD
      ADA M8        NON-FORMULA
      SSA             OPERATOR?
      CLB           YES
      ADA D53       NO, NON-FORMULA
      SSA,RSS         OPERATOR?
      CLB           YES
      CLA           NO
      LDA 1,I       LOAD INFORMATION WORD
      AND MSK1      SAVE
      STA TEMPS+7     PRECEDENCE
      XOR 1,I       SAVE
      ARS
      STA TEMPS+6     IDENTIFICATION
      JMP FOR11
FORM0 STA TSTPT,I   STACK HIGH WORD
      LDA TSTPT     STACK OPERAND
      STA HSTPT,I     ADDRESS
      INA           STORE
      STB 0,I         LOW WORD
FOR11 LDA LSTPT,I   DOES OPERATOR
      AND MSK0        ON TOP OF
      CMA               OPERATOR STACK
      ADA TEMPS+7         HAVE HIGHER
      SSA                   PRECEDENCE?
      JMP FORM9     YES, EXECUTE IT
      RSS           NO
FOR10 ISZ LSTPT
      LDB TEMPS+7   RETRIEVE PRECEDENCE
      ADB M15       NO, LEFT PARENTHESIS
      SSB             OR LEFT BRACKET?
      ADB .15       NO, RESTORE PRECEDENCE
      ADB TEMPS+6   COMBINE IDENTIFICATION
      JSB SLWST       WITH PRECEDENCE AND STACK
      JMP FORM1
FORM4 CPA FLGBT     CONSTANT?
      JMP FORM5     YES
      AND .15       NO, PRE-DEFINED
      CPA .15       FUNCTION
      JMP FORM7     YES
      LDB TEMPS+9   NO, MUST BE A
      JMP FORM2-1     PARAMETER
FORM5 LDB TEMPS     LOAD CONSTANT ADDRESS
      ISZ TEMPS     MOVE POINTER TO
      ISZ TEMPS       NEXT CODE WORD
      JMP FORM2-1
FORM6 STB TEMPS+6   SAVE SYMBOL TABLE POINTER
      LDB TSTPT     SAVE CURRENT POINTER
      JSB SLWST       TO TEMPORARY STACK
      LDB TEMPS+6,I
      JSB SLWST     SAVE FUNCTION ADDRESS
      LDA FORMX     SAVE CURRENT
      STA HSTPT,I     FORMX RETURN ADDRESS
      JSB FORMX     EVALUATE THE PARAMETER
      ISZ TEMPS     UPDATE FORMULA POINTER
      ISZ TEMPS       PAST RIGHT PARENTHESIS
      LDA TEMPS     SWITCH
      LDB LSTPT,I     FORMULA POINTER
      STB TEMPS         TO FUNCTION'S
      STA LSTPT,I         FORMULA
      LDB TEMPS+9   SET
      LDA HSTPT,I     PARAMETER POINTER
      ISZ LSTPT         TO NEW PARAMETER,
      ISZ HSTPT           SAVING PREVIOUS
      STB LSTPT,I           SETTING ON
      STA TEMPS+9             LOW-CORE STACK
      CPA TSTPT     PROTECT PARAMETER IF
      JSB RSCHK       ON TEMPORARY STACK
      JSB FORMX     EVALUATE FUNCTION
      LDA LSTPT,I   RESTORE OLD
      STA TEMPS+9     PARAMETER POINTER
      LDA LSTPT     CUT BACK
      ADA M3          LOW-CORE
      STA LSTPT         STACK
      INA           RESTORE ORIGINAL
      LDB 0,I         TEMPORARY STACK
      STB TSTPT         POINTER
      INA           RESTORE
      LDB 0,I         ORIGINAL
      STB TEMPS         FORMULA POINTER
      JSB STTOP     POP RESULT
      SKP
*
**  PRE-DEFINED FUNCTIONS RETURN HERE WITH RESULT
*
FOR12 STA TSTPT,I   STORE HIGH WORD
      LDA TSTPT
      INA           STORE
      STB 0,I         LOW WORD
      ISZ HSTPT
      LDB HSTPT,I   RESTORE FORMX
      STB FORMX       RETURN ADDRESS
      ADA M1        STACK ADDRESS
      STA HSTPT,I     OF RESULT
      JMP FORM2
FORM7 LDA TEMPS+6   COMPUTE
      ALF,ALF
      ALF             FUNCTION
      AND .31
      ADA PDFBS         ADDRESS
      LDB 0,I
      JSB SLWST     SAVE FUNCTION ADDRESS
      LDA FORMX     SAVE CURRENT
      STA HSTPT,I     FORMX RETURN ADDRESS
      JSB FORMX     EVALUATE THE PARAMETER
      ISZ TEMPS     UPDATE FORMULA POINTER
      ISZ TEMPS       PAST RIGHT PARENTHESIS
      LDB LSTPT,I   POP
      CCA             FUNCTION
      ADA LSTPT         ENTRY
      STA LSTPT           ADDRESS
      STB ESYMT     SAVE
      JSB STTOP     POP PARAMETER
      JMP ESYMT,I   EVALUATE FUNCTION
FORM9 LDA LSTPT,I   UNSTACK
      CCB             OPERATOR
      ADB LSTPT         INFORMATION
      STB LSTPT           WORD
      ALF,ALF       COMPUTE
      AND B177        SUBROUTINE
      ADA ARBAS         ADDRESS
      JMP 0,I       EXECUTE
**
***  EXECUTION BRANCH TABLE  **
**
XECTB DEF ELET      LET
      DEF XEC4      DIM
      DEF XEC4      COM
      DEF XEC4      DEF
      DEF XEC4      REM
      DEF EGOTO     GO TO
      DEF EIF       IF
      DEF EFOR      FOR
      DEF ENEXT     NEXT
      DEF EGOSB     GOSUB
      DEF ERTRN     RETURN
      DEF RDYDA,I   END
      DEF RDYDA,I   STOP
      DEF EWAIT     WAIT
      DEF ECALL     CALL
      DEF XEC4      DATA
      DEF EREAD     READ
      DEF EPRIN     PRINT
      DEF EINPT     INPUT
      DEF ERSTR     RESTORE
      DEF EMAT      MAT
*
* *************************
****                     ***
***  EXECUTE THE PROGRAM  ***
****                     ***
* *************************
*
**
***INITIALIZE FOR OUTPUT  **
**
XEC   CLA           SET COUNTER FOR
      STA TYPE        CHARACTERS OUTPUTTED
      STA XH        INITIALIZE
      INA             RANDOM
      STA XL            VARIABLE
**
***  INITIALIZE THE DATA POINTER  **
**
      CCA           SET
      STA DCCNT       'NO
      STA DSTRT         DATA'
      LDB PBUFF           CONDITION
      STB NXTDT
      LDA ADATA,I   SEARCH FOR FIRST
      JSB STSRH       DATA STATEMENT
      JMP XEC2      NONE FOUND
      STB DSTRT     SAVE STATEMENT LOCATION
      JSB SETDP     SET DATA POINTER
**
***  INITIALIZE STACK POINTERS  **
**
XEC2  LDB SYMTF     INITIALIZE
      STB HSTPT       POINTERS TO
      LDB FCORE          'HIGH CORE' STACK,
      STB TSTPT             'TEMPORARY'
      ADB .23                 STACK, AND
      STB LSTAK                 'LOW CORE'
      STB LSTPT                   STACK
      CMB           DO
      ADB HSTPT       STACKS
      SSB               MEET?
      JMP E1        YES
      LDB RMODE     NO, SHIFT TO
      STB LISTR       RUN MODE
      LDB PBUFF     BEGIN
      JMP XEC5        EXECUTION
      SKP
**
***  FIND NEXT STATEMENT TO BE EXECUTED  **
**
XEC4  LDA NXTST     NEXT STATEMENT NUMBER
      LDB PRADD     PROSPECTIVE ADDRESS
      CPA 1,I       DESIRED STATEMENT?
      JMP XEC6      YES
      LDB PBUFF     NO, FIND
      JSB FNDPA,I     STATEMENT
      NOP           NON-EXISTENT
      JSB ERROR       STATEMENT
XEC5  LDA 1,I       SAVE NEW
XEC6  STA .LNUM       SEQUENCE NUMBER
**
***  SET SUCCESSOR STATEMENT  **
**
      JSB FLWST
      AND OPMSK     EXTRACT STATEMENT TYPE
      ALF,ALF       POSITION
      RAR             IT
      ADA XECBR     COMPUTE EXECUTION ADDRESS
      JMP 0,I       BRANCH TO EXECUTION CODE
**
***  EVALUATE FORMULA AND RETURN RESULT  **
**
FETCH NOP
      JSB FORMA,I   EVALUATE FORMULA
      JSB OPCHK
      ISZ HSTPT     UNSTACK RESULT ADDRESS
      LDA 1,I       LOAD (A) WITH HIGH MANTISSA
      INB           LOAD LOW PART
      LDB 1,I         OF RESULT INTO (B)
      JMP FETCH,I   EXIT
**
***  SET POINTER TC START OF DATA STATEMENT  **
**
SETDP NOP           STATEMENT ADDRESS IN (B)
      INB           LOAD
      LDA 1,I         STATEMENT LENGTH
      CMA,INA       SET
      INA             DATA COUNTER
      STA DCCNT         TO 1-STATEMENT LENGTH
      INB           SET 'NEXT DATA' POINTER ONE
      STB NXTDT       WORD ABOVE FIRST CONSTANT
      JMP SETDP,I
**
***  SEARCH FOR STATEMENT OF GIVEN TYPE  **
**
STSRH NOP           TYPE IN (A), ADDRESS IN (B)
      AND OPMSK     EXTRACT
      STA TEMP4       STATEMENT TYPE
STSR1 LDA 1         EXTRACT
      ADA .2          PROGRAM
      LDA 0,I           STATEMENT
      AND OPMSK           TYPE
      CPA TEMP4     DESIRED TYPE?
      JMP STSR2     YES
      LDA 1         NO, FETCH
      INA             STATEMENT LENGTH
      ADB 0,I       COMPUTE NEW ADDRESS
      CPB PBPTR     PAST LAST STATEMENT?
      JMP STSRH,I   YES
      JMP STSR1     NO
STSR2 ISZ STSRH
      JMP STSRH,I
**
***  FETCH A DATA ITEM  **
**
FDATA NOP
FDAT1 ISZ DCCNT     MORE DATA?
      JMP FDAT2     YES
      LDA ADATA,I   NO, SEARCH
      LDB NXTDT       FOR NEXT
      JSB STSRH         DATA STATEMENT
      JSB ERROR     NONE FOUND
E4    JSB SETDP     INITIALIZE THE
      JMP FDAT1       DATA POINTERS
FDAT2 ISZ DCCNT     UPDATE
      ISZ DCCNT       POINTER
      ISZ NXTDT
      LDA NXTDT,I   LOAD
      ISZ NXTDT       DATA
      LDB NXTDT,I       ITEM
      ISZ NXTDT     UPDATE POINTER
      JMP FDATA,I
**
***  SET FOR FOLLOWING STATEMENT  **
**
FLWST NOP           (B) HOLDS PRESENT ADDRESS
      LDA 1         COMPUTE
      INA             ADDRESS
      LDA 0,I           OF
      ADA 1               NEXT
      STA PRADD             STATEMENT
      LDA 0,I       RECORD THE
      STA NXTST       SEQUENCE NUMBER
      ADB .2        FETCH
      STB TEMPS       FIRST WORD
      LDA 1,I           OF CURRENT
      JMP FLWST,I         STATEMENT
**
***  SEARCH STACK FOR GIVEN FOR-VARIABLE  **
**
FVSRH NOP
      LDA TEMPS,I   FETCH
      AND MSK1        FOR-VARIABLE
      STA EDELM     SAVE FOR-VARIABLE
      JSB SSYMA,I   FIND ADDRESS IN
      INB             SYMBOL TABLE
      LDA HSTPT     SAVE
      STA TEMP3       STACK TOP
FVSR1 CPA SYMTF     STACK BOTTOM?
      JMP FVSRH,I   YES, EXIT VIA (P+1)
      CPB 0,I       MATCHING FOR-VARIABLE?
      JMP FVSR2     YES
      ADA .6        NO, MOVE TO
      JMP FVSR1       NEXT STACK ENTRY
FVSR2 ISZ FVSRH     EXIT
      JMP FVSRH,I     VIA (P+2)
*
***             ***
**  EXECUTE LET  **
***             ***
*
ELET  JSB FORMA,I
      JMP XEC4
*
***               ***
**  EXECUTE GO TO  **
***               ***
*
EGOTO INB           LOAD SEQUENCE
      LDA 1,I         NUMBER
      JMP XEC4+1    FIND REFERENCED STATEMENT
*
***            ***
**  EXECUTE IF  **
***            ***
*
EIF   JSB FETCA,I   FETCH VALUE OF FORMULA
      SZA,RSS       RESULTANT TRUE?
      JMP XEC4      NO
      ISZ TEMPS     YES, BRANCH TO
      LDB TEMPS       FOLLOWING
      JMP EGOTO         SEQUENCE NUMBER
*
***             ***
**  EXECUTE FOR  **
***             ***
*
EFOR  JSB FVSRH     FOR-VARIABLE ALREADY IN STACK?
      JMP EFOR1     NO
      STA TEMP2     YES, SAVE SOURCE ADDRESS
      ADA .6        SAVE
      STA TEMP4       DESTINATION ADDRESS
      STB TEMP1     SAVE FOR-VARIABLE ADDRESS
      JSB MVTOH     COMPRESS STACK
      LDB TEMP1     RESTORE FOR-VARIABLE ADDRESS
      CLA           COMPUTE
      CLA,RSS       COMPUTE
EFOR1 LDA M6          NEW TOP OF
      ADA HSTPT         FOR-STACK
      STA HSTPT           POINTER
      STA TEMP1
      CMA,INA       STACK
      ADA LSTPT
      SSA,RSS         OVERFLOW?
      JMP E1        YES
      STB TEMP1,I   NO, RECORD FOR-VARIABLE ADDRESS
      JSB FORMA,I   INITIALIZE FOR-VARIABLE
      ISZ TEMPS
      ISZ TEMP1     SAVE
      LDA TEMP1       LIMIT
      STA ENEX2         ADDRESS
      JSB FETCA,I   FETCH
      STA TEMP1,I     AND
      ISZ TEMP1         STORE
      STB TEMP1,I         LIMIT
      ISZ TEMP1
      LDB M2        SET FOR STEP SIZE
      STB FDATA       SIGN CHECK
      LDA TEMPS,I   LOOK FOR
      SZA             FOLLOWING ' STEP'
      JMP EFOR2     FOUND
      LDA HONE      NOT FOUND,
      LDB .2          DEFAULT
      RSS               IS 1.0
EFOR2 JSB FETCA,I
      SSA           STEP SIZE NEGATIVE?
      ISZ FDATA     YES
      STA TEMP1,I   SAVE
      ISZ TEMP1       STEP
      STB TEMP1,I       SIZE
      ISZ TEMP1     SET POINTER
      LDA NXTST       TO STATEMENT
      STA TEMP1,I       FOLLOWING THE FOR
EFOR3 LDA ANEXT,I   FIND
      LDB PRADD       'NEXT'
      JSB STSRH         STATEMENT
      NOP
      JSB FLWST     FIND FOLLOWING STATEMENT
      AND MSK1      SAME
      CPA EDELM       FOR-VARIABLE?
      RSS           YES
      JMP EFOR3     NO
      LDB HSTPT,I   LOAD
      LDA 1,I         VALUE
      INB               OF
      LDB 1,I             FOR-VARIABLE
      JMP ENEX2-1   CHECK ACCEPTABILITY
*
***              ***
**  EXECUTE NEXT  **
***              ***
*
ENEXT JSB FVSRH     FIND CORRESPONDING STACK ENTRY
      JMP XEC4      NONE PRESENT
      STA HSTPT     RESET TOP OF STACK
      STB ENEX1     SAVE FOR-VARIABLE ADDRESS
      INA           SAVE LIMIT
      STA ENEX2       ADDRESS
      ADA .2        SAVE STEP SIZE
      STA TEMP1       ADDRESS
      LDB M2        SET STEP SIZE
      STB FDATA       SIGN CHECK
      LDA TEMP1,I   LOAD
      ISZ TEMP1       STEP
      LDB TEMP1,I       SIZE
      ISZ TEMP1
      SSA           CHECK
      ISZ FDATA       SIGN
      JSB .FAD      INCREMENT
ENEX1 NOP           FOR-VARIABLE
      STA ENEX1,I       AND
      ISZ ENEX1           SAVE
      STB ENEX1,I           VALUE
      JSB .FSB      COMPUTE FOR-VARIABLE - LIMIT
ENEX2 NOP
      ISZ FDATA     POSITIVE STEP SIZE?
      ELA           YES, COMPLEMENT SIGN
      SSA           NO, NON-NEGATIVE RESULT?
      JMP ENEX3     NO
      LDA TEMP1,I   YES, GO TO FIRST
      JMP XEC4+1      STATEMENT OF LOOP
ENEX3 LDA HSTPT     FAILS,
      ADA .6          ERASE
      STA HSTPT         STACK
      JMP XEC4            ENTRY
*
***               ***
**  EXECUTE GOSUB  **
***               ***
*
EGOSB INB           LOAD (A) WITH
      LDA 1,I         SEQUENCE NUMBER
      LDB NXTST     LOAD (B) WITH
      STA NXTST       RETURN SEQUENCE NUMBER
      JSB SLWST     STACK RETURN ON LOW-CORE STACK
      ADA M10       GOSUBS NESTED
      CPA LSTAK       10 DEEP?
      JSB ERROR     YES
E2    JMP XEC4      NO
*
***                ***
**  EXECUTE RETURN  **
***                ***
*
ERTRN LDB LSTPT     RETURN STACK
      CPB LSTAK       EMPTY?
      JSB ERROR     YES
E3    LDA LSTPT,I   NO, LOAD RETURN ADDRESS
      ADB M1        RESET
      STB LSTPT       STACK POINTER
      JMP XEC4+1
      SKP
*
***              ***
**  EXECUTE WAIT  **
***              ***
*
EWAIT ISZ TEMPS     POINT (TEMPS) TO FORMULA
      JSB FETCA,I   FETCH EVALUATED FORMULA
      SSA           NEGATIVE?
      JMP XEC4      YES
      JSB IFIX      CONVERT TO INTEGER
      CLA,INA       LARGE INTEGER
      SZA,RSS       SMALL
      CMB,SSB,RSS     INTEGER?
      LDB MNEG      NO
EWAI1 INB,SZB,RSS   WAIT?
      JMP XEC4      NO
      LDA M310      YES, SET INNER LOOP
      INA,SZA       MORE?
      JMP *-1       YES
      JMP EWAI1     NO
*
***              ***
**  EXECUTE CALL  **
***              ***
*
ECALL ISZ TEMPS     FETCH
      ISZ TEMPS       SUBROUTINE
      LDB TEMPS,I       NUMBER
      JSB FNDSB     FIND
      INB             ENTRY
      LDB 1,I           POINT AND
      STB TEMPS+11        SAVE IT
      LDA HSTPT     SAVE HIGH CORE
      STA TEMPS+10    STACK POINTER
ECAL1 ISZ TEMPS     ANY
      LDA TEMPS,I     PARAMETERS
      CPA B4000         LEFT?
      JMP ECAL2     NO
      JSB FORMA,I   YES, EVALUATE
      JMP ECAL1       A PARAMETER
ECAL2 CCA           LOAD ADDRESS OF
      ADA TEMPS+10    PARAMETER ADDRESSES
      JSB TEMPS+11,I    AND BRANCH TO SUBROUTINE
      LDA TEMPS+10  RESTORE
      STA HSTPT
      LDB FCORE     POINTERS
      STB TSTPT
      JMP XEC4
      SKP
*
***              ***
**  EXECUTE READ  **
***              ***
*
EREAD CPB PRADD     END-OF-STATEMENT?
      JMP XEC4      YES
      JSB FORMA,I   NO, EVALUATE NEXT ADDRESS
      LDA HSTPT,I   RECORD
      STA OUTLN       ADDRESS
      JSB FDATA     GET DATA ITEM
      STA OUTLN,I   STORE
      ISZ OUTLN       DATA
      STB OUTLN,I       ITEM
      ISZ HSTPT
      LDB TEMPS
      INB
      JMP EREAD
**
***  INITIALIZE FOR PRINT  **
**
PRNIN NOP
      CCA           INITIALIZE
      ADA .BUFA       BUFFER
      STA BADDR         POINTER
      LDA TYPE      INITIALIZE
      CMA,INA         'CHARACTERS OUTPUTTED'
      STA CCNT          COUNTER
      SLA,RSS       START ON ODD CHARACTER POSITION?
      JMP PRNIN,I   NO
      ADA M1        YES, BIAS
      STA CCNT        COUNTER
      CLA           OUTPUT A
      JSB OUTCR       NULL CHARACTER
      JMP PRNIN,I
*
***               ***
**  EXECUTE PRINT  **
***               ***
*
EPRIN JSB PRNIN     SET FOR PRINT
      CLA           TURN ON
      JMP EPRI1+1     'END-OF-LINE' FLAG
EPRI0 CLA           EXECUTE COMMA
      CPA EOL         IF NOT FOLLOWING
      JSB EDELM         A TAB
EPRI1 CCA           TURN OFF
      STA EOL         'END-OF-LINE' FLAG
      LDA TEMPS,I   EXTRACT
      AND OPDMK       OPERAND
      SZA           NULL?
      JMP EPRI3     NO, FORMULA OR TAB
EPRI2 ISZ TEMPS     YES
      LDB TEMPS     MORE
      CPB PRADD       STATEMENT?
      JMP EPRI7     NO
      LDA TEMPS,I   YES, EXTRACT
      AND OPMSK       NEXT OPERATOR
      CPA B2000     ',' ?
      JMP EPRI0     YES
      CPA B3000     NO, ')' ?
      JMP EPRI1     YES
      CPA B1000     NO, * ?
      JMP EPRI4     YES
      CCA           NO, MUST BE +,-, OR (
      ADA TEMPS     BACKUP TO PRIOR
      STA TEMPS       NULL OPERAND
EPRI3 CCA           SET
      STA EOL         TAB FLAG
      JSB FETCA,I   EVALUATE
      ISZ EOL       TAB?
      JMP EPRI2     YES
      JSB ENOUT     NO, PRINT NUMBER
      JMP EPRI2
EPRI4 CLA           TURN ON
      STA EOL         'END-OF-LINE' FLAG
      STA SLWST     ZERO
      STA OUTLN       CHARACTER COUNT
EPRI5 LDA 1,I
      AND MSK0      NON-NULL
      SZA,RSS         LOW CHARACTER?
      JMP EPRI6     NO
      ISZ OUTLN     YES, COUNT IT
      INB
      LDA 1,I
      AND OPMSK
      CPA B1000     * NEXT?
      JMP EPRI6     YES
      ISZ OUTLN     NO, COUNT HIGH CHARACTER
      JMP EPRI5
EPRI6 LDB OUTLN     WILL
      ADB CCNT        LINE
      ADB M73           EXCEED
      SSB,RSS             72 CHARACTERS?
      JSB OUTLN     YES, GET FRESH LINE
      JSB OUTSA,I   OUTPUT STRING
      JMP EPRI1+2
EPRI7 ISZ EOL       'END-OF-LINE' ?
      JMP EPRI8     YES
      LDB TYPE      NO, LOAD COUNT OF
      CMB,INB         CHARACTERS OUTPUTTED
      LDA CCNT      LOAD LINE LENGTH
      CMA,INA       SAVE NEW COUNT OF
      STA TYPE        CHARACTERS OUTPUTTFD
      ADA 1         COMPUTE CHARACTERS NOT YET OUT
      SLB           CORRECT FOR START ON
      ADA M1          ODD PRINT POSITION
      LDB .BUFA     OUTPUT
      SZA             NON-EMPTY
      JSB WRITE,I       BUFFER
      JMP XEC4
EPRI8 JSB OUTLN     PRINT LINE
      JMP XEC4
**
***  TAB TELEPRINTER  **
**
ETAB  JSB IENTA,I   SMALL INTEGER?
      JMP ETAB1     NO
      CLB           YES, SET
      STB EOL         'TAB' FLAG TRUE
      ADA M72       EXCEED
      SSA,RSS         72?
      JMP ETAB1     YES
      CMA,INA       NO, COMPUTE
      ADA M72         BLANKS?
      ADA CCNT          REQUIRED
      SSA,RSS       ANY?
      JMP FR12A,I   NO
      STA OUTLN     YES,
      LDA .32         OUTPUT
      JSB OUTCR         REQUIRED
      ISZ OUTLN           NUMBER
      JMP *-3                OF BLANKS
      JMP FR12A,I
ETAB1 JSB OUTLN     OUTPUT THE
      JMP FR12A,I     LINE
*
IENTA DEF .IENT
*
***               ***
**  EXECUTE INPUT  **
***               ***
*
EINP1 INA,SZA       END-OF-INPUT?
      JSB DRQSA,I   YES, CALL FOR MORE
EINP2 JSB CONST     CONVERT AND STORE NUMBER
      JMP EINP1     NOT NUMBER
      LDB TEMPS     END-OF-
      INB
      CPB PRADD       STATEMENT?
      JMP EINP3     YES
      CPA .10       NO, INSURE MORE INPUT
EINPT JSB DRQSA,I   CALL FOR INPUT
      JSB FORMA,I   COMPUTE VARIABLE ADDRESS
      CCA           STORE
      ADA HSTPT,I     ADDRESS-1
      ISZ HSTPT         IN
      STA SBPTR           POINTER
      JMP EINP2
EINP3 CLA           RESET
      STA TYPE        OUTPUT BUFFER
      JMP XEC4
      SKP
**
***  EXIT FORMULA ON EMPTY STACK  **
**
      DEF FORMX,I
*
***                 ***
**  EXECUTE RESTORE  **
***                 ***
*
ERSTR LDB DSTRT     GET FIRST DATA STATEMENT ADDRESS
      CPB M1        IMPOSSIBLE ADDRESS?
      JMP XEC4      YES, DONE
      JSB SETDP     NO, SET DATA POINTER
      JMP XEC4      DONE
