PROGRAM sine (output);

(* a simple PASCAL program that prints a sine wave *)
(* should compile with any PASCAL compiler         *)
(* tested with:                                    *)
(*     FreePascal Compiler (fpc) under Linux       *)
(*     UCSD Pascal under pSystem II.0 for Z80      *)
(*     Turbo Pascal 3.01 under CP/M-80             *)

CONST
    cols = 79;  (* terminal width *)
    rows = 20;  (*   and height   *)
    dot = '*';
    blank = ' ';
    hline = '-';
    vline = '|';
    pi = 3.14159265;

VAR
    xmax,i1,i2,sinus : integer;
    step : real;
    draw : char;

BEGIN
    xmax := rows DIV 2;
    step := 360/cols;
    FOR i1 := xmax DOWNTO 1 DO  (* draw upper half wave, y>0 *)
    BEGIN
        FOR i2 := 0 TO cols - 1 DO
        BEGIN
            sinus := round(sin(step * i2 * pi / 180) * xmax);
            IF sinus = i1 THEN
                draw := dot
            ELSE
                draw := blank;
            IF i2 = 0 THEN
                IF i1 = xmax THEN
                    draw := '1'
                ELSE
                    draw := vline;
            write(draw)
        END;
        writeln
    END;
    FOR i2 := 0 TO cols - 1 DO  (* draw middle line, y=0 *)
    BEGIN
        IF (i2 MOD 10 = 0) THEN
            draw := vline;
        IF round(sin(step * i2 * pi / 180) * xmax) = 0 THEN
            draw := dot
        ELSE
            draw := hline;
        IF i2 = 0 THEN
            draw := '0';
        write(draw)
    END;
    writeln;
    FOR i1 := 1 TO xmax DO  (* draw lower half wave, y<0 *)
    BEGIN
        FOR i2 := 0 to cols - 1 DO
        BEGIN
            sinus := round(sin(step * i2 * pi / 180) * xmax);
            IF sinus = -i1 THEN
                draw := dot
            ELSE
                draw := blank;
            IF i2 = 0 THEN
                IF i1 = xmax THEN
                    draw := '1'
                ELSE
                    draw := vline;
            write(draw)
        END;
        writeln
    END;
END.
