
/*
** This program attempts to emulate a report generator.  Each of the
** individual functions is performed by a routine (even the simple
** incremenatation of a counter).  This is an attempt to emulate the
** behavior of a real ad hoc report generator.
**
** All functions, i.e., input, totals, sorting, etc., are performed by
** routines because we assume that the overhead associated with a given
** routine, e.g., keeping a running total, is relatively small compared
** to the call overhead.  This is probably not a completely valid
** assumption, e.g., the routine which formats the data for output would
** undoubtedly have to do a fair amount of work.  But, for a small
** benchmark I hope that this provides a reasonable idea of a compiler's
** behavior.
**
** Open a data file, seek to a random position, read a byte, and increment
** a record (character) count.  When the count reaches the appropriate
** size, sort the data. (Even though the data was read as single bytes,
** sort it as four byte entities to make the sort work a little harder.)
** Finally, write the sorted data to a file and count the number of four
** byte data groups written (to emulate keeping totals).
**
** This test can be run in one of two ways depending upon which top level
** routine starts things off.  The sort can either be performed by the
** compiler's library sort routine, or it can be performed by the sort
** routine provided in this code.
*/


#include <stdio.h>
#include "diskio.h"


extern FILE *fopen();
extern long lseek(), ftell();
extern long randpos();

extern long filesize;
extern char test_disk[];


char databuf[RPT_DATASIZE];


int rptcsort (lpcnt)
        int lpcnt;
        {
        return (rpt (lpcnt, 1));
        }



int rptshell (lpcnt)
        int lpcnt;
        {
        return (rpt (lpcnt, 0));
        }



int rpt (lpcnt, cmplsort)
        int lpcnt, cmplsort;
        {
        int strncmp();

        FILE *inf, *outf;
        int items;
        char idf[80], odf[80];


/* First, create the proper pathnames.
*/
        strcpy (idf, test_disk);
        strcat (idf, INFILE);
        strcpy (odf, test_disk);
        strcat (odf, OUTFILE);


        timestart ();
        while (lpcnt--)
                {


/* Open up the input and output files and find out how large the file is.
*/
                if ((inf = fopen (idf, "r")) == NULL)
                        return 0x8000;

                if ((outf = fopen (odf, "w")) == NULL)
                        return 0x8000;

                fseek (inf, 0L, 2);
                filesize = ftell (inf);


/* Read the data into the data buffer.  Then, sort the data, using the
** compiler's library sort routine or the sort routine included in this
** file.  Finally, write the report using the sorted data.
*/
                if ((items =
                     rd_data (inf, databuf, RPT_DATASIZE, RPT_ELSIZE)) == 0)
                        return 0x8000;

                if (cmplsort)
                        qsort (databuf, items, RPT_ELSIZE, strncmp);
                else
                        shellsort (databuf, items, RPT_ELSIZE, strncmp);

                if (wrt_rpt (outf, databuf, items, RPT_ELSIZE) == 0)
                        return 0x8000;

                fclose (inf);
                fclose (outf);
                }

        return (timend ());
        }



/*      rd_data
**
** This routine reads the data into the data buffer for sorting.
*/


int rd_data (inf, buf, bufsize, elsize)
        FILE *inf;
        char *buf;
        int bufsize, elsize;
        {
        int recsize, reccnt;


        reccnt = 0;
        while (bufsize > 0)
                {
                if ((recsize = get_rec (inf, buf, elsize)) == 0)
                        return 0;
                reccnt++;
                buf += recsize;
                bufsize -= recsize;
                }
        return reccnt;
        }



int get_rec (inf, buf, elsize)
        FILE *inf;
        char *buf;
        int elsize;
        {
        long pos;


        pos = randpos ();
        fseek (inf, pos, 0);
        if (fread (buf, elsize, 1, inf) == 1)
                return elsize;  /* size of the read */
        else
                return 0;
        }



/*      wrt_rpt
**
** Write a file containing the fake data.  Use fprintf to get in a little
** of the record formatting overhead.
*/


int wrt_rpt (outf, buf, items, elsize)
        FILE *outf;
        char *buf;
        int items, elsize;
        {
        int reccnt;


        reccnt = 0;
        while (items--)
                {
                if (fprintf (outf, "%.*s\n", elsize, buf) == 0)
                        return 0;
                reccnt++;
                buf += elsize;
                up_totals (reccnt);
                }
        return reccnt;
        }



/* This routine is in place just to increase the overhead a little
*/

up_totals (cnt)
        int cnt;
        {
        long reccount, totals;

        totals += cnt;
        reccount++;
        }



/*      shellsort
**
** Do a shell sort on a bunch of data which is all stuffed together in a buffer.

**
** On entry:
**      dp              char *, Pointer to the data to sort
**      nitems          int, Number of items
**      elsize          int, Length of a data item
**      comp            int (*)(), Pointer to the comparison routine
*/


#if 0
shellsort(dp, nitems, elsize, comp)
    char *dp;
    int nitems, elsize, (*comp)();
    {
    register char *lop, *hip;
    int i, gap, low, high;


    for (gap = nitems >> 1;  gap > 0;  gap >>= 1)
        for (i = gap;  i < nitems;  i++)
                for (low = i - gap;  low >= 0;  low -= gap)
                        {
                        if ((*comp) ((lop = dp + (low * elsize)),
                                     (hip = dp + ((low + gap) * elsize)),
                                     elsize) <= 0)
                                break;
                        exchange(lop, hip, elsize);
                        }
    }
#else
shellsort(dp, nitems, elsize, comp)
    register char *dp;
    int nitems, elsize, (*comp)();
    {
    register int low;
    int i, gap, end, miditem;
    char *lop, *hip;


    miditem = nitems >> 1;
    end = (nitems * elsize) - 1;
    for (gap = miditem * elsize;  miditem > 0;  gap = miditem * elsize)
        {
        for (i = gap;  i < end;  i += elsize)
                for (low = i - gap;  low >= 0;  low -= gap)
                        {
                        if ((*comp) ((lop = dp + low),
                                     (hip = dp + (low + gap)), elsize) <= 0)
                                break;
                        exchange (lop, hip, elsize);
                        }
        miditem >>= 1;
        }
    }
#endif



exchange (dp1, dp2, elsize)
        register char *dp1, *dp2;
        int elsize;
        {
        char tmp;


        while (elsize--)
                {
                tmp = *dp1;
                *dp1++ = *dp2;
                *dp2++ = tmp;
                }
        }
