/*      memref.c
**
** These routines run a series of loops incrementing a variable.  The loop
** counters are of various data types.  The intention is to figure out how
** fast the access to them is.  The two regtest routines determine two
** things:
**
**              When compared with autoint, regtest2 shows the effect of
**              register variables.
**
**              regtest5 will show whether or not the compiler does anything
**              clever when you give it more register variables than it can
**              handle.
*/



int lpauto (cnt)
        int cnt;
        {
        int i, j, k, l, var;


        timestart ();

        for (var = 0;  cnt;  cnt--)
                {
                for (i = 0;  i < 10000;  i++)
                        var++;
                for (j = 0;  j < 10000;  j++)
                        var++;
                for (k = 0;  k < 10000;  k++)
                        var++;
                for (l = 0;  l < 10000;  l++)
                        var++;
                }

        return (timend ());
        }




int lpstatic (cnt)
        int cnt;
        {
        static int i, j, k, l, var;


        timestart ();

        for (var = 0; cnt; cnt--)
                {
                for (i = 0;  i < 10000;  i++)
                        var++;
                for (j = 0;  j < 10000;  j++)
                        var++;
                for (k = 0;  k < 10000;  k++)
                        var++;
                for (l = 0;  l < 10000;  l++)
                        var++;
                }

        return (timend ());
        }





int lp2regs (cnt)
        int cnt;
        {
        register int i, var;
        int j, k, l;


        timestart ();

        for (var = 0;  cnt;  cnt--)
                {
                for (i = 0;  i < 10000;  i++)
                        var++;
                for (j = 0;  j < 10000;  j++)
                        var++;
                for (k = 0;  k < 10000;  k++)
                        var++;
                for (l = 0;  l < 10000;  l++)
                        var++;
                }

        return (timend ());
        }





int lp5regs (cnt)
        int cnt;
        {
        register int i, j, k, l, var;


        timestart ();

        for (var = 0;  cnt;  cnt--)
                {
                for (i = 0;  i < 10000;  i++)
                        var++;
                for (j = 0;  j < 10000;  j++)
                        var++;
                for (k = 0;  k < 10000;  k++)
                        var++;
                for (l = 0;  l < 10000;  l++)
                        var++;
                }

        return (timend ());
        }
