/*      math.c
**
** These routines test calculation times for short, long, float and double
** arithmetic.  They do it by calculating the areas of triangles,
** parallelograms and trapezoids.  No source level optimizations are
** performed, e.g., 2 * x is not written as x + x, and x ** 2 is not written
** as x * x.  (If the compiler's optimizer wants to catch anything, that's
** fine.)
*/



/* These tests are so fast, that they need to run a lot of times to get
** any meaningful results.
*/
#define INNER_LOOP      100


int clcint (loop)
        int loop;
        {
        register int base, height;
        int i, area, top;


        base = 2;
        height = 3;
        top = 4;
        timestart ();
        for (  ;  loop;  loop--)
                {
                for (i = 0;  i < INNER_LOOP;  i++)
                        {
                        /* Triangle, parallelogram & trapezoid */
                        area = (base * height) / 2;
                        area = base * height;
                        area = (height * (base + top)) / 2;
                        }
                }
        return (timend ());
        }





int clclong (loop)
        int loop ;
        {
        register long base, height;
        long area, top;
        int i;


        base = 2;
        height = 3;
        top = 4;
        timestart ();
        for (  ;  loop;  loop--)
                {
                for (i = 0;  i < INNER_LOOP;  i++)
                        {
                        /* Triangle, parallelogram & trapezoid */
                        area = (base * height) / 2;
                        area = base * height;
                        area = (height * (base + top)) / 2;
                        }
                }
        return (timend ()) ;
        }





int clcflt (loop)
        int loop;
        {
        register float base, height;
        float area, top;
        int i;


        base = 2;
        height = 3;
        top = 4;
        timestart ();
        for (  ;  loop;  loop--)
                {
                /* Triangle, parallelogram & trapezoid */
                area = (base * height) / 2;
                area = base * height;
                area = (height * (base + top)) / 2;
                }
        return (timend ()) ;
        }





int clcdbl (loop)
        int loop;
        {
        register double base, height;
        double area, top;
        int i;


        base = 2;
        height = 3;
        top = 4;
        timestart ();
        for (  ;  loop;  loop--)
                {
                /* Triangle, parallelogram & trapezoid */
                area = (base * height) / 2;
                area = base * height;
                area = (height * (base + top)) / 2;
                }
        return (timend ()) ;
        }

