CODESEG  segment para public 'code'
         assume cs:CODESEG,ds:CODESEG
;
; BRK or BRKL is expected to be called with one paramter, the
; address of the break-interrupt routine.
;
; The C-language interrupt handler is called with DS and ES
; regs the same as when I'm called.  The CS:IP are provided to
; me as parameters.  All other registers are unpredictable,
; although the stack SS:SP should be usable.  In particular,
; AX, BX, CX, DX, BP, SI, and DI are uninitialized.
;
         public brkkey_
         public brkkeyl_
brkkey   proc  near
brkkey_  label near
         mov   cs:svflag,0
         jmp   short start
brkkeyl_ label far
         mov   cs:svflag,1
         jmp   short start
svnewoff dw    0
svnewseg dw    0
svds     dw    0
sves     dw    0
svflag   db    0
rtnsegl  equ   18h                ; parm3 (large)      +18h
rtnoffl  equ   16h                ; parm2 (large)      +16h
rtnoffs  equ   14h                ; parm2 (small) +14h
                                  ; cs =               +14h
start:                            ; ip = +12h
         push  ds                 ; ds = +10h
         push  es                 ; es = +0eh
         push  di                 ; di = +0ch
         push  si                 ; si = +0ah
         push  bp                 ; bp = +08h
         push  dx                 ; dx = +06h
         push  cx                 ; cx = +04h
         push  bx                 ; bx = +02h
         push  ax                 ; ax = +00h
         mov   bp,sp
         push  cs
         pop   ds
;
         cmp   svflag,0
         jne   short cont17a
;
         push  cs                 ; get parms from small model
         pop   ax
         mov   svnewseg,ax
         mov   ax,[bp+rtnoffs]
         mov   svnewoff,ax
         jmp   short cont17b
cont17a:
         mov   ax,[bp+rtnsegl]    ; get parms from large model
         mov   svnewseg,ax
         mov   ax,[bp+rtnoffl]
         mov   svnewoff,ax
cont17b:
         mov   ax,[bp+10h]
         mov   svds,ax
         mov   ax,[bp+0eh]
         mov   sves,ax
;
         mov   dx,offset brk2     ; Set new break interrupt
         mov   ax,2523h           ;    int23
         int   21h
;
brkret:
         pop   ax
         pop   bx
         pop   cx
         pop   dx
         pop   bp
         pop   si
         pop   di
         pop   es
         pop   ds
         cmp   cs:svflag,0
         je    retn
         db    0cbh               ; far return
retn:
         db    0c3h               ; near return
brkkey   endp
;
;
brk2     proc  far
                                  ; flags = +16h
                                  ; cs = +14h
                                  ; ip = +12h
         push  ds                 ; ds = +10h
         push  es                 ; es = +0eh
         push  di                 ; di = +0ch
         push  si                 ; si = +0ah
         push  bp                 ; bp = +08h
         push  dx                 ; dx = +06h
         push  cx                 ; cx = +04h
         push  bx                 ; bx = +02h
         push  ax                 ; ax = +00h
         mov   bp,sp
         push  cs
         pop   ds
;
         mov   es,sves
         mov   ds,svds
;
         cmp   cs:svflag,0
         jne   cont18
         call  word ptr cs:[svnewoff]
         jmp   short cont19
cont18:  call  dword ptr cs:[svnewoff]
cont19:
;
brk2ret:
         pop   ax
         pop   bx
         pop   cx
         pop   dx
         pop   bp
         pop   si
         pop   di
         pop   es
         pop   ds
;                                   iret indicates not to terminate
;                                   Norton says STC/RETF would terminate
         iret
brk2     endp
;
CODESEG  ends
         end   brkkey
