;  LOAD.ASM - DKeels						07/09/84
;----------------------------------------------------------------------------
;  This program is a driver for all processes within the application.  It
;  gets loaded by DOS, and then loads the program specified in the command
;  line and gives it control.  For example, if "LOAD MAINMENU.EXE" is entered
;  at the command line (or in a batch file), then DOS loads LOAD, and LOAD
;  loads MAINMENU.EXE.  When MAINMENU terminates, control is returned to LOAD,
;  who will then try to execute the first command in the SYSPARM parameter
;  block.  If the first command is null (1st byte=space) then it will try the
;  second command.  If the second command is null, then LOAD will terminate
;  and return control to DOS.  Commands can be placed in the SYSPARM parameter
;  block by application programs to effectively control program chaining, or
;  to execute a DOS command such as "COPY A: B:", and get control back when
;  finished.  (The returned-to program is reloaded from disk.)
;
;  Note that this program uses the SYSPARM parameter block via interrupt 77H.
;  SYSPARM, a resident process, must be executed before LOAD can operate.
;----------------------------------------------------------------------------


CGROUP		GROUP STACK,DATA,CODE		;all addressing based on CS

MEMORY_SIZE	EQU	80H			;NOTE!!! value is dependent
						;on size of LOAD, but only
						;approximately.

STACK		SEGMENT STACK 'STACK'		;----------------- stack
		DB	16 DUP('dkstack ')
TOP_OF_STACK	LABEL	BYTE
STACK		ENDS


DATA		SEGMENT				;------------------- data

PARM_BLOCK	EQU	$
ENV_ADDR	DW	0
CMD_ADDR	DW	0,0
FCB_ADDR1	DW	0,0
FCB_ADDR2	DW	0,0

FILE_NAME	DB	80 DUP(' '),0

COMMAND_STRING	EQU	$
COMMAND_LEN	DB	0
COMMAND		DB	80 DUP(' ')
		DB	13

ERROR_MSG	DB	'** LOAD ERROR **     CODE=$'

SAVE_ES		DW	?
SAVE_SS		DW	?
SAVE_SP		DW	?

PARM_TBL_SEG_ADDR	DW	?		;address of system parameter

DATA		ENDS


CODE		SEGMENT
LOAD		PROC	FAR			;--------------------- code
		ASSUME	CS:CGROUP,DS:CGROUP,ES:CGROUP

	;prologue
		PUSH	CS		;establish data addressability
		POP	DS		;DS -> data
		MOV	SAVE_ES,ES	;ES -> psp
		MOV	SAVE_SS,SS	;SS -> stack

	;get file name to load from psp
		PUSH	DS		;swap DS/ES
		PUSH	ES
		POP	DS		;DS -> psp
		POP	ES		;ES -> data
		MOV	CL,BYTE PTR DS:[80H]	;get psp command line length
		MOV	CH,0		;cx has length of psp command
		MOV	SI,82H		;source offset - psp command line
		LEA	AX,FILE_NAME
		MOV	DI,AX		;destination offset
		CLD
		REP	MOVSB		;move psp command line to file name
		DEC	DI		;backup one byte to carraige return
		MOV	BYTE PTR ES:[DI],0	;make it asciiz string

	;modify allocated memory blocks to make room for new program(s)
	;  ES must have segment of block to modify
	;  BX must have new size of block in paragraphs
		PUSH	ES		;ES -> data
		PUSH	DS		;DS -> psp
		POP	ES		;ES -> psp

		MOV	BX,MEMORY_SIZE
		MOV	AH,4AH
		INT	21H		;free memory
		JC	ERROR
		POP	ES		;ES -> data
		PUSH	ES		;ES -> data
		POP	DS		;DS -> data

	;get and save address of parameter table
		MOV	DX,'dk'
		INT	77H			;get address of parameter tbl
		MOV	PARM_TBL_SEG_ADDR,AX	;save ax (tbl segment address)

	;execution loop - repeat until no more commands, or error occurs
EXEC:
		CALL	EXEC_COMMAND	;execute requested command
		CALL	GET_NEXT_CMD	;else prepare to execute next command
		JMP	EXEC


;-------------- error routine
ERROR:
		POP	DS			;DS -> data
		LEA	DX,ERROR_MSG		;display error message
		MOV	AH,9
		INT	21H
		MOV	DX,AX			;display DOS error code
		ADD     DL,64			;  as alpha character
		MOV     AH,2
		INT     21H
		MOV     DL,0DH			;carriage return
		MOV     AH,2
		INT     21H
		MOV     DL,0AH			;line feed
		MOV     AH,2
		INT     21H
		MOV     AL,99			;set errorlevel to 99
		MOV     AH,4CH			;terminate with error
		INT     21H


;-------------- exit routine
EXIT_LOAD:
		MOV     AL,0			;set error level to 0
		MOV     AH,4CH			;terminate without error
		INT     21H


LOAD     ENDP


;---------------------------------------------------------------------------
;call DOS EXEC function
;---------------------------------------------------------------------------

EXEC_COMMAND	PROC

	;point DS:DX to name of file to load and execute
         	LEA     DX,FILE_NAME

	;point cmd_addr in parmblok to COMMAND_STRING
		MOV	AX,ES
		MOV	CMD_ADDR+2,AX
		LEA	AX,COMMAND_STRING
		MOV	CMD_ADDR,AX

	;point ES:BX to parameter list.
		LEA	BX,PARM_BLOCK

	;save stack pointer (should be top minus 3 words)
		MOV	SAVE_SP,SP

	;here we go
		MOV     AH,4BH		;EXEC function call
		MOV	AL,0		;load and execute function
		INT	21H

	;return from call
;		MOV	AH,4DH		;get completion code
;		INT	21H
;		CMP	AH,0		;ah is zero for normal completion
;		JNE	EXIT_LOAD	;if not zero, error in loaded program

		MOV	AX,CS		;restore segment registers
		MOV	DS,AX		;DS -> data
		MOV	ES,AX		;ES -> data
		MOV	SS,SAVE_SS
		MOV	SP,SAVE_SP

		RET

EXEC_COMMAND	ENDP


;---------------------------------------------------------------------------
;get next command to execute
;---------------------------------------------------------------------------

GET_NEXT_CMD	PROC

		PUSH	DS
		MOV	AX,ES:PARM_TBL_SEG_ADDR	;address system parm table
		MOV	DS,AX			;DS -> system parm table
		MOV	AL,BYTE PTR DS:[0]	;get 1st byte of 1st file name
		CMP	AL,' '			;if space, assume no name,
		JE	SEC_COMMAND		;  try second file name

		MOV	SI,0			;move file name into position
		LEA	DI,FILE_NAME
		MOV	CX,81
		CLD
		REP	MOVSB
		LEA	DI,COMMAND_STRING	;move command line parameters
		MOV	CX,82
		REP	MOVSB

		MOV	BYTE PTR DS:[0],' '	;render 1st file name useless

		JMP	GET_NEXT_RET		;return

SEC_COMMAND:
		MOV	AL,BYTE PTR DS:[163]	;get 1st byte of 2nd file name
		CMP	AL,' '			;if space, assume no name,
		JE	EXIT_LOAD		;then quit
		MOV	SI,163			;move file name into position
		LEA	DI,FILE_NAME
		MOV	CX,81
		CLD
		REP	MOVSB
		MOV	SI,244			;move command line parameters
		LEA	DI,COMMAND_STRING
		MOV	CX,82
		REP	MOVSB

		MOV	BYTE PTR DS:[163],' '	;render 2nd file name useless

GET_NEXT_RET:
		POP	DS
		RET

GET_NEXT_CMD	ENDP

CODE     ENDS
         END     LOAD
