*<S>Sample Functions For PLIST.EXE - VALSTATE

***********************************************************
*
*     VALSTATE
*
*     Validates a state abbreviation.  SPVALSTATE is a
*     special routine that will allow a blank state IF
*     the other field passed to it is a blank.
*
***********************************************************
*
*     Written     September 2, 1986
*
*     Author      David Midkiff
*
***********************************************************

FUNCTION valstate
PARAMETERS state , l , r

RETURN UPPER(SUBSTR(state,1,1))+LOWER(SUBSTR(state,2,1))$'AkAlArAzCaoCtDeFGaHiIaIdIlInKsKyLaMaMeMiMnMdMoMsMtNcNdNeNhNjNmNvNyOhOkOrPaRiScSdTnTxUtVaVtWaWiWvWy'

*<S>BEEP() - Ring the console "Bell"
*page


**********************************************************************
*
*     BEEP
*
*     This will check the variable BELLFLAG (defined in globally elsewhere)
*     and if it is set to true then it will ring the console's bell
*
**********************************************************************
*
*     Written     August 25, 1986
*
*     Author      David Midkiff
*
**********************************************************************

PROCEDURE beep

IF bellflag
   ? CHR(7)
ENDIF       bellflag

RETURN
*<S>GETCHAR - Get a single character response
*page


*******************************************************************
*
*     GETCHAR() - This will get a valid keypress using the parameters
*                 passed.  It assumes that Escape should abort.
*
*           Calling convention :
*                 char = getchar( Line , chars , default , message )
*                        Line == Line number to print string on
*                        chars == Characters allowed in the answer
*                        default == Default answer
*                        message == Message to print for prompting
*
*******************************************************************
*
*     Written     August 25, 1986
*
*     Author      David Midkiff
*
*******************************************************************

FUNCTION getchar
PARAMETERS linenum , chrs , defchar , str

str1 = str+ ' Press [Esc] to abort.'
answer = defchar
pp = (80-LEN(str1))/2
ok = .f.
chrs = chrs + 'A'

DO WHILE .NOT. ok
   @ linenum , pp SAY str1 GET answer PICTURE '!'
   READ
   ok = ( answer$chrs ) .OR. ( LASTKEY() = 27 )
ENDDO       while .not. ok

@ linenum , 0 SAY SPACE(79)

RETURN answer
