Program Sample { Sample from PLIST.EXE } ;

Type
    Str4 = String[4] ;

Const
     PcJr = 'IBM PC-JR or compatible' ;
     PcAt = 'IBM PC-AT or compatible' ;
     PcXt = 'IBM PC-XT, Portable or compatible' ;
     pc = 'IBM PC or compatible' ;
     PcUnknown = 'non-IBM' ;


Var
   SystemType : Byte absolute $F000:$FFFE ;

   Scratch : Integer ;

   Results : Record
                   AX,BX,CX,DX,BP,SI,DI,DS,ES,Flags : Integer ;
                   end ;
			    
(*****************************************************************)
(*													*)
(*	ISCOLOR - Determine if the equipment flag has the correct	*)
(*			  values for a color display adapter.			*)
(*													*)
(*****************************************************************)

Function IsColor( EquipFlag : Integer ) : Boolean ;
Begin
     If EquipFlag And $0300 = $0300 Then
        IsColor := False
     Else
        Iscolor := True ;

End ;   { Function IsColor }

{     ---     Main Line     ---     }

Begin

     WriteLn( 'Machine ID Byte is ' , SystemType ) ;
     Write( 'This is a ' ) ;
     Case SystemType Of
          $FC : WriteLn( PcAt ) ;
          $FD : WriteLn( PcJr ) ;
          $FE : WriteLn( PcXt ) ;
          $FF : WriteLn( Pc ) ;
          Else  WriteLn( PcUnknown ) ;
     End ;

     Intr( $11 , Results ) ;

     With Results Do
     Begin
          Write( 'There is ' ) ;
          If AX And $2 <> 2 Then
             Write( 'NOT ' ) ;
          If SystemType = $FC Then
             Write( '80287' )
          Else
             Write( '8087' ) ;
          Writeln( ' installed. ' ) ;

         Write( 'There is a ' ) ;
         If IsColor( AX ) Then
            Write( 'color' )
         Else
            Write( 'monochrome' ) ;
         WriteLn( ' display adapter.' ) ;

         WriteLn( 'There are ' , (AX And $C0) shr 5 , ' diskette drives.' ) ;

         WriteLn( 'There are ' , (AX And $0300) shr 8 , ' serial ports.' ) ;

         WriteLn( 'There are ' , (AX And $C000) shr 14 , ' parallel ports.' ) ;

    End ;         { With Results Do }

End.		{ Program Sample }

(*****************************)
{						}
{     END OF SAMPLE.PAS		}
{						}
(*****************************)