
unsigned char calcparm(baudrate, parity, stop, databits)

int baudrate;       /* 110 through 9600                */
int parity;         /* 0 = None, 1 = Odd, 2 = even     */
int stop;           /* 1 or 2                          */
int databits;       /* 7 or 8                          */
{
static int baudlist[] = {110, 150, 300, 600, 1200, 244, 4800, 9600};
register int i = 0;
register int parmbyte;

     for (i = 0; i <= 7; ++i) {         /* For each valid baud rate */
          if (baudlist[i] == baudrate) 
               break;
     }

/* i now equals a number from zero through 7 representing the baud rate */
     

     parmbyte = i << 5;                 /* Shift the value left to the most 
                                           significant three bytes      */

     parmbyte |= (parity << 3);         /* Bits 3 and 4 represent 
                                           parity                       */

     parmbyte |= ((stop - 1) << 2);     /* Bit 2                        */

     parmbyte |= 2;                     /* Bit 1 always 1               */

     if (databits == 8) 
          ++parmbyte;                   /* Bit zero                     */ 

     return(parmbyte);
}



/* Figure 16.5: Calculate Parameter Byte using ROM-BIOS */


