/* Combined menu definition file for BATCH and EXEC versions of   */
/* $2MENU.COM                                                     */

/* Experiment using macro capability of preprocessor to make a    */
/* menu description language for easier human reading of menus.   */

/* This is similar to the MENUDAT.CP file for Turbo C++ but does   */
/* not use the new ANSI preprocessor functions as the Turbo C 2.0  */
/* preprocessor did not include support for the token pasting      */
/* function.                                                       */

/* Written by David Gwillim  24 June 1990 */
/* for the $2 Menu System package         */
/* Copyright (C) 1990 by David Gwillim    */

   /************************************************************************/

#define StartMenu(menu)          char *menu[] = {
#define Title(menutitle)         menutitle,
#define Entry(menuentry)         menuentry,
#define NoArgs                   ""
#define Cls                      "c"
#define ClsPause                 "p"
#define NoCls                    " "
#define Link(menuname)           menuname,"",
#define EndMenu(menu)            ""};
#define StartMenuSystem          char **menu[] = {
#define Menu(menuid)             menuid,
#define EndMenuSystem            NULL};
#define Set(var,color,mono)      unsigned char var={color,mono};

#define MenuNumber (char *)

#ifdef BATCH
  #define BatchCmd(action,cmdstr)  "",action cmdstr,
#else
  #define DosCmd(action,cmdstr)    CommandCom,action"/C"cmdstr,
  #define Exec(action,pgm,args)    pgm,action args,
#endif

     /***************************************************************/
     /** Fill in the values appropriate to your menu system.       **/
     /** The first constant is for Color the second for Monochrome **/
     /***************************************************************/

Set(MenuTitleColor[2],0x1E,0x70)         /* color for the title        */
Set(MenuTitleLine[2],0,0)                /* title pos (0=menu box top) */

Set(ScrnColor[2],0x71,0x07)              /* color of the screen        */
Set(ScrnChar[2],'\xB1',' ')              /* fill character for screen  */
Set(ScrnBoxColor[2],0x11,0x07)           /* color of box around screen */
Set(ScrnBoxStyle[2],4,0)                 /* box style for above        */

Set(MenuColor[2],0x4F,0x70)              /* color for menu entries     */
Set(MenuBoxColor[2],0x4E,0x70)           /* color for box around them  */
Set(MenuBoxStyle[2],1,1)                 /* box style for above        */

Set(MenuBorderTop[2],2,1)                /* space above menu items     */
Set(MenuBorderBot[2],2,1)                /* space below menu items     */
Set(MenuBorderLt[2],6,4)                 /* spaces to the left         */
Set(MenuBorderRt[2],6,4)                 /* spaces to the right        */

Set(LightBarColor[2],0x2F,0x07)          /* color for the light bar    */

   /************************************************************************/
   /** Don't forget to #define CommandCom appropriately for your system!! **/
   /************************************************************************/

#define CommandCom  "C:\\COMMAND.COM"

   /************************************************************************/
   /** You have to assign a numerical value to a menu so you can link to  **/
   /** it via a menu entry. #define all those you will reference. Note    **/
   /** the underscore prepended to the menu ID.                           **/
   /************************************************************************/

#define _mainmenu  MenuNumber 0         /* can't define a macro with a   */
#define _submenu01 MenuNumber 1         /* macro unfortunately! And the  */
#define _submenu02 MenuNumber 2         /* Link value must be a literal. */

     /*********************************************************************/
     /** Create your own menu system using the following as a pattern.   **/
     /** Each separate menu definition must be enclosed by a StartMenu() **/
     /** and EndMenu(). Each menu entry (the text that will display)     **/
     /** MUST be followed by either a BatchCmd() or Link() for the BATCH **/
     /** version. For the EXEC version the menu entry MUST be followed   **/
     /** by either a DosCmd() an Exec() or a Link(). Note that if the    **/
     /** Exec() has no parameters following the program path name you    **/
     /** must use "" or NoArgs explicitly to satisfy the macro.          **/
     /** When Link() is used to link to another menu in this Turbo C 2.0 **/
     /** implementation you must use the menu ID with a prepended        **/
     /** underscore as the argument to Link().                           **/
     /*********************************************************************/

#ifdef BATCH   /* BATCH version */

   StartMenu(mainmenu)
      Title(" SAMPLE MENU ")
         Entry("XyWrite III Plus WP")
            BatchCmd(NoCls,"@EDITOR")
         Entry("Turbo Power MAKEMENU")
            BatchCmd(NoCls,"@C:\\BIN\\MAKEMENU")
         Entry("Paradox Database")
            BatchCmd(NoCls,"@PARADOX")
         Entry("QEDIT Editor")
             BatchCmd(NoCls,"@Q")
         Entry("LIST File Browser")
             BatchCmd(NoCls,"@LIST")
         Entry("PMAP Memory Map Utility")
             BatchCmd(ClsPause,"@C:\\BIN\\PMAP")
         Entry(">> SUB MENU TWO")
             Link(_submenu01)
         Entry(">> SUB MENU THREE")
             Link(_submenu02)
   EndMenu(mainmenu)

   StartMenu(submenu01)
      Title(" LEVEL TWO MENU ")
         Entry("Menu Entry One")
            BatchCmd(ClsPause,"@dir /w")
         Entry("Menu Entry Two")
            BatchCmd(ClsPause,"@dir")
         Entry(">> MAIN MENU")
            Link(_mainmenu)
   EndMenu(submenu01)

   StartMenu(submenu02)
      Title(" LEVEL THREE MENU ")
         Entry("Menu Entry Three")
            BatchCmd(ClsPause,"@DIR /W")
         Entry("Menu Entry Four")
            BatchCmd(ClsPause,"@DIR /P")
         Entry(">> MAIN MENU")
            Link(_mainmenu)
   EndMenu(submenu02)

#else   /* EXEC version */

   StartMenu(mainmenu)
      Title(" SAMPLE MENU ")
         Entry("XyWrite III Plus WP")
            DosCmd(NoCls,"EDITOR")
         Entry("Turbo Power MAKEMENU")
            Exec(NoCls,"C:\\BIN\\MAKEMENU.EXE",NoArgs)
         Entry("Paradox Database")
            DosCmd(NoCls,"PARADOX")
         Entry("QEDIT Editor")
             DosCmd(NoCls,"Q")
         Entry("LIST File Browser")
             DosCmd(NoCls,"LIST")
         Entry("PMAP Memory Map Utility")
             Exec(ClsPause,"C:\\BIN\\PMAP.EXE",NoArgs)
         Entry("DOS Shell")
             Exec(Cls,CommandCom,NoArgs)
         Entry(">> SUB MENU TWO")
             Link(_submenu01)
         Entry(">> SUB MENU THREE")
             Link(_submenu02)
   EndMenu(mainmenu)

   StartMenu(submenu01)
      Title(" LEVEL TWO MENU ")
         Entry("Menu Entry One")
            DosCmd(ClsPause,"dir /w")
         Entry("Menu Entry Two")
            DosCmd(ClsPause,"dir")
         Entry(">> MAIN MENU")
            Link(_mainmenu)
   EndMenu(submenu01)

   StartMenu(submenu02)
      Title(" LEVEL THREE MENU ")
         Entry("Menu Entry Three")
            DosCmd(ClsPause,"DIR /W")
         Entry("Menu Entry Four")
            DosCmd(ClsPause,"DIR /P")
         Entry(">> MAIN MENU")
            Link(_mainmenu)
   EndMenu(submenu02)

#endif

       /***************************************************************/
       /** When you have defined each separate menu you must declare **/
       /** the menu system as a whole, with the individual menus in  **/
       /** the same sequence they were assigned link numbers.        **/
       /***************************************************************/

StartMenuSystem
   Menu(mainmenu)
   Menu(submenu01)
   Menu(submenu02)
EndMenuSystem

