          PAGE    61,132  ; (Ctrl-O) <--- Insert ASCII 15 for Condensed Print
          TITLE   RELOCK.ASM     (Creates RELOCK.COM)
;                         Version 1.1, 8/24/85
;   All Rights Reserved: J. C. Kilday Associates, Peaks Island, ME 04108
 
; RELOCK.COM is a companion program which interfaces with the device driver,
; SYSLOCK.SYS.  It allows the user to disable any further use of the PC until
; the system password is entered.  Ctrl-Break, Ctrl-Alt-Del, and any key
; strokes involving use of the CTRL, ALT, or right Shift keys are disabled.
; Type  RELOCK <ENTER>   to secure the PC.
 
; Since SYSLOCK.SYS is set up as a dummy read-only character device, RELOCK.COM
; accesses the device driver by issuing a device open and dummy device read
; commands.  The portion of the driver which requests entry of the system
; password is re-activated.  If the correct password is entered, the driver
; returns control to DOS after telling it a lie, i.e., that the correct number
; input characters were transferred to the requesting application.  Falling
; for this bit of fiction, DOS transfers control back to the requesting
; application, RELOCK.COM.  After restoring full keyboard capability this
; program invokes a normal exit and the DOS prompt appears.
 
; Version 1.1 incorporates a technique for disabling certain memory resident
; utilities such as SideKick which insist on regaining control of the keyboard
; interrupt vector when their control is interrupted.  The disabling of these
; utilities is necessary to prevent their use to bypass RELOCK operation.
; RELOCK.COM returns control to them once a password has been correctly entered.
 
 
CSEG      SEGMENT PARA 'CODE'
          ASSUME  CS:CSEG, DS:CSEG
 
          ORG     100H
 
BEGIN:    JMP     SHORT START
 
 
 
DEV_NAME  DB      'SLCK_JCK',0          ;ASCIIZ string: name of device driver
 
DUMMY_BUF DB      ?                     ;Dummy buffer. Really not needed.
 
VECTOR_BUF DB     12 DUP (?)            ;Buffer in which the original boot time
                                        ; vectors for the 08H,1AH, & 1CH time
                                        ; of day and timer interrupts saved
 
CUR_08H_OFF DW    ?                     ;Current INT 08H offset
CUR_08H_SEG DW    ?                     ;  "      "   "  segment
CUR_1AH_OFF DW    ?                     ;Current INT 1AH offset
CUR_1AH_SEG DW    ?                     ;  "      "   "  segment
CUR_1CH_OFF DW    ?                     ;Current INT 1CH offset
CUR_1CH_SEG DW    ?                     ;  "      "   "  segment
 
 
NOT_INST  DB      'The SYSLOCK.SYS'
          DB      ' device driver is not'
          DB      ' installed.',7,13,10,'$';Msg terminated with CR,LF, & BEEP
 
START:    MOV     AX,0                  ;Point ES to segment 0
          MOV     ES,AX
          MOV     AX,CS                 ;Point DS to this code segment
          MOV     DS,AX
 
 ; Save current Time of Day and Timer interrupt vectors before replacing them
 ; with originals which were saved at boot time by SYSLOCK.SYS.  This is the
 ; the first step in process of disabling resident utilities which could be
 ; used to bypass the RELOCK function (e.g., SideKick).
 
          CLI                           ;Turn off interrupts
          MOV     AX,WORD PTR ES:[08H*4];Save offset of INT 08H vector
          MOV     CUR_08H_OFF,AX
          MOV     AX,WORD PTR ES:[08H*4+2] ;Save segment of INT 08H vector
          MOV     CUR_08H_SEG,AX
 
          MOV     AX,WORD PTR ES:[1AH*4];Save offset of INT 1AH vector
          MOV     CUR_1AH_OFF,AX
          MOV     AX,WORD PTR ES:[1AH*4+2] ;Save segment of INT 1AH vector
          MOV     CUR_1AH_SEG,AX
 
          MOV     AX,WORD PTR ES:[1CH*4];Save offset of INT 1CH vector
          MOV     CUR_1CH_OFF,AX
          MOV     AX,WORD PTR ES:[1CH*4+2] ;Save segment of INT 1CH vector
          MOV     CUR_1CH_SEG,AX
          STI                           ;Turn on interrupts
 
; Invoke the device driver, SYSLOCK.SYS, to ask for the original time-related
; interrupt vectors saved at boot time.
 
          LEA     DX,DEV_NAME           ;Point DX to ASCIIZ string containing
                                        ; the device name
          MOV     AX,3D00H              ;Open the device for input
          INT     21H
          JNC     DRVR_OK               ;Test for SYSLOCK.SYS installed
          JMP     ERROR_EXIT            ; NO, not installed.
DRVR_OK:  MOV     BX,AX                 ;Put file handle returned by the open
                                        ; into BX to set up for a read request
          PUSH    BX                    ;Save for later
          MOV     CX,12                 ;Request 12 characters to be read
          LEA     DX,VECTOR_BUF         ;Establish buffer to catch vector data
          MOV     AX,3F00H              ;Read from device
          INT     21H
 
 ; Restore original time-related interrupt vectors in effect at system boot to
 ; effectively disable memory resident utilities from restoring their hold on
 ; the keyboard interrupt vector which we're about to take away.
 
          CLI                           ;Turn off interrupts
          MOV     AX,WORD PTR VECTOR_BUF;Get original INT 08H offset
          MOV     WORD PTR ES:[08H*4],AX ;Restore it
          MOV     AX,WORD PTR VECTOR_BUF[2];Get orig INT 08H segment
          MOV     WORD PTR ES:[08H*4+2],AX;Restore it
          MOV     AX,WORD PTR VECTOR_BUF[4];Get original INT 1AH offset
          MOV     WORD PTR ES:[1AH*4],AX;Restore it
          MOV     AX,WORD PTR VECTOR_BUF[6];Get orig INT 1AH segment
          MOV     WORD PTR ES:[1AH*4+2],AX;Restore it
          MOV     AX,WORD PTR VECTOR_BUF[8];Get original INT 1CH offset
          MOV     WORD PTR ES:[1CH*4],AX;Restore it
          MOV     AX,WORD PTR VECTOR_BUF[10];Get orig INT 1CH segment
          MOV     WORD PTR ES:[1CH*4+2],AX;Restore it
 
 
 ; Change keyboard interrupt vector to point to local INT 09H KB handler
 
          MOV     AX,WORD PTR ES:[09H*4];Save offset part of INT 09H vector
          MOV     KBINT_OFF,AX
          MOV     AX,WORD PTR ES:[09H*4+2] ;Save segment part of INT 09H vector
          MOV     KBINT_SEG,AX
          MOV     WORD PTR ES:[09H*4],OFFSET KB_INT ;Insert new vector offset
          MOV     WORD PTR ES:[09H*4+2],CS   ;Insert new vector segment
          STI                                ;Turn interrupts back on
 
 
; Invoke the device driver, SYSLOCK.SYS, to ask for password
 
          POP     BX                    ;Restore file handle
          MOV     CX,1                  ;Request one character to be read
          LEA     DX,DUMMY_BUF          ;Establish dummy buffer to catch char.
          MOV     AX,3F00H              ;Read from device
          INT     21H
 
; Note: Control will not return to this program until the device driver
;       receives the correct password.  When it does .....
 
; Restore keyboard interrupt vector, various time related interrupt vectors
; and return to DOS.
 
          CLI                           ;Turn interrupts off
          MOV     AX,0                  ;Point ES to segment 0
          MOV     ES,AX
          MOV     AX,KBINT_OFF          ;Restore offset portion of KB vector
          MOV     WORD PTR ES:[09H*4],AX
          MOV     AX,KBINT_SEG          ;Restore segment portion of KB vector
          MOV     WORD PTR ES:[09H*4+2],AX
          MOV     AX,CUR_08H_OFF        ;Restore offset portion of 08H vector
          MOV     WORD PTR ES:[08H*4],AX
          MOV     AX,CUR_08H_SEG        ;Restore segment portion of 08H vector
          MOV     WORD PTR ES:[08H*4+2],AX
          MOV     AX,CUR_1AH_OFF        ;Restore offset portion of 1AH vector
          MOV     WORD PTR ES:[1AH*4],AX
          MOV     AX,CUR_1AH_SEG        ;Restore segment portion of 1AH vector
          MOV     WORD PTR ES:[1AH*4+2],AX
          MOV     AX,CUR_1CH_OFF        ;Restore offset portion of 1CH vector
          MOV     WORD PTR ES:[1CH*4],AX
          MOV     AX,CUR_1CH_SEG        ;Restore segment portion of 1CH vector
          MOV     WORD PTR ES:[1CH*4+2],AX
          STI                           ;Turn interrupts back on
 
          INT     20H                   ;Return to DOS
 
ERROR_EXIT:
          LEA     DX,NOT_INST            ;Point DX to "Not Installed" message
          MOV     AH,9                   ;Print the message
          INT     21H
          INT     20H                    ;Return to DOS
 
; New Keyboard Interrupt Handler
 
KB_INT:
          STI                           ;Enable interrupts
          PUSH    DS                    ;Save registers to be used
          PUSH    AX
          MOV     AX,CS                 ;Establish addressability of data
          MOV     DS,AX
          IN      AL,60H                ;Read keyboard input
          TEST    AL,80H                ;Is it a key being released?
          JNZ     NML_KB_INT            ;If yes, go to reg. KB int handler
          CMP     AL,1DH                ;Is the Ctrl key pressed?
          JZ      IGNORE                ;If yes, ignore this keypress
          CMP     AL,38H                ;Is the Alt key pressed?
          JZ      IGNORE                ;If yes, ignore this keypress
          CMP     AL,36H                ;Is the Rt. Shift key pressed?
          JZ      IGNORE                ;If yes, ignore this keypress
          JMP     SHORT NML_KB_INT      ;Do normal KB interrupt
IGNORE:   IN      AL,61H                ;Read 8255 Port PB
          OR      AL,80H                ;Set KB acknowledge signal
          OUT     61H,AL                ;Send acknowledge
          AND     AL,7FH                ;Reset KB acknowledge signal
          OUT     61H,AL                ;Restore original 8255 Port PB
          MOV     AL,20H                ;Send End of Interrupt command to
          OUT     20H,AL                ;   8259 Int. Command Register
          POP     AX                    ;Restore registers
          POP     DS
          IRET                          ;Return to point of interrupt
 
NML_KB_INT:
          POP     AX                    ;Restore registers in preparation
          POP     DS                    ;  for going to normal KB int handler
          DB      0EAH             ;This is op code for a far jump to the
KBINT_OFF DW      ?                ; the normal KB interrupt handler at this
KBINT_SEG DW      ?                ; offset and segment.
 
CSEG      ENDS
          END     BEGIN
