DECLARE SUB comma (text$)
DECLARE SUB comline (fin$, echo, runstk, setconv$)
DECLARE SUB fill (nam$)
DECLARE SUB ciscq (fin$, path$, echo)
DECLARE SUB cishq (fin$, path$, echo)
DECLARE SUB djcq (fin$, path$, echo)
DECLARE SUB djhq (fin$, path$, echo)
DECLARE SUB djmm (fin$, path$, echo)
DECLARE SUB finn (fin$, path$, echo)
DECLARE SUB source (fin$, path$, echo)
DECLARE SUB sourcehq (fin$, path$, echo)
DECLARE SUB gecq (fin$, path$, echo)
DECLARE SUB gehq (fin$, path$, echo)
DECLARE SUB makewind (ulr, ulc, lrr, lrc, Frame, fore, back, grow, shadow, label$)
DECLARE SUB getdate (day$)
DECLARE SUB fraction (frac$, num)
DECLARE SUB keypress (timelimit%, q$, ql)
DECLARE SUB exist (file$, path$)
'============================================================================
' $tokTraX Data Conversion                            (Version 2.61, 5/21/89)
'----------------------------------------------------------------------------
' Program by C. E. Raymond, 2419 Hodges Bend Circle, Sugar Land, Texas 77479
'============================================================================
         CONST true = -1, false = 0
         DIM clr(32)
         COMMON SHARED ticks, echo, clr()
         KEY OFF: ON ERROR GOTO GETERR
         fin$ = "": autoexit = false
         CALL comline(fin$, echo, runstk, setconv$)
1        f$ = "$TOKTRAX.DEF": OPEN f$ FOR INPUT AS #1
         IF ERL = 1 THEN
            path$ = "": ticks = 1: colour$ = "COLOR"
           ELSE
            INPUT #1, path$, ticks, test$, test$, test$, test$, colour$: CLOSE #1
            END IF
         IF RIGHT$(path$, 1) <> "\" AND LEN(path$) > 1 THEN path$ = path$ + "\"
         IF colour$ = "MONO" THEN
            FOR i% = 0 TO 15: clr(i%) = 15: clr%(i% + 16) = 7: NEXT i%
            clr(0) = 0: clr(7) = 0
          ELSE
            FOR i% = 0 TO 31: clr(i%) = i%: NEXT i%
            END IF
top:
         COLOR clr(1), clr(7)
         CLS : PRINT : SOUND 4000, ticks
         IF autoexit THEN
            COLOR clr(3), clr(0): CLS : PRINT : PRINT : PRINT : PRINT
            PRINT "                   "
            PRINT "                    $tokTraX data conversion completed "
            PRINT "                   "
            f$ = "$TOKTRAX.EXE"
            IF runstk THEN RUN f$
            SYSTEM
            END IF
         IF fin$ <> "" THEN autoexit = true ELSE autoexit = false
         label$ = "Current path = " + path$
         text$ = "Convert [path\]FILE.EXT (or <ENTER>, $, ?) > "
         IF autoexit THEN text$ = "File " + fin$ + " selected."
         ulr = 3: ulc = 5: lrr = 5: lrc = 75
         Frame = 2: fore = 14: back = 1
         IF colour$ = "MONO" THEN back = 0
         LOCATE 9, 1: COLOR clr(8), clr(7)
         PRINT "           $tokConv, the $tokTraX data converter, will automatically"
         PRINT "           recognize and translate (to $tokTraX format) data files"
         PRINT "           captured from the following services:"
         COLOR clr(14), clr(7)
         PRINT "           "
         COLOR clr(9), clr(7)
         PRINT "                CompuServe - MicroQuote Current Quotes"
         PRINT "                CompuServe - MicroQuote Historical Quotes"
         PRINT "                Dow Jones News Service - Current Quotes (//CQ)"
         PRINT "                Dow Jones News Service - Historical Quotes (//HQ)"
         PRINT "                Dow Jones Market Manager Plus, Current Quotes"
         PRINT "                GEnie - Current Quotes"
         PRINT "                GEnie - Historical Quotes"
         PRINT "                Source - Stockcheck current quotes"
         PRINT "                Source - Historical (HQ) quotes"
         PRINT "                FNN - MarketWatch current quotes"
         COLOR clr(14), clr(7)
         PRINT "           "
3        GOSUB windo
         IF fin$ = "" THEN COLOR clr(9), clr(7): INPUT "", fin$
         IF INSTR(fin$, "$") > 0 THEN RUN "$TOKTRAX"
         IF fin$ = "" THEN autoexit = true: GOTO top
         IF INSTR(fin$, "?") > 0 OR INSTR(fin$, "/") > 0 OR INSTR(fin$, "*") > 0 THEN
                fin$ = path$ + "*.*"
                COLOR clr(8), clr(7): CLS : LOCATE 11, 3: PRINT : FILES fin$
                COLOR clr(12) + 16, clr(7): LOCATE CSRLIN - 1, 37: PRINT "Press any key to continue.....";
                WHILE INKEY$ = "": WEND: COLOR clr(9), clr(7): CLS : fin$ = "": GOTO top
                END IF
         n = 0: COLOR clr(8), clr(7)

5        fin$ = path$ + fin$: OPEN fin$ FOR INPUT AS #1
         IF LASTERR = 53 AND ERL = 5 THEN
            LASTERR = 0: COLOR clr(4) + 16, clr(7): SOUND 500, 2 * ticks
            LOCATE 22, 22: PRINT "File "; fin$; " not found!     ": fin$ = ""
            GOTO 3
            END IF
         autoexit = true

         SELECT CASE setconv$
            CASE "CISCQ": text$ = "Name"
            CASE "CISHQ": text$ = "Cusip:"
            CASE "FNN": text$ = "MONITOR NAME :"
            CASE "GECQ": text$ = "TICK "
            CASE "GEHQ": text$ = "CUSIP     "
            CASE "DJHQ": text$ = "DOW JONES HISTORICAL"
            CASE "DJCQ": text$ = "DOW JONES STOCK"
            CASE "DJMM": text$ = "Market Manager PLUS"
            CASE "SOURCECQ": text$ = "P-E   (hds)"
            CASE "SOURCEHQ": text$ = "ENTER A DATA REQUEST, OR HELP, OR STOP."
            CASE ELSE: LINE INPUT #1, text$
         END SELECT

         DO
           IF EOF(1) THEN
                CLS : LOCATE 20, 5: COLOR clr(12) + 16, clr(7)
                PRINT fin$; " not recognized as a $tokTraX convertible file."
                COLOR clr(11): PRINT "                     Press any key to continue...";
                CLOSE #1: SOUND 500, 2 * ticks
                fin$ = "": autoexit = false
                INPUT q$: GOTO top
                END IF
           IF LEFT$(text$, 4) = "Name" THEN
                CLOSE
                text$ = "       CompuServe MicroQuotes Current Quotes recognized"
                GOSUB windo
                CALL ciscq(fin$, path$, echo): fin$ = "": GOTO top
                END IF
           IF LEFT$(text$, 6) = "Cusip:" THEN
                CLOSE
                text$ = "       CompuServe MicroQuotes Historical Quotes recognized"
                GOSUB windo
                CALL cishq(fin$, path$, echo): fin$ = "": GOTO top
                END IF
           IF INSTR(text$, "MONITOR NAME :") > 0 THEN
                CLOSE
                text$ = "                   FNN Market Watch recognized"
                GOSUB windo
                CALL finn(fin$, path$, echo): fin$ = "": GOTO top
                END IF
           IF LEFT$(text$, 5) = "TICK " THEN
                CLOSE
                text$ = "                GEnie Current Quotes recognized"
                GOSUB windo
                CALL gecq(fin$, path$, echo): fin$ = "": GOTO top
                END IF
           IF LEFT$(text$, 10) = "CUSIP     " THEN
                CLOSE
                text$ = "               GEnie Historical Quotes recognized"
                GOSUB windo
                CALL gehq(fin$, path$, echo): fin$ = "": GOTO top
                END IF
           IF INSTR(text$, "DOW JONES HISTORICAL") > 0 THEN
                CLOSE
                text$ = "            Dow Jones Historical Quotes recognized"
                GOSUB windo
                CALL djhq(fin$, path$, echo): fin$ = "": GOTO top
                END IF
           IF INSTR(text$, "DOW JONES STOCK") > 0 THEN
                CLOSE
                text$ = "               Dow Jones Current Quotes recognized"
                GOSUB windo
                CALL djcq(fin$, path$, echo): fin$ = "": GOTO top
                END IF
           IF INSTR(text$, "Market Manager PLUS") > 0 THEN
                CLOSE
                text$ = "  Market Manager PLUS Current Quotes recognized   "
                GOSUB windo
                CALL djmm(fin$, path$, echo): fin$ = "": GOTO top
                END IF
           IF INSTR(text$, "P-E   (hds)") > 0 THEN
                CLOSE
                text$ = "               Source Stockcheck Quotes recognized"
                GOSUB windo
                CALL source(fin$, path$, echo): fin$ = "": GOTO top
                END IF
           IF INSTR(text$, "ENTER A DATA REQUEST, OR HELP, OR STOP.") > 0 THEN
                CLOSE
                text$ = "               SOURCE Historical Data File Recognized"
                GOSUB windo
                CALL sourcehq(fin$, path$, echo): GOTO top
                END IF

           LINE INPUT #1, text$
           LOOP
         CLS : END

'==============================================================================
GETERR:
 ERRLINE = ERL: LASTERR = ERR: COLOR clr(4) + 16: LOCATE 15, 25
 IF ERL = 1 AND LASTERR = 53 THEN PRINT "File "; f$; " not found!";
 COLOR clr(7)
 RESUME NEXT

'==============================================================================
windo:
        CALL makewind(ulr, ulc, lrr, lrc, Frame, fore, back, 0, 1, label$)
        LOCATE ulr, 6: COLOR clr(12), clr(back)
        PRINT "$tokConv (v2.6) Data Converter"; TAB(51);
        PRINT "program by C. E. Raymond";
        LOCATE ulr + 1, 5: COLOR clr(fore), clr(back): PRINT STRING$(71, 196)
        LOCATE ulr + 2, 6: COLOR clr(11), clr(back): PRINT text$;
        RETURN

'===============================================================================
'Convert CompuServe MicroQuote to $tokTraX
'===============================================================================
SUB ciscq (fin$, path$, echo) STATIC
'-----------------------------------
                VIEW PRINT 9 TO 24: COLOR clr(8), clr(7): CLS
                REDIM stk$(40): n% = 0
                OPEN fin$ FOR INPUT AS #1
AGAIN:
                COLOR clr(8), clr(7)
                WHILE LEFT$(text$, 6) <> "Issue:"
                    LINE INPUT #1, text$
                    PRINT text$
                    IF EOF(1) THEN
                        CLOSE : PRINT "END OF DATA": VIEW PRINT: EXIT SUB
                        END IF
                    WEND

                i% = 0
                k% = INSTR(text$, ": ") + 2
                j% = INSTR(text$, ","): IF j% = 0 THEN j% = LEN(text$) + 1

                DO
                    i% = i% + 1
                    stk$(i%) = MID$(text$, k%, j% - k%)
                    IF INSTR(stk$(i%), " ") > 0 THEN MID$(stk$(i%), INSTR(stk$(i%), " "), 1) = "_"
                    k% = j% + 1: j% = INSTR(k%, text$, ",")
                    IF j% = 0 THEN j% = LEN(text$) + 1
                LOOP UNTIL k% > LEN(text$)

                n% = i%
                WHILE INSTR(text$, ".") < 40: LINE INPUT #1, text$: WEND
                FOR i% = 1 TO n%
                    IF echo THEN COLOR clr(8), clr(7): PRINT text$ ELSE PRINT ".";
                    sym$ = stk$(i%): fout$ = path$ + sym$ + ".STK": COLOR clr(9), clr(7)
                    OPEN fout$ FOR APPEND AS #2
                    IF echo THEN PRINT "Updating file "; fout$; ":  ";
                    hi = VAL(MID$(text$, 36, 8))
                    lo = VAL(MID$(text$, 46, 8))
                    clo = VAL(MID$(text$, 55, 8))
                    vol = VAL(MID$(text$, 27, 8))
                    day$ = DATE$
                    test$ = RIGHT$(text$, 6) + "/" + RIGHT$(day$, 2)
                    IF INSTR(test$, ":") = 0 THEN day$ = test$
                    CALL getdate(day$)
                    IF echo THEN COLOR clr(12), clr(7): PRINT day$; hi; lo; clo; vol
                    SOUND 16000, ticks
                    PRINT #2, CHR$(34); day$; CHR$(34); ","; hi; ","; lo; ","; clo; ","; vol: CLOSE #2
                    IF i% < n% THEN
                        DO
                            LINE INPUT #1, text$
                            j% = INSTR(text$, ".")
                        LOOP UNTIL EOF(1) OR j% > 30
                    END IF
                NEXT i%
                IF EOF(1) THEN CLOSE : VIEW PRINT: EXIT SUB
                GOTO AGAIN
    END SUB

'=============================================================================
'Convert CompuServe MicroQuote Historical to $tokTraX
'=============================================================================
SUB cishq (fin$, path$, echo) STATIC
'-----------------------------------
                 VIEW PRINT 9 TO 24: COLOR clr(8), clr(7): CLS
TOPCISHQ:
                 PRINT : SOUND 4000, ticks: DIVISOR = 100: n = 0
                 OPEN fin$ FOR INPUT AS #1
                 COLOR clr(8), clr(7)
                
                 WHILE INSTR(cis$, "Ticker:") < 45
                                LINE INPUT #1, cis$
                                IF EOF(1) THEN
                                  CLS : LOCATE 23, 30: COLOR clr(4), clr(7)
                                  PRINT fin$; "> NO CIS HISTORICAL DATA FOUND"
                                  CLOSE #1: SOUND 500, 2: GOTO TOPCISHQ
                                END IF
                                IF echo THEN PRINT cis$
                 WEND
NEWSTOCK:
                 i = LEN(cis$) - 52: stk$ = RIGHT$(cis$, i)
                 stk$ = LTRIM$(RTRIM$(stk$))
                 fout$ = path$ + stk$ + ".STK"
                 CALL exist(fout$, path$)
                 IF RIGHT$(fout$, 1) = "+" THEN
                         fout$ = LEFT$(fout$, LEN(fout$) - 1)
                         OPEN fout$ FOR APPEND AS #2
                         ELSE OPEN fout$ FOR OUTPUT AS #2
                 END IF

                 WHILE LEFT$(cis$, 6) <> "------"
                                LINE INPUT #1, cis$
                 WEND
                 LINE INPUT #1, cis$: CLS
                
                 WHILE NOT EOF(1)
                    IF INSTR(cis$, "/") <> 3 THEN GOTO REPEAT
                    day$ = LEFT$(cis$, 8): CALL getdate(day$)
                    IF echo THEN COLOR clr(8), clr(7): PRINT : PRINT "Reading: "; cis$
                    vol$ = MID$(cis$, 12, 10): test$ = ""
                    FOR i% = 1 TO LEN(vol$)
                        t$ = MID$(vol$, i%, 1)
                        IF INSTR("0123456789", t$) > 0 THEN test$ = test$ + t$
                        NEXT i%
                    vol = INT(VAL(test$) / 100)
                    hi$ = MID$(cis$, 25, 10): CALL fraction(hi$, hi)
                    lo$ = MID$(cis$, 37, 10): CALL fraction(lo$, lo)
                    clo$ = MID$(cis$, 49, 10): CALL fraction(clo$, clo)
                    IF (vol = 0 AND hi = 0 AND lo = 0 AND clo = 0) THEN GOTO REPEAT
                    IF echo THEN
                        COLOR clr(9), clr(7): PRINT "Updating "; fout$; ": ";
                        COLOR clr(12), clr(7): PRINT day$; hi; lo; clo; vol
                        ELSE PRINT ".";
                    END IF
                    SOUND 16000, 1      ': PRINT #2, day$; ","; hi; lo; clo; vol
                    PRINT #2, CHR$(34); day$; CHR$(34); ","; hi; ","; lo; ","; clo; ","; vol
REPEAT:
                    LINE INPUT #1, cis$
                    IF INSTR(cis$, "Ticker:") > 44 THEN
                        test$ = RTRIM$(LTRIM$(MID$(cis$, 52, 6)))
                        IF test$ <> stk$ THEN CLOSE #2: GOTO NEWSTOCK
                        END IF
                 WEND
                 CLOSE : VIEW PRINT
END SUB

'=============================================================================
SUB comline (f$, echo, runstk, setconv$) STATIC
'----------------------------------------------
    echo = true: f$ = "": runstk = false: setconv$ = ""
    cl$ = COMMAND$
    test = INSTR(cl$, "/=")
    IF test > 0 THEN
        j% = INSTR(test, cl$, "/"): IF j% = 0 THEN j% = LEN(cl$)
        setconv$ = RIGHT$(LTRIM$(RTRIM$(MID$(cl$, test, j%))), LEN(cl$) - test - 1)
        END IF
    test = INSTR(cl$, "/$")
    IF test > 0 THEN runstk = true
    test = INSTR(cl$, "/NE")
    IF test > 0 THEN echo = false: MID$(cl$, test, 3) = "   "
    test = INSTR(cl$, "/F") + 2: i% = test
    IF test < 3 THEN EXIT SUB ELSE cl$ = cl$ + " "
    DO
        t$ = MID$(cl$, i%, 1)
        IF t$ > " " THEN f$ = f$ + t$
        i% = i% + 1
        LOOP UNTIL t$ = " "
    END SUB

'===========================================================================
SUB comma (text$) STATIC                          'Replace blanks with comma
'-----------------------                          --------------------------
    text$ = LTRIM$(RTRIM$(text$)): new$ = ""
    FOR i% = 1 TO LEN(text$)
        t$ = MID$(text$, i%, 1)
        IF t$ <> " " THEN
            IF t$ <> CHR$(8) THEN new$ = new$ + MID$(text$, i%, 1)
          ELSE
            IF MID$(text$, i% - 1, 1) <> " " THEN new$ = new$ + ","
        END IF
    NEXT i%
    text$ = new$
END SUB

'=============================================================================
'Convert Dow Jones Current Quotes (//CQ) to $tokTraX Format
'=============================================================================
SUB djcq (fin$, path$, echo) STATIC
'----------------------------------
         VIEW PRINT 9 TO 24
         PRINT : PRINT : COLOR clr(9), clr(7): CLS
         PRINT "   At no point in the listing of Current Quotes (//CQ) does Dow Jones News"
         PRINT "   Service indicate the effective date for the quotes.  $tokTraX, therefore,"
         PRINT "   will assume today's date unless you indicate something different.  Press"
         COLOR clr(12): PRINT "   <Esc>"; : COLOR clr(9): PRINT " within 10 seconds if you don't want to use "; DATE$; ", or press"
         COLOR clr(12): PRINT "   <ENTER>"; : COLOR clr(9): PRINT " to continue......"
         CALL keypress(15000, q$, ql): PRINT : PRINT
         IF q$ = CHR$(27) THEN INPUT "   New date (yyyy-mm-dd or ENTER)"; day$ ELSE day$ = DATE$
         IF day$ = "" THEN day$ = DATE$
         CALL getdate(day$): CLS
         OPEN fin$ FOR INPUT AS #1
         COLOR clr(8), clr(7)
         WHILE LEFT$(text$, 10) <> "STOCK     " AND NOT EOF(1): LINE INPUT #1, text$: WEND
         WHILE NOT EOF(1)
                IF INSTR(text$, "STOCK") = 0 THEN 7300
                COLOR clr(8), clr(7)
                sym$ = RIGHT$(text$, LEN(text$) - 14)
                fout$ = path$ + sym$ + ".STK"
                OPEN fout$ FOR APPEND AS #2
                LINE INPUT #1, text$: LINE INPUT #1, text$: LINE INPUT #1, text$
                PRICE$ = RIGHT$(text$, 10)
                        CALL fraction(PRICE$, hi)
                LINE INPUT #1, text$: PRICE$ = RIGHT$(text$, 10)
                        CALL fraction(PRICE$, lo)
                LINE INPUT #1, text$: PRICE$ = RIGHT$(text$, 10)
                        CALL fraction(PRICE$, clo)
                LINE INPUT #1, text$: vol = VAL(RIGHT$(text$, LEN(text$) - 14))
                IF echo THEN
                    COLOR clr(9), clr(7): PRINT "Updating file "; fout$; ": ";
                    COLOR clr(12), clr(7): PRINT day$; ","; hi; lo; clo; vol
                    END IF
                SOUND 15000, 1          ': PRINT #2, day$; ","; hi; lo; clo; vol: CLOSE #2
                PRINT #2, CHR$(34); day$; CHR$(34); ","; hi; ","; lo; ","; clo; ","; vol: CLOSE #2
7300    WHILE LEFT$(text$, 10) <> "STOCK     " AND NOT EOF(1): LINE INPUT #1, text$: WEND
        WEND
        VIEW PRINT: CLOSE
        END SUB

'=============================================================================
'Convert DJNS Historical (//HQ) to $tokTraX Format
'==============================================================================
SUB djhq (fin$, path$, echo) STATIC
'----------------------------------
         VIEW PRINT 9 TO 24: COLOR clr(9), clr(7): CLS
1110     OPEN fin$ FOR INPUT AS #1
         DO UNTIL EOF(1)
                LINE INPUT #1, text$
                t = INSTR(text$, "STOCK "): IF INSTR(text$, "QUOTE") > 0 THEN t = 0
                IF t > 0 THEN
                        fout$ = RIGHT$(text$, LEN(text$) - 6)
                        fout$ = LTRIM$(RTRIM$(fout$))
                        EXIT DO
                        END IF
                LOOP
         CLOSE #1
         IF t = 0 THEN
                fout$ = fin$
                t = INSTR(fin$, "."): IF t > 0 THEN fout$ = LEFT$(fin$, t - 1)
                END IF
         IF INSTR(fout$, path$) = 0 THEN fout$ = path$ + fout$
         stk$ = LTRIM$(RTRIM$(fout$))

1150     LOCATE 16, 10
         t$ = fout$: COLOR clr(12)
         PRINT "    Output file (ENTER="; t$; ".STK) : "; : INPUT fout$
         IF fout$ = "" THEN fout$ = t$: IF fout$ = "" THEN 1150
         IF RIGHT$(fout$, 4) <> ".STK" THEN fout$ = fout$ + ".STK"
         COLOR clr(12), clr(7): CLS : n = 0
1200     CALL exist(fout$, path$)
         IF RIGHT$(fout$, 1) = "+" THEN
                fout$ = LEFT$(fout$, LEN(fout$) - 1)
                OPEN fout$ FOR APPEND AS #2
         ELSEIF RIGHT$(fout$, 1) <> "+" THEN
                OPEN fout$ FOR OUTPUT AS #2
         END IF
         LOCATE 16, 1: PRINT STRING$(80, " ")
         IF LASTERR% <> 0 AND ERL = 1200 THEN CLOSE : LASTERR% = 0: GOTO 1110
         FOUNDIT = 0: i = 1
         OPEN fin$ FOR INPUT AS #1
         WHILE NOT EOF(1)
                LINE INPUT #1, text$
                IF echo THEN COLOR clr(8), clr(7): PRINT text$ ELSE PRINT ".";
                COLOR clr(9), clr(7): IF INSTR(text$, "/") <> 3 THEN 2070
                IF INSTR(text$, "NOT TRADED") > 0 THEN 2000
                day$ = "": hi = 0: lo = 0: clo = 0: vol = 0: FOUNDIT = 1
                day$ = LEFT$(text$, 8): CALL getdate(day$)
                hi$ = MID$(text$, 12, 7): PRICE$ = hi$: CALL fraction(PRICE$, hi)
                lo$ = MID$(text$, 22, 7): PRICE$ = lo$: CALL fraction(PRICE$, lo)
                clo$ = MID$(text$, 32, 7): PRICE$ = clo$: CALL fraction(PRICE$, clo)
                IF hi < lo THEN SWAP hi, lo
                IF clo = 0 THEN clo = lo
                IF hi = 0 THEN hi = clo
                IF lo = 0 THEN lo = clo
                vol = VAL(MID$(text$, 42, 8))
                IF echo THEN PRINT day$, hi, lo, clo, vol: PRINT
2000            SOUND 16000, ticks
                'PRINT #2, day$; ","; hi; lo; clo; vol
                PRINT #2, CHR$(34); day$; CHR$(34); ","; hi; ","; lo; ","; clo; ","; vol
                i = i + 1
2070     WEND: CLOSE
         i = i - 1: COLOR clr(2)
         IF FOUNDIT = 0 THEN
                COLOR clr(12), clr(7): CLS : SOUND 1000, 2: SOUND 500, 1: LOCATE 15, 5
                PRINT fin$; " Dow Jones Historical data file not found - no conversion."
                KILL fout$
         END IF
5110 VIEW PRINT
         END SUB

'=============================================================================
'Convert Dow Jones Market Manager PLUS Current Quotes to $tokTraX Format
'=============================================================================
SUB djmm (fin$, path$, echo) STATIC
'----------------------------------
         VIEW PRINT 9 TO 24: QUOTE$ = CHR$(34): QUOTE2$ = QUOTE$ + QUOTE$
         OPEN fin$ FOR INPUT AS #1
         COLOR clr(8), clr(7): CLS
         WHILE INSTR(text$, "/") <> 4 AND NOT EOF(1)
            LINE INPUT #1, text$
            WEND
         day$ = MID$(text$, 2, 10): CALL getdate(day$)
         WHILE NOT EOF(1)
                LINE INPUT #1, text$
                IF INSTR(text$, QUOTE$) = 0 THEN 7333
                IF INSTR(text$, QUOTE2$) > 0 THEN 7333
                IF INSTR(text$, "  CLOSE") > 0 THEN 7333
                IF INSTR(text$, "  OPEN") > 0 THEN 7333
                IF INSTR(text$, "  HIGH") > 0 THEN 7333
                IF INSTR(text$, "  LOW") > 0 THEN 7333
                IF INSTR(text$, "  LAST") > 0 THEN 7333
                IF INSTR(text$, "VOL(100S)") > 0 THEN 7333
                IF INSTR(text$, "$ Chng") > 0 THEN 7333
                IF INSTR(text$, "% Chng") > 0 THEN 7333
                IF INSTR(text$, "Gainers") > 0 THEN 7333
                IF INSTR(text$, "Non Mover") > 0 THEN 7333
                IF INSTR(text$, "Losers") > 0 THEN 7333
                'COLOR CLR(8), CLR(7)
                sym$ = MID$(text$, 2, LEN(text$) - 2)
                fout$ = path$ + sym$ + ".STK"
                OPEN fout$ FOR APPEND AS #2
                IF echo THEN PRINT
                FOR i% = 1 TO 5
                    LINE INPUT #1, text$
                    NEXT i%
                hi = VAL(RIGHT$(text$, LEN(text$) - 2))
                FOR i% = 1 TO 2
                    LINE INPUT #1, text$
                    NEXT i%
                lo = VAL(RIGHT$(text$, LEN(text$) - 2))
                FOR i% = 1 TO 2
                    LINE INPUT #1, text$
                    NEXT i%
                clo = VAL(RIGHT$(text$, LEN(text$) - 2))
                FOR i% = 1 TO 2
                    LINE INPUT #1, text$
                    NEXT i%
                vol = VAL(RIGHT$(text$, LEN(text$) - 2))
                IF echo THEN
                    COLOR clr(9), clr(7): PRINT "Updating "; fout$; ": ";
                    COLOR clr(8), clr(7): PRINT day$; ","; hi; lo; clo; vol
                  ELSE PRINT ".";
                    END IF
                SOUND 15000, 1          ': PRINT #2, day$; ","; hi; lo; clo; vol: CLOSE #2
                PRINT #2, CHR$(34); day$; CHR$(34); ","; hi; ","; lo; ","; clo; ","; vol: CLOSE #2
7333    WEND
        VIEW PRINT: CLOSE
'        STOP
        END SUB

'============================================================================
SUB exist (file$, path$) STATIC
'------------------------------
4700 OPEN file$ FOR INPUT AS #2: CLOSE #2
         IF ERL = 4700 THEN EXIT SUB
         CLS : COLOR clr(12): LOCATE 16, 6
         PRINT "File "; file$; " already exists."
         PRINT : SOUND 500, ticks: SOUND 1000, ticks
         PRINT "     <O>verwrite, <A>ppend, or <C>hange file specifier? ";
         DO
                CALL keypress(0, q$, ql)
                LOOP UNTIL INSTR("OACoac", q$) > 0
         COLOR clr(9): PRINT : PRINT
         IF q$ = "O" OR q$ = "o" THEN CLS : EXIT SUB
         IF q$ = "A" OR q$ = "a" THEN file$ = file$ + "+": EXIT SUB
         IF NOT echo AND q$ <> "C" AND file$ > " " THEN EXIT SUB
         SOUND 2000, ticks: INPUT "     Name for new file"; file$: CLS
         IF INSTR(file$, path$) = 0 THEN file$ = path$ + file$
         IF INSTR(file$, ".STK") = 0 THEN file$ = file$ + ".STK"
         GOTO 4700
END SUB

'=============================================================================
SUB fill (nam$) STATIC
    L = LEN(nam$)
    FOR i = 1 TO L
        IF MID$(nam$, i, 1) = " " THEN MID$(nam$, i, 1) = "_"
        NEXT i
    WHILE RIGHT$(nam$, 1) = "_"
        nam$ = LEFT$(nam$, L - 1)
        L = L - 1
        WEND
END SUB

'=============================================================================
'Convert FNN MarketWatch to $tokTraX
'==============================================================================
SUB finn (fin$, path$, echo) STATIC
'----------------------------------
         VIEW PRINT 9 TO 24
         COLOR clr(9), clr(7): CLS
         OPEN fin$ FOR INPUT AS #1
6201     COLOR clr(9), clr(7)
         IF (LASTERR = 53 OR LASTERR = 64) AND ERL = 6201 THEN CLOSE : LASTERR = 0
         WHILE INSTR(DAT$, "DATE:") = 0 AND NOT EOF(1)
            LINE INPUT #1, DAT$
            IF echo THEN PRINT DAT$
            WEND
         i = INSTR(DAT$, "DATE:") + 5: day$ = MID$(DAT$, i, 9): CALL getdate(day$)
         WHILE LEFT$(DAT$, 6) <> " ALARM" AND NOT EOF(1)
            LINE INPUT #1, DAT$
            IF echo THEN PRINT DAT$
            WEND
         LINE INPUT #1, DAT$
         WHILE NOT EOF(1)
                IF LEN(DAT$) < 20 THEN 6350
                sym$ = MID$(DAT$, 8, 6): CALL fill(sym$)
                fout$ = path$ + sym$ + ".STK"
                OPEN fout$ FOR APPEND AS #2
                PRICE$ = MID$(DAT$, 37, 10): CALL fraction(PRICE$, hi)
                PRICE$ = MID$(DAT$, 48, 10): CALL fraction(PRICE$, lo)
                PRICE$ = MID$(DAT$, 59, 10): CALL fraction(PRICE$, clo)
                vol = VAL(MID$(DAT$, 70, 8)) \ 100
                IF lo = 0 THEN lo = clo
                IF hi = 0 THEN hi = clo
                        'PRINT #2, day$; ","; hi; lo; clo; vol: CLOSE #2
                PRINT #2, CHR$(34); day$; CHR$(34); ","; hi; ","; lo; ","; clo; ","; vol: CLOSE #2
                SOUND 15000, 1
                IF echo THEN
                    COLOR clr(9), clr(7): PRINT "Updating file "; fout$
                    COLOR clr(8), clr(7): PRINT DAT$
                    COLOR clr(12), clr(7): PRINT TAB(10); day$; hi; lo; clo; vol
                    ELSE PRINT ".";
                    END IF
6350            LINE INPUT #1, DAT$
        WEND
        VIEW PRINT: CLOSE
        END SUB

'=============================================================================
SUB fraction (frac$, num) STATIC
        frac$ = LTRIM$(RTRIM$(frac$))
        i% = LEN(frac$)
        j% = INSTR(frac$, "/"): IF j% = 0 THEN num = VAL(frac$): EXIT SUB
        k% = INSTR(frac$, " ") + 1
        denom = VAL(RIGHT$(frac$, i% - j%))
        numer = VAL(MID$(frac$, k%, j% - k%))
        IF k% > 0 THEN num = VAL(LEFT$(frac$, k% - 1)) ELSE num = 0
        num = num + numer / denom
        END SUB

'==============================================================================
'Convert GEnie Quotes to $tokTraX
'==============================================================================
SUB gecq (fin$, path$, echo) STATIC
'----------------------------------
         VIEW PRINT 9 TO 24
         IF DROUT$ = "" THEN DROUT$ = path$
5200     COLOR clr(9), clr(7): CLS : n = 0: OPEN "I", 1, fin$
         IF (LASTERR = 53 OR LASTERR = 64) AND ERL = 5200 THEN CLOSE : LASTERR = 0: EXIT SUB
         WHILE MID$(GE$, 43, 1) <> "<" AND NOT EOF(1)
            LINE INPUT #1, GE$
            IF echo THEN PRINT GE$
            WEND
         t$ = "19" + MID$(GE$, 51, 6)
         IF VAL(LEFT$(t$, 4)) < 1930 THEN t$ = "20" + MID$(GE$, 51, 6)
         day$ = LEFT$(t$, 4) + "-" + MID$(t$, 5, 2) + "-" + RIGHT$(t$, 2)
         LINE INPUT #1, GE$: IF echo THEN PRINT GE$
         WHILE NOT EOF(1)
                IF LEFT$(GE$, 4) <> "TICK" THEN 5300 ELSE LINE INPUT #1, GE$
                IF MID$(GE$, 31, 2) = "cv" THEN LINE INPUT #1, GE$
                IF INSTR(GE$, "0.00") = 37 THEN LINE INPUT #1, GE$
                IF echo THEN COLOR clr(15), clr(7): PRINT GE$
                sym$ = LEFT$(GE$, 5)
                t = LEN(sym$): t$ = RIGHT$(sym$, t)
                WHILE t$ = " ": t = t - 1: t$ = RIGHT$(sym$, t): WEND: sym$ = t$
                fout$ = DROUT$ + sym$ + ".STK"
                OPEN fout$ FOR APPEND AS #2
                clo = VAL(MID$(GE$, 42, 8)): hi = clo: lo = clo
                vol = VAL(MID$(GE$, 50, 6))
                SOUND 15000, 1
                        'PRINT #2, day$; ","; hi; lo; clo; vol: CLOSE #2
                PRINT #2, CHR$(34); day$; CHR$(34); ","; hi; ","; lo; ","; clo; ","; vol: CLOSE #2
                IF echo THEN
                    COLOR clr(8), clr(7): PRINT "Updating file "; fout$; ": ";
                    COLOR clr(9), clr(7): PRINT day$; ","; hi; lo; clo; vol
                    ELSE PRINT ".";
                    END IF
5300            LINE INPUT #1, GE$
        WEND: CLOSE : VIEW PRINT
        END SUB

'=============================================================================
'Convert GEHQ Historical to $tokTraX Format
'==============================================================================
SUB gehq (fin$, path$, echo) STATIC
'----------------------------------
         VIEW PRINT 9 TO 24: CLS
         OPEN fin$ FOR INPUT AS #1

         COLOR clr(12), clr(7): CLS : n = 0
         LOCATE 16, 1

         DO
                LINE INPUT #1, text$
                IF echo THEN PRINT text$
                IF INSTR(text$, "CUSIP      TICKER") > 0 THEN EXIT DO
         LOOP UNTIL EOF(1)
         LINE INPUT #1, text$
         sym$ = MID$(text$, 12, 8)
         sym$ = LTRIM$(RTRIM$(sym$))
         fout$ = sym$: COLOR clr(4)
         PRINT "     Output file (ENTER="; path$; sym$; ".STK) : "; : INPUT fout$
         IF fout$ = "" THEN fout$ = sym$
         IF RIGHT$(fout$, 4) <> ".STK" THEN fout$ = fout$ + ".STK"
         fout$ = path$ + fout$
         CALL exist(fout$, path$)
         IF RIGHT$(fout$, 1) = "+" THEN
                fout$ = LEFT$(fout$, LEN(fout$) - 1)
                OPEN fout$ FOR APPEND AS #2
                ELSE OPEN fout$ FOR OUTPUT AS #2
         END IF
         FOUNDIT = 0: i = 1

         WHILE NOT EOF(1)
                LINE INPUT #1, text$
                IF echo THEN COLOR clr(8), clr(7): PRINT text$: COLOR clr(9), clr(7)
                IF INSTR(text$, ",") <> 7 THEN 2075
                FOUNDIT = 1
                day$ = LEFT$(text$, 6): CALL getdate(day$)
                vol = VAL(MID$(text$, 8, 7))
                hi = VAL(MID$(text$, 17, 7))
                lo = VAL(MID$(text$, 25, 7))
                clo = VAL(RIGHT$(text$, 7))
                IF clo = 0 THEN clo = lo
                IF hi < lo THEN SWAP hi, lo
                IF hi = 0 THEN hi = clo
                IF lo = 0 THEN lo = clo
                IF echo THEN PRINT day$, hi, lo, clo, vol ELSE PRINT ".";
                SOUND 16000, ticks
                        'PRINT #2, day$; ","; hi; lo; clo; vol
                PRINT #2, CHR$(34); day$; CHR$(34); ","; hi; ","; lo; ","; clo; ","; vol
                i = i + 1
2075 WEND: CLOSE
         i = i - 1: COLOR clr(2)
         IF FOUNDIT = 0 THEN
                COLOR clr(12), clr(7): CLS : SOUND 1000, 2: SOUND 500, 1: LOCATE 15, 10
                PRINT fin$; " not a GEnie Historical data file - no conversion."
                KILL fout$
         END IF
         VIEW PRINT
         END SUB

'=============================================================================
SUB getdate (day$) STATIC
'-------------------------------------
'STANDARDIZE DATE TO YYYY-MM-DD FORMAT
'-------------------------------------
4950 j% = INSTR(day$, "/"): IF j% > 0 THEN MID$(day$, j%, 1) = "-": GOTO 4950
4960 j% = INSTR(day$, "."): IF j% > 0 THEN MID$(day$, j%, 1) = "-": GOTO 4960
4970 j% = INSTR(day$, ","): IF j% > 0 THEN MID$(day$, j%, 1) = "-": GOTO 4970
         c = LEN(day$)
         IF c = 6 THEN
                yr$ = LEFT$(day$, 2): mo$ = MID$(day$, 3, 2): da$ = RIGHT$(day$, 2)
                day$ = mo$ + "-" + da$ + "-" + yr$: c = 8
                END IF
         i1 = INSTR(day$, "-"): i2 = INSTR(RIGHT$(day$, c - i1), "-")
         IF i1 = 5 AND i2 = 3 THEN EXIT SUB
         mo$ = LEFT$(day$, i1 - 1): da$ = MID$(day$, i1 + 1, i2 - 1): yr$ = RIGHT$(day$, 2)
         IF VAL(da$) > 31 THEN SWAP da$, yr$
         IF VAL(mo$) > 12 THEN SWAP mo$, da$
         IF VAL(mo$) < 10 THEN mo$ = "0" + RIGHT$(mo$, 1)
         IF VAL(da$) < 10 THEN da$ = "0" + RIGHT$(da$, 1)
         IF VAL(yr$) < 10 THEN yr$ = "200" + RIGHT$(yr$, 1)
         IF VAL(yr$) < 50 THEN yr$ = "20" + RIGHT$(yr$, 2)
         IF VAL(yr$) < 100 THEN yr$ = "19" + RIGHT$(yr$, 2)
         day$ = yr$ + "-" + mo$ + "-" + da$
         END SUB

'=============================================================================
SUB keypress (timelimit%, q$, ql) STATIC
        IF timelimit% = 0 THEN timelimit% = 2: n% = 0 ELSE n% = 1
        FOR i% = 1 TO timelimit% STEP n%
                q$ = INKEY$: IF q$ = "" THEN GOTO doagain
                ql = LEN(q$): q$ = RIGHT$(q$, 1)
                EXIT SUB
doagain:
                NEXT i%: q$ = CHR$(13)
END SUB

'=============================================================================
SUB makewind (ulr, ulc, lrr, lrc, Frame, fore, back, grow, shadow, label$) STATIC

Box:
          IF grow = 0 THEN GOSUB Dont.Grow: GOTO Return.From.Box
          shadow = 0
          X1% = ulc + INT((lrc - ulc) / 2)
          X2% = lrc - INT((lrc - ulc) / 2)
          Y1% = ulr + INT((lrr - ulr) / 2)
          Y2% = lrr - INT((lrr - ulr) / 2)

Check.Box.Size:
          IF X1% > ulc THEN X1% = X1% - 3: IF X1% < ulc THEN X1% = ulc
          IF X2% < lrc THEN X2% = X2% + 3: IF X2% > lrc THEN X2% = lrc
          IF Y1% > ulr THEN Y1% = Y1% - 1
          IF Y2% < lrr THEN Y2% = Y2% + 1
          GOSUB Determine.Box.Attributes
          IF (X1% = ulc) AND (X2% = lrc) AND (Y1% = ulr) AND Y2% = (lrr) THEN GOTO Cant.Grow ELSE GOTO Check.Box.Size

Cant.Grow:
         grow = 0
         GOTO Return.From.Box

Dont.Grow:
          X1% = ulc: X2% = lrc: Y1% = ulr: Y2% = lrr

Determine.Box.Attributes:
          Page% = 0: Attr% = (back AND 7) * 16 + fore
          ON Frame GOSUB Frame.1, Frame.2, Frame.3, Frame.4
          IF label$ = "" OR LEN(label$) > (LEN(top$) - 5) THEN GOTO Make.Shadow
          MID$(top$, 2) = LeftBracket$ + label$ + RightBracket$

Make.Shadow:
          IF shadow = 0 THEN GOTO Draw.Box
          Col% = X1% - 3: DAT$ = STRING$((X2% - X1%) + 3, 32): Black% = 0
          FOR i% = Y1% TO (Y2% + 2)
          Row% = i%
          LOCATE Row%, Col%: COLOR 0, 0: PRINT DAT$  ' or CALL assembler routine
          NEXT i%
          shadow = 0

Draw.Box:
          Row% = Y1% - 1: Col% = X1% - 1
          LOCATE Row%, Col%: COLOR clr(fore), clr(back): PRINT top$   ' or CALL assembler
          FOR i% = Y1% TO Y2%
          Row% = i%: Col% = X1% - 1
          LOCATE Row%, Col%: COLOR clr(fore), clr(back): PRINT Midl$  ' or CALL assembler
          NEXT i%
          Row% = Y2% + 1: Col% = X1% - 1
          LOCATE Row%, Col%: COLOR clr(fore), clr(back): PRINT Bottm$ ' or CALL assembler
          RETURN

Frame.1:
          top$ = CHR$(218) + STRING$((X2% - X1%) + 1, 196) + CHR$(191)
          Midl$ = CHR$(179) + STRING$((X2% - X1%) + 1, 32) + CHR$(179)
          Bottm$ = CHR$(192) + STRING$((X2% - X1%) + 1, 196) + CHR$(217)
          LeftBracket$ = CHR$(180): RightBracket$ = CHR$(195)
          RETURN

Frame.2:
          top$ = CHR$(201) + STRING$((X2% - X1%) + 1, 205) + CHR$(187)
          Midl$ = CHR$(186) + STRING$((X2% - X1%) + 1, 32) + CHR$(186)
          Bottm$ = CHR$(200) + STRING$((X2% - X1%) + 1, 205) + CHR$(188)
          LeftBracket$ = CHR$(181): RightBracket$ = CHR$(198)
          RETURN

Frame.3:
          top$ = CHR$(214) + STRING$((X2% - X1%) + 1, 196) + CHR$(183)
          Midl$ = CHR$(186) + STRING$((X2% - X1%) + 1, 32) + CHR$(186)
          Bottm$ = CHR$(211) + STRING$((X2% - X1%) + 1, 196) + CHR$(189)
          LeftBracket$ = CHR$(180): RightBracket$ = CHR$(195)
          RETURN

Frame.4:
          top$ = CHR$(213) + STRING$((X2% - X1%) + 1, 205) + CHR$(184)
          Midl$ = CHR$(179) + STRING$((X2% - X1%) + 1, 32) + CHR$(179)
          Bottm$ = CHR$(212) + STRING$((X2% - X1%) + 1, 205) + CHR$(190)
          LeftBracket$ = CHR$(181): RightBracket$ = CHR$(198)
          RETURN

Return.From.Box:
   COLOR clr(7), clr(0)

EXIT SUB  ' Box '

Screen.Off:
'                 Turn Off Screen Display
'                 -----------------------
'
   OUT &H3D8, &H1
EXIT SUB


Screen.On:
'                 Turn On Screen Display
'                 ----------------------
'
   OUT &H3D8, &H29
EXIT SUB

END SUB

'=============================================================================
SUB source (fin$, path$, echo) STATIC
'=============================================================================
'Convert SOURCE-StockCheck to $tokTraX
'==============================================================================
         VIEW PRINT 9 TO 24
         COLOR clr(9), clr(7): CLS : SRC$ = ""
         OPEN fin$ FOR INPUT AS #1
16200    COLOR clr(9), clr(7)
         IF (LASTERR = 53 OR LASTERR = 64) AND ERL = 16200 THEN CLOSE : LASTERR = 0
         LINE INPUT #1, SRC$: IF echo THEN PRINT SRC$
         WHILE NOT EOF(1)
                IF (INSTR(SRC$, "/") = 0 OR INSTR(SRC$, ":") = 0) THEN 16300
                COLOR clr(8), clr(7)
                sym$ = MID$(SRC$, 13, 6)
                WHILE RIGHT$(sym$, 1) = " ": sym$ = LEFT$(sym$, LEN(sym$) - 1): WEND
                fout$ = path$ + sym$ + ".STK"
                OPEN fout$ FOR APPEND AS #2
                IF echo THEN PRINT SRC$
                day$ = MID$(SRC$, 1, 5) + "/" + RIGHT$(DATE$, 2)
                FOR t = 1 TO LEN(day$)
                        IF MID$(day$, t, 1) = " " THEN MID$(day$, t, 1) = "0"
                NEXT t
                test$ = day$: CALL getdate(test$): day$ = test$
                PRICE$ = MID$(SRC$, 36, 8): CALL fraction(PRICE$, hi)
                PRICE$ = MID$(SRC$, 46, 8): CALL fraction(PRICE$, lo)
                PRICE$ = MID$(SRC$, 56, 8): CALL fraction(PRICE$, clo)
                vol = VAL(MID$(SRC$, 24, 8))
                SOUND 15000, 1
                        'PRINT #2, day$; ","; hi; lo; clo; vol: CLOSE #2
                PRINT #2, CHR$(34); day$; CHR$(34); ","; hi; ","; lo; ","; clo; ","; vol: CLOSE #2
                IF echo THEN
                    COLOR clr(9), clr(7): PRINT "Updating file "; fout$; ": ";
                    COLOR clr(12), clr(7): PRINT day$; ","; hi; lo; clo; vol
                    ELSE PRINT ".";
                    END IF
16300           LINE INPUT #1, SRC$
        WEND
        VIEW PRINT: CLOSE
END SUB

'=============================================================================
'Convert SOURCE Historical (HQ) to $tokTraX Format
'==============================================================================
SUB sourcehq (fin$, path$, echo) STATIC
'--------------------------------------
         VIEW PRINT 9 TO 24: COLOR clr(9), clr(7): CLS
2150     OPEN fin$ FOR INPUT AS #1

2151     DO UNTIL EOF(1)
             LINE INPUT #1, text$
             IF fout$ <> "$" THEN i% = INSTR(text$, "ENTER A DATA REQUEST")
             IF i% > 0 THEN
                LINE INPUT #1, text$
                IF EOF(1) THEN 4070
                WHILE INSTR(text$, "H") < 1: LINE INPUT #1, text$: WEND
                CALL comma(text$)
                j% = 1
                FOR i% = 1 TO 3
                    j% = INSTR(j% + 1, text$, ",")
                    IF i% = 2 THEN k% = j%
                NEXT i%
                fout$ = MID$(text$, k% + 1, j% - k% - 1)
                fout$ = LTRIM$(RTRIM$(fout$))
                EXIT DO
             END IF
         LOOP

         IF INSTR(fout$, path$) = 0 THEN fout$ = path$ + fout$
        
2250     LOCATE 16, 10
         IF RIGHT$(fout$, 4) <> ".STK" THEN fout$ = fout$ + ".STK"
         COLOR clr(12), clr(7): CLS : n = 0
3200     CALL exist(fout$, path$)
         IF RIGHT$(fout$, 1) = "+" THEN
             fout$ = LEFT$(fout$, LEN(fout$) - 1)
             OPEN fout$ FOR APPEND AS #2
           ELSEIF RIGHT$(fout$, 1) <> "+" THEN
             OPEN fout$ FOR OUTPUT AS #2
         END IF
         IF LASTERR% <> 0 AND ERL = 1200 THEN CLOSE : LASTERR% = 0: GOTO 6110
         FOUNDIT = 0: i = 1

         WHILE NOT EOF(1)
            LINE INPUT #1, text$
            IF EOF(1) THEN 4070
            IF INSTR(text$, "ENTER A DATA REQUEST") > 0 THEN
                CLOSE #2: fout$ = "$": i% = 1
                GOTO 2151
            END IF
            IF echo THEN COLOR clr(8), clr(7): PRINT text$ ELSE PRINT ".";
            COLOR clr(9), clr(7): IF INSTR(text$, "/") <> 3 THEN 4070
            day$ = "": hi = 0: lo = 0: clo = 0: vol = 0: FOUNDIT = 1
            day$ = LEFT$(text$, 8): CALL getdate(day$)
            hi = VAL(MID$(text$, 13, 7))
            lo = VAL(MID$(text$, 24, 7))
            clo = VAL(MID$(text$, 35, 7))
            IF hi = 0 THEN hi = clo
            IF lo = 0 THEN lo = clo
            IF hi < lo THEN SWAP hi, lo
            IF clo = 0 THEN clo = lo
            vol = VAL(MID$(text$, 47, 8)) \ 100
            IF echo AND clo > 0 THEN PRINT day$, hi, lo, clo, vol: PRINT
4000        SOUND 16000, ticks
                'IF clo > 0 THEN PRINT #2, day$; ","; hi; lo; clo; vol
            IF clo > 0 THEN PRINT #2, CHR$(34); day$; CHR$(34); ","; hi; ","; lo; ","; clo; ","; vol
            i = i + 1
4070     WEND: CLOSE

         i = i - 1: COLOR clr(2)
         IF FOUNDIT = 0 THEN
            COLOR clr(12), clr(7): CLS : SOUND 1000, 2: SOUND 500, 1: LOCATE 15, 5
            PRINT fin$; " SOURCE Historical data file not found - no conversion."
            KILL fout$
         END IF
6110     VIEW PRINT
         END SUB

