page ,132
;**************************************************************************
; The following is an Interrupt/Stay resident program that intercepts all
; BIOS video calls involving color and maps them to black and white calls.
; It will eliminate many of the fuzzy screens that arise from having
; a BW monitor hooked up to a color graphics board.
; THIS PROGRAM IS ONLY USEFUL IF YOU HAVE A BLACK AND WHITE HIGH RESOLUTION
; MONITOR CONNECTED TO YOUR GRAPHICS CARD.
;
; PROBLEMS THAT THIS ROUTINE SOLVES:
;    This program, when installed will remove all the fuzzy displays that
;    result when color display instructions are sent to BW monitor through
;    the BIOS system.  The VAST MAJORITY of available code does go through
;    BIOS so this will catch most of those problems.  This program works
;    by intercepting the following video calls and changing them as described.

;    SET MODE FUNCTION (INT 10H, AH=0)
;    If BIOS call is to set mode to 40x25 color then force mode to 40x25 BW
;    If BIOS call is to set mode to 80x25 color then force mode to 80x25 BW
;    If BIOS call is to set mode to 320x200 color then force mode to 320x200 BW

;    WRITE CHARACTER AND ATTRIBUTE (INT 10H, AH=9)
;    Intercepts BIOS calls to write attributes and characters and changes
;    the attributes.  In the following, "Normal Video" is defined as White
;    (or Intense white) on black.  "Reverse Video" is defined as black on white
;    (or Intense white).  Attributes are modified as follows:
;         IF foreground and background are the same THEN
;            IF they are black or white THEN leave them alone
;            ELSE they are another color so force to white
;         ELSE
;            IF foreground is black OR background is white THEN force "Reverse Video"
;            ELSE force "Normal Video"
;
;    SCROLL PAGE UP (INT 10H, AH=6) or SCROLL PAGE DOWN  (INT 10H, AH=7)
;    Intercepts BIOS calls to scroll up or down and changes the attribute
;       associated with the call as described immediately above for write character.

;    SET COLOR PALATTE  (INT 10H, AH=11)
;    Intercepts BIOS graphic calls to set the palette and changes them such that:
;       *  Background is always black
;       *  Foreground pallate always includes white (Color Id = 1)

;    WRITE DOT (INT 10H, AH=12) and WRITE TELETYPE (INT 10H, AH=14)
;    The "Write Dot" and "Write Teletype" intercept functions both map fore-
;       ground to white, regardless of the intended color.
;
; PROBLEMS THAT THIS ROUTINE CREATES:
;    When information is transmitted to the view SOLELY through color
;    information, then that information is lost in this transformation.
;    (naturally!).  So if, for example, a game has a color bar that switches
;    from green to red to signify danger, that information will be lost.
;    This is because generally all foreground colors are forced to white and
;    all background colors are forced to black.  This is not so much a
;    problem created by this program as it is a problem with Black and White
;    monitors not conveying as much information as Color Monitors.
;
; PROBLEMS THAT THIS ROUTINE DOES NOTHING ABOUT:
;    Any video calls that go straight to the hardware instead of going
;    through BIOS.  It is unfortunately the case that some VERY sophisticated
;    programs that really have snazzy graphics do go to the hardware directly
;    because of the speed benefits.
;
; After installing this program, all of the IBM Diagnostic tests look
; reasonable.
;
; When loaded this program uses 309 Decimal bytes of memory including the
; Program Segment Prefix (It relocates itself down into the unused portion
;     of the Program Segment Prefix to save memory).
;
; BWVID - Version 1.2, (C) Copyright 1985 by Scott W. Killen, All Rights Reserved
;         This program may not be used for commercial purposes without the
;            express written consent of Scott W. Killen.
; Version 1.0 - 5/02/85
; Version 1.1 - 8/20/85
; Version 1.2 - 8/29/85
; By:
;    Scott W. Killen
;    P.O Box 27012
;    Austin Texas  78755
;    CIS ID: 76703,734
;    512/836-1942
;
; This program is GiveAware!  The only payment I ask is your comments and
; bug reports.
;**************************************************************************

white      MACRO   reg            ; Force register to have white color code
           LOCAL   continue       ;    if not backgound.
           mov     ah,0f8h        ; Get ready for masking high bits
           and     ah,reg         ; Save High order bits
           and     reg,0fh        ; test for foreground or background
           jz      continue       ; If background then we are finished
           or      reg,07h        ; Force to white (or intense white) foreground
continue:  or      reg,ah         ; Recombine the two parts
           ENDM

CSEG    SEGMENT
        ASSUME CS:CSEG
        ORG 100H

BWVID  PROC NEAR
          JMP     initialize
CodeStart   equ 5ch
RelocWidth  equ $-CodeStart
JumpVector  equ $-RelocWidth
JumpTable   dw  Test0   -RelocWidth
            dw  JumpBios-RelocWidth
            dw  JumpBios-RelocWidth
            dw  JumpBios-RelocWidth
            dw  JumpBios-RelocWidth
            dw  JumpBios-RelocWidth
            dw  Test6   -RelocWidth
            dw  Test7   -RelocWidth
            dw  JumpBios-RelocWidth
            dw  Test9   -RelocWidth
            dw  JumpBios-RelocWidth
            dw  Test11  -RelocWidth
            dw  Test12  -RelocWidth
            dw  JumpBios-RelocWidth
            dw  Test14  -RelocWidth
            dw  JumpBios-RelocWidth
EndJumpVector equ $-RelocWidth
BiosVector    equ $-RelocWidth
BiosAddress dd ?

EntryPoint  equ  $-RelocWidth
            push    di
            xchg    ah, al
            mov     di, ax
            xchg    ah, al
            and     di, 0ffh               ; Put AH in DL
            shl     di, 1                  ; Multiply times 2
            add     di, JumpVector         ; Add in Base address
            cmp     di, EndJumpVector      ; Is our vector out of range?
            jge     JumpBios
            jmp     Word Ptr cs:[di]       ; Jump to function

Test0:      cmp     al, 03H        ; Check if Alpha Mode
            jg      Test0a         ; Jump if not Alpha mode
            and     al, 02H        ; Force black and white display
            jmp     Short JumpBios
Test0a:     cmp     al, 05H        ; Check for Medium Res Graphics
            jg      JumpBios       ; Jump if not Medium Res Graphics
            mov     al, 05H        ; Force black and white graphics

Test6:
Test7:
            push    ax             ; Save the function value
            xchg    bh, bl         ; Put attribute in BL
            call    AdjustAttr     ; Adjust the attribute in BL
            xchg    bh, bl         ; Return attribute to BH
            pop     ax             ; Restore function (destroyed by AdjustAttr)

JumpBios:   pop     di
            jmp     DWord Ptr cs:[BiosVector]

Test9:
            call    AdjustAttr
            mov     ah, 09h        ; Restore AH and return to BIOS
            jmp     Short JumpBios

Test11:     and     bl, 0f0h       ; Zero out low bits (black background)
            or      bh, bh         ; Is it a set background?
            jz      Test11a        ; if so, we are finished
            mov     bl, 01h        ; Set palette one
Test11a:    jmp     Short JumpBios

Test12:     white   al             ; Force the color (if any) to white
            mov     ah,0CH         ; Now restore function code
            jmp     Short JumpBios

Test14:     white   bl             ; Force foreground (if any) to white
            mov     ah,0EH         ; Restore function code
            jmp     Short JumpBios
BWVID  endp

AdjustAttr  Proc  Near             ; Adjust attribute in BL
                                   ; AH destroyed, and BL modified
            push    bx
            mov     ah,bl          ; Use the AH register for a minute
            and     ah, 07h        ; Isolate the foreground color
            sar     bl, 1          ; Shift the background into right portion of word
            sar     bl, 1
            sar     bl, 1
            sar     bl, 1
            and     bl, 07h        ; Isolate the background color
            cmp     ah, bl         ; Compare foreground and background
            je      AA2            ; Jump if they are the same
            or      ah, ah         ; Is foreground black?
            jz      AA1            ; If so then force reverse video
            cmp     bl, 07h        ; Is background white?
            jz      AA1
            pop     bx             ; Ok, so it is normal video
            or      bl, 07h        ; force foreground on,
            and     bl, 8fh        ; and background off!
            ret
AA1:
            pop     bx
            or      bl, 70h        ; force background on,
            and     bl, 0f8h       ; and foreground off!
            ret
AA2:
            or      bl, bl         ; Test to see if they are off
            pop     bx
            jz      AA3
            or      bl, 77h        ; Force foreground and background on!
AA3:        ret
AdjustAttr  endp

CODEWIDTH   equ  $-JumpTable
INIT   PROC  NEAR
cpyrite   db  'BWVID - Version 1.2, (C) Copyright 1985 by Scott W. Killen, All Rights Reserved$'
initialize:
        PUSH    DS                          ; Save DS for later use
        XOR     AX,AX                       ; Clear AX
        MOV     DS,AX                       ; Prepare to save original interrupt
;
        MOV     AX, 40H
        MOV     SI, AX                      ; Source for INT 10h as provided for in the interrupt table
        MOV     DI, Offset BiosAddress      ; Destination in the code segment for moving this pointer
        MOVSW                               ; Move the two word address
        MOVSW
;
        MOV     AX, EntryPoint         ; Fill AX with starting point
        MOV     [SI-04H],AX            ; Move offset in line
        MOV     [SI-02H],CS            ; Move segment value in line
;
        POP     DS                     ; Restore the data segment
;
                                       ; These lines relocate the interrupt
        MOV     CX, CodeWidth          ;   handler down into the unused
        MOV     DI, CodeStart          ;   portion of the Program Segment
        MOV     SI, Offset JumpTable   ;   Prefix (to save memory)!
 REP    MOVSB                          ;
;
        mov     ah, 0fh                ; Interrupt is now installed
        int     10h                    ; Return the current mode
        xor     ah, ah                 ; Set mode function
        int     10h                    ; Reset the current mode (taking BW defaults)
;
        mov     dx, offset cpyrite     ; Display copyright
        mov     ah, 9
        int     21h
;
        mov     ah, 2                  ; Set the cursor position
        mov     dx, 300h
        xor     bx, bx
        int     10h
;
        MOV     DX, (offset initialize - offset JumpTable)+CodeStart ; Top of code address
        INT     27H                    ; Terminate but stay resident
INIT    ENDP
CSEG    ENDS
        END  BWVID
                                                           