;
;                               q_cmds.inc
;
;
;       This INCLUDE file provides the tables and table-driven code
;       to implement a set of slash commands in command lines given
;       to QUERY, FUNKY, and other utilities.
;
;       To add a new command, increase the CMD_TOTAL param by one,
;       add the two characters that identify the command (usually
;       upper and lower case of a letter character) to the CMD_LETTERS
;       table, and add the entry point to the command execute procedure
;       to the CMD_OFFSETS table.
;
;
CMD_TOTAL       DW      3                       ;total commands defined
;
CMD_LETTERS     DB      'B','b'                 ;"beep" command
                DB      'L','l'                 ;"skip line" command
                DB      'D','d'                 ;"delimiter line" command
;
CMD_OFFSETS     DW      BEEP                    ;"beep" procedure
                DW      SKIP                    ;"skip line" procedure
                DW      DELIM_LINE              ;"delimiter line" procedure
;
;       equates for procedures
;
BORDER_CHAR     EQU     0CDH                    ;"double line" graphics char
;
;       data for procedures
;
NEW_LINE        DB      CR,LF,'$'
;
;       procedure code
;
BEEP            PROC    NEAR
                MOV     DL,BEL_CHAR             ;ascii bell char code
                MOV     AH,2                    ;"display one char" DOS call
                INT     21H                     ;call DOS
                RET                             ;done
BEEP            ENDP
;
SKIP            PROC    NEAR
                MOV     DX,OFFSET NEW_LINE      ;offset of CR, LF
                MOV     AH,9                    ;"display string" DOS call
                INT     21H                     ;call DOS
                RET                             ;done
SKIP            ENDP
;
DELIM_LINE      PROC    NEAR
                MOV     AH,15                   ;"get current page" BIOS call
                INT     10H                     ;call BIOS video
                PUSH    AX                      ;save number of cols in AH
                MOV     AH,8                    ;"get current attribute" call
                INT     10H                     ;call BIOS video
                MOV     BL,AH                   ;attribute into BL
                POP     AX                      ;number cols restored in AH
                SUB     CH,CH                   ;zero CH
                MOV     CL,AH                   ;move number of cols to CL
                MOV     AL,BORDER_CHAR          ;character code into AL
                MOV     AH,9                    ;"display char/attrib" BIOS call
                INT     10H                     ;call BIOS video
                MOV     DX,OFFSET NEW_LINE      ;skip line
                MOV     AH,9                    ;"display string" DOS call
                INT     21H                     ;call DOS
                RET                             ;done
DELIM_LINE      ENDP
;
;               --------        end of q_cmds.inc       --------
;
         cmd2.                               s