program WDir1;
{  Usage:

    dirdemo [options] [directory mask]

  Options:

    -W      Wide display
    -N      Sort by file name
    -S      Sort by file size
    -T      Sort by file date and time

  Directory mask:

    Path, Filename, wildcards, etc.

}

{$I-,S-}
{$M 8192,8192,655360}

uses Dos, Graph, Drivers, Fonts;

const
  MaxDirSize = 512;
  MonthStr: array[1..12] of string[3] = (
    'Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun',
    'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec');

type
  DirPtr   = ^DirRec;
  DirRec   = record
               Attr: Byte;
               Time: Longint;
               Size: Longint;
               Name: string[12];
             end;
  DirList  = array[0..MaxDirSize - 1] of DirPtr;
  LessFunc = function(X, Y: DirPtr): Boolean;

var
  WideDir: Boolean;
  Count: Integer;
  Less: LessFunc;
  Path: PathStr;
  Dir: DirList;
  Drive: longint;
  ErrorMess: String[50];

function NumStr(N, D: Integer): String;
begin
  NumStr[0] := Chr(D);
  while D > 0 do
  begin
    NumStr[D] := Chr(N mod 10 + Ord('0'));
    N := N div 10;
    Dec(D);
  end;
end;

{$F+}

function LessName(X, Y: DirPtr): Boolean;
begin
  LessName := X^.Name < Y^.Name;
end;

function LessSize(X, Y: DirPtr): Boolean;
begin
  LessSize := X^.Size < Y^.Size;
end;

function LessTime(X, Y: DirPtr): Boolean;
begin
  LessTime := X^.Time > Y^.Time;
end;

{$F-}

procedure QuickSort(L, R: Integer);
var
  I, J: Integer;
  X, Y: DirPtr;
begin
  I := L;
  J := R;
  X := Dir[(L + R) div 2];
  repeat
    while Less(Dir[I], X) do Inc(I);
    while Less(X, Dir[J]) do Dec(J);
    if I <= J then
    begin
      Y := Dir[I];
      Dir[I] := Dir[J];
      Dir[J] := Y;
      Inc(I);
      Dec(J);
    end;
  until I > J;
  if L < J then QuickSort(L, J);
  if I < R then QuickSort(I, R);
end;

procedure GetCommand;
var
  I,J: Integer;
  Attr: Word;
  S: PathStr;
  D: DirStr;
  N: NameStr;
  E: ExtStr;
  F: File;
begin
  WideDir := False;
  @Less := nil;
  Path := '';
  for I := 1 to ParamCount do
  begin
    S := ParamStr(I);
    if S[1] = '-' then
      for J := 2 to Length(S) do
        case UpCase(S[J]) of
          'N': Less := LessName;
          'S': Less := LessSize;
          'T': Less := LessTime;
          'W': WideDir := True;
        else
          WriteLn('Invalid option: ', S[J]);
          Halt(1);
        end
    else
      Path := S;
  end;
  Path := FExpand(Path);
  if Path[Length(Path)] <> '\' then
  begin
    Assign(F, Path);
    GetFAttr(F, Attr);
    if (DosError = 0) and (Attr and Directory <> 0) then
      Path := Path + '\';
  end;
  FSplit(Path, D, N, E);
  if N = '' then N := '*';
  if E = '' then E := '.*';
  Path := D + N + E;
end;

procedure FindFiles;
var
  F: SearchRec;
begin
  Count := 0;
  FindFirst(Path, ReadOnly + Directory + Archive, F);
  while (DosError = 0) and (Count < MaxDirSize) do
  begin
    GetMem(Dir[Count], Length(F.Name) + 10);
    Move(F.Attr, Dir[Count]^, Length(F.Name) + 10);
    Inc(Count);
    FindNext(F);
  end;
end;

procedure SortFiles;
begin
  if (Count <> 0) and (@Less <> nil) then
    QuickSort(0, Count - 1);
end;

procedure SetError(ErrorMess : string);

begin
  SetActivePage(0);
  SetTextJustify(CenterText,BottomText);
  OutTextXY(320,250,ErrorMess);
  Readln;
  RestoreCRTMode;
  halt;
end;

procedure GetDriveSize(ErrorMess : string; var Drive: Longint);
var
   I : integer;

begin
  I := Ord(Path[1]) - 64;
  if I > 26 then
   begin
    ErrorMess := 'Invalid Drive!  Press Return to continue.';
    SetError(ErrorMess);
   end;
  Drive := DiskSize(I) div 1024;
end;


procedure PrintFiles(Drive:longint);
const
  MaxiY = 330;

var
  I, P, J : Integer;
  Total: Longint;
  T: DateTime;
  N: NameStr;
  E: ExtStr;
  FreeY : integer;
  Direct: String[100];
  Tail, Count1, Total1, Diskfree1, FileName: String[50];
  Tail1, FileSize : String[25];
  Diskfree2 :longint;
  Count2, Count3, Start, Box1Y, Box2Y, Box3Y :integer;
  Percent, Percent1 : longint;
  Drive1 : String;
  DownY : integer;

procedure SetWindow(Count : integer; var DownY : integer);
var
  UpX,UpY,DownX : integer;

begin
  DownX := GetMaxX;
  if Count < 69 then
    if Count <> 0 then
    DownY := (Count div 3)*10+100;
  UpX := DownX div 2 - 20; UpY := 0;
  SetViewPort(UpX,UpY,DownX,DownY,ClipOn);
  SetWriteMode(CopyPut);
  SetFillStyle(1,Cyan);
  FloodFill(1,1,Cyan);
  Rectangle(0,0,DownX-300,DownY);
  SetTextStyle(1,0,2);
end;

procedure adjustdrive1(var Drive1:String);

var
  Drive2 : String[25];

begin
  if length(Drive1) > 6 then
   begin
    Drive2 := Copy(Drive1,1,length(Drive1)-6);
    Drive1 := Drive2 + '.'+ Copy(Drive1,3,1)+ ' M';
   end
  else if length(Drive1) < 7 then
    begin
      Drive2 := Copy(Drive1,1,length(Drive1)-3);
      Drive1 := Drive2 + ' K';
    end;
end;


begin
  DownY := MaxiY;
  if Count = 0 then
  begin
    ErrorMess := 'No matching files... Press return to continue.';
    SetError(ErrorMess);
  end;
  Direct := ('Directory of ' + Path);
  Str(Count,Count1);
  SetWindow(Count,DownY);
  OutTextXY(10,10,Direct);
  SetTextStyle(0,0,1);
  Total := 0;
  Count2 := 50; Start := 10;Count3 := 0;
  for I := 0 to Count-1 do
  with Dir[I]^ do
    begin
    P := Pos('.', Name);
    if P > 1 then
    begin
      N := Copy(Name, 1, P - 1);
      E := Copy(Name, P + 1, 3);
    end else
    begin
      N := Name;
      E := '';
    end;
    FileName :=(N+ ' '+ E + ' ');
    OutTextXY(Start,Count2,FileName);
    Inc(Total,Size);
    Start := Start + 110;
    Count3:=Count3+1;
    if Count3 > 68 then
      begin
        SetVisualPage(1);
        OutTextXY(10,Count2+20,'Press Return to continue...');
        Readln;
        Start := 10;
        Count2 := 50;
        SetVisualPage(0);
        ClearViewPort;
        SetWindow(Count3,DownY);
        OutTextXY(10,10,Direct);
        SetTextStyle(0,0,1);
        Count3 := 0;
      end;
    if Start > 300 then
      begin
      Start:=10;
      Count2 := Count2 + 10;
      end;
  end;
  Str(Total,Total1);
  Diskfree2:= DiskFree(Ord(Path[1])-64);
  Str(Diskfree2,Diskfree1);
  Tail := (Count1+ ' files, ' + Total1 + ' bytes used' );
  Tail1 := ( Diskfree1 + ' bytes free');
  OutTextXY(10, DownY-30, Tail);
  OutTextXY(10, DownY-20, Tail1);
  SetViewPort(GetMaxX div 2, GetMaxY-30, GetMaxX, GetMaxY,ClipOn);
  OutTextXY(10,15,'Hit Return to Continue...');
  Percent := GetMaxY * (Drive - (DiskFree2 div 1024)) div Drive;
  Percent1 := Percent * (Total div 1024) div Drive;
  SetViewPort(0,0,((GetMaxX div 2) - 40),GetMaxY,ClipOn);
  SetFillStyle(XHatchFill,Blue);
  Box1Y := GetMaxY - (Percent - Percent1);
  OuttextXY(160,GetMaxY-7, '0 Bytes');
  Bar3D(100,Box1Y,140,GetMaxY,10,TopOff);
  SetFillStyle(SolidFill,Cyan);
  Box2Y := GetMaxY - Percent;
  Bar3D(100,Box2Y,140,Box1Y,10,TopOff);
  SetFillStyle(WideDotFill,Magenta);
  Box3Y := Box2Y - 1;
  Bar3D(100,7,140,Box3Y,10,TopOn);
  Str((Drive * 1024) - Diskfree2, Drive1);
  AdjustDrive1(Drive1);
  OutTextXY(160,Box3Y, Drive1+'Bytes');
  Str(Drive * 1024,Drive1);
  AdjustDrive1(Drive1);
  OutTextXY(160,0, Drive1+'Bytes');
  FreeY:=(Box3Y div 2)-5;
  if FreeY < 0 then FreeY := 5;
  OutTextXY(10,FreeY,'Free Disk');
  OutTextXY(10,FreeY+10, 'Space');
  OutTextXY(10,Box2Y+((Box1Y-Box2Y)-5),'Current');
  OutTextXY(10,Box2y+((Box1Y-Box2Y)+5),'Directory');
  OuttextXY(10,(Box2Y+((GetMaxY-Box2Y) div 2))-5, 'Used Disk');
  OutTextXY(10,(Box2Y+((GetMaxy-Box2Y) div 2)) + 5,'Space');
  SetVisualPage(1);
end;

procedure SetGraph;
  var
    GD, GM : integer;
    ErrorCode : integer;

procedure Abort(Msg : string);
begin
  Writeln(Msg, ': ', GraphErrorMsg(GraphResult));
  Halt(1);
end;

  begin
    if RegisterBGIdriver(@EGAVGADriverProc) < 0 then
       Abort('EGA/VGA');
    if RegisterBGIfont(@TriplexFontProc) < 0 then
       Abort('Triplex');
    GD := Detect;
    InitGraph(GD,GM,'');
    ErrorCode := GraphResult;
    if ErrorCode <> grOk then
    begin
      Writeln('Graphics error: ', GraphErrorMsg(ErrorCode));
      Writeln('Program aborted...');
      Halt(1);
    end;
    SetVisualPage(0);
    SetTextJustify(CenterText,CenterText);
    OuttextXY(GetMaxX div 2, getMaxY div 2, 'Reading Directory');
    SetTextJustify(LeftText,TopText);
    SetActivePage(1);
end;

begin
  SetGraph;
  GetCommand;
  FindFiles;
  SortFiles;
  GetDriveSize(ErrorMess,Drive);
  PrintFiles(Drive);
  Readln;
  CloseGraph;
  RestoreCRTMode;
end.
