/*--------------------------------------------------------------------------
  Name:         BATQUEST

  Author:       David Michmerhuizen

  Date:         August 1, 1986

  Language:     MicroSoft C ver 3.0

  Description:  Allows batch files to display a prompt and determine the
                users response via the DOS ERRORLEVEL.

                A prompt is displayed on the screen and a keystroke is
                read from the keyboard. The allowable keystrokes can
                be specified on the command line (see below), and if
                the keystroke received is not one of those, there is a
                beep and another keystroke is read. The DOS ERRORLEVEL
                is set depending on the keystroke read. If no allowable
                keystroke set was specified, any keystroke results in an
                errorlevel of 0. Otherwise, the errorlevel is the integer
                position of the keystroke in the set of allowable keystrokes.

  Subroutines:  charpos -- returns integer position of character in string
                charecho -- echos printable characters on screen.

  Call:         BATQUEST <"prompt"> [ <choices> ]

                where:   <prompt>  is a prompt string enclosed in double quote
                                   marks, and is required. However, you may
                                   make it null or blank.

                         <choices> is an optional character string whose
                                   characters are the valid responses to the
                                   prompt, in increasing ERRORLEVEL order.
                                   Embedded blanks are not allowed.  Lowercase
                                   letters are translated to uppercase.
                                   <choices> must be less than 40 characters
                                   long, and if any character is duplicated,
                                   only the last occurance will be found.  If
                                   <choices> is not present, then any character
                                   is a valid answer to the prompt.

  Example:      BATQUEST "Enter your choice ==> " 123ABCQ

                will display the message:  Enter your choice ==>
                which can only be answered with one of the characters:  123ABCQ
                which will return an ERRORLEVEL of 4 if answered with:  A
                which will return an ERRORLEVEL of 7 if answered with:  Q


---------------------------------------------------------------------------*/

#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <stdlib.h>

#define OR  ||
#define AND &&
#define NOT !
#define NE  !=
#define EQ  ==

#define MINARGS 2
#define MAXARGS 3
#define MAXARGLEN 40

/*-------------------------------------------------------------------*/

main(argc, argv)

    int argc;                 /* number of arguments passed */
    char *argv[];             /* array of argument strings */

 {    /*** start of main ***/

 char *UpperArgs,inchar;
 int  choice;



/*--------------------------------------------------------------------
**  if not enough args
**     say not enough
**     exit
**  endif
** if too many args
**    say too many
**    exit
** endif
** if too many choices
**    say too many
**    exit
** endif
**/

 if (argc < MINARGS) {
    printf("\n");
    printf("Format is:  BATQUEST  <prompt>  [ <choices> ]\n");
    printf("\n");
    printf("where:   <prompt>  is a prompt string enclosed in double quote marks, and\n");
    printf("                   is required. However, you may make it null or blank.\n");
    printf("\n");
    printf("         <choices> is an optional character string whose characters are the\n");
    printf("                   valid responses to the prompt, in increasing ERRORLEVEL\n");
    printf("                   order. Embedded blanks are not allowed.  Lowercase letters\n");
    printf("                   are translated to uppercase. <choices> must be less than\n");
    printf("                   40 characters long, and if any character is duplicated,\n");
    printf("                   only the last occurance will be found.  If <choices> is not\n");
    printf("                   present, then any character is a valid answer to the prompt.\n");
    printf("\n");
    printf("Example.   BATQUEST \"Enter your choice ==> \" 123ABCQ\n");
    printf("\n");
    printf("           will display the message:  Enter your choice ==>\n");
    printf("           which can only be answered with one of the characters:  123ABCQ\n");
    printf("           which will return an ERRORLEVEL of 4 if answered with:  A\n");
    printf("           which will return an ERRORLEVEL of 7 if answered with:  Q\n");
    printf("\n");
    printf("written for the Public Domain by David Michmerhuizen, Oakland CA, 1986\n");
    printf("\n");
    exit(0);
    }
 if (argc > MAXARGS) {
    printf("\007Too many arguments. Type BATQUEST for more information\n");
    exit(0);
    }
 if ((argc == MINARGS) AND (strlen(argv[2]) > MAXARGLEN)) {
    printf("\007Too many choices. Type BATQUEST for more information\n");
    exit(0);
    }

/*---------------------------------------------------------------------------
** translate choices to uppercase
** write the prompt
** answer is not valid
** do while answer is not valid
**    read the answer
**    if it isn't valid
**       beep
**    endif
** enddo
** exit with errorlevel code
**/

 UpperArgs = strupr(argv[2]);
 printf("%s",argv[1]);
 if (strlen(UpperArgs) == 0) {
    inchar = toupper(getch());
    CharEcho(inchar);
    if (inchar EQ '\0') inchar = getch();
    choice = 0;
    }
 else {
    while( NOT (choice = charpos(inchar = toupper(getch()),UpperArgs)) ) {
       CharEcho(inchar);
       putchar('\007');
       if (inchar EQ '\0') inchar = getch();
       }
    CharEcho(inchar);
    if (inchar EQ '\0') inchar = getch();
    }
 exit(choice);
 }

/**************************************************************************/
/**************************************************************************/

    int charpos(c,s)
    char c, s[];
       {
       int indx, pos;
       for (indx = 0,pos = 0; s[indx]; ++indx)
          if (c == s[indx]) pos = indx+1;
       return(pos);
       }

/*-------------------------------------------------------------------------*/

#define LOCHAR '\x20'
#define HICHAR '\x7e'

    CharEcho(c)
    char c;
       {
       if ((c >= LOCHAR) AND (c <= HICHAR)) {
          putchar(c);
          putchar('\b');
          }
       }
