10 REM   E I G H T  C U R V E S
11 REM
12 REM Adapted from the program Eight Curves in Basic Programs for Production
13 REM and Operations Management by Pricha Pantumsinchai, M. Zia Hassan and
14 REM Ishwar D. Gupta, Prentice Hall, Englewood Cliffs, NJ Copyright 1983
15 REM Adapted by Joseph C. Hudson 4198 Warbler Dr. Flint MI 48504
20 REM
30 REM   THIS PROGRAM PERFORMS CURVE FITTING OF TWO VARIABLES
40 REM   UP TO EIGHT TYPES OF CURVES. X = INDEPENDENT VARIABLE
50 REM   Y = DEPENDENT VARIABLE
60 REM
65 GOSUB 4360
70 DIM U(N0),V(N0),X(N0),Y(N0),P(N0),P$(N0),DATAROW(1)
80 DIM A(8),B(8),C(8),F(8),R(8),T(8),W(8),Z(12)
280 GOTO 700
310 PRINT
320 PRINT "COMMAND -->";
330 C$ = INKEY$ :  IF C$ = "" THEN 330
335 PRINT " ",C$
340 ON INSTR("ADEQCHILPRSGW*adeqchilprsgw*",C$) MOD 14 GOSUB 1090,1090,                       4810,470,4890,4630,890,1330,5030,2550,1730,700,9000
350 GOTO 310
470 KEY ON : END
700 REM INPUT DATA FROM DISK
710 PRINT
720 INPUT "What is the name of the data file" ; DATAFILE$
725 PRINT "There must be at least 3 and at most ";N0;" rows of data."
730 INPUT "How many rows of data are there" ; N
740 INPUT "How many columns of data are there"; NUMCOL
745 PRINT "Is there anything in the file after column";NUMCOL;:INPUT ANS$
747 IND = 0 : IF RIGHT$(ANS$,1) = "y" OR RIGHT$(ANS$,1) = "Y" THEN IND = 1
750 ERASE DATAROW : DIM DATAROW(NUMCOL)
760 INPUT "Which column is Y"; YCOL
770 INPUT "Which column is X"; XCOL
780 OPEN DATAFILE$ FOR INPUT AS #1
790 FOR I = 1 TO N
800   FOR J = 1 TO NUMCOL
810      INPUT #1,DATAROW(J)
820   NEXT J
830   IF IND = 1 THEN LINE INPUT #1, DUMMY$
840   X(I) = DATAROW(XCOL) : Y(I) = DATAROW(YCOL)
850 NEXT I
860 CLOSE #1
870 GOSUB 4630
880 GOTO 310
890 REM INSERT COMMAND
900 REM --------------
910 PRINT
920 PRINT "INSERT AFTER OBSERVATION NUMBER -->";
930 INPUT N1
940 IF N1 < 0 THEN 1080
950 IF N1 > N THEN 1080
960 IF N >= N0 THEN 1080
970 PRINT
980 PRINT "ENTER OBSERVATION ";N1+1;" IN THE FORM X,Y :";
990 INPUT A(1),B(1)
1000 IF N1 = N THEN 1050
1010 FOR I = N TO N1+1 STEP -1
1020 X(I+1) = X(I)
1030 Y(I+1) = Y(I)
1040 NEXT I
1050 X(N1+1) = A(1)
1060 Y(N1+1) = B(1)
1070 N = N + 1
1075 K9 = 0
1080 RETURN
1090 REM CHANGE OR DELETE COMMANDS
1100 REM -------------------------
1110 PRINT "OBSERVATION NUMBER -->";
1120 INPUT K
1130 IF K <= 0 THEN 1160
1140 IF K <= N THEN 1170
1150 PRINT "LAST OBSERVATION NUMBER IS ";N
1160 RETURN
1170 IF C$ = "DELETE" OR C$ = "delete" THEN 1240
1180 PRINT "ENTER X,Y -->";
1190 INPUT X1,Y1
1200 X(K) = X1
1210 Y(K) = Y1
1220 K9 = 0
1230 RETURN
1240 IF N = 1 THEN 470
1250 FOR I = K TO N-1
1260 X(I) = X(I+1)
1270 Y(I) = Y(I+1)
1280 NEXT I
1290 N = N-1
1300 PRINT "OBSERVATION ";K;" DELETED."
1310 K9 = 0
1320 RETURN
1330 REM LIST COMMAND  -  LIST OBSERVATIONS AND STATISTICS
1340 REM -------------------------------------------------
1350 X1 = 0
1360 X2 = 0
1370 Y1 = 0
1380 Y2 = 0
1390 X8 = E7
1400 X9 = E8
1410 Y8 = E7
1420 Y9 = E8
1430 FOR I = 1 TO N
1440 X1 = X1 + X(I)
1450 Y1 = Y1 + Y(I)
1460 X2 = X2 + X(I) * X(I)
1470 Y2 = Y2 + Y(I) * Y(I)
1480 IF X(I) >= X8 THEN 1500
1490 X8 = X(I)
1500 IF X(I) <= X9 THEN 1520
1510 X9 = X(I)
1520 IF Y(I) >= Y8 THEN 1540
1530 Y8 = Y(I)
1540 IF Y(I) <= Y9 THEN 1560
1550 Y9 = Y(I)
1560 NEXT I
1570 LPRINT
1580 LPRINT "OBSERVATION";TAB(15);"X";TAB(30);"Y"
1590 FOR I = 1 TO N
1600 LPRINT TAB(5);I;TAB(13);X(I);TAB(28);Y(I)
1610 NEXT I
1620 IF N <= 1 THEN 1720
1630 X2 = SQR((X2-X1*X1/N)/(N-1))
1640 Y2 = SQR((Y2-Y1*Y1/N)/(N-1))
1650 X1 = X1/N
1660 Y1 = Y1/N
1670 LPRINT
1680 LPRINT "   MEAN";TAB(13);X1;TAB(28);Y1
1690 LPRINT "STD DEV";TAB(13);X2;TAB(28);Y2
1700 LPRINT "MINIMUM";TAB(13);X8;TAB(28);Y8
1710 LPRINT "MAXIMUM";TAB(13);X9;TAB(28);Y9
1720 RETURN
1730 REM SOLVE COMMAND
1740 REM -------------
1750 IF K9 = 1 THEN 2250
1760 IF N >= 3 THEN 1800
1770 PRINT
1780 PRINT "NOT ENOUGH OBSERVATIONS. PLEASE ADD MORE DATA"
1790 RETURN
1800 GOSUB 3440
1810 REM
1820 REM CALCULATE COEFICIENTS FOR THE EIGHT CURVES
1830 R(1) = Z(7) - Z(1)*Z(1)/N
1840 B(1) = (W(1)-Z(1)*Z(2)/N)/R(1)
1850 A(1) = (Z(2)-B(1)*Z(1))/N
1860 T(1) = Z(8)-Z(2)*Z(2)/N
1870 IF C(2) < .5 THEN 1930
1880 R(2) = R(1)
1890 B(2) = (W(2)-Z(1)*Z(6)/N)/R(2)
1900 A(2) = (Z(6)-B(2)*Z(1))/N
1910 A(2) = EXP(A(2))
1920 T(2) = Z(12)-Z(6)*Z(6)/N
1930 IF C(3) < .5 THEN 1990
1940 R(3) = Z(11)-Z(5)*Z(5)/N
1950 B(3) = (W(3)-Z(5)*Z(6)/N)/R(3)
1960 A(3) = (Z(6)-B(3)*Z(5))/N
1970 A(3) = EXP(A(3))
1980 T(3) = T(2)
1990 IF C(4) < .5 THEN 2040
2000 R(4) = Z(9)-Z(3)*Z(3)/N
2010 B(4) = (W(4)-Z(3)*Z(2)/N)/R(4)
2020 A(4) = (Z(2)-B(4)*Z(3))/N
2030 T(4) = T(1)
2040 IF C(5) < .5 THEN 2090
2050 R(5) = R(1)
2060 B(5) = (W(5)-Z(1)*Z(4)/N)/R(5)
2070 A(5) = (Z(4)-B(5)*Z(1))/N
2080 T(5) = Z(10)-Z(4)*Z(4)/N
2090 IF C(6) < .5 THEN 2140
2100 R(6) = R(4)
2110 B(6) = (W(6)-Z(3)*Z(4)/N)/R(6)
2120 A(6) = (Z(4)-B(6)*Z(3))/N
2130 T(6) = T(5)
2140 IF C(6) < .5 THEN 2190
2150 R(7) = Z(11)-Z(5)*Z(5)/N
2160 B(7) = (W(7)-Z(5)*Z(2)/N)/R(7)
2170 A(7) = (Z(2)-B(7)*Z(5))/N
2180 T(7) = T(1)
2190 IF C(8) < .5 THEN 2240
2200 R(8) = R(4)
2210 B(8) = (W(8)-Z(6)*Z(3)/N)/R(8)
2220 A(8) = (Z(6)-B(8)*Z(3))/N
2230 T(8) = T(2)
2240 K9 = 1
2250 LPRINT
2260 LPRINT
2270 LPRINT "CURVE";TAB(8);"EQUATION";TAB(25);"A";TAB(40)"B";
2280 LPRINT TAB(55);"R SQUARED";TAB(70);"ADJ. R SQUARED"
2290 FOR J = 1 TO J0
2300 IF C(J) < .5 THEN 2350
2310 LPRINT TAB(2);J;TAB(8);Q$(J);
2315 R1 = 1
2320 IF T(J) > 0 THEN R1 = B(J) * B(J) * R(J) / T(J)
2330 R2 = 1-(1-R1)*(N-1)/(N-2)
2340 LPRINT TAB(24);A(J);TAB(39);B(J);TAB(54);R1;TAB(69);R2
2350 NEXT J
2360 LPRINT
2370 LPRINT
2380 LPRINT "A N A L Y S I S    O F    V A R I A N C E"
2390 LPRINT
2400 LPRINT "CURVE";TAB(8);"SS-REGRESSION";TAB(23);"SS-RESIDUAL";
2410 LPRINT TAB(38);"SS-TOTAL";TAB(53);"F-VALUE"
2420 FOR J = 1 TO J0
2430 IF C(J) < .5 THEN 2500
2440 S1 = B(J)*B(J)*R(J)
2450 S2 = T(J)-S1
2455 S3 = 1E+20
2460 IF S2 > 0 THEN S3 = S1 / S2 * (N-2)
2470 LPRINT TAB(3);J;TAB(7);S1;TAB(22);S2;TAB(37);T(J);TAB(52);S3
2500 NEXT J
2510 LPRINT " D.F.",1,N-2,N-1
2520 LPRINT
2530 LPRINT
2540 RETURN
2550 REM RESIDUAL COMMAND
2560 REM ----------------
2570 GOSUB 2830
2580 IF I0 > .5 THEN 2600
2590 RETURN
2600 S1 = 0
2610 S2 = 0
2620 LPRINT "OBSERVATION";TAB(15);"X";TAB(30);"Y";TAB(45);"FITTED Y";
2630 LPRINT TAB(60);"RESIDUAL";TAB(75);"% ERROR"
2640 FOR I = 1 TO N
2650 X0 = X(I)
2660 GOSUB 3140
2670 E0 = Y(I)-Y0
2680 S2 = S2 + E0*E0
2690 P1 = 999
2700 IF Y(I) = 0 THEN 2720
2710 P1 = ABS(E0/Y(I)*100)
2720 S1 = S1 + P1
2730 LPRINT TAB(5);I;TAB(14);X(I);TAB(29);Y(I);TAB(44);Y0;TAB(59);E0;TAB(74);P1
2750 NEXT I
2760 S1 = S1/N
2770 S2 = S2/N
2780 LPRINT
2790 LPRINT "MEAN ABSOLUTE % ERROR  ";S1
2800 LPRINT "MEAN SQUARE ERROR      ";S2
2810 LPRINT
2820 RETURN
2830 REM SCREENING PROCESS
2840 REM -----------------
2850 I0 = 0
2860 IF K9 > .5 THEN 2900
2870 PRINT
2880 PRINT "USE THE SOLVE COMMAND FIRST."
2890 RETURN
2900 PRINT
2910 PRINT "ENTER CURVE NUMBER -->";
2920 INPUT K0
2930 IF K0 <= 0 THEN 2990
2940 IF K0 > J0 THEN 2990
2950 IF C(K0) > .5 THEN 3020
2960 PRINT
2970 PRINT "DATA NOT ELIGABLE FOR SOLUTION OF CURVE",K0
2980 RETURN
2990 PRINT
3000 PRINT "*** INVALID CURVE NUMBER ***"
3010 RETURN
3020 I0 = 1
3030 LPRINT
3040 LPRINT
3050 LPRINT
3060 LPRINT "CURVE";TAB(8);"EQUATION";TAB(25);"A";TAB(40)"B";
3070 LPRINT TAB(55);"R SQUARED";TAB(70);"ADJ. R SQUARED"
3080 LPRINT TAB(2);K0;TAB(8);Q$(K0);
3090 R1 = B(K0)*B(K0)*R(K0)/T(K0)
3100 R2 = 1-(1-R1)*(N-1)/(N-2)
3110 LPRINT TAB(24);A(K0);TAB(39);B(K0);TAB(54);R1;TAB(69);R2
3120 LPRINT
3130 RETURN
3140 REM CALCULATE FITTED-Y VALUE ==> Y0
3150 Y0 = 0
3160 ON K0 GOTO 3230,3250,3270,3300,3330,3360,3390,3410
3230 Y0 = A(1)+B(1)*X0
3240 RETURN
3250 Y0 = A(2)*EXP(B(2)*X0)
3260 RETURN
3270 IF X0 < 0 THEN 3290
3280 Y0 = A(3)*X0^B(3)
3290 RETURN
3300 IF X0 = 0 THEN 3320
3310 Y0 = A(4)+B(4)/X0
3320 RETURN
3330 IF A(5)+B(5)*X0 = 0 THEN 3350
3340 Y0 = 1/(A(5)+B(5)*X0)
3350 RETURN
3360 IF A(6)*X0+B(6) = 0 THEN 3380
3370 Y0 = X0/(A(6)*X0+B(6))
3380 RETURN
3390 IF X0 <= 0 THEN 3410
3400 Y0 = A(7) + B(7)*LOG(X0)
3410 IF X0 = 0 THEN 3430
3420 Y0 = EXP(A(8)+B(8)/X0)
3430 RETURN
3440 REM DETERMINE ELIGIBILITY FOR CALCULATION OF EACH CURVE
3450 REM ---------------------------------------------------
3460 FOR J = 1 TO J0 : C(J) = 1 : W(J) = 0 : NEXT J
3500 X8 = 0
3510 X9 = 0
3520 Y8 = 0
3530 Y9 = 0
3540 FOR I = 1 TO N
3550 IF ABS(X(I)) > E9 THEN 3570
3560 X8 = 1
3570 IF X(I) > E9 THEN 3590
3580 X9 = 1
3590 IF ABS(Y(I)) > E9 THEN 3610
3600 Y8 = 1
3610 IF Y(I) > E9 THEN 3630
3620 Y9 = 1
3630 NEXT I
3640 IF Y9 < .5 THEN 3680
3650 C(2) = 0
3660 C(3) = 0
3670 C(8) = 0
3680 IF X9 < .5 THEN 3710
3690 C(3) = 0
3700 C(7) = 0
3710 IF Y8 < .5 THEN 3770
3720 C(2) = 0
3730 C(3) = 0
3740 C(5) = 0
3750 C(6) = 0
3760 C(8) = 0
3770 IF X8 < .5 THEN 3830
3780 C(3) = 0
3790 C(4) = 0
3800 C(6) = 0
3810 C(7) = 0
3820 C(8) = 0
3830 REM
3840 REM CALCULATE LOG(X) AND LOG(Y)
3850 IF Y9 > .5 THEN 3890
3860 FOR I = 1 TO N
3870 V(I) = LOG(Y(I))
3880 NEXT I
3890 IF X9 > .5 THEN 3930
3900 FOR I = 1 TO N
3910 U(I) = LOG(X(I))
3920 NEXT I
3930 FOR I = 1 TO 12
3940 Z(I) = 0
3950 NEXT I
3960 FOR I = 1 TO N
3970 Z(1) = Z(1) + X(I)
3980 Z(2) = Z(2) + Y(I)
3990 IF X8 > .5 THEN 4030
4000 Z0 = 1/X(I)
4010 Z(3) = Z(3) + Z0
4020 Z(9) = Z(9) + Z0*Z0
4030 IF Y8 > .5 THEN 4070
4040 Z0 = 1/Y(I)
4050 Z(4) = Z(4) +Z0
4060 Z(10) = Z(10) + Z0*Z0
4070 IF X9 > .5 THEN 4100
4080 Z(5) = Z(5) + U(I)
4090 Z(11) = Z(11) + U(I) * U(I)
4100 IF Y9 > .5 THEN 4130
4110 Z(6) = Z(6) + V(I)
4120 Z(12) = Z(12) + V(I) * V(I)
4130 Z(7) = Z(7) + X(I) * X(I)
4140 Z(8) = Z(8) + Y(I) * Y(I)
4150 NEXT I
4160 REM
4170 REM CALCULATE CROSS PRODUCT TERMS
4180 FOR I = 1 TO N
4190 W(1) = W(1) + X(I) * Y(I)
4200 IF C(2) < .5 THEN 4220
4210 W(2) = W(2) + V(I) * X(I)
4220 IF C(3) < .5 THEN 4240
4230 W(3) = W(3) + U(I) * V(I)
4240 IF C(4) < .5 THEN 4260
4250 W(4) = W(4) + Y(I) / X(I)
4260 IF C(5) < .5 THEN 4280
4270 W(5) = W(5) + X(I) / Y(I)
4280 IF C(6) < .5 THEN 4300
4290 W(6) = W(6) + 1 / ( X(I) *  Y(I) )
4300 IF C(7) < .5 THEN 4320
4310 W(7) = W(7) + Y(I) * U(I)
4320 IF C(8) < .5 THEN 4340
4330 W(8) = W(8) + V(I) / X(I)
4340 NEXT I
4350 RETURN
4360 REM I N I T I A L I Z A T I O N
4370 REM ---------------------------
4380 N = 0 : K9 = 0  : N0 = 100 : J0 = 8
4400 E9 = 1E-08
4410 E8 = -9.999999E-21
4420 E7 = 1E+20
4430 Q$(1) = "Y = A+B*X     "
4440 Q$(2) = "Y = A*EXP(B*X)"
4450 Q$(3) = "Y = A*(X^B)   "
4460 Q$(4) = "Y = A+B/X     "
4470 Q$(5) = "Y = 1/(A+B*X) "
4480 Q$(6) = "Y = X/(A*X+B) "
4490 Q$(7) = "Y = A+B*LOG(X)"
4500 Q$(8) = "Y = EXP(A+B/X)"
4590 WIDTH "LPT1:",132 : KEY OFF
4600 LPRINT CHR$(27);+"B"+CHR$(3)+CHR$(27)+"M"+CHR$(10)
4620 RETURN
4630 REM   H E L P   C O M M A N D
4640 REM   -----------------------
4650 CLS : LOCATE 3,1
4660 COLOR 31,0 : PRINT "A"; : COLOR 7,0 : PRINT "lter an observation";
4670 COLOR 31,0 : PRINT TAB(30);"D"; : COLOR 7,0
4680 PRINT "elete an observation" : PRINT : COLOR 31,0
4690 PRINT "C"; : COLOR 7,0 : PRINT "alculate a yhat value"; : COLOR 31,0
4700 PRINT TAB(30);"H"; : COLOR 7,0 : PRINT "elp" : PRINT
4710 PRINT "show "; : COLOR 31,0 : PRINT "E"; : COLOR 7,0
4720 PRINT "quation forms"; : COLOR 31,0 : PRINT TAB(30);"Q";
4730 COLOR 7,0 : PRINT "uit the program" : PRINT  : COLOR 31,0
4750 PRINT "I"; : COLOR 7,0 : PRINT "nsert an observation"; : COLOR 31,0
4760 PRINT TAB(30);"L"; : COLOR 7,0 : PRINT "ist data and summary statistics"
4770 PRINT : COLOR 31,0 : PRINT "P"; : COLOR 7,0
4774 PRINT "lot a curve and the data    print "; : COLOR 31,0
4776 PRINT "R"; : COLOR 7,0 : PRINT "esiduals" : PRINT : COLOR 31,0
4780 PRINT "S"; : COLOR 7,0 : PRINT "olve the equations" : PRINT : COLOR 31,0
4782 PRINT "G"; : COLOR 7,0 : PRINT "et data from disk"; : COLOR 31,0
4784 PRINT TAB(30);"W"; : COLOR 7,0 : PRINT "rite data to disk" : PRINT : PRINT
4800 RETURN
4810 REM   C U R V E S   C O M M A N D
4820 REM   ---------------------------
4830 LPRINT : LPRINT "CURVE";TAB(10);"EQUATION"
4840 FOR J = 1 TO J0
4850 LPRINT TAB(2);J;TAB(9);Q$(J)
4860 NEXT J
4870 LPRINT
4880 RETURN
4890 REM   F O R E C A S T   C O M M A N D
4900 REM   -------------------------------
4910 GOSUB 2830
4920 IF I0 > .5 THEN 4950
4930 RETURN
4940 PRINT
4950 PRINT "ENTER X-VALUE (OR -99999 TO RETURN) -->";
4960 INPUT X0
4970 IF X0 = -99999! THEN 5020
4980 GOSUB 3140
4990 LPRINT
5000 LPRINT "X = ";X0;"   Yhat = ";Y0
5010 GOTO 4940
5020 RETURN
5030 REM   P L O T   C O M M A N D
5040 REM   -----------------------
5050 GOSUB 2830
5060 IF I0 > .5 THEN 5080
5070 RETURN
5080 REM
5090 REM   SORT Y(I) HIGH TO LOW
5100 FOR I = 1 TO N
5110 P(I) = I
5120 NEXT I
5130 FOR I = 1 TO N-1
5140 Z0 = Y(P(I))
5150 FOR J = I+1 TO N
5160 IF Z0 >= Y(P(J)) THEN 5210
5170 Z0 = Y(P(J))
5180 SWAP P(I),P(J)
5210 NEXT J
5220 NEXT I
5230 REM
5240 REM     FIND MIN/MAX OF X(I) , Y(I)
5250 X8 = E7
5260 X9 = E8
5270 Y8 = E7
5280 Y9 = E8
5290 FOR I = 1 TO N
5300 IF X(I) >= X8 THEN 5320
5310 X8 = X(I)
5320 IF X(I) <= X9 THEN 5340
5330 X9 = X(I)
5340 IF Y(I) >= Y8 THEN 5360
5350 Y8 = Y(I)
5360 IF Y(I) <= Y9 THEN 5380
5370 Y9 = Y(I)
5380 NEXT I
5390 REM
5400 REM   DETERMINE SCALING FOR Y AXIS
5410 A0 = Y8
5420 A1 = Y9
5430 GOSUB 6810
5440 IF L5 > 0 THEN 5460
5450 RETURN
5460 Y1 = L0
5470 Y2 = U0
5480 Y3 = H0
5490 Y4 = Y3/8
5500 REM
5510 REM    DETERMINE SCALING FOR X AXIS
5520 A0 = X8
5530 A1 = X9
5540 GOSUB 6810
5550 IF L5 > 0 THEN 5570
5560 RETURN
5570 X1 = L0
5580 X2 = U0
5590 X3 = H0
5600 X4 = X3/20
5610 LPRINT
5620 LPRINT TAB(61);"X-VALUE"
5630 GOSUB 5840
5640 GOSUB 5950
5650 I = 1
5660 M = 8
5670 Y5 = Y2 - Y4/2
5680 Y6 = Y5 + Y4
5690 L0 = Y2
5700 GOSUB 6030
5710 FOR L = 1 TO 5
5720 L0 = L0 - Y3
5730 FOR M = 1 TO 8
5740 Y6 = Y5
5750 Y5 = Y6 - Y4
5760 GOSUB 6030
5770 NEXT M
5780 NEXT L
5790 GOSUB 5950
5800 GOSUB 5840
5810 LPRINT TAB(61);"X-VALUE"
5820 LPRINT
5830 RETURN
5840 REM
5850 REM PRINT AXIS LABEL
5860 H0 = X1
5870 LPRINT TAB(13);H0;
5880 FOR J = 1 TO 10
5890 H0 = H0 + X3/2
5900 LPRINT TAB(13+10*J);H0;
5910 NEXT J
5920 LPRINT
5930 RETURN
5940 REM
5950 REM   PRINT AXIS
5960 LPRINT TAB(14);"+";
5970 FOR J = 1 TO 10
5980 LPRINT "---------+";
5990 NEXT J
6000 LPRINT
6010 RETURN
6020 REM
6030 REM CALCULATE PLOT LINE
6040 FOR J = 0 TO 100
6050 P$(J) = " "
6060 NEXT J
6070 J9 = 0
6080 IF I > N THEN 6220
6090 J2 = I
6100 FOR J1 = J2 TO N
6110 IF Y(P(J1)) < Y5 THEN 6190
6120 N9 = INT((X(P(J1))-X1)/X4+.5)
6130 P$(N9) = "O"
6140 IF N9 <= J9 THEN 6160
6150 J9 = N9
6160 IF J1 <> N THEN 6210
6170 I = N + 1
6180 GOTO 6210
6190 I = J1
6200 GOTO 6240
6210 NEXT J1
6220 REM
6230 REM    CALCULATE FITTED VALUE OF X
6240 Y7 = (Y5 + Y6)/2
6250 ON K0 GOTO 6320,6350,6350,6420,6450,6480,6510,6540
6320 IF B(K0) = 0 THEN 6690
6330 X0 = (Y7-A(K0))/B(K0)
6340 GOTO 6590
6350 IF B(K0) = 0 THEN 6690
6360 IF A(K0) = 0 THEN 6690
6370 IF Y7/A(K0) <= 0 THEN 6690
6380 X0 = LOG(Y7/A(K0))/B(K0)
6390 IF K0 = 2 THEN 6590
6400 X0 = EXP(X0)
6410 GOTO 6590
6420 IF Y7 - A(K0) = 0 THEN 6690
6430 X0 = B(K0) / (Y7-A(K0))
6440 GOTO 6590
6450 IF Y7*B(K0) = 0 THEN 6690
6460 X0 = (1 - A(K0)*Y7) / (Y7*B(K0))
6470 GOTO 6590
6480 IF 1-A(K0)*Y7 = 0 THEN 6690
6490 X0 = B(K0)*Y7/(1-A(K0)*Y7)
6500 GOTO 6590
6510 IF B(K0) = 0 THEN 6690
6520 X0 = EXP((Y7-A(K0))/B(K0))
6530 GOTO 6590
6540 IF Y7 <= 0 THEN 6690
6550 X0 = LOG(Y7) - A(K0)
6560 IF X0 = 0 THEN 6690
6570 X0 = B(K0)/X0
6580 REM
6590 REM    CALCULATE FITTED PLOT POSITION
6600 IF X0 < X1 THEN 6690
6610 IF X0 > X2 THEN 6690
6620 N9 = INT((X0-X1)/X4+.5)
6630 IF P$(N9) = "O" THEN 6660
6640 P$(N9) = "*"
6650 GOTO 6670
6660 P$(N9) = "+"
6670 IF N9 <= J9 THEN 6690
6680 J9 = N9
6690 REM
6700 REM    PLOT THE LINE
6710 IF M <> 8 THEN 6750
6720 LPRINT L0; : LPRINT TAB(12);" +"; : GOTO 6760
6750 LPRINT TAB(12);" -";
6760 FOR J = 0 TO J9
6770 LPRINT P$(J);
6780 NEXT J
6790 LPRINT
6800 RETURN
6810 REM   S C A L I N G   R O U T I N E
6820 REM   -----------------------------
6830 L5 = 0
6840 A8 = A0
6850 A9 = A1
6860 A2 = (A1 - A0)/4
6870 IF A2 <= 0 THEN 7200
6880 L5 = L5 + 1
6890 A3 = LOG(A2)/LOG(10)
6900 REM
6910 REM    ROUND DOWN A3 TO A4
6920 A4 = INT(A3)
6930 IF A4 <= A3 THEN 6950
6940 A4 = A4 - 1
6950 A5 = 10^A4
6960 A6 = A2/A5
6970 REM
6980 REM    ROUND UP A6 TO A7
6990 A7 = INT(A6+1)
7000 H0 = A5 * A7
7010 REM    ROUND DOWN L0
7020 L0 = INT(A0/H0)
7030 IF L0 <= A0/H0 THEN 7050
7040 L0 = L0 - 1
7050 L0 = L0 * H0
7060 U0 = L0 + 5 * H0
7070 IF U0 >= A1 THEN 7100
7080 A1 = A1 + A2/2
7090 GOTO 6860
7100 IF L0 <= A0 THEN 7130
7110 A0 = A0 - A2/2
7120 GOTO 6860
7130 IF U0 - H0 <= A9 THEN 7160
7140 U0 = U0 - H0
7150 GOTO 7130
7160 IF L0 + H0 >= A8 THEN 7190
7170 L0 = L0 + H0
7180 GOTO 7160
7190 H0 = (U0 - L0)/5
7200 RETURN
7210 END
9000 REM   SAVE DATA TO DISK
9010 REM -------------------
9020 INPUT "File name to use";SAVEFILE$
9030 IF SAVEFILE$ = "" THEN RETURN
9040 OPEN SAVEFILE$ FOR APPEND AS #2
9050 FOR I = 1 TO N : PRINT #2,X(I);" ";Y(I) : NEXT I
9060 CLOSE #2
9070 RETURN
TURN
9040 OPEN SAVEFILE$ FOR APPEND AS #2
9050 FOR I = 1 TO N : PRINT #2,X(I);" ";Y(I) : NEXT I
9060 CLOSE #2
9070