/* xlftab1.c - xlisp function table - part 1 */
/*	Copyright (c) 1985, by David Michael Betz
	All Rights Reserved
	Permission is granted for unrestricted non-commercial use	*/

#include "xlisp.h"

/* external functions */
extern NODE
    *xeval(),*xapply(),*xfuncall(),*xquote(),*xfunction(),*xbquote(),
    *xset(),*xsetq(),*xsetf(),*xdefun(),*xdefmacro(),
    *xgensym(),*xmakesymbol(),*xintern(),
    *xsymname(),*xsymvalue(),*xsymplist(),*xget(),*xputprop(),*xremprop(),
    *xcar(),*xcaar(),*xcadr(),*xcdr(),*xcdar(),*xcddr(),
    *xcons(),*xlist(),*xappend(),*xreverse(),*xlast(),*xnth(),*xnthcdr(),
    *xmember(),*xassoc(),*xsubst(),*xsublis(),*xremove(),*xlength(),
    *xmapc(),*xmapcar(),*xmapl(),*xmaplist(),
    *xrplca(),*xrplcd(),*xnconc(),*xdelete(),
    *xatom(),*xsymbolp(),*xnumberp(),*xboundp(),*xnull(),*xlistp(),*xconsp(),
    *xeq(),*xeql(),*xequal(),
    *xcond(),*xand(),*xor(),*xlet(),*xletstar(),*xif(),
    *xprog(),*xprogstar(),*xprog1(),*xprog2(),*xprogn(),*xgo(),*xreturn(),
    *xcatch(),*xthrow(),
    *xerror(),*xcerror(),*xbreak(),*xcleanup(),*xcontinue(),*xerrset(),
    *xbaktrace(),*xevalhook(),
    *xdo(),*xdostar(),*xdolist(),*xdotimes(),
    *xminusp(),*xzerop(),*xplusp(),*xevenp(),*xoddp();

/* the function table */
struct fdef ftab1[] = {

	/* evaluator functions */
{	"EVAL",		SUBR,	xeval		},
{	"APPLY",	SUBR,	xapply		},
{	"FUNCALL",	SUBR,	xfuncall	},
{	"QUOTE",	FSUBR,	xquote		},
{	"FUNCTION",	FSUBR,	xfunction	},
{	"BACKQUOTE",	FSUBR,	xbquote		},

	/* symbol functions */
{	"SET",		SUBR,	xset		},
{	"SETQ",		FSUBR,	xsetq		},
{	"SETF",		FSUBR,	xsetf		},
{	"DEFUN",	FSUBR,	xdefun		},
{	"DEFMACRO",	FSUBR,	xdefmacro	},
{	"GENSYM",	SUBR,	xgensym		},
{	"MAKE-SYMBOL",	SUBR,	xmakesymbol	},
{	"INTERN",	SUBR,	xintern		},
{	"SYMBOL-NAME",	SUBR,	xsymname	},
{	"SYMBOL-VALUE",	SUBR,	xsymvalue	},
{	"SYMBOL-PLIST",	SUBR,	xsymplist	},
{	"GET",		SUBR,	xget		},
{	"PUTPROP",	SUBR,	xputprop	},
{	"REMPROP",	SUBR,	xremprop	},

	/* list functions */
{	"CAR",		SUBR,	xcar		},
{	"CAAR",		SUBR,	xcaar		},
{	"CADR",		SUBR,	xcadr		},
{	"CDR",		SUBR,	xcdr		},
{	"CDAR",		SUBR,	xcdar		},
{	"CDDR",		SUBR,	xcddr		},
{	"CONS",		SUBR,	xcons		},
{	"LIST",		SUBR,	xlist		},
{	"APPEND",	SUBR,	xappend		},
{	"REVERSE",	SUBR,	xreverse	},
{	"LAST",		SUBR,	xlast		},
{	"NTH",		SUBR,	xnth		},
{	"NTHCDR",	SUBR,	xnthcdr		},
{	"MEMBER",	SUBR,	xmember		},
{	"ASSOC",	SUBR,	xassoc		},
{	"SUBST",	SUBR,	xsubst		},
{	"SUBLIS",	SUBR,	xsublis		},
{	"REMOVE",	SUBR,	xremove		},
{	"LENGTH",	SUBR,	xlength		},
{	"MAPC",		SUBR,	xmapc		},
{	"MAPCAR",	SUBR,	xmapcar		},
{	"MAPL",		SUBR,	xmapl		},
{	"MAPLIST",	SUBR,	xmaplist	},

	/* destructive list functions */
{	"RPLACA",	SUBR,	xrplca		},
{	"RPLACD",	SUBR,	xrplcd		},
{	"NCONC",	SUBR,	xnconc		},
{	"DELETE",	SUBR,	xdelete		},

	/* predicate functions */
{	"ATOM",		SUBR,	xatom		},
{	"SYMBOLP",	SUBR,	xsymbolp	},
{	"NUMBERP",	SUBR,	xnumberp	},
{	"BOUNDP",	SUBR,	xboundp		},
{	"NULL",		SUBR,	xnull		},
{	"NOT",		SUBR,	xnull		},
{	"LISTP",	SUBR,	xlistp		},
{	"CONSP",	SUBR,	xconsp		},
{	"MINUSP",	SUBR,	xminusp		},
{	"ZEROP",	SUBR,	xzerop		},
{	"PLUSP",	SUBR,	xplusp		},
{	"EVENP",	SUBR,	xevenp		},
{	"ODDP",		SUBR,	xoddp		},
{	"EQ",		SUBR,	xeq		},
{	"EQL",		SUBR,	xeql		},
{	"EQUAL",	SUBR,	xequal		},

	/* control functions */
{	"COND",		FSUBR,	xcond		},
{	"AND",		FSUBR,	xand		},
{	"OR",		FSUBR,	xor		},
{	"LET",		FSUBR,	xlet		},
{	"LET*",		FSUBR,	xletstar	},
{	"IF",		FSUBR,	xif		},
{	"PROG",		FSUBR,	xprog		},
{	"PROG*",	FSUBR,	xprogstar	},
{	"PROG1",	FSUBR,	xprog1		},
{	"PROG2",	FSUBR,	xprog2		},
{	"PROGN",	FSUBR,	xprogn		},
{	"GO",		FSUBR,	xgo		},
{	"RETURN",	SUBR,	xreturn		},
{	"DO",		FSUBR,	xdo		},
{	"DO*",		FSUBR,	xdostar		},
{	"DOLIST",	FSUBR,	xdolist		},
{	"DOTIMES",	FSUBR,	xdotimes	},
{	"CATCH",	FSUBR,	xcatch		},
{	"THROW",	SUBR,	xthrow		},

	/* debugging and error handling functions */
{	"ERROR",	SUBR,	xerror		},
{	"CERROR",	SUBR,	xcerror		},
{	"BREAK",	SUBR,	xbreak		},
{	"CLEAN-UP",	SUBR,	xcleanup	},
{	"CONTINUE",	SUBR,	xcontinue	},
{	"ERRSET",	FSUBR,	xerrset		},
{	"BAKTRACE",	SUBR,	xbaktrace	},
{	"EVALHOOK",	SUBR,	xevalhook	},

{	0					}
};
