;***********************************************************************
;
;
; Clock code for MBYE, a kaypro, and the Kenmore Computer Tech. Clock.
;
; 02/18/85 Tim Gary
;
;-----	---	---	---	---	--	---	---	---
; Notes:
;
;   RTCBUF contains the followin information:
;	HHMMSS YYYYMMDD   for the first 7 bytes in bcd format
;  and  Mins. on System   as a two byte integer following
;

cbase 	equ	0e0h	; clock base port address
cyear	equ	1985h	; current year..  Must change each year since
			; you can't read the year with this clock

; Main read routine starts here
 
clock:
	push	psw
	push	h
	push	d
	push	b
;
eqloop:	lxi	h,RTCBUF
	call	rdclock		; get first time clock info into RTCBUF
	lxi	h,TRTCBUF
	call	rdclock		; get second time info into temp buffer
;
	lxi	h,RTCBUF	; now compare the two times read
	lxi	d,TRTCBUF
	mvi	b,7
cmplp:	ldax	d
	cmp	m
	jnz	eqloop		; if not equal, read times again..
	inx	h
	inx	d
	dcr	b
	jnz	cmplp		; if ok after 7 bytes, we have a valid time
;
	pop	b
	pop	d
	pop	h
	pop	psw
	ret
;
TRTCBUF:	db	99h,99h,99h,99h,99h,99h,99h,0,0
;
; This routine does the actual reading of the clock..
; 	On input:  HL contains the address of where to put the time/date
;	On output: HL contains above address+6
;		   DE contains the year (bcd)
;		   A  contains the day of month
rdclock:
	in	cbase+4
	mov	m,a
	inx	h
	in	cbase+3
	mov	m,a
	inx	h
	in	cbase+2
	mov	m,a
	inx	h
	lxi	d,cyear		; since no year on clock, get from value
	mov	m,d		; defined at beinging of this overlay
	inx	h
	mov	m,e
	inx	h
	in	cbase+7
	mov	m,a
	inx	h
	in	cbase+6
	mov	m,a
	ret
;
;
;**********************************************************************
